/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.OrientedKeyBinding;
import com.sun.javafx.scene.control.skin.ScrollPaneSkin;
import java.util.ArrayList;
import java.util.List;
import javafx.event.EventType;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ScrollPaneBehavior
extends BehaviorBase<ScrollPane> {
    protected static final List<KeyBinding> SCROLLVIEW_BINDINGS = new ArrayList<KeyBinding>();

    public ScrollPaneBehavior(ScrollPane scrollPane) {
        super(scrollPane);
    }

    public void horizontalUnitIncrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).hsbIncrement();
    }

    public void horizontalUnitDecrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).hsbDecrement();
    }

    public void verticalUnitIncrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).vsbIncrement();
    }

    void verticalUnitDecrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).vsbDecrement();
    }

    void horizontalPageIncrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).hsbPageIncrement();
    }

    void horizontalPageDecrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).hsbPageDecrement();
    }

    void verticalPageIncrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).vsbPageIncrement();
    }

    void verticalPageDecrement() {
        ((ScrollPaneSkin)((ScrollPane)this.getControl()).getSkin()).vsbPageDecrement();
    }

    public void contentDragged(double d, double d2) {
        ScrollPane scrollPane = (ScrollPane)this.getControl();
        if (!scrollPane.isPannable()) {
            return;
        }
        if (d < 0.0 && scrollPane.getHvalue() != 0.0 || d > 0.0 && scrollPane.getHvalue() != scrollPane.getHmax()) {
            scrollPane.setHvalue(scrollPane.getHvalue() + d);
        }
        if (d2 < 0.0 && scrollPane.getVvalue() != 0.0 || d2 > 0.0 && scrollPane.getVvalue() != scrollPane.getVmax()) {
            scrollPane.setVvalue(scrollPane.getVvalue() + d2);
        }
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return SCROLLVIEW_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        if ("HorizontalUnitDecrement".equals(string)) {
            this.horizontalUnitDecrement();
        } else if ("HorizontalUnitIncrement".equals(string)) {
            this.horizontalUnitIncrement();
        } else if ("VerticalUnitDecrement".equals(string)) {
            this.verticalUnitDecrement();
        } else if ("VerticalUnitIncrement".equals(string)) {
            this.verticalUnitIncrement();
        } else if ("VerticalPageDecrement".equals(string)) {
            this.verticalPageDecrement();
        } else if ("VerticalPageIncrement".equals(string)) {
            this.verticalPageIncrement();
        } else {
            super.callAction(string);
        }
    }

    public void mouseClicked() {
        ((ScrollPane)this.getControl()).requestFocus();
    }

    static {
        SCROLLVIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraverseNext"));
        SCROLLVIEW_BINDINGS.add(new KeyBinding(KeyCode.TAB, "TraversePrevious").shift());
        SCROLLVIEW_BINDINGS.add(new KeyBinding(KeyCode.F4, "TraverseDebug").alt().ctrl().shift());
        SCROLLVIEW_BINDINGS.add(new ScrollViewKeyBinding(KeyCode.LEFT, "HorizontalUnitDecrement"));
        SCROLLVIEW_BINDINGS.add(new ScrollViewKeyBinding(KeyCode.RIGHT, "HorizontalUnitIncrement"));
        SCROLLVIEW_BINDINGS.add(new ScrollViewKeyBinding(KeyCode.UP, "VerticalUnitDecrement"));
        SCROLLVIEW_BINDINGS.add(new ScrollViewKeyBinding(KeyCode.DOWN, "VerticalUnitIncrement"));
        SCROLLVIEW_BINDINGS.add(new ScrollViewKeyBinding(KeyCode.PAGE_UP, "VerticalPageDecrement"));
        SCROLLVIEW_BINDINGS.add(new ScrollViewKeyBinding(KeyCode.PAGE_DOWN, "VerticalPageIncrement"));
        SCROLLVIEW_BINDINGS.add(new KeyBinding(KeyCode.SPACE, "VerticalPageIncrement"));
    }

    public static class ScrollViewKeyBinding
    extends OrientedKeyBinding {
        public ScrollViewKeyBinding(KeyCode keyCode, String string) {
            super(keyCode, string);
        }

        public ScrollViewKeyBinding(KeyCode keyCode, EventType<KeyEvent> eventType, String string) {
            super(keyCode, eventType, string);
        }

        @Override
        public boolean getVertical(Control control) {
            return true;
        }
    }
}

