/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Accordion;
import javafx.scene.control.FocusModel;
import javafx.scene.control.TitledPane;
import javafx.scene.input.KeyCode;

public class AccordionBehavior
extends BehaviorBase<Accordion> {
    private AccordionFocusModel focusModel;
    private static final String HOME = "Home";
    private static final String END = "End";
    private static final String PAGE_UP = "Page_Up";
    private static final String PAGE_DOWN = "Page_Down";
    private static final String CTRL_PAGE_UP = "Ctrl_Page_Up";
    private static final String CTRL_PAGE_DOWN = "Ctrl_Page_Down";
    private static final String CTRL_TAB = "Ctrl_Tab";
    private static final String CTRL_SHIFT_TAB = "Ctrl_Shift_Tab";
    protected static final List<KeyBinding> ACCORDION_BINDINGS = new ArrayList<KeyBinding>();

    public AccordionBehavior(Accordion accordion) {
        super(accordion);
        this.focusModel = new AccordionFocusModel(accordion);
    }

    @Override
    protected List<KeyBinding> createKeyBindings() {
        return ACCORDION_BINDINGS;
    }

    @Override
    protected void callAction(String string) {
        Accordion accordion = (Accordion)this.getControl();
        if ("TraverseLeft".equals(string) || "TraverseUp".equals(string) || PAGE_UP.equals(string)) {
            if (((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                this.focusModel.focusPrevious();
                int n = this.focusModel.getFocusedIndex();
                ((TitledPane)accordion.getPanes().get(n)).requestFocus();
                if (PAGE_UP.equals(string)) {
                    ((TitledPane)accordion.getPanes().get(n)).setExpanded(true);
                }
            }
        } else if ("TraverseRight".equals(string) || "TraverseDown".equals(string) || PAGE_DOWN.equals(string)) {
            if (((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                this.focusModel.focusNext();
                int n = this.focusModel.getFocusedIndex();
                ((TitledPane)accordion.getPanes().get(n)).requestFocus();
                if (PAGE_DOWN.equals(string)) {
                    ((TitledPane)accordion.getPanes().get(n)).setExpanded(true);
                }
            }
        } else if (CTRL_TAB.equals(string) || CTRL_PAGE_DOWN.equals(string)) {
            this.focusModel.focusNext();
            int n = this.focusModel.getFocusedIndex();
            ((TitledPane)accordion.getPanes().get(n)).requestFocus();
            ((TitledPane)accordion.getPanes().get(n)).setExpanded(true);
        } else if (CTRL_SHIFT_TAB.equals(string) || CTRL_PAGE_UP.equals(string)) {
            this.focusModel.focusPrevious();
            int n = this.focusModel.getFocusedIndex();
            ((TitledPane)accordion.getPanes().get(n)).requestFocus();
            ((TitledPane)accordion.getPanes().get(n)).setExpanded(true);
        } else if (HOME.equals(string)) {
            if (((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                TitledPane titledPane = (TitledPane)accordion.getPanes().get(0);
                titledPane.requestFocus();
                titledPane.setExpanded(!titledPane.isExpanded());
            }
        } else if (END.equals(string)) {
            if (((TitledPane)accordion.getPanes().get(this.focusModel.getFocusedIndex())).isFocused()) {
                TitledPane titledPane = (TitledPane)accordion.getPanes().get(accordion.getPanes().size() - 1);
                titledPane.requestFocus();
                titledPane.setExpanded(!titledPane.isExpanded());
            }
        } else {
            super.callAction(string);
        }
    }

    static {
        ACCORDION_BINDINGS.addAll(TRAVERSAL_BINDINGS);
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.HOME, HOME));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.END, END));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, PAGE_UP));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, PAGE_DOWN));
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_UP, CTRL_PAGE_UP).ctrl());
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.PAGE_DOWN, CTRL_PAGE_DOWN).ctrl());
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_TAB).ctrl());
        ACCORDION_BINDINGS.add(new KeyBinding(KeyCode.TAB, CTRL_SHIFT_TAB).shift().ctrl());
    }

    static class AccordionFocusModel
    extends FocusModel<TitledPane> {
        private final Accordion accordion;

        public AccordionFocusModel(final Accordion accordion) {
            if (accordion == null) {
                throw new IllegalArgumentException("Accordion can not be null");
            }
            this.accordion = accordion;
            this.accordion.focusedProperty().addListener(new ChangeListener<Boolean>(){

                @Override
                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                    if (bl2.booleanValue()) {
                        if (accordion.getExpandedPane() != null) {
                            accordion.getExpandedPane().requestFocus();
                        } else {
                            ((TitledPane)accordion.getPanes().get(0)).requestFocus();
                        }
                    }
                }
            });
            this.accordion.getPanes().addListener(new ListChangeListener<TitledPane>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends TitledPane> change) {
                    while (change.next()) {
                        if (!change.wasAdded()) continue;
                        for (final TitledPane titledPane : change.getAddedSubList()) {
                            titledPane.focusedProperty().addListener(new ChangeListener<Boolean>(){

                                @Override
                                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                                    if (bl2.booleanValue()) {
                                        AccordionFocusModel.this.focus(accordion.getPanes().indexOf(titledPane));
                                    }
                                }
                            });
                        }
                    }
                }
            });
            for (final TitledPane titledPane : this.accordion.getPanes()) {
                titledPane.focusedProperty().addListener(new ChangeListener<Boolean>(){

                    @Override
                    public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                        if (bl2.booleanValue()) {
                            AccordionFocusModel.this.focus(accordion.getPanes().indexOf(titledPane));
                        }
                    }
                });
            }
        }

        @Override
        protected int getItemCount() {
            ObservableList<TitledPane> observableList = this.accordion.getPanes();
            return observableList == null ? 0 : observableList.size();
        }

        @Override
        protected TitledPane getModelItem(int n) {
            ObservableList<TitledPane> observableList = this.accordion.getPanes();
            if (observableList == null) {
                return null;
            }
            if (n < 0) {
                return null;
            }
            return (TitledPane)observableList.get(n % observableList.size());
        }

        @Override
        public void focusPrevious() {
            if (this.getFocusedIndex() <= 0) {
                this.focus(this.accordion.getPanes().size() - 1);
            } else {
                this.focus((this.getFocusedIndex() - 1) % this.accordion.getPanes().size());
            }
        }

        @Override
        public void focusNext() {
            if (this.getFocusedIndex() == -1) {
                this.focus(0);
            } else {
                this.focus((this.getFocusedIndex() + 1) % this.accordion.getPanes().size());
            }
        }
    }
}

