/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene;

import com.sun.javafx.Utils;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.event.BasicEventDispatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.Mnemonic;

public final class KeyboardShortcutsHandler
extends BasicEventDispatcher {
    private ObservableMap<KeyCombination, Runnable> accelerators;
    private ObservableMap<KeyCombination, ObservableList<Mnemonic>> mnemonics;
    private boolean mnemonicsDisplayEnabled = false;

    public void addMnemonic(Mnemonic mnemonic) {
        ObservableListWrapper<Mnemonic> observableListWrapper = (ObservableListWrapper<Mnemonic>)this.getMnemonics().get(mnemonic.getKeyCombination());
        if (observableListWrapper == null) {
            observableListWrapper = new ObservableListWrapper<Mnemonic>(new ArrayList());
            this.getMnemonics().put(mnemonic.getKeyCombination(), observableListWrapper);
        }
        boolean bl = false;
        for (int i = 0; i < observableListWrapper.size(); ++i) {
            if (observableListWrapper.get(i) != mnemonic) continue;
            bl = true;
        }
        if (!bl) {
            observableListWrapper.add(mnemonic);
        }
    }

    public void removeMnemonic(Mnemonic mnemonic) {
        ObservableList observableList = (ObservableList)this.getMnemonics().get(mnemonic.getKeyCombination());
        if (observableList != null) {
            for (int i = 0; i < observableList.size(); ++i) {
                if (observableList.get(i) != mnemonic) continue;
                observableList.remove(i);
            }
        }
    }

    public ObservableMap<KeyCombination, ObservableList<Mnemonic>> getMnemonics() {
        if (this.mnemonics == null) {
            this.mnemonics = new ObservableMapWrapper<KeyCombination, ObservableList<Mnemonic>>(new HashMap());
        }
        return this.mnemonics;
    }

    public ObservableMap<KeyCombination, Runnable> getAccelerators() {
        if (this.accelerators == null) {
            this.accelerators = new ObservableMapWrapper<KeyCombination, Runnable>(new HashMap());
        }
        return this.accelerators;
    }

    @Override
    public Event dispatchBubblingEvent(Event event) {
        if (event.getEventType() == KeyEvent.KEY_PRESSED) {
            if (Utils.isMac()) {
                if (((KeyEvent)event).isMetaDown()) {
                    this.processMnemonics((KeyEvent)event);
                }
            } else if (((KeyEvent)event).isAltDown()) {
                this.processMnemonics((KeyEvent)event);
            }
            if (!event.isConsumed()) {
                this.processAccelerators((KeyEvent)event);
            }
        }
        if (!Utils.isMac()) {
            if (event.getEventType() == KeyEvent.KEY_PRESSED && ((KeyEvent)event).isAltDown() && !event.isConsumed()) {
                this.setMnemonicsDisplayEnabled(true);
            }
            if (event.getEventType() == KeyEvent.KEY_RELEASED && !((KeyEvent)event).isAltDown()) {
                this.setMnemonicsDisplayEnabled(false);
            }
        }
        return event;
    }

    private void processMnemonics(KeyEvent keyEvent) {
        if (this.mnemonics != null) {
            ObservableList observableList = null;
            for (Map.Entry entry : this.mnemonics.entrySet()) {
                if (!((KeyCombination)entry.getKey()).match(keyEvent)) continue;
                observableList = (ObservableList)entry.getValue();
                break;
            }
            if (observableList != null) {
                Map.Entry entry;
                boolean bl = false;
                entry = null;
                Mnemonic mnemonic = null;
                int n = -1;
                int n2 = -1;
                for (int i = 0; i < observableList.size(); ++i) {
                    if (!(observableList.get(i) instanceof Mnemonic)) continue;
                    Node node = ((Mnemonic)observableList.get(i)).getNode();
                    if (node.impl_isTreeVisible() && node.isFocusTraversable()) {
                        if (entry == null) {
                            entry = node;
                            mnemonic = (Mnemonic)observableList.get(i);
                        } else {
                            bl = true;
                            if (n != -1 && n2 == -1) {
                                n2 = i;
                            }
                        }
                    }
                    if (!node.isFocused()) continue;
                    n = i;
                }
                if (entry != null) {
                    if (!bl) {
                        ((Node)((Object)entry)).requestFocus();
                        mnemonic.fire();
                        keyEvent.consume();
                    } else if (n == -1) {
                        ((Node)((Object)entry)).requestFocus();
                        keyEvent.consume();
                    } else if (n >= observableList.size()) {
                        ((Node)((Object)entry)).requestFocus();
                        keyEvent.consume();
                    } else {
                        if (n2 != -1) {
                            ((Mnemonic)observableList.get(n2)).getNode().requestFocus();
                        } else {
                            ((Node)((Object)entry)).requestFocus();
                        }
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    private void processAccelerators(KeyEvent keyEvent) {
        if (this.accelerators != null) {
            for (Map.Entry entry : this.accelerators.entrySet()) {
                Runnable runnable;
                if (!((KeyCombination)entry.getKey()).match(keyEvent) || (runnable = (Runnable)entry.getValue()) == null) continue;
                runnable.run();
                keyEvent.consume();
            }
        }
    }

    private void processMnemonicsKeyDisplay() {
        ObservableList observableList = null;
        ArrayList arrayList = null;
        if (this.mnemonics != null) {
            for (Map.Entry entry : this.mnemonics.entrySet()) {
                observableList = (ObservableList)entry.getValue();
                if (observableList == null) continue;
                arrayList = new ArrayList();
                for (int i = 0; i < observableList.size(); ++i) {
                    Node node = ((Mnemonic)observableList.get(i)).getNode();
                    node.impl_setShowMnemonics(this.mnemonicsDisplayEnabled);
                }
            }
        }
    }

    public boolean isMnemonicsDisplayEnabled() {
        return this.mnemonicsDisplayEnabled;
    }

    public void setMnemonicsDisplayEnabled(boolean bl) {
        if (bl != this.mnemonicsDisplayEnabled) {
            this.mnemonicsDisplayEnabled = bl;
            this.processMnemonicsKeyDisplay();
        }
    }
}

