/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import com.sun.javafx.fxml.BeanAdapter;
import com.sun.javafx.fxml.expression.Expression;
import com.sun.javafx.fxml.expression.KeyPath;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.Observable;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class ExpressionBinding {
    private Expression expression;
    private Map<String, Object> namespace;
    private ValueProperty valueProperty = new ValueProperty();
    private boolean valid = false;
    private boolean updating = false;
    private LinkedList<KeyPathMonitor> argumentMonitors = new LinkedList();

    public ExpressionBinding(Expression expression, Map<String, Object> map) {
        if (expression == null) {
            throw new IllegalArgumentException();
        }
        if (map == null) {
            throw new IllegalArgumentException();
        }
        this.expression = expression;
        this.namespace = map;
        for (KeyPath keyPath : expression.getArguments()) {
            this.argumentMonitors.add(new KeyPathMonitor(keyPath));
        }
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Map<String, Object> getNamespace() {
        return this.namespace;
    }

    public Object getValue() {
        return this.valueProperty.get();
    }

    public ReadOnlyObjectProperty<Object> valueProperty() {
        return this.valueProperty;
    }

    private class KeyPathMonitor {
        public final KeyPath keyPath;
        public final LinkedList<Object> collections = new LinkedList();
        private ListChangeListener<Object> listChangeListener = new ListChangeListener<Object>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends Object> change) {
                while (change.next()) {
                    int n;
                    ObservableList<? extends Object> observableList = change.getList();
                    Iterator<Object> iterator = KeyPathMonitor.this.collections.iterator();
                    Iterator<String> iterator2 = KeyPathMonitor.this.keyPath.iterator();
                    String string = null;
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        string = (String)iterator2.next();
                        if (e != observableList) continue;
                        break;
                    }
                    if ((n = Integer.parseInt(string)) < change.getFrom() || n >= change.getTo()) continue;
                    ExpressionBinding.this.valueProperty.fireValueChangedEvent();
                    if (iterator.hasNext()) {
                        KeyPathMonitor.this.unregisterChangeListeners(iterator);
                    }
                    if (!iterator2.hasNext()) continue;
                    KeyPathMonitor.this.registerChangeListeners(Expression.get(observableList, string), iterator2);
                }
            }
        };
        private MapChangeListener<String, Object> mapChangeListener = new MapChangeListener<String, Object>(){

            @Override
            public void onChanged(MapChangeListener.Change<? extends String, ? extends Object> change) {
                ObservableMap<? extends String, ? extends Object> observableMap = change.getMap();
                Iterator<Object> iterator = KeyPathMonitor.this.collections.iterator();
                Iterator<String> iterator2 = KeyPathMonitor.this.keyPath.iterator();
                String string = null;
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    string = (String)iterator2.next();
                    if (e != observableMap) continue;
                    break;
                }
                if (string.equals(change.getKey())) {
                    ExpressionBinding.this.valueProperty.fireValueChangedEvent();
                    if (iterator.hasNext()) {
                        KeyPathMonitor.this.unregisterChangeListeners(iterator);
                    }
                    if (iterator2.hasNext()) {
                        KeyPathMonitor.this.registerChangeListeners(Expression.get(observableMap, string), iterator2);
                    }
                }
            }
        };

        public KeyPathMonitor(KeyPath keyPath) {
            this.keyPath = keyPath;
        }

        public void registerChangeListeners() {
            this.registerChangeListeners(ExpressionBinding.this.namespace, this.keyPath.iterator());
        }

        public void registerChangeListeners(Object object, Iterator<String> iterator) {
            Observable observable;
            String string = iterator.next();
            if (object instanceof ObservableList) {
                ObservableList observableList = (ObservableList)object;
                observableList.addListener(this.listChangeListener);
                observable = observableList;
            } else {
                ObservableMap observableMap = object instanceof Map ? (ObservableMap)object : new BeanAdapter(object);
                observableMap.addListener(this.mapChangeListener);
                observable = observableMap;
            }
            this.collections.add(observable);
            if (iterator.hasNext() && (object = Expression.get(object, string)) != null) {
                this.registerChangeListeners(object, iterator);
            }
        }

        public void unregisterChangeListeners() {
            this.unregisterChangeListeners(this.collections.iterator());
        }

        public void unregisterChangeListeners(Iterator<Object> iterator) {
            Object object = iterator.next();
            if (object instanceof List) {
                ObservableList observableList = (ObservableList)object;
                observableList.removeListener(this.listChangeListener);
            } else {
                ObservableMap observableMap = (ObservableMap)object;
                observableMap.removeListener(this.mapChangeListener);
            }
            if (iterator.hasNext()) {
                this.unregisterChangeListeners(iterator);
            }
            this.collections.removeLast();
        }
    }

    private class ValueProperty
    extends ReadOnlyObjectPropertyBase<Object> {
        private Object value = null;
        private int listenerCount = 0;

        private ValueProperty() {
        }

        @Override
        public Object getBean() {
            return ExpressionBinding.this;
        }

        @Override
        public String getName() {
            return "value";
        }

        @Override
        public Object get() {
            if (!ExpressionBinding.this.valid) {
                this.value = ExpressionBinding.this.expression.evaluate(ExpressionBinding.this.namespace);
                ExpressionBinding.this.valid = true;
            }
            return this.value;
        }

        @Override
        public void addListener(ChangeListener<? super Object> changeListener) {
            if (this.listenerCount == 0) {
                for (KeyPathMonitor keyPathMonitor : ExpressionBinding.this.argumentMonitors) {
                    keyPathMonitor.registerChangeListeners();
                }
            }
            super.addListener(changeListener);
            ++this.listenerCount;
        }

        @Override
        public void removeListener(ChangeListener<? super Object> changeListener) {
            super.removeListener(changeListener);
            --this.listenerCount;
            if (this.listenerCount == 0) {
                for (KeyPathMonitor keyPathMonitor : ExpressionBinding.this.argumentMonitors) {
                    keyPathMonitor.unregisterChangeListeners();
                }
            }
        }

        @Override
        protected void fireValueChangedEvent() {
            ExpressionBinding.this.valid = false;
            if (!ExpressionBinding.this.updating) {
                ExpressionBinding.this.updating = true;
                super.fireValueChangedEvent();
                ExpressionBinding.this.updating = false;
            }
        }
    }
}

