/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml;

import com.sun.javafx.collections.MapInvalidationListenerWrapper;
import com.sun.javafx.fxml.PropertyNotFoundException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.fxml.FXMLLoader;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;

public class BeanAdapter
extends AbstractMap<String, Object>
implements ObservableMap<String, Object> {
    private Object bean;
    private HashMap<String, Method> getterMethods = new HashMap();
    private HashMap<String, Method> setterMethods = new HashMap();
    private HashMap<String, Method> propertyModelMethods = new HashMap();
    private PropertyEntrySet entrySet = new PropertyEntrySet();
    private LinkedList<PropertyInvalidationListener> propertyInvalidationListeners = null;
    private Set<MapChangeListener<? super String, ? super Object>> changeListeners = null;
    public static final String GET_PREFIX = "get";
    public static final String IS_PREFIX = "is";
    public static final String SET_PREFIX = "set";
    public static final String PROPERTY_MODEL_SUFFIX = "Property";
    public static final String VALUE_OF_METHOD_NAME = "valueOf";
    public static final String ARRAY_COMPONENT_DELIMITER = ",";

    public BeanAdapter(Object object) {
        Object object2;
        String string;
        Method method;
        int n;
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this.bean = object;
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        for (n = 0; n < methodArray.length; ++n) {
            method = methodArray[n];
            string = method.getName();
            object2 = string.startsWith(GET_PREFIX) ? "get" : (string.startsWith(IS_PREFIX) ? IS_PREFIX : null);
            if (object2 == null) continue;
            Class<?>[] classArray = method.getParameterTypes();
            int n2 = method.getModifiers();
            if (classArray.length != 0 || (n2 & 8) != 0) continue;
            this.getterMethods.put(BeanAdapter.toKey(string, object2), method);
        }
        for (n = 0; n < methodArray.length; ++n) {
            String string2;
            int n3;
            method = methodArray[n];
            string = method.getName();
            if (string.startsWith(SET_PREFIX)) {
                Method method2;
                object2 = method.getParameterTypes();
                n3 = method.getModifiers();
                if (((Class<?>[])object2).length != 1 || (n3 & 8) != 0 || (method2 = this.getterMethods.get(string2 = BeanAdapter.toKey(string, SET_PREFIX))) == null || object2[0] != method2.getReturnType()) continue;
                this.setterMethods.put(string2, method);
                continue;
            }
            if (!string.endsWith(PROPERTY_MODEL_SUFFIX)) continue;
            object2 = method.getParameterTypes();
            n3 = method.getModifiers();
            if (((Class<?>[])object2).length != 0 || (n3 & 8) != 0) continue;
            string2 = string.substring(0, string.length() - PROPERTY_MODEL_SUFFIX.length()).toLowerCase();
            this.propertyModelMethods.put(string2, method);
        }
    }

    public Object getBean() {
        return this.bean;
    }

    @Override
    public Object get(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Object object2 = null;
        Method method = this.getterMethods.get(object.toString());
        if (method != null) {
            try {
                object2 = method.invoke(this.bean, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        return object2;
    }

    @Override
    public Object put(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        Method method = this.setterMethods.get(string);
        if (method == null) {
            throw new PropertyNotFoundException("Property \"" + string + "\" does not exist" + " or is read-only.");
        }
        Class<?> clazz = this.getType(string);
        if (object != null && !clazz.isAssignableFrom(object.getClass())) {
            object = BeanAdapter.coerce(object, clazz);
        }
        try {
            method.invoke(this.bean, object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getterMethods.containsKey(object);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.entrySet;
    }

    public boolean isReadOnly(String string) {
        return !this.setterMethods.containsKey(string);
    }

    public Class<?> getType(String string) {
        Method method = this.getterMethods.get(string);
        return method == null ? null : method.getReturnType();
    }

    public Type getGenericType(String string) {
        Method method = this.getterMethods.get(string);
        return method == null ? null : method.getGenericReturnType();
    }

    public Property<Object> getPropertyModel(String string) {
        Property property;
        Method method = this.propertyModelMethods.get(string.toLowerCase());
        if (method != null) {
            try {
                property = (Property)method.invoke(this.bean, new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        } else {
            property = null;
        }
        return property;
    }

    @Override
    public void addListener(MapChangeListener<? super String, ? super Object> mapChangeListener) {
        Set<MapChangeListener<? super String, ? super Object>> set = this.getChangeListeners();
        if (set.isEmpty()) {
            this.registerPropertyChangeHandlers();
        }
        set.add(mapChangeListener);
    }

    @Override
    public void removeListener(MapChangeListener<? super String, ? super Object> mapChangeListener) {
        Set<MapChangeListener<? super String, ? super Object>> set = this.getChangeListeners();
        set.remove(mapChangeListener);
        if (set.isEmpty()) {
            this.unregisterPropertyChangeHandlers();
        }
    }

    private Set<MapChangeListener<? super String, ? super Object>> getChangeListeners() {
        if (this.changeListeners == null) {
            this.changeListeners = new HashSet<MapChangeListener<? super String, ? super Object>>();
        }
        return this.changeListeners;
    }

    private void registerPropertyChangeHandlers() {
        this.propertyInvalidationListeners = new LinkedList();
        for (String string : this.keySet()) {
            Property<Object> property = this.getPropertyModel(string);
            if (property == null) continue;
            PropertyInvalidationListener propertyInvalidationListener = new PropertyInvalidationListener(string);
            property.addListener(propertyInvalidationListener);
            this.propertyInvalidationListeners.add(propertyInvalidationListener);
        }
    }

    private void unregisterPropertyChangeHandlers() {
        for (PropertyInvalidationListener propertyInvalidationListener : this.propertyInvalidationListeners) {
            Property<Object> property = this.getPropertyModel(propertyInvalidationListener.key);
            property.removeListener(propertyInvalidationListener);
        }
        this.propertyInvalidationListeners = null;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof BeanAdapter) {
            BeanAdapter beanAdapter = (BeanAdapter)object;
            bl = this.bean == beanAdapter.bean;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.bean.hashCode();
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.addListener(new MapInvalidationListenerWrapper(this, invalidationListener));
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.removeListener(new MapInvalidationListenerWrapper(this, invalidationListener));
    }

    public static <T> T coerce(Object object, Class<? extends T> clazz) {
        Object object2;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (object == null) {
            object2 = null;
        } else if (clazz.isAssignableFrom(object.getClass())) {
            object2 = object;
        } else if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            object2 = Boolean.valueOf(object.toString());
        } else if (clazz == Character.class || clazz == Character.TYPE) {
            object2 = Character.valueOf(object.toString().charAt(0));
        } else if (clazz == Number.class) {
            String string = object.toString();
            object2 = string.contains(".") ? (Number)Double.valueOf(string) : (Number)Long.valueOf(string);
        } else if (clazz == Byte.class || clazz == Byte.TYPE) {
            object2 = object instanceof Number ? Byte.valueOf(((Number)object).byteValue()) : Byte.valueOf(object.toString());
        } else if (clazz == Short.class || clazz == Short.TYPE) {
            object2 = object instanceof Number ? Short.valueOf(((Number)object).shortValue()) : Short.valueOf(object.toString());
        } else if (clazz == Integer.class || clazz == Integer.TYPE) {
            object2 = object instanceof Number ? Integer.valueOf(((Number)object).intValue()) : Integer.valueOf(object.toString());
        } else if (clazz == Long.class || clazz == Long.TYPE) {
            object2 = object instanceof Number ? Long.valueOf(((Number)object).longValue()) : Long.valueOf(object.toString());
        } else if (clazz == BigInteger.class) {
            object2 = object instanceof Number ? BigInteger.valueOf(((Number)object).longValue()) : new BigInteger(object.toString());
        } else if (clazz == Float.class || clazz == Float.TYPE) {
            object2 = object instanceof Number ? Float.valueOf(((Number)object).floatValue()) : Float.valueOf(object.toString());
        } else if (clazz == Double.class || clazz == Double.TYPE) {
            object2 = object instanceof Number ? Double.valueOf(((Number)object).doubleValue()) : Double.valueOf(object.toString());
        } else if (clazz == BigDecimal.class) {
            object2 = object instanceof Number ? BigDecimal.valueOf(((Number)object).doubleValue()) : new BigDecimal(object.toString());
        } else {
            if (clazz == Class.class) {
                try {
                    object2 = FXMLLoader.loadType(object.toString());
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException(classNotFoundException);
                }
            }
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                String string = object.toString();
                if (string.length() > 0) {
                    String[] stringArray = string.split(ARRAY_COMPONENT_DELIMITER);
                    object2 = Array.newInstance(clazz2, stringArray.length);
                    for (int i = 0; i < stringArray.length; ++i) {
                        Array.set(object2, i, BeanAdapter.coerce(stringArray[i], clazz.getComponentType()));
                    }
                } else {
                    object2 = Array.newInstance(clazz2, 0);
                }
            } else if (clazz == Color.class || clazz == Paint.class) {
                String string = object.toString();
                if (string.startsWith("#")) {
                    object2 = Color.web(string);
                } else {
                    try {
                        object2 = Color.class.getDeclaredField(string.toUpperCase()).get(null);
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("\"" + object + "\" is not a valid color constant.");
                    }
                }
            } else {
                Class<?> clazz3 = object.getClass();
                Method method = null;
                while (method == null && clazz3 != null) {
                    try {
                        method = clazz.getMethod(VALUE_OF_METHOD_NAME, clazz3);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null) continue;
                    clazz3 = clazz3.getSuperclass();
                }
                if (method == null) {
                    throw new IllegalArgumentException("Unable to coerce " + object + " to " + clazz + ".");
                }
                if (clazz.isEnum() && object instanceof String && Character.isLowerCase(((String)object).charAt(0))) {
                    object = BeanAdapter.toAllCaps((String)object);
                }
                try {
                    object2 = method.invoke(null, object);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(securityException);
                }
            }
        }
        return (T)object2;
    }

    public static <T> T get(Object object, Class<?> clazz, String string) {
        Object object2 = null;
        Class<?> clazz2 = object.getClass();
        Method method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2);
        if (method != null) {
            try {
                object2 = method.invoke(null, object);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
        }
        return (T)object2;
    }

    public static void put(Object object, Class<?> clazz, String string, Object object2) {
        Class<?> clazz2;
        Class<?> clazz3 = object.getClass();
        Method method = null;
        if (object2 != null) {
            method = BeanAdapter.getStaticSetterMethod(clazz, string, object2.getClass(), clazz3);
        }
        if (method == null && (clazz2 = BeanAdapter.getType(clazz, string, clazz3)) != null) {
            method = BeanAdapter.getStaticSetterMethod(clazz, string, clazz2, clazz3);
            object2 = BeanAdapter.coerce(object2, clazz2);
        }
        if (method == null) {
            throw new PropertyNotFoundException("Static property \"" + string + "\" does not exist" + " or is read-only.");
        }
        try {
            method.invoke(null, object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    public static boolean isDefined(Class<?> clazz, String string, Class<?> clazz2) {
        return BeanAdapter.getStaticGetterMethod(clazz, string, clazz2) != null;
    }

    public static Class<?> getType(Class<?> clazz, String string, Class<?> clazz2) {
        Method method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2);
        return method == null ? null : method.getReturnType();
    }

    public static Type getGenericType(Class<?> clazz, String string, Class<?> clazz2) {
        Method method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2);
        return method == null ? null : method.getGenericReturnType();
    }

    public static Type getGenericListItemType(Type type) {
        Object object = null;
        Type type2 = type;
        while (type2 != null) {
            Object object2;
            Type type3;
            if (type2 instanceof ParameterizedType) {
                type3 = (ParameterizedType)type2;
                object2 = (Class)type3.getRawType();
                if (!List.class.isAssignableFrom((Class<?>)object2)) break;
                object = type3.getActualTypeArguments()[0];
                break;
            }
            type3 = (Class)type2;
            object2 = ((Class)type3).getGenericInterfaces();
            for (int i = 0; i < ((Type[])object2).length; ++i) {
                ParameterizedType parameterizedType;
                Class clazz;
                Type type4 = object2[i];
                if (!(type4 instanceof ParameterizedType) || !List.class.isAssignableFrom(clazz = (Class)(parameterizedType = (ParameterizedType)type4).getRawType())) continue;
                object = parameterizedType.getActualTypeArguments()[0];
                if (!(object instanceof TypeVariable)) break;
                object = Object.class;
                break;
            }
            if (object != null) break;
            type2 = ((Class)type3).getGenericSuperclass();
        }
        return object;
    }

    public static Type getGenericMapValueType(Type type) {
        Object object = null;
        Type type2 = type;
        while (type2 != null) {
            Object object2;
            Type type3;
            if (type2 instanceof ParameterizedType) {
                type3 = (ParameterizedType)type2;
                object2 = (Class)type3.getRawType();
                if (!Map.class.isAssignableFrom((Class<?>)object2)) break;
                object = type3.getActualTypeArguments()[1];
                break;
            }
            type3 = (Class)type2;
            object2 = ((Class)type3).getGenericInterfaces();
            for (int i = 0; i < ((Type[])object2).length; ++i) {
                ParameterizedType parameterizedType;
                Class clazz;
                Type type4 = object2[i];
                if (!(type4 instanceof ParameterizedType) || !Map.class.isAssignableFrom(clazz = (Class)(parameterizedType = (ParameterizedType)type4).getRawType())) continue;
                object = parameterizedType.getActualTypeArguments()[1];
                if (!(object instanceof TypeVariable)) break;
                object = Object.class;
                break;
            }
            if (object != null) break;
            type2 = ((Class)type3).getGenericSuperclass();
        }
        return object;
    }

    public static String toCamelCase(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            c = c == '_' && i < n - 1 ? Character.toUpperCase(string.charAt(++i)) : Character.toLowerCase(c);
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String toAllCaps(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c)) {
                stringBuilder.append('_');
            }
            stringBuilder.append(Character.toUpperCase(c));
        }
        return stringBuilder.toString();
    }

    private static Method getStaticGetterMethod(Class<?> clazz, String string, Class<?> clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("sourceType is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        Method method = null;
        if (clazz2 != null) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            String string2 = GET_PREFIX + string;
            String string3 = IS_PREFIX + string;
            try {
                method = clazz.getMethod(string2, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                try {
                    method = clazz.getMethod(string3, clazz2);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            if (method == null) {
                Class<?>[] classArray = clazz2.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    try {
                        method = clazz.getMethod(string2, classArray[i]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method == null) {
                        try {
                            method = clazz.getMethod(string3, classArray[i]);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                    if (method != null) break;
                }
            }
            if (method == null) {
                method = BeanAdapter.getStaticGetterMethod(clazz, string, clazz2.getSuperclass());
            }
        }
        return method;
    }

    private static Method getStaticSetterMethod(Class<?> clazz, String string, Class<?> clazz2, Class<?> clazz3) {
        if (clazz == null) {
            throw new IllegalArgumentException("sourceType is null.");
        }
        if (string == null) {
            throw new IllegalArgumentException("key is null.");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException();
        }
        Method method = null;
        if (clazz3 != null) {
            string = Character.toUpperCase(string.charAt(0)) + string.substring(1);
            String string2 = SET_PREFIX + string;
            try {
                method = clazz.getMethod(string2, clazz3, clazz2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method == null) {
                Class<?>[] classArray = clazz3.getInterfaces();
                for (int i = 0; i < classArray.length; ++i) {
                    try {
                        method = clazz.getMethod(string2, classArray[i], clazz2);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    if (method != null) break;
                }
            }
            if (method == null) {
                method = BeanAdapter.getStaticSetterMethod(clazz, string, clazz2, clazz3.getSuperclass());
            }
        }
        return method;
    }

    private static String toKey(String string, String string2) {
        int n = string2.length();
        String string3 = Character.toLowerCase(string.charAt(n)) + string.substring(n + 1);
        return string3;
    }

    private static class BeanAdapterChangeEvent
    extends MapChangeListener.Change<String, Object> {
        private String key;

        public BeanAdapterChangeEvent(BeanAdapter beanAdapter, String string) {
            super(beanAdapter);
            this.key = string;
        }

        @Override
        public boolean wasAdded() {
            return false;
        }

        @Override
        public boolean wasRemoved() {
            return true;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValueAdded() {
            return null;
        }

        @Override
        public Object getValueRemoved() {
            return null;
        }
    }

    private class PropertyInvalidationListener
    implements InvalidationListener {
        public String key;

        public PropertyInvalidationListener(String string) {
            this.key = string;
        }

        @Override
        public void invalidated(Observable observable) {
            for (MapChangeListener mapChangeListener : BeanAdapter.this.changeListeners) {
                mapChangeListener.onChanged(new BeanAdapterChangeEvent(BeanAdapter.this, this.key));
            }
        }
    }

    private class PropertyEntrySet
    extends AbstractSet<Map.Entry<String, Object>> {
        private PropertyEntrySet() {
        }

        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new PropertyEntrySetIterator();
        }

        private class PropertyEntrySetIterator
        implements Iterator<Map.Entry<String, Object>> {
            private Class<?> type;
            private Method[] methods;
            private int i = 0;
            private String nextKey = null;

            public PropertyEntrySetIterator() {
                this.type = BeanAdapter.this.bean.getClass();
                this.methods = this.type.getMethods();
                this.nextKey();
            }

            @Override
            public boolean hasNext() {
                return this.nextKey != null;
            }

            @Override
            public Map.Entry<String, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextKey;
                this.nextKey();
                return new PropertyEntry(string);
            }

            private void nextKey() {
                this.nextKey = null;
                while (this.i < this.methods.length && this.nextKey == null) {
                    String string;
                    String string2;
                    Method method;
                    if ((method = this.methods[this.i++]).getDeclaringClass() == Object.class || method.getParameterTypes().length != 0 || (method.getModifiers() & 8) != 0 || (string2 = (string = method.getName()).startsWith(BeanAdapter.GET_PREFIX) ? BeanAdapter.GET_PREFIX : (string.startsWith(BeanAdapter.IS_PREFIX) ? BeanAdapter.IS_PREFIX : null)) == null) continue;
                    this.nextKey = BeanAdapter.toKey(string, string2);
                    Class<?> clazz = method.getReturnType();
                    Method method2 = (Method)BeanAdapter.this.setterMethods.get(this.nextKey);
                    if (method2 != null || List.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz)) continue;
                    this.nextKey = null;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class PropertyEntry
    implements Map.Entry<String, Object> {
        private String key;

        public PropertyEntry(String string) {
            this.key = string;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Object getValue() {
            return BeanAdapter.this.get(this.key);
        }

        @Override
        public Object setValue(Object object) {
            return BeanAdapter.this.put(this.key, object);
        }
    }
}

