/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.Utils;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import javafx.scene.text.Font;

public final class StringConverter
extends StyleConverter<String, String> {
    public static StringConverter getInstance() {
        return Holder.INSTANCE;
    }

    private StringConverter() {
    }

    @Override
    public String convert(Value<String, String> value, Font font) {
        String string = value.getValue();
        if (string == null) {
            return null;
        }
        return Utils.convertUnicode(string);
    }

    public String toString() {
        return "StringConverter";
    }

    public static final class SequenceConverter
    extends StyleConverter<Value<String, String>[], String[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public String[] convert(Value<Value<String, String>[], String[]> value, Font font) {
            Value<String, String>[] valueArray = value.getValue();
            String[] stringArray = new String[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                stringArray[i] = StringConverter.getInstance().convert((Value)valueArray[i], font);
            }
            return stringArray;
        }

        public String toString() {
            return "String.SequenceConverter";
        }
    }

    private static class Holder {
        static StringConverter INSTANCE = new StringConverter();
        static SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();

        private Holder() {
        }
    }
}

