/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css.converters;

import com.sun.javafx.css.Size;
import com.sun.javafx.css.SizeUnits;
import com.sun.javafx.css.StyleConverter;
import com.sun.javafx.css.Value;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.text.Font;

public final class PaintConverter
extends StyleConverter<Value<?, Paint>, Paint> {
    public static PaintConverter getInstance() {
        return Holder.INSTANCE;
    }

    private PaintConverter() {
    }

    @Override
    public Paint convert(Value<Value<?, Paint>, Paint> value, Font font) {
        Value<?, Paint> value2 = value.getValue();
        if (value2 instanceof Paint) {
            return (Paint)((Object)value2);
        }
        return value.getValue().convert(font);
    }

    public String toString() {
        return "PaintConverter";
    }

    public static final class RadialGradientConverter
    extends StyleConverter<Value[], Paint> {
        public static RadialGradientConverter getInstance() {
            return Holder.RADIAL_GRADIENT_INSTANCE;
        }

        private RadialGradientConverter() {
        }

        @Override
        public Paint convert(Value<Value[], Paint> value, Font font) {
            boolean bl;
            Value[] valueArray = value.getValue();
            int n = 0;
            Size size = valueArray[n++] != null ? (Size)valueArray[n - 1].convert(font) : null;
            Size size2 = valueArray[n++] != null ? (Size)valueArray[n - 1].convert(font) : null;
            Size size3 = valueArray[n++] != null ? (Size)valueArray[n - 1].convert(font) : null;
            Size size4 = valueArray[n++] != null ? (Size)valueArray[n - 1].convert(font) : null;
            Size size5 = (Size)valueArray[n++].convert(font);
            boolean bl2 = size5.getUnits().equals((Object)SizeUnits.PERCENT);
            boolean bl3 = size3 != null ? bl2 == size3.getUnits().equals((Object)SizeUnits.PERCENT) : (bl = true);
            boolean bl4 = bl && size4 != null ? bl2 == size4.getUnits().equals((Object)SizeUnits.PERCENT) : (bl = true);
            if (!bl) {
                throw new IllegalArgumentException("units do not agree");
            }
            CycleMethod cycleMethod = (CycleMethod)((Object)valueArray[n++].convert(font));
            Stop[] stopArray = new Stop[valueArray.length - n];
            for (int i = n; i < valueArray.length; ++i) {
                stopArray[i - n] = (Stop)valueArray[i].convert(font);
            }
            double d = 0.0;
            if (size != null) {
                d = size.pixels(font);
                if (size.getUnits().equals((Object)SizeUnits.PERCENT)) {
                    d = d * 360.0 % 360.0;
                }
            }
            return new RadialGradient(d, size2 != null ? size2.pixels() : 0.0, size3 != null ? size3.pixels() : 0.0, size4 != null ? size4.pixels() : 0.0, size5 != null ? size5.pixels() : 1.0, bl2, cycleMethod, stopArray);
        }

        public String toString() {
            return "RadialGradientConverter";
        }
    }

    public static final class LinearGradientConverter
    extends StyleConverter<Value[], Paint> {
        public static LinearGradientConverter getInstance() {
            return Holder.LINEAR_GRADIENT_INSTANCE;
        }

        private LinearGradientConverter() {
        }

        @Override
        public Paint convert(Value<Value[], Paint> value, Font font) {
            Value[] valueArray = value.getValue();
            int n = 0;
            Size size = (Size)valueArray[n++].convert(font);
            Size size2 = (Size)valueArray[n++].convert(font);
            Size size3 = (Size)valueArray[n++].convert(font);
            Size size4 = (Size)valueArray[n++].convert(font);
            boolean bl = size.getUnits() == SizeUnits.PERCENT && size.getUnits() == size2.getUnits() && size.getUnits() == size3.getUnits() && size.getUnits() == size4.getUnits();
            CycleMethod cycleMethod = (CycleMethod)((Object)valueArray[n++].convert(font));
            Stop[] stopArray = new Stop[valueArray.length - n];
            for (int i = n; i < valueArray.length; ++i) {
                stopArray[i - n] = (Stop)valueArray[i].convert(font);
            }
            return new LinearGradient(size.pixels(font), size2.pixels(font), size3.pixels(font), size4.pixels(font), bl, cycleMethod, stopArray);
        }

        public String toString() {
            return "LinearGradientConverter";
        }
    }

    public static final class SequenceConverter
    extends StyleConverter<Value<?, Paint>[], Paint[]> {
        public static SequenceConverter getInstance() {
            return Holder.SEQUENCE_INSTANCE;
        }

        private SequenceConverter() {
        }

        @Override
        public Paint[] convert(Value<Value<?, Paint>[], Paint[]> value, Font font) {
            Value<?, Paint>[] valueArray = value.getValue();
            Paint[] paintArray = new Paint[valueArray.length];
            for (int i = 0; i < valueArray.length; ++i) {
                paintArray[i] = valueArray[i].convert(font);
            }
            return paintArray;
        }

        public String toString() {
            return "Paint.SequenceConverter";
        }
    }

    private static class Holder {
        static PaintConverter INSTANCE = new PaintConverter();
        static SequenceConverter SEQUENCE_INSTANCE = new SequenceConverter();
        static LinearGradientConverter LINEAR_GRADIENT_INSTANCE = new LinearGradientConverter();
        static RadialGradientConverter RADIAL_GRADIENT_INSTANCE = new RadialGradientConverter();

        private Holder() {
        }
    }
}

