/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.StringStore;
import com.sun.javafx.css.Value;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Declaration {
    final String propertyName;
    final Value cssValue;
    final boolean important;

    public Declaration(String string, Value value, boolean bl) {
        this.propertyName = string;
        this.cssValue = value;
        this.important = bl;
    }

    private Declaration() {
        this(null, null, false);
    }

    public Value getCssValue() {
        return this.cssValue;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.propertyName);
        stringBuilder.append(": ");
        stringBuilder.append(this.cssValue);
        if (this.important) {
            stringBuilder.append(" !important");
        }
        return stringBuilder.toString();
    }

    void writeBinary(DataOutputStream dataOutputStream, StringStore stringStore) throws IOException {
        dataOutputStream.writeShort(stringStore.addString(this.propertyName));
        this.cssValue.writeBinary(dataOutputStream, stringStore);
        dataOutputStream.writeBoolean(this.important);
    }

    static Declaration readBinary(DataInputStream dataInputStream, String[] stringArray) throws IOException {
        String string = stringArray[dataInputStream.readShort()];
        Value value = Value.readBinary(dataInputStream, stringArray);
        boolean bl = dataInputStream.readBoolean();
        return new Declaration(string, value, bl);
    }
}

