/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.collections.IterableChangeBuilder;
import com.sun.javafx.collections.ListInvalidationListenerWrapper;
import com.sun.javafx.collections.ListenerList;
import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import com.sun.javafx.collections.SortableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public class ObservableListWrapper<E>
implements ObservableList<E>,
SortableList<E> {
    ListenerList<ListChangeListener<? super E>> observers;
    List<E> backingList;
    private IterableChangeBuilder<E> iterableChangeBuilder;
    private SortHelper helper;

    public ObservableListWrapper(List<E> list) {
        this.backingList = list;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.addListener(new ListInvalidationListenerWrapper(this, invalidationListener));
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        this.removeListener(new ListInvalidationListenerWrapper(this, invalidationListener));
    }

    @Override
    public void addListener(ListChangeListener<? super E> listChangeListener) {
        if (this.observers == null) {
            this.observers = new ListenerList();
            this.observers.add(listChangeListener);
        } else if (!this.observers.contains(listChangeListener)) {
            this.observers = this.observers.safeAdd(listChangeListener);
        }
    }

    @Override
    public void removeListener(ListChangeListener<? super E> listChangeListener) {
        if (this.observers != null) {
            this.observers = this.observers.safeRemove(listChangeListener);
            if (this.observers.isEmpty()) {
                this.observers = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callObservers(ListChangeListener.Change<E> change) {
        if (this.observers != null) {
            ListenerList<ListChangeListener<E>> listenerList = this.observers;
            listenerList.lock();
            try {
                for (int i = 0; i < listenerList.size(); ++i) {
                    change.reset();
                    ((ListChangeListener)listenerList.get(i)).onChanged(change);
                }
            }
            finally {
                listenerList.unlock();
            }
        }
    }

    @Override
    public boolean add(E e) {
        this.add(this.size(), e);
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.backingList.add(n, e);
        this.callObservers(new NonIterableChange.SimpleAddChange(n, n + 1, this));
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        int n = this.size();
        return this.addAll(n, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        boolean bl = this.backingList.addAll(n, collection);
        this.callObservers(new NonIterableChange.SimpleAddChange(n, n + collection.size(), this));
        return bl;
    }

    @Override
    public void clear() {
        List<E> list = this.hasObserver() ? Collections.unmodifiableList(new ArrayList<E>(this.backingList)) : null;
        this.backingList.clear();
        this.callObservers(new NonIterableChange.GenericAddRemoveChange<E>(0, 0, list, this));
    }

    protected boolean hasObserver() {
        return this.observers != null && !this.observers.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingList.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.backingList.containsAll(collection);
    }

    @Override
    public boolean equals(Object object) {
        return ((Object)this.backingList).equals(object);
    }

    @Override
    public E get(int n) {
        return this.backingList.get(n);
    }

    @Override
    public int hashCode() {
        return ((Object)this.backingList).hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.backingList.indexOf(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return new ObservableListIterator(this.backingList.iterator(), 0, 0);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.backingList.lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ObservableListIterator(this.backingList.listIterator(), 0, 0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        if (n < 0 || n > this.backingList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return new ObservableListIterator(this.backingList.listIterator(n), 0, n);
    }

    @Override
    public E remove(int n) {
        E e = this.backingList.remove(n);
        this.callObservers(new NonIterableChange.SimpleRemovedChange<E>(n, n, e, this));
        return e;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n != -1) {
            this.remove(n);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.removeFromList(this.backingList, 0, collection, false);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.removeFromList(this.backingList, 0, collection, true);
    }

    @Override
    public E set(int n, E e) {
        E e2 = this.backingList.set(n, e);
        this.callObservers(new NonIterableChange.SimpleRemovedChange<E>(n, n + 1, e2, this));
        return e2;
    }

    @Override
    public boolean setAll(Collection<? extends E> collection) {
        List<E> list = Collections.unmodifiableList(new ArrayList<E>(this.backingList));
        this.backingList.clear();
        this.backingList.addAll(collection);
        this.callObservers(new NonIterableChange.GenericAddRemoveChange<E>(0, collection.size(), list, this));
        return true;
    }

    @Override
    public boolean addAll(E ... EArray) {
        return this.addAll((Collection<? extends E>)Arrays.asList(EArray));
    }

    @Override
    public boolean setAll(E ... EArray) {
        return this.setAll((Collection<? extends E>)Arrays.asList(EArray));
    }

    @Override
    public boolean removeAll(E ... EArray) {
        return this.removeAll((Collection<?>)Arrays.asList(EArray));
    }

    @Override
    public boolean retainAll(E ... EArray) {
        return this.retainAll((Collection<?>)Arrays.asList(EArray));
    }

    @Override
    public void remove(int n, int n2) {
        this.subList(n, n2).clear();
    }

    @Override
    public int size() {
        return this.backingList.size();
    }

    @Override
    public List<E> subList(int n, int n2) {
        return new ObservableSubList(n, n2);
    }

    @Override
    public Object[] toArray() {
        return this.backingList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.backingList.toArray(TArray);
    }

    public String toString() {
        return this.backingList.toString();
    }

    protected boolean removeFromList(List<E> list, int n, Collection<?> collection, boolean bl) {
        IterableChangeBuilder<E> iterableChangeBuilder = new IterableChangeBuilder<E>(this);
        for (int i = 0; i < list.size(); ++i) {
            E e = list.get(i);
            if (!(collection.contains(e) ^ bl)) continue;
            iterableChangeBuilder.nextSimpleRemove(n + i, e);
            list.remove(i);
            --i;
        }
        if (iterableChangeBuilder.isEmpty()) {
            return false;
        }
        this.callObservers(iterableChangeBuilder.buildAndReset());
        return true;
    }

    @Override
    public void sort() {
        if (this.backingList.isEmpty()) {
            return;
        }
        int[] nArray = this.getSortHelper().sort(this.backingList);
        this.callObservers(new NonIterableChange.SimplePermutationChange(0, this.size(), nArray, this));
    }

    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.backingList.isEmpty()) {
            return;
        }
        int[] nArray = this.getSortHelper().sort(this.backingList, comparator);
        this.callObservers(new NonIterableChange.SimplePermutationChange(0, this.size(), nArray, this));
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }

    class ObservableListIterator
    implements ListIterator<E> {
        Iterator<E> backingIt;
        ListIterator<E> backingListIt;
        int cursor;
        E current;
        boolean forward = true;

        ObservableListIterator(Iterator<E> iterator, int n, int n2) {
            this.backingIt = iterator;
            this.cursor = n + n2;
        }

        ObservableListIterator(ListIterator<E> listIterator, int n, int n2) {
            this((Iterator)listIterator, n, n2);
            this.backingListIt = listIterator;
        }

        @Override
        public void add(E e) {
            this.backingListIt.add(e);
            ++this.cursor;
            ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleAddChange(this.cursor - 1, this.cursor, ObservableListWrapper.this));
        }

        @Override
        public boolean hasNext() {
            return this.backingIt.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.backingListIt.hasPrevious();
        }

        @Override
        public E next() {
            this.current = this.backingIt.next();
            ++this.cursor;
            this.forward = true;
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.backingListIt.nextIndex();
        }

        @Override
        public E previous() {
            this.current = this.backingListIt.previous();
            --this.cursor;
            this.forward = false;
            return this.current;
        }

        @Override
        public int previousIndex() {
            return this.backingListIt.previousIndex();
        }

        @Override
        public void remove() {
            this.backingIt.remove();
            if (this.forward) {
                --this.cursor;
            }
            ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleRemovedChange(this.cursor, this.cursor, this.current, ObservableListWrapper.this));
        }

        @Override
        public void set(E e) {
            this.backingListIt.set(e);
            if (this.forward) {
                ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleRemovedChange(this.cursor - 1, this.cursor, this.current, ObservableListWrapper.this));
            } else {
                ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleRemovedChange(this.cursor, this.cursor + 1, this.current, ObservableListWrapper.this));
            }
        }
    }

    class ObservableSubList
    implements List<E> {
        int offset;
        int sz;
        List<E> backingSubList;

        ObservableSubList(int n, int n2) {
            if (n < 0 || n2 > ObservableListWrapper.this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (n > n2) {
                throw new IllegalArgumentException();
            }
            this.offset = n;
            this.sz = n2 - n;
            this.backingSubList = ObservableListWrapper.this.backingList.subList(this.offset, this.offset + this.sz);
        }

        @Override
        public boolean add(E e) {
            this.add(this.sz, e);
            return true;
        }

        @Override
        public void add(int n, E e) {
            this.backingSubList.add(n, e);
            ++this.sz;
            ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleAddChange(this.offset + n, this.offset + n + 1, ObservableListWrapper.this));
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            return this.addAll(this.sz, collection);
        }

        @Override
        public boolean addAll(int n, Collection<? extends E> collection) {
            boolean bl = this.backingSubList.addAll(n, collection);
            if (bl) {
                this.sz += collection.size();
                ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleAddChange(this.offset + n, this.offset + n + collection.size(), ObservableListWrapper.this));
            }
            return bl;
        }

        @Override
        public void clear() {
            List list = ObservableListWrapper.this.hasObserver() ? Collections.unmodifiableList(new ArrayList(this.backingSubList)) : null;
            this.backingSubList.clear();
            this.sz = 0;
            ObservableListWrapper.this.callObservers(new NonIterableChange.GenericAddRemoveChange(this.offset, this.offset, list, ObservableListWrapper.this));
        }

        @Override
        public boolean contains(Object object) {
            return this.indexOf(object) >= 0;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.backingSubList.containsAll(collection);
        }

        @Override
        public boolean equals(Object object) {
            return ((Object)this.backingSubList).equals(object);
        }

        @Override
        public E get(int n) {
            return this.backingSubList.get(n);
        }

        @Override
        public int hashCode() {
            return ((Object)this.backingSubList).hashCode();
        }

        @Override
        public int indexOf(Object object) {
            return this.backingSubList.indexOf(object);
        }

        @Override
        public boolean isEmpty() {
            return this.backingSubList.isEmpty();
        }

        @Override
        public Iterator<E> iterator() {
            return new ObservableListIterator(this.backingSubList.iterator(), this.offset, 0);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.backingSubList.lastIndexOf(object);
        }

        @Override
        public ListIterator<E> listIterator() {
            return new ObservableListIterator(this.backingSubList.listIterator(), this.offset, 0);
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            return new ObservableListIterator(this.backingSubList.listIterator(n), this.offset, n);
        }

        @Override
        public E remove(int n) {
            Object e = this.backingSubList.remove(n);
            if (e != null) {
                --this.sz;
                ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleRemovedChange(this.offset + n, this.offset + n, e, ObservableListWrapper.this));
            }
            return e;
        }

        @Override
        public boolean remove(Object object) {
            for (int i = 0; i < this.sz; ++i) {
                Object e = this.get(i);
                if ((e != null || object != null) && (e == null || !e.equals(object))) continue;
                this.remove(i);
                return true;
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = ObservableListWrapper.this.removeFromList(this.backingSubList, this.offset, collection, false);
            this.sz = this.backingSubList.size();
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            boolean bl = ObservableListWrapper.this.removeFromList(this.backingSubList, this.offset, collection, true);
            this.sz = this.backingSubList.size();
            return bl;
        }

        @Override
        public E set(int n, E e) {
            Object e2 = this.backingSubList.set(n, e);
            ObservableListWrapper.this.callObservers(new NonIterableChange.SimpleRemovedChange(this.offset + n, this.offset + n + 1, e2, ObservableListWrapper.this));
            return e2;
        }

        @Override
        public int size() {
            return this.backingSubList.size();
        }

        @Override
        public List<E> subList(int n, int n2) {
            this.rangeCheck(n);
            if (n2 < n) {
                throw new IllegalArgumentException();
            }
            return ObservableListWrapper.this.subList(this.offset + n, this.offset + n2);
        }

        @Override
        public Object[] toArray() {
            return this.backingSubList.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.backingSubList.toArray(TArray);
        }

        public String toString() {
            return this.backingSubList.toString();
        }

        private void rangeCheck(int n) {
            if (n < 0 || n >= this.sz) {
                throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
            }
        }

        private String outOfBoundsMsg(int n) {
            return "Index: " + n + ", Size: " + this.sz;
        }
    }
}

