/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import java.util.AbstractList;
import java.util.List;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;

public final class MappingChange<E, F>
extends ListChangeListener.Change<F> {
    private final Map<E, F> map;
    private final ListChangeListener.Change<? extends E> original;
    private List<F> removed;
    public static final Map NOOP_MAP = new Map(){

        public Object map(Object object) {
            return object;
        }
    };

    public MappingChange(ListChangeListener.Change<? extends E> change, Map<E, F> map, ObservableList<F> observableList) {
        super(observableList);
        this.original = change;
        this.map = map;
    }

    @Override
    public boolean next() {
        return this.original.next();
    }

    @Override
    public void reset() {
        this.original.reset();
    }

    @Override
    public int getFrom() {
        return this.original.getFrom();
    }

    @Override
    public int getTo() {
        return this.original.getTo();
    }

    @Override
    public List<F> getRemoved() {
        if (this.removed == null) {
            this.removed = new AbstractList<F>(){

                @Override
                public F get(int n) {
                    return MappingChange.this.map.map(MappingChange.this.original.getRemoved().get(n));
                }

                @Override
                public int size() {
                    return MappingChange.this.original.getRemovedSize();
                }
            };
        }
        return this.removed;
    }

    @Override
    protected int[] getPermutation() {
        return null;
    }

    @Override
    public boolean wasPermutated() {
        return this.original.wasPermutated();
    }

    @Override
    public int getPermutation(int n) {
        return this.original.getPermutation(n);
    }

    public static interface Map<E, F> {
        public F map(E var1);
    }
}

