/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import java.lang.ref.WeakReference;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.FloatPropertyBase;
import javafx.beans.property.IntegerPropertyBase;
import javafx.beans.property.LongPropertyBase;
import javafx.beans.property.Property;

public abstract class BidirectionalBinding<T>
implements InvalidationListener {
    private final int cachedHashCode;

    private static void checkParameters(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException("Both properties must be specified.");
        }
        if (object.equals(object2)) {
            throw new IllegalArgumentException("Cannot bind property to itself");
        }
    }

    public static <T> BidirectionalBinding<T> bind(Property<T> property, Property<T> property2) {
        BidirectionalBinding.checkParameters(property, property2);
        BidirectionalBinding bidirectionalBinding = property instanceof DoublePropertyBase && property2 instanceof DoublePropertyBase ? new BidirectionalDoubleBinding((DoublePropertyBase)property, (DoublePropertyBase)property2) : (property instanceof FloatPropertyBase && property2 instanceof FloatPropertyBase ? new BidirectionalFloatBinding((FloatPropertyBase)property, (FloatPropertyBase)property2) : (property instanceof IntegerPropertyBase && property2 instanceof IntegerPropertyBase ? new BidirectionalIntegerBinding((IntegerPropertyBase)property, (IntegerPropertyBase)property2) : (property instanceof LongPropertyBase && property2 instanceof LongPropertyBase ? new BidirectionalLongBinding((LongPropertyBase)property, (LongPropertyBase)property2) : (property instanceof BooleanPropertyBase && property2 instanceof BooleanPropertyBase ? new BidirectionalBooleanBinding((BooleanPropertyBase)property, (BooleanPropertyBase)property2) : new GenericBidirectionalBinding(property, property2)))));
        property.setValue(property2.getValue());
        property.addListener(bidirectionalBinding);
        property2.addListener(bidirectionalBinding);
        return bidirectionalBinding;
    }

    public static <T> void unbind(Property<T> property, Property<T> property2) {
        BidirectionalBinding.checkParameters(property, property2);
        GenericBidirectionalBinding genericBidirectionalBinding = new GenericBidirectionalBinding(property, property2);
        property.removeListener(genericBidirectionalBinding);
        property2.removeListener(genericBidirectionalBinding);
    }

    private BidirectionalBinding(Property<T> property, Property<T> property2) {
        this.cachedHashCode = property.hashCode() * property2.hashCode();
    }

    protected abstract Property<T> getProperty1();

    protected abstract Property<T> getProperty2();

    public int hashCode() {
        return this.cachedHashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Property<T> property = this.getProperty1();
        Property<T> property2 = this.getProperty2();
        if (property == null || property2 == null) {
            return false;
        }
        if (object instanceof BidirectionalBinding) {
            BidirectionalBinding bidirectionalBinding = (BidirectionalBinding)object;
            Property<T> property3 = bidirectionalBinding.getProperty1();
            Property<T> property4 = bidirectionalBinding.getProperty2();
            if (property3 == null || property4 == null) {
                return false;
            }
            if (property.equals(property3) && property2.equals(property4)) {
                return true;
            }
            if (property.equals(property4) && property2.equals(property3)) {
                return true;
            }
        }
        return false;
    }

    private static class GenericBidirectionalBinding<T>
    extends BidirectionalBinding<T> {
        private final WeakReference<Property<T>> propertyRef1;
        private final WeakReference<Property<T>> propertyRef2;
        private boolean updating = false;

        private GenericBidirectionalBinding(Property<T> property, Property<T> property2) {
            super(property, property2);
            this.propertyRef1 = new WeakReference<Property<Property<T>>>(property);
            this.propertyRef2 = new WeakReference<Property<Property<T>>>(property2);
        }

        @Override
        protected Property<T> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<T> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                Property property = (Property)this.propertyRef1.get();
                Property property2 = (Property)this.propertyRef2.get();
                if (property == null || property2 == null) {
                    if (property != null) {
                        property.removeListener(this);
                    }
                    if (property2 != null) {
                        property2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (property.equals(observable)) {
                            property2.setValue(property.getValue());
                        } else {
                            property.setValue(property2.getValue());
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalLongBinding
    extends BidirectionalBinding<Number> {
        private final WeakReference<LongPropertyBase> propertyRef1;
        private final WeakReference<LongPropertyBase> propertyRef2;
        private boolean updating = false;

        private BidirectionalLongBinding(LongPropertyBase longPropertyBase, LongPropertyBase longPropertyBase2) {
            super(longPropertyBase, longPropertyBase2);
            this.propertyRef1 = new WeakReference<LongPropertyBase>(longPropertyBase);
            this.propertyRef2 = new WeakReference<LongPropertyBase>(longPropertyBase2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                LongPropertyBase longPropertyBase = (LongPropertyBase)this.propertyRef1.get();
                LongPropertyBase longPropertyBase2 = (LongPropertyBase)this.propertyRef2.get();
                if (longPropertyBase == null || longPropertyBase2 == null) {
                    if (longPropertyBase != null) {
                        longPropertyBase.removeListener(this);
                    }
                    if (longPropertyBase2 != null) {
                        longPropertyBase2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (longPropertyBase.equals(observable)) {
                            longPropertyBase2.set(longPropertyBase.get());
                        } else {
                            longPropertyBase.set(longPropertyBase2.get());
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalIntegerBinding
    extends BidirectionalBinding<Number> {
        private final WeakReference<IntegerPropertyBase> propertyRef1;
        private final WeakReference<IntegerPropertyBase> propertyRef2;
        private boolean updating = false;

        private BidirectionalIntegerBinding(IntegerPropertyBase integerPropertyBase, IntegerPropertyBase integerPropertyBase2) {
            super(integerPropertyBase, integerPropertyBase2);
            this.propertyRef1 = new WeakReference<IntegerPropertyBase>(integerPropertyBase);
            this.propertyRef2 = new WeakReference<IntegerPropertyBase>(integerPropertyBase2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                IntegerPropertyBase integerPropertyBase = (IntegerPropertyBase)this.propertyRef1.get();
                IntegerPropertyBase integerPropertyBase2 = (IntegerPropertyBase)this.propertyRef2.get();
                if (integerPropertyBase == null || integerPropertyBase2 == null) {
                    if (integerPropertyBase != null) {
                        integerPropertyBase.removeListener(this);
                    }
                    if (integerPropertyBase2 != null) {
                        integerPropertyBase2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (integerPropertyBase.equals(observable)) {
                            integerPropertyBase2.set(integerPropertyBase.get());
                        } else {
                            integerPropertyBase.set(integerPropertyBase2.get());
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalFloatBinding
    extends BidirectionalBinding<Number> {
        private final WeakReference<FloatPropertyBase> propertyRef1;
        private final WeakReference<FloatPropertyBase> propertyRef2;
        private boolean updating = false;

        private BidirectionalFloatBinding(FloatPropertyBase floatPropertyBase, FloatPropertyBase floatPropertyBase2) {
            super(floatPropertyBase, floatPropertyBase2);
            this.propertyRef1 = new WeakReference<FloatPropertyBase>(floatPropertyBase);
            this.propertyRef2 = new WeakReference<FloatPropertyBase>(floatPropertyBase2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                FloatPropertyBase floatPropertyBase = (FloatPropertyBase)this.propertyRef1.get();
                FloatPropertyBase floatPropertyBase2 = (FloatPropertyBase)this.propertyRef2.get();
                if (floatPropertyBase == null || floatPropertyBase2 == null) {
                    if (floatPropertyBase != null) {
                        floatPropertyBase.removeListener(this);
                    }
                    if (floatPropertyBase2 != null) {
                        floatPropertyBase2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (floatPropertyBase.equals(observable)) {
                            floatPropertyBase2.set(floatPropertyBase.get());
                        } else {
                            floatPropertyBase.set(floatPropertyBase2.get());
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalDoubleBinding
    extends BidirectionalBinding<Number> {
        private final WeakReference<DoublePropertyBase> propertyRef1;
        private final WeakReference<DoublePropertyBase> propertyRef2;
        private boolean updating = false;

        private BidirectionalDoubleBinding(DoublePropertyBase doublePropertyBase, DoublePropertyBase doublePropertyBase2) {
            super(doublePropertyBase, doublePropertyBase2);
            this.propertyRef1 = new WeakReference<DoublePropertyBase>(doublePropertyBase);
            this.propertyRef2 = new WeakReference<DoublePropertyBase>(doublePropertyBase2);
        }

        @Override
        protected Property<Number> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Number> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                DoublePropertyBase doublePropertyBase = (DoublePropertyBase)this.propertyRef1.get();
                DoublePropertyBase doublePropertyBase2 = (DoublePropertyBase)this.propertyRef2.get();
                if (doublePropertyBase == null || doublePropertyBase2 == null) {
                    if (doublePropertyBase != null) {
                        doublePropertyBase.removeListener(this);
                    }
                    if (doublePropertyBase2 != null) {
                        doublePropertyBase2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (doublePropertyBase.equals(observable)) {
                            doublePropertyBase2.set(doublePropertyBase.get());
                        } else {
                            doublePropertyBase.set(doublePropertyBase2.get());
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }

    private static class BidirectionalBooleanBinding
    extends BidirectionalBinding<Boolean> {
        private final WeakReference<BooleanPropertyBase> propertyRef1;
        private final WeakReference<BooleanPropertyBase> propertyRef2;
        private boolean updating = false;

        private BidirectionalBooleanBinding(BooleanPropertyBase booleanPropertyBase, BooleanPropertyBase booleanPropertyBase2) {
            super(booleanPropertyBase, booleanPropertyBase2);
            this.propertyRef1 = new WeakReference<BooleanPropertyBase>(booleanPropertyBase);
            this.propertyRef2 = new WeakReference<BooleanPropertyBase>(booleanPropertyBase2);
        }

        @Override
        protected Property<Boolean> getProperty1() {
            return (Property)this.propertyRef1.get();
        }

        @Override
        protected Property<Boolean> getProperty2() {
            return (Property)this.propertyRef2.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invalidated(Observable observable) {
            if (!this.updating) {
                BooleanPropertyBase booleanPropertyBase = (BooleanPropertyBase)this.propertyRef1.get();
                BooleanPropertyBase booleanPropertyBase2 = (BooleanPropertyBase)this.propertyRef2.get();
                if (booleanPropertyBase == null || booleanPropertyBase2 == null) {
                    if (booleanPropertyBase != null) {
                        booleanPropertyBase.removeListener(this);
                    }
                    if (booleanPropertyBase2 != null) {
                        booleanPropertyBase2.removeListener(this);
                    }
                } else {
                    try {
                        this.updating = true;
                        if (booleanPropertyBase.equals(observable)) {
                            booleanPropertyBase2.set(booleanPropertyBase.get());
                        } else {
                            booleanPropertyBase.set(booleanPropertyBase2.get());
                        }
                    }
                    finally {
                        this.updating = false;
                    }
                }
            }
        }
    }
}

