/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.application;

import com.sun.javafx.runtime.SystemProperties;
import com.sun.javafx.tk.TKListener;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.application.ConditionalFeature;

public class PlatformImpl {
    private static AtomicBoolean initialized = new AtomicBoolean(false);
    private static AtomicBoolean platformExit = new AtomicBoolean(false);
    private static AtomicBoolean toolkitExit = new AtomicBoolean(false);
    private static CountDownLatch startupLatch = new CountDownLatch(1);
    private static AtomicBoolean listenersRegistered = new AtomicBoolean(false);
    private static TKListener toolkitListener = null;
    private static AtomicInteger pendingRunnables = new AtomicInteger(0);
    private static AtomicInteger numWindows = new AtomicInteger(0);
    private static volatile boolean firstWindowShown = false;
    private static volatile boolean lastWindowClosed = false;
    private static AtomicBoolean reallyIdle = new AtomicBoolean(false);
    private static Set<FinishListener> finishListeners = new CopyOnWriteArraySet<FinishListener>();

    public static void startup(final Runnable runnable) {
        if (platformExit.get()) {
            throw new IllegalStateException("Platform.exit has been called");
        }
        if (initialized.getAndSet(true)) {
            PlatformImpl.runLater(runnable);
            return;
        }
        toolkitListener = new TKListener(){

            @Override
            public void changedTopLevelWindows(List<TKStage> list) {
                numWindows.set(list.size());
                PlatformImpl.checkIdle();
            }
        };
        Toolkit.getToolkit().addTkListener(toolkitListener);
        Toolkit.getToolkit().startup(new Runnable(){

            @Override
            public void run() {
                startupLatch.countDown();
                runnable.run();
            }
        });
    }

    private static void waitForStart() {
        if (startupLatch.getCount() > 0L) {
            try {
                startupLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static boolean isFxApplicationThread() {
        return Toolkit.getToolkit().isFxUserThread();
    }

    public static void runLater(Runnable runnable) {
        PlatformImpl.runLater(runnable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runLater(final Runnable runnable, boolean bl) {
        if (!initialized.get()) {
            throw new IllegalStateException("Toolkit not initialized");
        }
        pendingRunnables.incrementAndGet();
        PlatformImpl.waitForStart();
        if (SystemProperties.isDebug()) {
            Toolkit.getToolkit().pauseCurrentThread();
        }
        Class<PlatformImpl> clazz = PlatformImpl.class;
        synchronized (PlatformImpl.class) {
            if (!bl && toolkitExit.get()) {
                pendingRunnables.decrementAndGet();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            Toolkit.getToolkit().defer(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                        pendingRunnables.decrementAndGet();
                        PlatformImpl.checkIdle();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in runnable");
                        throwable.printStackTrace();
                    }
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void runAndWait(Runnable runnable) {
        PlatformImpl.runAndWait(runnable, false);
    }

    private static void runAndWait(final Runnable runnable, boolean bl) {
        if (SystemProperties.isDebug()) {
            Toolkit.getToolkit().pauseCurrentThread();
        }
        if (PlatformImpl.isFxApplicationThread()) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                System.err.println("Exception in runnable");
                throwable.printStackTrace();
            }
        } else {
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            PlatformImpl.runLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        System.err.println("Exception in runnable");
                        throwable.printStackTrace();
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            }, bl);
            if (!bl && toolkitExit.get()) {
                throw new IllegalStateException("Toolkit has exited");
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public static void addListener(FinishListener finishListener) {
        listenersRegistered.set(true);
        finishListeners.add(finishListener);
    }

    public static void removeListener(FinishListener finishListener) {
        finishListeners.remove(finishListener);
    }

    private static void notifyFinishListeners(boolean bl) {
        for (FinishListener finishListener : finishListeners) {
            if (bl) {
                finishListener.exitCalled();
                continue;
            }
            finishListener.idle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkIdle() {
        boolean bl = false;
        Class<PlatformImpl> clazz = PlatformImpl.class;
        synchronized (PlatformImpl.class) {
            int n = numWindows.get();
            if (n > 0) {
                firstWindowShown = true;
                lastWindowClosed = false;
                reallyIdle.set(false);
            } else if (n == 0 && firstWindowShown) {
                lastWindowClosed = true;
            }
            if (lastWindowClosed && pendingRunnables.get() == 0) {
                if (reallyIdle.getAndSet(true)) {
                    bl = true;
                    lastWindowClosed = false;
                } else {
                    PlatformImpl.runLater(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (bl) {
                PlatformImpl.notifyFinishListeners(false);
            }
            return;
        }
    }

    public static void tkExit() {
        if (toolkitExit.getAndSet(true)) {
            return;
        }
        if (initialized.get()) {
            PlatformImpl.runAndWait(new Runnable(){

                @Override
                public void run() {
                    Toolkit.getToolkit().exit();
                }
            }, true);
            Toolkit.getToolkit().removeTkListener(toolkitListener);
            toolkitListener = null;
        }
    }

    public static void exit() {
        platformExit.set(true);
        if (listenersRegistered.get()) {
            PlatformImpl.notifyFinishListeners(true);
        } else {
            PlatformImpl.tkExit();
        }
    }

    public static boolean isSupported(ConditionalFeature conditionalFeature) {
        return Toolkit.getToolkit().isSupported(conditionalFeature);
    }

    public static interface FinishListener {
        public void idle();

        public void exitCalled();
    }
}

