﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace IntegracaoPosSitef.Util
{
    public class Tabelas
    {
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();

        Dictionary<string, string> tabelaBandeira = new Dictionary<string, string>();
        Dictionary<string, string> tabelaCodigoTransacao = new Dictionary<string, string>();
        Dictionary<string, string> tabelaRede = new Dictionary<string, string>();
        Dictionary<string, string> tabelaTipoParcelamento = new Dictionary<string, string>();
        Dictionary<int, string> tabelaCodigoResposta = new Dictionary<int, string>();
        Dictionary<int, string> tabelaTipoTransacao = new Dictionary<int, string>();

        public Tabelas()
        {
            SetNomeRede();
        }

        public string GetNomeCodResp(int codigo)
        {
            logger.Trace(string.Empty);
            foreach (var i in tabelaCodigoResposta)
            {
                if (i.Key == codigo)
                    return i.Value;
            }
            return "[" + codigo + "] Não encontrado.";
        }
        public string GetNomeBandeira(string codigo)
        {
            logger.Trace(string.Empty);
            foreach (var i in tabelaBandeira)
            {
                if (i.Key == codigo)
                    return i.Value;
            }
            return "[" + codigo + "] Não encontrado.";
        }
        public string GetNomeRede(string codigo)
        {
            logger.Trace(string.Empty);
            foreach (var i in tabelaRede)
            {
                if (i.Key == codigo)
                    return i.Value;
            }
            return "[" + codigo + "] Não encontrado.";
        }
        public string GetNomeTipoParcelamento(string codigo)
        {
            logger.Trace(string.Empty);
            foreach (var i in tabelaTipoParcelamento)
            {
                if (i.Key == codigo)
                    return i.Value;
            }
            return "[" + codigo + "] Não encontrado.";
        }
        public string GetNomeCodigoTransacao(string codigo)
        {
            logger.Trace(string.Empty);
            foreach (var i in tabelaCodigoTransacao)
            {
                if (i.Key == codigo)
                    return i.Value;
            }
            return "[" + codigo + "] Não encontrado.";
        }
        public string GetNomeTipoTrn(int codigo)
        {
            logger.Trace(string.Empty);
            foreach (var i in tabelaTipoTransacao)
            {
                if (i.Key == codigo)
                    return i.Value;
            }
            return "[" + codigo + "] Não encontrado.";
        }
        public void SetNomeRede()
        {
            logger.Trace(string.Empty);
            try
            {
                //Bandeira
                if (tabelaBandeira.Count == 0)
                {
                    #region SITEF
                    tabelaBandeira.Add("00000", "OUTROS");
                    tabelaBandeira.Add("00001", "VISA");
                    tabelaBandeira.Add("00002", "MASTERCARD");
                    tabelaBandeira.Add("00003", "DINERS CLUB");
                    tabelaBandeira.Add("00004", "AMERICAN EXPRESS");
                    tabelaBandeira.Add("00005", "SOLLO");
                    tabelaBandeira.Add("00006", "Sidecard (Redecard)");
                    tabelaBandeira.Add("00007", "Private Label (Redecard)");
                    tabelaBandeira.Add("00008", "REDESHOP");
                    tabelaBandeira.Add("00009", "Pão de Açúcar");
                    tabelaBandeira.Add("00010", "Fininvest (Visanet)");
                    tabelaBandeira.Add("00011", "JCB");
                    tabelaBandeira.Add("00012", "HIPERCARD");
                    tabelaBandeira.Add("00013", "AURA");
                    tabelaBandeira.Add("00014", "LOSANGO");
                    tabelaBandeira.Add("00015", "SOROCRED");
                    tabelaBandeira.Add("10014", "Discovery");
                    #endregion
                }

                //REDE AUT
                if (tabelaRede.Count == 0)
                {
                    #region SITEF
                    tabelaRede.Add("00000", "OUTROS");
                    tabelaRede.Add("00001", "TECBAN");
                    tabelaRede.Add("00002", "ITAU");
                    tabelaRede.Add("00003", "BRADESCO");
                    tabelaRede.Add("00004", "VISANET");
                    tabelaRede.Add("00005", "REDE");
                    tabelaRede.Add("00006", "AMEX");
                    tabelaRede.Add("00007", "SOLLO");
                    tabelaRede.Add("00008", "E CAPTURE");
                    tabelaRede.Add("00009", "SERASA");
                    tabelaRede.Add("00010", "SPC BRASIL");
                    tabelaRede.Add("00011", "SERASA DETALHADO");
                    tabelaRede.Add("00012", "TELEDATA");
                    tabelaRede.Add("00013", "ACSP");
                    tabelaRede.Add("00014", "ACSP DETALHADO");
                    tabelaRede.Add("00015", "TECBIZ");
                    tabelaRede.Add("00016", "CDL DF");
                    tabelaRede.Add("00017", "Repom");
                    tabelaRede.Add("00018", "STANDBY");
                    tabelaRede.Add("00019", "EDMCARD");
                    tabelaRede.Add("00020", "CREDICESTA");
                    tabelaRede.Add("00021", "BANRICOMPRAS");
                    tabelaRede.Add("00022", "ACC CARD");
                    tabelaRede.Add("00023", "Clubcard");
                    tabelaRede.Add("00024", "ACPR");
                    tabelaRede.Add("00025", "Vidalink");
                    tabelaRede.Add("00026", "CCC_WEB");
                    tabelaRede.Add("00027", "Ediguay");
                    tabelaRede.Add("00028", "Carrefour");
                    tabelaRede.Add("00029", "SOFTWAY");
                    tabelaRede.Add("00030", "MULTICHEQUE");
                    tabelaRede.Add("00031", "Ticket combustível");
                    tabelaRede.Add("00032", "YAMADA");
                    tabelaRede.Add("00033", "Citibank");
                    tabelaRede.Add("00034", "Infocard");
                    tabelaRede.Add("00035", "BESC");
                    tabelaRede.Add("00036", "EMS");
                    tabelaRede.Add("00037", "CHEQUE CASH");
                    tabelaRede.Add("00038", "CENTRAL CARD");
                    tabelaRede.Add("00039", "Drogaraia");
                    tabelaRede.Add("00040", "OUTRO SERVIÇO");
                    tabelaRede.Add("00041", "ACCOR");
                    tabelaRede.Add("00042", "EPAY GIFT");
                    tabelaRede.Add("00043", "Parati");
                    tabelaRede.Add("00044", "Tokoró");
                    tabelaRede.Add("00045", "COOPERCRED");
                    tabelaRede.Add("00046", "SERVCEL");
                    tabelaRede.Add("00047", "SOROCRED");
                    tabelaRede.Add("00048", "Vital");
                    tabelaRede.Add("00049", "SAX FINANCEIRA");
                    tabelaRede.Add("00050", "Formosa");
                    tabelaRede.Add("00051", "HIPERCARD");
                    tabelaRede.Add("00052", "Tricard");
                    tabelaRede.Add("00053", "CHECK OK");
                    tabelaRede.Add("00054", "POLICARD");
                    tabelaRede.Add("00055", "Cetelem Carrefour");
                    tabelaRede.Add("00056", "LEADER");
                    tabelaRede.Add("00057", "Consórcio Credicard Venezuela");
                    tabelaRede.Add("00058", "GAZINCRED");
                    tabelaRede.Add("00059", "TELENET");
                    tabelaRede.Add("00060", "Cheque Pré");
                    tabelaRede.Add("00061", "BRASIL CARD");
                    tabelaRede.Add("00062", "Epharma");
                    tabelaRede.Add("00063", "Total");
                    tabelaRede.Add("00064", "Consórcio Amex Venezuela");
                    tabelaRede.Add("00065", "GAX");
                    tabelaRede.Add("00066", "Peralta");
                    tabelaRede.Add("00067", "SERVIDOR PAGAMENTO");
                    tabelaRede.Add("00068", "BANESE");
                    tabelaRede.Add("00069", "RESOMAQ");
                    tabelaRede.Add("00070", "SYSDATA");
                    tabelaRede.Add("00071", "CDL POA");
                    tabelaRede.Add("00072", "BIGCARD");
                    tabelaRede.Add("00073", "DTRANSFER");
                    tabelaRede.Add("00074", "VIAVAREJO");
                    tabelaRede.Add("00075", "Check Express");
                    tabelaRede.Add("00076", "GIVEX");
                    tabelaRede.Add("00077", "Valecard");
                    tabelaRede.Add("00078", "Portal Card");
                    tabelaRede.Add("00079", "BANPARA");
                    tabelaRede.Add("00080", "SOFTNEX");
                    tabelaRede.Add("00081", "SuperCard");
                    tabelaRede.Add("00082", "GETNET");
                    tabelaRede.Add("00083", "PREVSAUDE");
                    tabelaRede.Add("00084", "BANCO POTTENCIAL");
                    tabelaRede.Add("00085", "SOPHUS");
                    tabelaRede.Add("00086", "MARISA 2");
                    tabelaRede.Add("00087", "MaxiCred");
                    tabelaRede.Add("00088", "BLACKHAWK");
                    tabelaRede.Add("00089", "EXPANSIVA");
                    tabelaRede.Add("00090", "SAS NT");
                    tabelaRede.Add("00091", "LEADER 2");
                    tabelaRede.Add("00092", "Somar");
                    tabelaRede.Add("00093", "CETELEM AURA");
                    tabelaRede.Add("00094", "CABAL");
                    tabelaRede.Add("00095", "CREDSYSTEM");
                    tabelaRede.Add("00096", "Banco Provincial");
                    tabelaRede.Add("00097", "CARTESYS");
                    tabelaRede.Add("00098", "CISA");
                    tabelaRede.Add("00099", "TRNCENTRE");
                    tabelaRede.Add("00100", "ACPR D");
                    tabelaRede.Add("00101", "CARDCO");
                    tabelaRede.Add("00102", "CHECK CHECK");
                    tabelaRede.Add("00103", "CADASA");
                    tabelaRede.Add("00104", "PRIVATE BRADESCO");
                    tabelaRede.Add("00105", "CREDMAIS");
                    tabelaRede.Add("00106", "GWCEL");
                    tabelaRede.Add("00107", "CHECK EXPRESS 2");
                    tabelaRede.Add("00108", "GETNET PBM");
                    tabelaRede.Add("00109", "USECRED");
                    tabelaRede.Add("00110", "SERV VOUCHER");
                    tabelaRede.Add("00111", "TREDENEXX");
                    tabelaRede.Add("00112", "Bonus Presente Carrefour");
                    tabelaRede.Add("00113", "CREDISHOP");
                    tabelaRede.Add("00114", "ESTAPAR");
                    tabelaRede.Add("00115", "Banco Ibi");
                    tabelaRede.Add("00116", "WORKERCARD");
                    tabelaRede.Add("00117", "Telecheque");
                    tabelaRede.Add("00118", "OBOE");
                    tabelaRede.Add("00119", "PROTEGE");
                    tabelaRede.Add("00120", "SERASA CARDS");
                    tabelaRede.Add("00121", "Hotcard");
                    tabelaRede.Add("00122", "Banco Panamericano");
                    tabelaRede.Add("00123", "Banco Mercantil");
                    tabelaRede.Add("00124", "Sigacred");
                    tabelaRede.Add("00125", "CIELO");
                    tabelaRede.Add("00126", "SPTRANS");
                    tabelaRede.Add("00127", "PRESENTE MARISA");
                    tabelaRede.Add("00128", "COOPLIFE");
                    tabelaRede.Add("00129", "BOD");
                    tabelaRede.Add("00130", "G CARD");
                    tabelaRede.Add("00131", "TCREDIT");
                    tabelaRede.Add("00132", "Siscred");
                    tabelaRede.Add("00133", "FOXWINCARDS");
                    tabelaRede.Add("00134", "CONVCARD");
                    tabelaRede.Add("00135", "Voucher");
                    tabelaRede.Add("00136", "EXPAND CARDS");
                    tabelaRede.Add("00137", "ULTRAGAZ");
                    tabelaRede.Add("00138", "Qualicard");
                    tabelaRede.Add("00139", "HSBC UK");
                    tabelaRede.Add("00140", "WAPPA");
                    tabelaRede.Add("00141", "SQCF");
                    tabelaRede.Add("00142", "INTELLISYS");
                    tabelaRede.Add("00143", "BOD DÉBITO");
                    tabelaRede.Add("00144", "ACCREDITO");
                    tabelaRede.Add("00145", "COMPROCARD");
                    tabelaRede.Add("00146", "ORGCARD");
                    tabelaRede.Add("00147", "MINASCRED");
                    tabelaRede.Add("00148", "Farmácia Popular");
                    tabelaRede.Add("00149", "Fidelidade Mais");
                    tabelaRede.Add("00150", "ITAÚ SHOPLINE");
                    tabelaRede.Add("00151", "CDL RIO");
                    tabelaRede.Add("00152", "FORTCARD");
                    tabelaRede.Add("00153", "PAGGO");
                    tabelaRede.Add("00154", "SMARTNET");
                    tabelaRede.Add("00155", "INTERFARMACIA");
                    tabelaRede.Add("00156", "VALECON");
                    tabelaRede.Add("00157", "CARTÃO EVANGÉLICO");
                    tabelaRede.Add("00158", "VEGASCARD");
                    tabelaRede.Add("00159", "SCCARD");
                    tabelaRede.Add("00160", "ORBITALL");
                    tabelaRede.Add("00161", "ICARDS");
                    tabelaRede.Add("00162", "FACILCARD");
                    tabelaRede.Add("00163", "Fidelize");
                    tabelaRede.Add("00164", "FINAMAX");
                    tabelaRede.Add("00165", "BANCO GE");
                    tabelaRede.Add("00166", "UNIK");
                    tabelaRede.Add("00167", "TIVIT");
                    tabelaRede.Add("00168", "VALIDATA");
                    tabelaRede.Add("00169", "BANESCARD");
                    tabelaRede.Add("00170", "CSU CARREFOUR");
                    tabelaRede.Add("00171", "Valeshop");
                    tabelaRede.Add("00172", "SOMAR CARD");
                    tabelaRede.Add("00173", "OMNION");
                    tabelaRede.Add("00174", "CONDOR");
                    tabelaRede.Add("00175", "STANDBYDUP");
                    tabelaRede.Add("00176", "BPAG BOLDCRON");
                    tabelaRede.Add("00177", "MARISA SAX SYSIN");
                    tabelaRede.Add("00178", "STARFICHE");
                    tabelaRede.Add("00179", "ACE SEGUROS");
                    tabelaRede.Add("00180", "TOP CARD");
                    tabelaRede.Add("00181", "GETNET LAC");
                    tabelaRede.Add("00182", "UP SIGHT");
                    tabelaRede.Add("00183", "MAR");
                    tabelaRede.Add("00184", "Funcional Card");
                    tabelaRede.Add("00185", "PHARMA SYSTEM");
                    tabelaRede.Add("00186", "NEUS");
                    tabelaRede.Add("00187", "SICREDI");
                    tabelaRede.Add("00188", "ESCALENA");
                    tabelaRede.Add("00189", "N SERVIÇOS");
                    tabelaRede.Add("00190", "CSF CARREFOUR");
                    tabelaRede.Add("00191", "ATP");
                    tabelaRede.Add("00192", "AVST");
                    tabelaRede.Add("00193", "ALGORIX");
                    tabelaRede.Add("00194", "AMEX EMV");
                    tabelaRede.Add("00195", "COMPREMAX");
                    tabelaRede.Add("00196", "LIBERCARD");
                    tabelaRede.Add("00197", "SEICON");
                    tabelaRede.Add("00198", "SERASA AUTORIZ CRÉDITO");
                    tabelaRede.Add("00199", "SMARTN");
                    tabelaRede.Add("00200", "PLATCO");
                    tabelaRede.Add("00201", "SMARTNET EMV");
                    tabelaRede.Add("00202", "PROSA MÉXICO");
                    tabelaRede.Add("00203", "PEELA");
                    tabelaRede.Add("00204", "NUTRIK");
                    tabelaRede.Add("00205", "GOLDENFARMA PBM");
                    tabelaRede.Add("00206", "GLOBAL PAYMENTS");
                    tabelaRede.Add("00207", "ELAVON");
                    tabelaRede.Add("00208", "CTF");
                    tabelaRede.Add("00209", "BANESTIK");
                    tabelaRede.Add("00210", "VISA ARG");
                    tabelaRede.Add("00211", "AMEX ARG");
                    tabelaRede.Add("00212", "POSNET ARG");
                    tabelaRede.Add("00213", "AMEX MÉXICO");
                    tabelaRede.Add("00214", "ELETROZEMA");
                    tabelaRede.Add("00215", "BARIGUI");
                    tabelaRede.Add("00216", "SIMEC");
                    tabelaRede.Add("00217", "SGF");
                    tabelaRede.Add("00218", "HUG");
                    tabelaRede.Add("00219", "CARTÃO CONSIGNUM CARTÃO METTACARD");
                    tabelaRede.Add("00220", "DDTOTAL");
                    tabelaRede.Add("00221", "CARTÃO QUALIDADE");
                    tabelaRede.Add("00222", "REDECONV");
                    tabelaRede.Add("00223", "NUTRICARD");
                    tabelaRede.Add("00224", "DOTZ");
                    tabelaRede.Add("00225", "PREMIAÇÕES RAIZEN");
                    tabelaRede.Add("00226", "TROCO SOLIDÁRIO");
                    tabelaRede.Add("00227", "AMBEV SÓCIO TORCEDOR");
                    tabelaRede.Add("00228", "SEMPRE");
                    tabelaRede.Add("00229", "FIRST DATA");
                    tabelaRede.Add("00230", "COCIPA");
                    tabelaRede.Add("00231", "IBI MÉXICO");
                    tabelaRede.Add("00232", "SIANET");
                    tabelaRede.Add("00233", "SGCARDS");
                    tabelaRede.Add("00234", "CIAGROUP");
                    tabelaRede.Add("00235", "FILLIP");
                    tabelaRede.Add("00236", "Conductor");
                    tabelaRede.Add("00237", "LTM RAIZEN");
                    tabelaRede.Add("00238", "INCOMM");
                    tabelaRede.Add("00239", "VISA PASS FIRST");
                    tabelaRede.Add("00240", "CENCOSUD");
                    tabelaRede.Add("00241", "HIPERLIFE");
                    tabelaRede.Add("00242", "SITPOS");
                    tabelaRede.Add("00243", "AGT");
                    tabelaRede.Add("00244", "MIRA");
                    tabelaRede.Add("00245", "AMBEV 2 SÓCIO TORCEDOR");
                    tabelaRede.Add("00246", "JGV");
                    tabelaRede.Add("00247", "CREDSAT");
                    tabelaRede.Add("00248", "BRAZILIAN CARD");
                    tabelaRede.Add("00249", "RIACHUELO");
                    tabelaRede.Add("00250", "ITS RAIZEN");
                    tabelaRede.Add("00251", "SIMCRED");
                    tabelaRede.Add("00252", "BANCRED CARD");
                    tabelaRede.Add("00253", "CONEKTA");
                    tabelaRede.Add("00254", "SOFTCARD");
                    tabelaRede.Add("00255", "ECOPAG");
                    tabelaRede.Add("00256", "C&A AUTOMAÇÃO IBI");
                    tabelaRede.Add("00257", "C&A PARCERIAS BRADESCARD");
                    tabelaRede.Add("00258", "OGLOBA");
                    tabelaRede.Add("00259", "BANESE VOUCHER");
                    tabelaRede.Add("00260", "RAPP");
                    tabelaRede.Add("00261", "Monitora POS");
                    tabelaRede.Add("00262", "SOLLUS");
                    tabelaRede.Add("00263", "FITCARD");
                    tabelaRede.Add("00264", "ADIANTI");
                    tabelaRede.Add("00265", "STONE");
                    tabelaRede.Add("00266", "DMCARD");
                    tabelaRede.Add("00267", "ICATU 2");
                    #endregion
                }

                //Tipo Prc
                if (tabelaTipoParcelamento.Count == 0)
                {
                    #region SITEF
                    tabelaTipoParcelamento.Add("00", "À Vista");
                    tabelaTipoParcelamento.Add("01", "Predatado");
                    tabelaTipoParcelamento.Add("02", "Parcelado com financiamento pelo estabelecimento");
                    tabelaTipoParcelamento.Add("03", "Parcelado com financiamento pela administradora");
                    #endregion
                }
                
                //Código Resposta
                if (tabelaCodigoResposta.Count == 0)
                {
                    #region SITEF
                    tabelaCodigoResposta.Add(0, "Transacao OK");
                    tabelaCodigoResposta.Add(2, "Cancelado pelo POS.");
                    tabelaCodigoResposta.Add(43, "Erro Pin-Pad.");
                    #endregion
                }

                //Código Transação
                if (tabelaCodigoTransacao.Count == 0)
                {
                    #region SITEF
                    tabelaCodigoTransacao.Add("00", "Reimpressão.");
                    tabelaCodigoTransacao.Add("01", "Cartao Debito.");
                    tabelaCodigoTransacao.Add("02", "Cartao Credito.");
                    #endregion
                }

                //Tipo Transação
                if (tabelaTipoTransacao.Count == 0)
                {
                    #region SITEF
                    tabelaTipoTransacao.Add(1, "Transacao Financeira.");
                    tabelaTipoTransacao.Add(2, "Transacao Administrativa.");
                    tabelaTipoTransacao.Add(3, "Transacao Direta.");
                    #endregion
                }
            }
            catch (Exception e)
            {
                logger.Error(e.ToString());
                throw new Exception(e.Message);
            }
        }

    }
}