﻿using Adaptive.Launcher.Util;
using AdaptiveSoft.AdaptiveFW.Util;
using Devart.Data.PostgreSql;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.IO;
using System.Text;
using System.Web;
using System.Xml;

namespace AdaptiveSoft.AdaptivePOS.IntegracaoPosSitef.DAO
{
    public class ConnectionFactory
    {
        private static NLog.Logger logger = NLog.LogManager.GetCurrentClassLogger();
        private PgSqlConnection ObtemConexao()
        {
            logger.Trace(Path.GetDirectoryName(HttpContext.Current.Server.MapPath("")).Replace("\\IntegracaoPosSitef", string.Empty));
            StringBuilder sbConn = new StringBuilder();            

            var CONFIG = AdaptiveCNF.ReadINI(Path.GetDirectoryName(HttpContext.Current.Server.MapPath("")).Replace("\\IntegracaoPosSitef", string.Empty));
            if (!CONFIG.ContainsKey("PetrosUpdateService")
                || !CONFIG["PetrosUpdateService"].ContainsKey("Config"))
            {
                throw new Exception("Conexão não configurada pelo Petros Update Service.");
            }

            string jsonConfig = AdaptiveFWHelper.DecryptRijndael(CONFIG["PetrosUpdateService"]["Config"]);
            ConfigAdaptiveLauncher configPetrosUpdateService = (ConfigAdaptiveLauncher)JsonConvert.DeserializeObject(jsonConfig,
                typeof(ConfigAdaptiveLauncher));
            
            sbConn.Append("Host=" + configPetrosUpdateService.DbHost);
            sbConn.Append(";Port=" + configPetrosUpdateService.DbPort);
            sbConn.Append(";Database=" + configPetrosUpdateService.DbName);
            sbConn.Append(";UserID=" + configPetrosUpdateService.DbUser);
            sbConn.Append(";Password=" + configPetrosUpdateService.DbPassword);
            sbConn.Append(";Unicode=True;UnpreparedExecute=True;Persist Security Info=True;Schema=public;Pooling=false;Max Pool Size=100;Connection Timeout=0;Default Command Timeout=0;");

            string strConn = sbConn.ToString();

            try
            {
                PgSqlConnection conexao = new PgSqlConnection(strConn);
                conexao.Open();
                return conexao;
            }
            catch (Exception ex)
            {
                logger.Error("Não foi possível conectar ao Banco de Dados. Verifique as configurações no arquivo App.config e tente novamente. " + ex.ToString());
                throw new Exception("Não foi possível conectar ao Banco de Dados. Verifique as configurações no arquivo App.config e tente novamente. ");
            }
        }

        public void FechaConexao(PgSqlConnection conexao)
        {
            logger.Trace(string.Empty);
            try
            {
                if (conexao != null && conexao.State == ConnectionState.Open)
                {
                    conexao.Close();
                }
            }
            catch (Exception ex)
            {
                logger.Error("Nao foi possível fechar a conexao. " + ex.ToString());
            }
        }

        public PgSqlCommand ObtemComando(string sql, ref PgSqlConnection conexao)
        {
            logger.Trace(string.Empty);
            try
            {
                if(conexao == null || conexao.State != ConnectionState.Open)
                    conexao = ObtemConexao();

                PgSqlCommand cmd = new PgSqlCommand(sql, conexao);
                return cmd;
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        public void ExecutaComando(String sql, ref PgSqlConnection conexao)
        {
            logger.Trace(string.Empty);

            try
            {
                if (conexao == null || conexao.State != ConnectionState.Open)
                    conexao = ObtemConexao();

                PgSqlCommand cmd = new PgSqlCommand(sql, conexao);
                cmd.ExecuteNonQuery();
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }        
    }
}