/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.AppDTVImpl;
import com.microsoft.sqlserver.jdbc.DDC;
import com.microsoft.sqlserver.jdbc.DTVExecuteOp;
import com.microsoft.sqlserver.jdbc.DTVImpl;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.ReaderInputStream;
import com.microsoft.sqlserver.jdbc.SQLCollation;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.ServerDTVImpl;
import com.microsoft.sqlserver.jdbc.StreamSetterArgs;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Locale;

final class DTV {
    private DTVImpl impl;

    DTV() {
    }

    void setValue(SQLCollation sQLCollation, JDBCType jDBCType, Object object, StreamSetterArgs streamSetterArgs, Calendar calendar, Integer n, SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setValue(this, sQLCollation, jDBCType, object, streamSetterArgs, calendar, n, sQLServerConnection);
    }

    final void setValue(Object object) {
        this.impl.setValue(object);
    }

    final void clear() {
        this.impl = null;
    }

    final void skipValue(TypeInfo typeInfo, TDSReader tDSReader, boolean bl) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        this.impl.skipValue(typeInfo, tDSReader, bl);
    }

    final void setStreamSetterArgs(StreamSetterArgs streamSetterArgs) {
        this.impl.setStreamSetterArgs(streamSetterArgs);
    }

    final void setCalendar(Calendar calendar) {
        this.impl.setCalendar(calendar);
    }

    final void setScale(Integer n) {
        this.impl.setScale(n);
    }

    StreamSetterArgs getStreamSetterArgs() {
        return this.impl.getStreamSetterArgs();
    }

    Calendar getCalendar() {
        return this.impl.getCalendar();
    }

    Integer getScale() {
        return this.impl.getScale();
    }

    boolean isNull() {
        return null == this.impl || this.impl.isNull();
    }

    final void setJdbcType(JDBCType jDBCType) {
        if (null == this.impl) {
            this.impl = new AppDTVImpl();
        }
        this.impl.setJdbcType(jDBCType);
    }

    final JDBCType getJdbcType() {
        assert (null != this.impl);
        return this.impl.getJdbcType();
    }

    Object getValue(JDBCType jDBCType, int n, InputStreamGetterArgs inputStreamGetterArgs, Calendar calendar, TypeInfo typeInfo, TDSReader tDSReader) throws SQLServerException {
        if (null == this.impl) {
            this.impl = new ServerDTVImpl();
        }
        return this.impl.getValue(this, jDBCType, true, n, inputStreamGetterArgs, calendar, typeInfo, tDSReader);
    }

    Object getSetterValue() {
        return this.impl.getSetterValue();
    }

    void setImpl(DTVImpl dTVImpl) {
        this.impl = dTVImpl;
    }

    final void executeOp(DTVExecuteOp dTVExecuteOp) throws SQLServerException {
        JDBCType jDBCType = this.getJdbcType();
        Object object = this.getSetterValue();
        if (String.class.isInstance(object) || null == object && (JDBCType.NCHAR == jDBCType || JDBCType.NVARCHAR == jDBCType || JDBCType.LONGNVARCHAR == jDBCType || JDBCType.NCLOB == jDBCType)) {
            dTVExecuteOp.execute(this, (String)object);
        } else if (Integer.class.isInstance(object) || null == object && JDBCType.INTEGER == jDBCType) {
            dTVExecuteOp.execute(this, (Integer)object);
        } else if (Date.class.isInstance(object) || null == object && JDBCType.DATE == jDBCType) {
            dTVExecuteOp.execute(this, (Date)object);
        } else if (Timestamp.class.isInstance(object) || null == object && JDBCType.TIMESTAMP == jDBCType) {
            dTVExecuteOp.execute(this, (Timestamp)object);
        } else if (Float.class.isInstance(object) || null == object && (JDBCType.FLOAT == jDBCType || JDBCType.REAL == jDBCType)) {
            dTVExecuteOp.execute(this, (Float)object);
        } else if (BigDecimal.class.isInstance(object) || null == object && (JDBCType.NUMERIC == jDBCType || JDBCType.DECIMAL == jDBCType)) {
            dTVExecuteOp.execute(this, (BigDecimal)object);
        } else if (byte[].class.isInstance(object) || null == object && (JDBCType.BINARY == jDBCType || JDBCType.VARBINARY == jDBCType || JDBCType.LONGVARBINARY == jDBCType || JDBCType.BLOB == jDBCType || JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
            dTVExecuteOp.execute(this, (byte[])object);
        } else if (Byte.class.isInstance(object) || null == object && JDBCType.TINYINT == jDBCType) {
            dTVExecuteOp.execute(this, (Byte)object);
        } else if (Long.class.isInstance(object) || null == object && JDBCType.BIGINT == jDBCType) {
            dTVExecuteOp.execute(this, (Long)object);
        } else if (Double.class.isInstance(object) || null == object && JDBCType.DOUBLE == jDBCType) {
            dTVExecuteOp.execute(this, (Double)object);
        } else if (Short.class.isInstance(object) || null == object && JDBCType.SMALLINT == jDBCType) {
            dTVExecuteOp.execute(this, (Short)object);
        } else if (Time.class.isInstance(object) || null == object && JDBCType.TIME == jDBCType) {
            dTVExecuteOp.execute(this, (Time)object);
        } else if (Boolean.class.isInstance(object) || null == object && (JDBCType.BIT == jDBCType || JDBCType.BOOLEAN == jDBCType)) {
            dTVExecuteOp.execute(this, (Boolean)object);
        } else if (Blob.class.isInstance(object)) {
            dTVExecuteOp.execute(this, (Blob)object);
        } else if (Clob.class.isInstance(object)) {
            dTVExecuteOp.execute(this, (Clob)object);
        } else if (InputStream.class.isInstance(object)) {
            dTVExecuteOp.execute(this, (InputStream)object);
        } else if (Reader.class.isInstance(object)) {
            dTVExecuteOp.execute(this, (Reader)object);
        } else {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownType"));
            Object[] objectArray = new Object[]{new String(object.getClass().getName())};
            SQLServerException.makeFromDriverError(null, null, messageFormat.format(objectArray), null, false);
        }
    }

    void sendByRPC(String string, SQLCollation sQLCollation, int n, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) throws SQLServerException {
        this.executeOp(new SendByRPCOp(string, sQLCollation, n, bl, tDSWriter, sQLServerConnection));
    }

    final class SendByRPCOp
    extends DTVExecuteOp {
        private final String name;
        private final SQLCollation collation;
        private final int outScale;
        private final boolean isOutParam;
        private final TDSWriter tdsWriter;
        private final SQLServerConnection conn;

        SendByRPCOp(String string, SQLCollation sQLCollation, int n, boolean bl, TDSWriter tDSWriter, SQLServerConnection sQLServerConnection) {
            this.name = string;
            this.collation = sQLCollation;
            this.outScale = n;
            this.isOutParam = bl;
            this.tdsWriter = tDSWriter;
            this.conn = sQLServerConnection;
        }

        @Override
        void execute(DTV dTV, String string) throws SQLServerException {
            this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, this.collation);
        }

        @Override
        void execute(DTV dTV, Clob clob) throws SQLServerException {
            assert (null != clob);
            long l = 0L;
            Reader reader = null;
            try {
                l = clob.length();
                reader = clob.getCharacterStream();
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
            }
            JDBCType jDBCType = dTV.getJdbcType();
            if (null != this.collation && (JDBCType.CHAR == jDBCType || JDBCType.VARCHAR == jDBCType || JDBCType.LONGVARCHAR == jDBCType || JDBCType.CLOB == jDBCType)) {
                if (null == reader) {
                    this.tdsWriter.writeRPCByteArray(this.name, null, this.isOutParam, jDBCType, this.collation);
                } else {
                    ReaderInputStream readerInputStream = null;
                    try {
                        readerInputStream = new ReaderInputStream(reader, this.collation.getCharset(), l);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_encodingErrorWritingTDS"));
                        Object[] objectArray = new Object[]{new String(unsupportedEncodingException.getMessage())};
                        SQLServerException.makeFromDriverError(this.conn, null, messageFormat.format(objectArray), null, true);
                    }
                    this.tdsWriter.writeRPCInputStream(this.name, readerInputStream, -1L, this.isOutParam, jDBCType, this.collation);
                }
            } else if (null == reader) {
                this.tdsWriter.writeRPCStringUnicode(this.name, null, this.isOutParam, this.collation);
            } else {
                this.tdsWriter.writeRPCReaderUnicode(this.name, reader, l, this.isOutParam, this.collation);
            }
        }

        @Override
        void execute(DTV dTV, Byte by) throws SQLServerException {
            this.tdsWriter.writeRPCByte(this.name, by, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Integer n) throws SQLServerException {
            this.tdsWriter.writeRPCInt(this.name, n, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Time time) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            assert (JDBCType.TIMESTAMP == jDBCType || JDBCType.TIME == jDBCType || JDBCType.DATE == jDBCType) : "Unexpected jdbcType " + (Object)((Object)jDBCType);
            Calendar calendar = null;
            if (null != time) {
                calendar = dTV.getCalendar();
                if (null == calendar) {
                    calendar = Calendar.getInstance(Locale.US);
                }
                if (JDBCType.DATE == jDBCType) {
                    calendar.clear();
                } else {
                    calendar.setTimeInMillis(time.getTime());
                    calendar.set(1970, 0, 1);
                }
            }
            this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Date date) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            assert (JDBCType.TIMESTAMP == jDBCType || JDBCType.TIME == jDBCType || JDBCType.DATE == jDBCType) : "Unexpected jdbcType " + (Object)((Object)jDBCType);
            Calendar calendar = null;
            if (null != date) {
                calendar = dTV.getCalendar();
                if (null == calendar) {
                    calendar = Calendar.getInstance(Locale.US);
                }
                if (JDBCType.TIME == jDBCType) {
                    calendar.clear();
                } else {
                    calendar.setTimeInMillis(date.getTime());
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                }
            }
            this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Timestamp timestamp) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            assert (JDBCType.TIMESTAMP == jDBCType || JDBCType.TIME == jDBCType || JDBCType.DATE == jDBCType) : "Unexpected jdbcType " + (Object)((Object)dTV.getJdbcType());
            Calendar calendar = null;
            if (null != timestamp) {
                calendar = dTV.getCalendar();
                if (null == calendar) {
                    calendar = Calendar.getInstance(Locale.US);
                }
                calendar.setTimeInMillis(timestamp.getTime());
                calendar.set(14, timestamp.getNanos() / 1000000);
                if (JDBCType.DATE == jDBCType) {
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                } else if (JDBCType.TIME == jDBCType) {
                    calendar.set(1970, 0, 1);
                }
            }
            this.tdsWriter.writeRPCTimestamp(this.name, calendar, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Float f) throws SQLServerException {
            if (JDBCType.REAL == dTV.getJdbcType()) {
                this.tdsWriter.writeRPCReal(this.name, f, this.isOutParam);
            } else {
                Double d = null == f ? null : new Double(f.floatValue());
                this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
            }
        }

        @Override
        void execute(DTV dTV, Double d) throws SQLServerException {
            this.tdsWriter.writeRPCDouble(this.name, d, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, BigDecimal bigDecimal) throws SQLServerException {
            if (DDC.exceedsMaxRPCDecimalPrecisionOrScale(bigDecimal)) {
                String string = bigDecimal.toString();
                this.tdsWriter.writeRPCStringUnicode(this.name, string, this.isOutParam, this.collation);
            } else {
                this.tdsWriter.writeRPCBigDecimal(this.name, bigDecimal, this.outScale, this.isOutParam);
            }
        }

        @Override
        void execute(DTV dTV, Long l) throws SQLServerException {
            this.tdsWriter.writeRPCLong(this.name, l, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Short s) throws SQLServerException {
            this.tdsWriter.writeRPCShort(this.name, s, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, Boolean bl) throws SQLServerException {
            this.tdsWriter.writeRPCBit(this.name, bl, this.isOutParam);
        }

        @Override
        void execute(DTV dTV, byte[] byArray) throws SQLServerException {
            this.tdsWriter.writeRPCByteArray(this.name, byArray, this.isOutParam, dTV.getJdbcType(), this.collation);
        }

        @Override
        void execute(DTV dTV, Blob blob) throws SQLServerException {
            assert (null != blob);
            long l = 0L;
            InputStream inputStream = null;
            try {
                l = blob.length();
                inputStream = blob.getBinaryStream();
            }
            catch (SQLException sQLException) {
                SQLServerException.makeFromDriverError(this.conn, null, sQLException.toString(), null, false);
            }
            if (null == inputStream) {
                this.tdsWriter.writeRPCByteArray(this.name, null, this.isOutParam, dTV.getJdbcType(), this.collation);
            } else {
                this.tdsWriter.writeRPCInputStream(this.name, inputStream, l, this.isOutParam, dTV.getJdbcType(), this.collation);
            }
        }

        @Override
        void execute(DTV dTV, InputStream inputStream) throws SQLServerException {
            this.tdsWriter.writeRPCInputStream(this.name, inputStream, dTV.getStreamSetterArgs().getLength(), this.isOutParam, dTV.getJdbcType(), this.collation);
        }

        @Override
        void execute(DTV dTV, Reader reader) throws SQLServerException {
            JDBCType jDBCType = dTV.getJdbcType();
            assert (null != reader);
            assert (JDBCType.NCHAR == jDBCType || JDBCType.NVARCHAR == jDBCType || JDBCType.LONGNVARCHAR == jDBCType || JDBCType.NCLOB == jDBCType) : "SendByRPCOp(Reader): Unexpected JDBC type " + (Object)((Object)jDBCType);
            this.tdsWriter.writeRPCReaderUnicode(this.name, reader, dTV.getStreamSetterArgs().getLength(), this.isOutParam, this.collation);
        }
    }
}

