/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.web;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.Toolkit;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.platform.event.KeyCodeMap;
import com.sun.webpane.platform.event.WCFocusEvent;
import com.sun.webpane.platform.event.WCInputMethodEvent;
import com.sun.webpane.platform.event.WCKeyEvent;
import com.sun.webpane.platform.event.WCMouseEvent;
import com.sun.webpane.platform.event.WCMouseWheelEvent;
import com.sun.webpane.sg.ImplementationManager;
import com.sun.webpane.sg.InputMethodClientImpl;
import com.sun.webpane.sg.PGWebView;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.web.WebEngine;

public final class WebView
extends Parent {
    private static final Map<Object, Integer> idMap = new HashMap<Object, Integer>();
    private final WebPage page;
    private final WebEngine engine;
    private volatile InputMethodClientImpl imClient;
    private final TKPulseListener stagePulseListener;
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper(this, "width");
    private ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper(this, "height");
    private DoubleProperty fontScale;
    private DoubleProperty minWidth;
    private DoubleProperty minHeight;
    private DoubleProperty prefWidth;
    private DoubleProperty prefHeight;
    private DoubleProperty maxWidth;
    private DoubleProperty maxHeight;

    public final WebEngine getEngine() {
        return this.engine;
    }

    public final double getWidth() {
        return this.width.get();
    }

    public ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final double getHeight() {
        return this.height.get();
    }

    public ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    public final void setFontScale(double d) {
        WebEngine.checkThread();
        this.fontScaleProperty().set(d);
    }

    public final double getFontScale() {
        return this.fontScale == null ? 1.0 : this.fontScale.get();
    }

    public DoubleProperty fontScaleProperty() {
        if (this.fontScale == null) {
            this.fontScale = new DoublePropertyBase(1.0){

                @Override
                public void invalidated() {
                    if (WebView.this.page != null) {
                        double d = this.get();
                        WebView.this.page.setZoomFactor((float)d, true);
                    }
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "fontScale";
                }
            };
        }
        return this.fontScale;
    }

    public WebView() {
        this.engine = new WebEngine();
        this.engine.setView(this);
        this.page = this.engine.getPage();
        this.registerEventHandlers();
        this.stagePulseListener = new TKPulseListener(){

            @Override
            public void pulse() {
                WebView.this.handleStagePulse();
            }
        };
        this.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (WebView.this.page != null) {
                    WCFocusEvent wCFocusEvent = new WCFocusEvent(WebView.this.isFocused() ? 2 : 3, -1);
                    WebView.this.page.dispatchFocusEvent(wCFocusEvent);
                }
            }
        });
        Toolkit.getToolkit().addStageTkPulseListener(this.stagePulseListener);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public void resize(double d, double d2) {
        this.width.set(d);
        this.height.set(d2);
        this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
        this.impl_geomChanged();
    }

    @Override
    public final double minWidth(double d) {
        return this.getMinWidth();
    }

    @Override
    public final double minHeight(double d) {
        return this.getMinHeight();
    }

    @Override
    public final double prefWidth(double d) {
        return this.getPrefWidth();
    }

    @Override
    public final double prefHeight(double d) {
        return this.getPrefHeight();
    }

    @Override
    public final double maxWidth(double d) {
        return this.getMaxWidth();
    }

    @Override
    public final double maxHeight(double d) {
        return this.getMaxHeight();
    }

    public DoubleProperty minWidthProperty() {
        if (this.minWidth == null) {
            this.minWidth = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "minWidth";
                }
            };
        }
        return this.minWidth;
    }

    public final void setMinWidth(double d) {
        this.minWidthProperty().set(d);
    }

    public final double getMinWidth() {
        return this.minWidth == null ? 0.0 : this.minWidth.get();
    }

    public DoubleProperty minHeightProperty() {
        if (this.minHeight == null) {
            this.minHeight = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "minHeight";
                }
            };
        }
        return this.minHeight;
    }

    public final void setMinHeight(double d) {
        this.minHeightProperty().set(d);
    }

    public final double getMinHeight() {
        return this.minHeight == null ? 0.0 : this.minHeight.get();
    }

    public void setMinSize(double d, double d2) {
        this.setMinWidth(d);
        this.setMinHeight(d2);
    }

    public DoubleProperty prefWidthProperty() {
        if (this.prefWidth == null) {
            this.prefWidth = new DoublePropertyBase(800.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "prefWidth";
                }
            };
        }
        return this.prefWidth;
    }

    public final void setPrefWidth(double d) {
        this.prefWidthProperty().set(d);
    }

    public final double getPrefWidth() {
        return this.prefWidth == null ? 800.0 : this.prefWidth.get();
    }

    public DoubleProperty prefHeightProperty() {
        if (this.prefHeight == null) {
            this.prefHeight = new DoublePropertyBase(600.0){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "prefHeight";
                }
            };
        }
        return this.prefHeight;
    }

    public final void setPrefHeight(double d) {
        this.prefHeightProperty().set(d);
    }

    public final double getPrefHeight() {
        return this.prefHeight == null ? 600.0 : this.prefHeight.get();
    }

    public void setPrefSize(double d, double d2) {
        this.setPrefWidth(d);
        this.setPrefHeight(d2);
    }

    public DoubleProperty maxWidthProperty() {
        if (this.maxWidth == null) {
            this.maxWidth = new DoublePropertyBase(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "maxWidth";
                }
            };
        }
        return this.maxWidth;
    }

    public final void setMaxWidth(double d) {
        this.maxWidthProperty().set(d);
    }

    public final double getMaxWidth() {
        return this.maxWidth == null ? Double.MAX_VALUE : this.maxWidth.get();
    }

    public DoubleProperty maxHeightProperty() {
        if (this.maxHeight == null) {
            this.maxHeight = new DoublePropertyBase(Double.MAX_VALUE){

                @Override
                public void invalidated() {
                    if (WebView.this.getParent() != null) {
                        WebView.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return WebView.this;
                }

                @Override
                public String getName() {
                    return "maxHeight";
                }
            };
        }
        return this.maxHeight;
    }

    public final void setMaxHeight(double d) {
        this.maxHeightProperty().set(d);
    }

    public final double getMaxHeight() {
        return this.maxHeight == null ? Double.MAX_VALUE : this.maxHeight.get();
    }

    public void setMaxSize(double d, double d2) {
        this.setMaxWidth(d);
        this.setMaxHeight(d2);
    }

    private void handleStagePulse() {
        boolean bl;
        boolean bl2 = bl = this.impl_isTreeVisible() && this.getScene() != null && this.getScene().getWindow() != null && this.getScene().getWindow().isShowing();
        if (bl) {
            if (this.page != null && this.page.isDirty()) {
                this.impl_markDirty(DirtyBits.WEBVIEW_VIEW);
            }
            if (this.impl_isDirty(DirtyBits.WEBVIEW_VIEW)) {
                Scene.impl_setAllowPGAccess(true);
                this.getPGWebView().update();
                Scene.impl_setAllowPGAccess(false);
            }
        } else if (this.page != null) {
            this.page.clearRenderQueues();
        }
    }

    private void processMouseEvent(MouseEvent mouseEvent) {
        if (this.page == null) {
            return;
        }
        if (mouseEvent.getEventType() != MouseEvent.IMPL_MOUSE_WHEEL_ROTATED) {
            Integer n = idMap.get(mouseEvent.getEventType());
            if (n == null) {
                return;
            }
            WCMouseEvent wCMouseEvent = new WCMouseEvent(n, idMap.get((Object)mouseEvent.getButton()), mouseEvent.getClickCount(), (int)mouseEvent.getX(), (int)mouseEvent.getY(), (int)mouseEvent.getScreenX(), (int)mouseEvent.getScreenY(), System.currentTimeMillis(), mouseEvent.isShiftDown(), mouseEvent.isControlDown(), mouseEvent.isAltDown(), mouseEvent.isMetaDown(), MouseEvent.impl_getPopupTrigger(mouseEvent));
            this.page.dispatchMouseEvent(wCMouseEvent);
        }
        mouseEvent.consume();
    }

    private void processScrollEvent(ScrollEvent scrollEvent) {
        if (this.page == null) {
            return;
        }
        double d = -scrollEvent.getDeltaY() * this.getFontScale();
        double d2 = scrollEvent.isShiftDown() ? d : 0.0;
        double d3 = d - d2;
        WCMouseWheelEvent wCMouseWheelEvent = new WCMouseWheelEvent((int)scrollEvent.getX(), (int)scrollEvent.getY(), (int)scrollEvent.getScreenX(), (int)scrollEvent.getScreenY(), System.currentTimeMillis(), scrollEvent.isShiftDown(), scrollEvent.isControlDown(), scrollEvent.isAltDown(), scrollEvent.isMetaDown(), (float)(d2 *= this.getScaleX()), (float)(d3 *= this.getScaleY()));
        this.page.dispatchMouseWheelEvent(wCMouseWheelEvent);
        scrollEvent.consume();
    }

    private void processKeyEvent(KeyEvent keyEvent) {
        if (this.page == null) {
            return;
        }
        WCKeyEvent wCKeyEvent = new WCKeyEvent(idMap.get(keyEvent.getEventType()), KeyCodeMap.getCode(keyEvent.getCode()), keyEvent.getCharacter(), KeyCodeMap.getKeyText(keyEvent.getCode()), System.currentTimeMillis(), keyEvent.isShiftDown(), keyEvent.isControlDown(), keyEvent.isAltDown(), keyEvent.isMetaDown());
        if (this.page.dispatchKeyEvent(wCKeyEvent)) {
            keyEvent.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputMethodClientImpl getInputMethodClient() {
        if (this.imClient == null) {
            WebView webView = this;
            synchronized (webView) {
                if (this.imClient == null) {
                    this.imClient = new InputMethodClientImpl(this, this.page);
                }
            }
        }
        return this.imClient;
    }

    private void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        if (this.page == null) {
            return;
        }
        if (!this.getInputMethodClient().getInputMethodState()) {
            inputMethodEvent.consume();
            return;
        }
        WCInputMethodEvent wCInputMethodEvent = InputMethodClientImpl.convertToWCInputMethodEvent(inputMethodEvent);
        if (this.page.dispatchInputMethodEvent(wCInputMethodEvent)) {
            inputMethodEvent.consume();
            return;
        }
    }

    private void registerEventHandlers() {
        this.addEventHandler(KeyEvent.ANY, new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                WebView.this.processKeyEvent(keyEvent);
            }
        });
        this.addEventHandler(MouseEvent.ANY, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                WebView.this.processMouseEvent(mouseEvent);
            }
        });
        this.addEventHandler(ScrollEvent.SCROLL, new EventHandler<ScrollEvent>(){

            @Override
            public void handle(ScrollEvent scrollEvent) {
                WebView.this.processScrollEvent(scrollEvent);
            }
        });
        this.setOnInputMethodTextChanged((EventHandler<? super InputMethodEvent>)new EventHandler<InputMethodEvent>(){

            @Override
            public void handle(InputMethodEvent inputMethodEvent) {
                WebView.this.processInputMethodEvent(inputMethodEvent);
            }
        });
        this.setInputMethodRequests(this.getInputMethodClient());
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(double d, double d2) {
        if (this.contains(d, d2)) {
            return this;
        }
        return null;
    }

    @Override
    @Deprecated
    protected Node impl_pickNodeLocal(PickRay pickRay) {
        if (this.impl_intersects(pickRay)) {
            return this;
        }
        return null;
    }

    @Override
    protected ObservableList<Node> getChildren() {
        return super.getChildren();
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return ImplementationManager.createView(this);
    }

    @Deprecated
    public void impl_repaint() {
        this.impl_markDirty(DirtyBits.WEBVIEW_VIEW);
    }

    PGWebView getPGWebView() {
        return (PGWebView)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds.deriveWithNewBounds(0.0f, 0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), 0.0f);
        baseTransform.transform(baseBounds, baseBounds);
        return baseBounds;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        return true;
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        PGWebView pGWebView = this.getPGWebView();
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            pGWebView.setPage(this.page);
        }
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            pGWebView.resize((float)this.getWidth(), (float)this.getHeight());
        }
        if (this.impl_isDirty(DirtyBits.WEBVIEW_VIEW)) {
            pGWebView.requestRender();
        }
    }

    static {
        idMap.put((Object)MouseButton.NONE, 0);
        idMap.put((Object)MouseButton.PRIMARY, 1);
        idMap.put((Object)MouseButton.MIDDLE, 2);
        idMap.put((Object)MouseButton.SECONDARY, 4);
        idMap.put(MouseEvent.MOUSE_PRESSED, 0);
        idMap.put(MouseEvent.MOUSE_RELEASED, 1);
        idMap.put(MouseEvent.MOUSE_MOVED, 2);
        idMap.put(MouseEvent.MOUSE_DRAGGED, 3);
        idMap.put(KeyEvent.KEY_PRESSED, 1);
        idMap.put(KeyEvent.KEY_RELEASED, 2);
        idMap.put(KeyEvent.KEY_TYPED, 0);
    }
}

