/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class StackPane
extends Pane {
    private static final String MARGIN_CONSTRAINT = "stackpane-margin";
    private static final String ALIGNMENT_CONSTRAINT = "stackpane-alignment";
    @Styleable(property="-fx-alignment", initial="center")
    private ObjectProperty<Pos> alignment;

    public static void setAlignment(Node node, Pos pos) {
        StackPane.setConstraint(node, ALIGNMENT_CONSTRAINT, (Object)pos);
    }

    public static Pos getAlignment(Node node) {
        return (Pos)((Object)StackPane.getConstraint(node, ALIGNMENT_CONSTRAINT));
    }

    public static void setMargin(Node node, Insets insets) {
        StackPane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)StackPane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void clearConstraints(Node node) {
        StackPane.setAlignment(node, null);
        StackPane.setMargin(node, null);
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new ObjectPropertyBase<Pos>(Pos.CENTER){

                @Override
                public void invalidated() {
                    StackPane.this.requestLayout();
                    StackPane.this.impl_cssPropertyInvalidated(StyleableProperties.ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return StackPane.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.CENTER : (Pos)((Object)this.alignment.get());
    }

    @Override
    public Orientation getContentBias() {
        for (int i = 0; i < this.getChildren().size(); ++i) {
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged() || node.getContentBias() == null) continue;
            return node.getContentBias();
        }
        return null;
    }

    @Override
    protected double computeMinWidth(double d) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getLeft() + this.computeMaxMinAreaWidth(list, this.getMargins(list), this.getAlignment().getHpos(), d) + this.getInsets().getRight();
    }

    @Override
    protected double computeMinHeight(double d) {
        List<Node> list = this.getManagedChildren();
        return this.getInsets().getTop() + this.computeMaxMinAreaHeight(list, this.getMargins(list), this.getAlignment().getVpos(), d) + this.getInsets().getBottom();
    }

    @Override
    protected double computePrefWidth(double d) {
        List<Node> list = this.getManagedChildren();
        Insets[] insetsArray = this.getMargins(list);
        Insets insets = this.getInsets();
        return insets.getLeft() + this.computeMaxPrefAreaWidth(list, insetsArray, d == -1.0 ? -1.0 : d - insets.getTop() - insets.getBottom(), this.getAlignment().getHpos()) + insets.getRight();
    }

    @Override
    protected double computePrefHeight(double d) {
        List<Node> list = this.getManagedChildren();
        Insets[] insetsArray = this.getMargins(list);
        Insets insets = this.getInsets();
        return insets.getTop() + this.computeMaxPrefAreaHeight(list, insetsArray, d == -1.0 ? -1.0 : d - insets.getLeft() - insets.getRight(), this.getAlignment().getVpos()) + insets.getBottom();
    }

    private Insets[] getMargins(List<Node> list) {
        Insets[] insetsArray = new Insets[list.size()];
        for (int i = 0; i < insetsArray.length; ++i) {
            insetsArray[i] = StackPane.getMargin(list.get(i));
        }
        return insetsArray;
    }

    @Override
    protected void layoutChildren() {
        List<Node> list = this.getManagedChildren();
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.getInsets().getTop();
        double d4 = this.getInsets().getRight();
        double d5 = this.getInsets().getLeft();
        double d6 = this.getInsets().getBottom();
        double d7 = this.getAlignment().getVpos() == VPos.BASELINE ? StackPane.getMaxBaselineOffset(list) : d2 / 2.0;
        for (int i = 0; i < list.size(); ++i) {
            Node node = list.get(i);
            Pos pos = StackPane.getAlignment(node);
            this.layoutInArea(node, d5, d3, d - d5 - d4, d2 - d3 - d6, d7, StackPane.getMargin(node), pos != null ? pos.getHpos() : this.getAlignment().getHpos(), pos != null ? pos.getVpos() : this.getAlignment().getVpos());
        }
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if (!"-fx-alignment".equals(string)) {
            return super.impl_cssSet(string, object);
        }
        this.setAlignment((Pos)((Object)object));
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-alignment".equals(string)) {
            return this.alignment == null || !this.alignment.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty ALIGNMENT = new StyleableProperty(StackPane.class, "alignment");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ALIGNMENT);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

