/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.layout;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;

public class GridPane
extends Pane {
    public static final int REMAINING = Integer.MAX_VALUE;
    private static final String MARGIN_CONSTRAINT = "gridpane-margin";
    private static final String HALIGNMENT_CONSTRAINT = "gridpane-halignment";
    private static final String VALIGNMENT_CONSTRAINT = "gridpane-valignment";
    private static final String HGROW_CONSTRAINT = "gridpane-hgrow";
    private static final String VGROW_CONSTRAINT = "gridpane-vgrow";
    private static final String ROW_INDEX_CONSTRAINT = "gridpane-row";
    private static final String COLUMN_INDEX_CONSTRAINT = "gridpane-column";
    private static final String ROW_SPAN_CONSTRAINT = "gridpane-row-span";
    private static final String COLUMN_SPAN_CONSTRAINT = "gridpane-column-span";
    private static final Color GRID_LINE_COLOR = Color.rgb(30, 30, 30);
    private static final double GRID_LINE_DASH = 3.0;
    @Styleable(property="-fx-hgap", initial="0")
    private DoubleProperty hgap;
    @Styleable(property="-fx-vgap", initial="0")
    private DoubleProperty vgap;
    @Styleable(property="-fx-alignment", initial="top-left")
    private ObjectProperty<Pos> alignment;
    @Styleable(property="-fx-grid-lines-visible", initial="false")
    private BooleanProperty gridLinesVisible;
    private final ObservableList<RowConstraints> rowConstraints = new TrackableObservableList<RowConstraints>(){

        @Override
        protected void onChanged(ListChangeListener.Change<RowConstraints> change) {
            while (change.next()) {
                for (RowConstraints rowConstraints : change.getRemoved()) {
                    if (rowConstraints == null || GridPane.this.rowConstraints.contains(rowConstraints)) continue;
                    rowConstraints.impl_remove(GridPane.this);
                }
                for (RowConstraints rowConstraints : change.getAddedSubList()) {
                    if (rowConstraints == null) continue;
                    rowConstraints.impl_add(GridPane.this);
                }
            }
            GridPane.this.requestLayout();
        }
    };
    private final ObservableList<ColumnConstraints> columnConstraints = new TrackableObservableList<ColumnConstraints>(){

        @Override
        protected void onChanged(ListChangeListener.Change<ColumnConstraints> change) {
            while (change.next()) {
                for (ColumnConstraints columnConstraints : change.getRemoved()) {
                    if (columnConstraints == null || GridPane.this.columnConstraints.contains(columnConstraints)) continue;
                    columnConstraints.impl_remove(GridPane.this);
                }
                for (ColumnConstraints columnConstraints : change.getAddedSubList()) {
                    if (columnConstraints == null) continue;
                    columnConstraints.impl_add(GridPane.this);
                }
            }
            GridPane.this.requestLayout();
        }
    };
    private Group gridLines;
    private double[] rowPercentHeight;
    private double rowPercentTotal = 0.0;
    private double[] rowMinHeight;
    private double[] rowPrefHeight;
    private double[] rowMaxHeight;
    private double[] rowBaseline;
    private Priority[] rowGrow;
    private double[] rowHeights;
    private double[] columnPercentWidth;
    private double columnPercentTotal = 0.0;
    private double[] columnMinWidth;
    private double[] columnPrefWidth;
    private double[] columnMaxWidth;
    private Priority[] columnGrow;
    private double[] columnWidths;
    private boolean metricsDirty = true;

    public static void setRowIndex(Node node, Integer n) {
        if (n != null && n < 0) {
            throw new IllegalArgumentException("rowIndex must be greater or equal to 0, but was " + n);
        }
        GridPane.setConstraint(node, ROW_INDEX_CONSTRAINT, n);
    }

    public static Integer getRowIndex(Node node) {
        return (Integer)GridPane.getConstraint(node, ROW_INDEX_CONSTRAINT);
    }

    public static void setColumnIndex(Node node, Integer n) {
        if (n != null && n < 0) {
            throw new IllegalArgumentException("columnIndex must be greater or equal to 0, but was " + n);
        }
        GridPane.setConstraint(node, COLUMN_INDEX_CONSTRAINT, n);
    }

    public static Integer getColumnIndex(Node node) {
        return (Integer)GridPane.getConstraint(node, COLUMN_INDEX_CONSTRAINT);
    }

    public static void setRowSpan(Node node, Integer n) {
        if (n != null && n < 1) {
            throw new IllegalArgumentException("rowSpan must be greater or equal to 1, but was " + n);
        }
        GridPane.setConstraint(node, ROW_SPAN_CONSTRAINT, n);
    }

    public static Integer getRowSpan(Node node) {
        return (Integer)GridPane.getConstraint(node, ROW_SPAN_CONSTRAINT);
    }

    public static void setColumnSpan(Node node, Integer n) {
        if (n != null && n < 1) {
            throw new IllegalArgumentException("columnSpan must be greater or equal to 1, but was " + n);
        }
        GridPane.setConstraint(node, COLUMN_SPAN_CONSTRAINT, n);
    }

    public static Integer getColumnSpan(Node node) {
        return (Integer)GridPane.getConstraint(node, COLUMN_SPAN_CONSTRAINT);
    }

    public static void setMargin(Node node, Insets insets) {
        GridPane.setConstraint(node, MARGIN_CONSTRAINT, insets);
    }

    public static Insets getMargin(Node node) {
        return (Insets)GridPane.getConstraint(node, MARGIN_CONSTRAINT);
    }

    public static void setHalignment(Node node, HPos hPos) {
        GridPane.setConstraint(node, HALIGNMENT_CONSTRAINT, (Object)hPos);
    }

    public static HPos getHalignment(Node node) {
        return (HPos)((Object)GridPane.getConstraint(node, HALIGNMENT_CONSTRAINT));
    }

    public static void setValignment(Node node, VPos vPos) {
        GridPane.setConstraint(node, VALIGNMENT_CONSTRAINT, (Object)vPos);
    }

    public static VPos getValignment(Node node) {
        return (VPos)((Object)GridPane.getConstraint(node, VALIGNMENT_CONSTRAINT));
    }

    public static void setHgrow(Node node, Priority priority) {
        GridPane.setConstraint(node, HGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getHgrow(Node node) {
        return (Priority)((Object)GridPane.getConstraint(node, HGROW_CONSTRAINT));
    }

    public static void setVgrow(Node node, Priority priority) {
        GridPane.setConstraint(node, VGROW_CONSTRAINT, (Object)priority);
    }

    public static Priority getVgrow(Node node) {
        return (Priority)((Object)GridPane.getConstraint(node, VGROW_CONSTRAINT));
    }

    public static void setConstraints(Node node, int n, int n2) {
        GridPane.setRowIndex(node, n2);
        GridPane.setColumnIndex(node, n);
    }

    public static void setConstraints(Node node, int n, int n2, int n3, int n4) {
        GridPane.setRowIndex(node, n2);
        GridPane.setColumnIndex(node, n);
        GridPane.setRowSpan(node, n4);
        GridPane.setColumnSpan(node, n3);
    }

    public static void setConstraints(Node node, int n, int n2, int n3, int n4, HPos hPos, VPos vPos) {
        GridPane.setRowIndex(node, n2);
        GridPane.setColumnIndex(node, n);
        GridPane.setRowSpan(node, n4);
        GridPane.setColumnSpan(node, n3);
        GridPane.setHalignment(node, hPos);
        GridPane.setValignment(node, vPos);
    }

    public static void setConstraints(Node node, int n, int n2, int n3, int n4, HPos hPos, VPos vPos, Priority priority, Priority priority2) {
        GridPane.setRowIndex(node, n2);
        GridPane.setColumnIndex(node, n);
        GridPane.setRowSpan(node, n4);
        GridPane.setColumnSpan(node, n3);
        GridPane.setHalignment(node, hPos);
        GridPane.setValignment(node, vPos);
        GridPane.setHgrow(node, priority);
        GridPane.setVgrow(node, priority2);
    }

    public static void setConstraints(Node node, int n, int n2, int n3, int n4, HPos hPos, VPos vPos, Priority priority, Priority priority2, Insets insets) {
        GridPane.setRowIndex(node, n2);
        GridPane.setColumnIndex(node, n);
        GridPane.setRowSpan(node, n4);
        GridPane.setColumnSpan(node, n3);
        GridPane.setHalignment(node, hPos);
        GridPane.setValignment(node, vPos);
        GridPane.setHgrow(node, priority);
        GridPane.setVgrow(node, priority2);
        GridPane.setMargin(node, insets);
    }

    public static void clearConstraints(Node node) {
        GridPane.setRowIndex(node, null);
        GridPane.setColumnIndex(node, null);
        GridPane.setRowSpan(node, null);
        GridPane.setColumnSpan(node, null);
        GridPane.setHalignment(node, null);
        GridPane.setValignment(node, null);
        GridPane.setHgrow(node, null);
        GridPane.setVgrow(node, null);
        GridPane.setMargin(node, null);
    }

    static void createRow(int n, Node ... nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            GridPane.setConstraints(nodeArray[i], i, n);
        }
    }

    static void createColumn(int n, Node ... nodeArray) {
        for (int i = 0; i < nodeArray.length; ++i) {
            GridPane.setConstraints(nodeArray[i], n, i);
        }
    }

    private static int getNodeRowIndex(Node node) {
        Integer n = GridPane.getRowIndex(node);
        return n != null ? n : 0;
    }

    private static int getNodeRowSpan(Node node) {
        Integer n = GridPane.getRowSpan(node);
        return n != null ? n : 1;
    }

    private static int getNodeRowEnd(Node node) {
        int n = GridPane.getNodeRowSpan(node);
        return n != Integer.MAX_VALUE ? GridPane.getNodeRowIndex(node) + n - 1 : Integer.MAX_VALUE;
    }

    private static int getNodeColumnIndex(Node node) {
        Integer n = GridPane.getColumnIndex(node);
        return n != null ? n : 0;
    }

    private static int getNodeColumnSpan(Node node) {
        Integer n = GridPane.getColumnSpan(node);
        return n != null ? n : 1;
    }

    private static int getNodeColumnEnd(Node node) {
        int n = GridPane.getNodeColumnSpan(node);
        return n != Integer.MAX_VALUE ? GridPane.getNodeColumnIndex(node) + n - 1 : Integer.MAX_VALUE;
    }

    private static Priority getNodeHgrow(Node node) {
        Priority priority = GridPane.getHgrow(node);
        return priority != null ? priority : Priority.NEVER;
    }

    private static Priority getNodeVgrow(Node node) {
        Priority priority = GridPane.getVgrow(node);
        return priority != null ? priority : Priority.NEVER;
    }

    private static double sum(double[] dArray) {
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return d;
    }

    private static Priority[] createPriorityArray(int n, Priority priority) {
        Priority[] priorityArray = new Priority[n];
        for (int i = 0; i < n; ++i) {
            priorityArray[i] = priority;
        }
        return priorityArray;
    }

    private static double[] createDoubleArray(int n, double d) {
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
        return dArray;
    }

    public final DoubleProperty hgapProperty() {
        if (this.hgap == null) {
            this.hgap = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    GridPane.this.requestLayout();
                    GridPane.this.impl_cssPropertyInvalidated(StyleableProperties.HGAP);
                }

                @Override
                public Object getBean() {
                    return GridPane.this;
                }

                @Override
                public String getName() {
                    return "hgap";
                }
            };
        }
        return this.hgap;
    }

    public final void setHgap(double d) {
        this.hgapProperty().set(d);
    }

    public final double getHgap() {
        return this.hgap == null ? 0.0 : this.hgap.get();
    }

    public final DoubleProperty vgapProperty() {
        if (this.vgap == null) {
            this.vgap = new DoublePropertyBase(0.0){

                @Override
                public void invalidated() {
                    GridPane.this.requestLayout();
                    GridPane.this.impl_cssPropertyInvalidated(StyleableProperties.VGAP);
                }

                @Override
                public Object getBean() {
                    return GridPane.this;
                }

                @Override
                public String getName() {
                    return "vgap";
                }
            };
        }
        return this.vgap;
    }

    public final void setVgap(double d) {
        this.vgapProperty().set(d);
    }

    public final double getVgap() {
        return this.vgap == null ? 0.0 : this.vgap.get();
    }

    public final ObjectProperty<Pos> alignmentProperty() {
        if (this.alignment == null) {
            this.alignment = new ObjectPropertyBase<Pos>(Pos.TOP_LEFT){

                @Override
                public void invalidated() {
                    GridPane.this.requestLayout();
                    GridPane.this.impl_cssPropertyInvalidated(StyleableProperties.ALIGNMENT);
                }

                @Override
                public Object getBean() {
                    return GridPane.this;
                }

                @Override
                public String getName() {
                    return "alignment";
                }
            };
        }
        return this.alignment;
    }

    public final void setAlignment(Pos pos) {
        this.alignmentProperty().set(pos);
    }

    public final Pos getAlignment() {
        return this.alignment == null ? Pos.TOP_LEFT : (Pos)((Object)this.alignment.get());
    }

    public final BooleanProperty gridLinesVisibleProperty() {
        if (this.gridLinesVisible == null) {
            this.gridLinesVisible = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    if (this.get()) {
                        GridPane.this.gridLines = new Group();
                        GridPane.this.gridLines.setManaged(false);
                        GridPane.this.getChildren().add(GridPane.this.gridLines);
                    } else {
                        GridPane.this.getChildren().remove(GridPane.this.gridLines);
                        GridPane.this.gridLines = null;
                    }
                    GridPane.this.requestLayout();
                    GridPane.this.impl_cssPropertyInvalidated(StyleableProperties.GRID_LINES_VISIBLE);
                }

                @Override
                public Object getBean() {
                    return GridPane.this;
                }

                @Override
                public String getName() {
                    return "gridLinesVisible";
                }
            };
        }
        return this.gridLinesVisible;
    }

    public final void setGridLinesVisible(boolean bl) {
        this.gridLinesVisibleProperty().set(bl);
    }

    public final boolean isGridLinesVisible() {
        return this.gridLinesVisible == null ? false : this.gridLinesVisible.get();
    }

    public final ObservableList<RowConstraints> getRowConstraints() {
        return this.rowConstraints;
    }

    public final ObservableList<ColumnConstraints> getColumnConstraints() {
        return this.columnConstraints;
    }

    public void add(Node node, int n, int n2) {
        GridPane.setConstraints(node, n, n2);
        this.getChildren().add(node);
    }

    public void add(Node node, int n, int n2, int n3, int n4) {
        GridPane.setConstraints(node, n, n2, n3, n4);
        this.getChildren().add(node);
    }

    public void addRow(int n, Node ... nodeArray) {
        GridPane.createRow(n, nodeArray);
        this.getChildren().addAll((Node[])nodeArray);
    }

    public void addColumn(int n, Node ... nodeArray) {
        GridPane.createColumn(n, nodeArray);
        this.getChildren().addAll((Node[])nodeArray);
    }

    @Override
    protected double computeMinWidth(double d) {
        this.computeGridMetrics();
        return this.snapSpace(this.getInsets().getLeft()) + (this.computeTotalWidth(this.columnMinWidth) + (double)(this.columnMinWidth.length - 1) * this.snapSpace(this.getHgap())) + this.snapSpace(this.getInsets().getRight());
    }

    @Override
    protected double computeMinHeight(double d) {
        this.computeGridMetrics();
        return this.snapSpace(this.getInsets().getTop()) + (this.computeTotalHeight(this.rowMinHeight) + (double)(this.rowMinHeight.length - 1) * this.snapSpace(this.getVgap())) + this.snapSpace(this.getInsets().getBottom());
    }

    @Override
    protected double computePrefWidth(double d) {
        this.computeGridMetrics();
        return this.snapSpace(this.getInsets().getLeft()) + (this.computeTotalWidth(this.columnPrefWidth) + (double)(this.columnPrefWidth.length - 1) * this.snapSpace(this.getHgap())) + this.snapSpace(this.getInsets().getRight());
    }

    @Override
    protected double computePrefHeight(double d) {
        this.computeGridMetrics();
        return this.snapSpace(this.getInsets().getTop()) + (this.computeTotalHeight(this.rowPrefHeight) + (double)(this.rowPrefHeight.length - 1) * this.snapSpace(this.getVgap())) + this.snapSpace(this.getInsets().getBottom());
    }

    private double computeTotalWidth(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (this.columnPercentWidth[i] < 0.0) {
                d2 += dArray[i];
                continue;
            }
            d = Math.max(d, dArray[i] * 100.0 / this.columnPercentWidth[i]);
        }
        if (this.columnPercentTotal <= 0.0) {
            d = d2;
        } else if (this.columnPercentTotal < 100.0) {
            d = Math.max(d, d2 * 100.0 / (100.0 - this.columnPercentTotal));
        }
        return d;
    }

    private double computeTotalHeight(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            if (this.rowPercentHeight[i] < 0.0) {
                d2 += dArray[i];
                continue;
            }
            d = Math.max(d, dArray[i] * 100.0 / this.rowPercentHeight[i]);
        }
        if (this.rowPercentTotal <= 0.0) {
            d = d2;
        } else if (this.rowPercentTotal < 100.0) {
            d = Math.max(d, d2 * 100.0 / (100.0 - this.rowPercentTotal));
        }
        return d;
    }

    private VPos getRowValignment(int n) {
        RowConstraints rowConstraints;
        if (n < this.getRowConstraints().size() && (rowConstraints = (RowConstraints)this.getRowConstraints().get(n)).getValignment() != null) {
            return rowConstraints.getValignment();
        }
        return VPos.CENTER;
    }

    private HPos getColumnHalignment(int n) {
        ColumnConstraints columnConstraints;
        if (n < this.getColumnConstraints().size() && (columnConstraints = (ColumnConstraints)this.getColumnConstraints().get(n)).getHalignment() != null) {
            return columnConstraints.getHalignment();
        }
        return HPos.LEFT;
    }

    private boolean shouldRowFillHeight(int n) {
        if (n < this.getRowConstraints().size()) {
            return ((RowConstraints)this.getRowConstraints().get(n)).isFillHeight() && this.getRowValignment(n) != VPos.BASELINE;
        }
        return true;
    }

    private boolean shouldColumnFillWidth(int n) {
        if (n < this.getColumnConstraints().size()) {
            return ((ColumnConstraints)this.getColumnConstraints().get(n)).isFillWidth();
        }
        return true;
    }

    private void computeGridMetrics() {
        if (this.metricsDirty) {
            int n = this.getRowConstraints().size();
            int n2 = this.getColumnConstraints().size();
            for (int i = 0; i < this.getChildren().size(); ++i) {
                Node node = (Node)this.getChildren().get(i);
                if (!node.isManaged()) continue;
                int n3 = GridPane.getNodeRowIndex(node);
                int n4 = GridPane.getNodeColumnIndex(node);
                int n5 = GridPane.getNodeRowEnd(node);
                int n6 = GridPane.getNodeColumnEnd(node);
                n = Math.max(n, (n5 != Integer.MAX_VALUE ? n5 : n3) + 1);
                n2 = Math.max(n2, (n6 != Integer.MAX_VALUE ? n6 : n4) + 1);
            }
            this.computeRowMetrics(n);
            this.computeColumnMetrics(n2);
            this.metricsDirty = false;
        }
    }

    private void computeRowMetrics(int n) {
        int n2;
        int n3;
        this.rowPercentHeight = GridPane.createDoubleArray(n, -1.0);
        this.rowMinHeight = GridPane.createDoubleArray(n, 0.0);
        this.rowPrefHeight = GridPane.createDoubleArray(n, 0.0);
        this.rowMaxHeight = GridPane.createDoubleArray(n, 2.147483647E9);
        this.rowHeights = GridPane.createDoubleArray(n, 0.0);
        this.rowBaseline = GridPane.createDoubleArray(n, 0.0);
        this.rowGrow = GridPane.createPriorityArray(n, Priority.NEVER);
        double d = this.snapSpace(this.getVgap());
        for (n3 = 0; n3 < n; ++n3) {
            int n4;
            Insets[] insetsArray;
            boolean bl = true;
            n2 = 1;
            boolean bl2 = true;
            boolean bl3 = true;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            ArrayList<Insets[]> arrayList2 = new ArrayList<Insets[]>();
            for (int i = 0; i < this.getChildren().size(); ++i) {
                insetsArray = (Insets[])this.getChildren().get(i);
                if (!insetsArray.isManaged()) continue;
                if (GridPane.getNodeRowIndex((Node)insetsArray) == n3) {
                    arrayList.add((Node)insetsArray);
                }
                if (((n4 = GridPane.getNodeRowEnd((Node)insetsArray)) != Integer.MAX_VALUE || n3 != n - 1) && n4 != n3) continue;
                arrayList2.add(insetsArray);
            }
            if (n3 < this.getRowConstraints().size()) {
                RowConstraints rowConstraints = (RowConstraints)this.getRowConstraints().get(n3);
                if (rowConstraints.getPercentHeight() > 0.0) {
                    this.rowPercentHeight[n3] = rowConstraints.getPercentHeight();
                    bl3 = false;
                } else {
                    double d2 = rowConstraints.getPrefHeight();
                    if (d2 != -1.0) {
                        this.rowPrefHeight[n3] = d2;
                        bl2 = false;
                    }
                    if ((d2 = rowConstraints.getMinHeight()) != -1.0) {
                        this.rowMinHeight[n3] = d2;
                        bl = false;
                    }
                    if ((d2 = rowConstraints.getMaxHeight()) != -1.0) {
                        this.rowMaxHeight[n3] = d2;
                        n2 = 0;
                    }
                    if (rowConstraints.getVgrow() != null) {
                        this.rowGrow[n3] = rowConstraints.getVgrow();
                        bl3 = false;
                    }
                }
            }
            VPos vPos = this.getRowValignment(n3);
            insetsArray = new Insets[arrayList.size()];
            for (n4 = 0; n4 < arrayList.size(); ++n4) {
                insetsArray[n4] = GridPane.getMargin((Node)arrayList.get(n4));
            }
            this.rowBaseline[n3] = GridPane.getMaxAreaBaselineOffset(arrayList, insetsArray);
            if (bl || n2 != 0 || bl2 || bl3 || vPos == VPos.BASELINE) {
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    int n5;
                    double d3;
                    double d4;
                    Node node = (Node)arrayList2.get(n4);
                    Insets insets = GridPane.getMargin(node);
                    double d5 = insets != null ? insets.getTop() : 0.0;
                    int n6 = GridPane.getNodeRowIndex(node);
                    int n7 = GridPane.getNodeRowSpan(node);
                    if (n7 == Integer.MAX_VALUE) {
                        n7 = n - n6;
                    }
                    if (bl2) {
                        d4 = this.computeChildPrefAreaHeight(node, insets);
                        if (n7 > 1) {
                            d3 = 0.0;
                            for (n5 = n6; n5 < n6 + n7 - 1; ++n5) {
                                d3 += this.rowPrefHeight[n5];
                            }
                            d4 -= d3 + (double)(n7 - 1) * d;
                        } else if (vPos == VPos.BASELINE) {
                            d4 = this.rowBaseline[n3] + (d4 - node.getBaselineOffset() - d5);
                        }
                        this.rowPrefHeight[n3] = Math.max(this.rowPrefHeight[n3], d4);
                    }
                    if (bl) {
                        d4 = this.computeChildMinAreaHeight(node, insets);
                        if (n7 > 1) {
                            d3 = 0.0;
                            for (n5 = n6; n5 < n6 + n7 - 1; ++n5) {
                                d3 += this.rowMinHeight[n5];
                            }
                            d4 -= d3 + (double)(n7 - 1) * d;
                        } else if (vPos == VPos.BASELINE) {
                            d4 = this.rowBaseline[n3] + (d4 - node.getBaselineOffset() - d5);
                        }
                        this.rowMinHeight[n3] = Math.max(this.rowMinHeight[n3], d4);
                    }
                    if (n2 != 0) {
                        d4 = this.computeChildMaxAreaHeight(node, insets);
                        if (n7 > 1) {
                            d3 = 0.0;
                            for (n5 = n6; n5 < n6 + n7 - 1; ++n5) {
                                d3 += this.rowMaxHeight[n5];
                            }
                            d4 -= d3 + (double)(n7 - 1) * d;
                        }
                        this.rowMaxHeight[n3] = Math.max(this.rowMaxHeight[n3], d4);
                    }
                    if (!bl3 || n7 != 1) continue;
                    this.rowGrow[n3] = Priority.max(this.rowGrow[n3], GridPane.getNodeVgrow(node));
                }
            }
            if (this.rowMinHeight[n3] == Double.NEGATIVE_INFINITY) {
                this.rowMinHeight[n3] = this.rowPrefHeight[n3];
            }
            if (this.rowMaxHeight[n3] == Double.NEGATIVE_INFINITY) {
                this.rowMaxHeight[n3] = this.rowPrefHeight[n3];
            }
            this.rowPrefHeight[n3] = GridPane.boundedSize(this.rowPrefHeight[n3], this.rowMinHeight[n3], this.rowMaxHeight[n3]);
        }
        this.rowPercentTotal = 0.0;
        for (n3 = 0; n3 < this.rowPercentHeight.length; ++n3) {
            if (!(this.rowPercentHeight[n3] > 0.0)) continue;
            this.rowPercentTotal += this.rowPercentHeight[n3];
        }
        if (this.rowPercentTotal > 100.0) {
            double d6 = 100.0 / this.rowPercentTotal;
            for (n2 = 0; n2 < this.rowPercentHeight.length; ++n2) {
                if (!(this.rowPercentHeight[n2] > 0.0)) continue;
                int n8 = n2;
                this.rowPercentHeight[n8] = this.rowPercentHeight[n8] * d6;
            }
            this.rowPercentTotal = 100.0;
        }
    }

    private void computeColumnMetrics(int n) {
        int n2;
        int n3;
        this.columnPercentWidth = GridPane.createDoubleArray(n, -1.0);
        this.columnMinWidth = GridPane.createDoubleArray(n, 0.0);
        this.columnPrefWidth = GridPane.createDoubleArray(n, 0.0);
        this.columnMaxWidth = GridPane.createDoubleArray(n, 2.147483647E9);
        this.columnWidths = GridPane.createDoubleArray(n, 0.0);
        this.columnGrow = GridPane.createPriorityArray(n, Priority.NEVER);
        double d = this.snapSpace(this.getHgap());
        for (n3 = 0; n3 < n; ++n3) {
            int n4;
            boolean bl = true;
            n2 = 1;
            boolean bl2 = true;
            boolean bl3 = true;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            for (n4 = 0; n4 < this.getChildren().size(); ++n4) {
                int n5;
                Node node = (Node)this.getChildren().get(n4);
                if (!node.isManaged()) continue;
                if (GridPane.getNodeColumnIndex(node) == n3) {
                    arrayList.add(node);
                }
                if (((n5 = GridPane.getNodeColumnEnd(node)) != Integer.MAX_VALUE || n3 != n - 1) && n5 != n3) continue;
                arrayList2.add(node);
            }
            if (n3 < this.getColumnConstraints().size()) {
                ColumnConstraints columnConstraints = (ColumnConstraints)this.getColumnConstraints().get(n3);
                if (columnConstraints.getPercentWidth() > 0.0) {
                    this.columnPercentWidth[n3] = columnConstraints.getPercentWidth();
                    bl3 = false;
                } else {
                    double d2 = columnConstraints.getPrefWidth();
                    if (d2 != -1.0) {
                        this.columnPrefWidth[n3] = d2;
                        bl2 = false;
                    }
                    if ((d2 = columnConstraints.getMinWidth()) != -1.0) {
                        this.columnMinWidth[n3] = d2;
                        bl = false;
                    }
                    if ((d2 = columnConstraints.getMaxWidth()) != -1.0) {
                        this.columnMaxWidth[n3] = d2;
                        n2 = 0;
                    }
                    if (columnConstraints.getHgrow() != null) {
                        this.columnGrow[n3] = columnConstraints.getHgrow();
                        bl3 = false;
                    }
                }
            }
            if (bl || n2 != 0 || bl2 || bl3) {
                for (n4 = 0; n4 < arrayList2.size(); ++n4) {
                    int n6;
                    double d3;
                    double d4;
                    Node node = (Node)arrayList2.get(n4);
                    Insets insets = GridPane.getMargin(node);
                    int n7 = GridPane.getNodeColumnIndex(node);
                    int n8 = GridPane.getNodeColumnSpan(node);
                    if (n8 == Integer.MAX_VALUE) {
                        n8 = n - n7;
                    }
                    if (bl2) {
                        d4 = this.computeChildPrefAreaWidth(node, insets);
                        if (n8 > 1) {
                            d3 = 0.0;
                            for (n6 = n7; n6 < n7 + n8 - 1; ++n6) {
                                d3 += this.columnPrefWidth[n6];
                            }
                            d4 -= d3 + (double)(n8 - 1) * d;
                        }
                        this.columnPrefWidth[n3] = Math.max(this.columnPrefWidth[n3], d4);
                    }
                    if (bl) {
                        d4 = this.computeChildMinAreaWidth(node, insets);
                        if (n8 > 1) {
                            d3 = 0.0;
                            for (n6 = n7; n6 < n7 + n8 - 1; ++n6) {
                                d3 += this.columnMinWidth[n6];
                            }
                            d4 -= d3 + (double)(n8 - 1) * d;
                        }
                        this.columnMinWidth[n3] = Math.max(this.columnMinWidth[n3], d4);
                    }
                    if (n2 != 0) {
                        d4 = this.computeChildMaxAreaWidth(node, insets);
                        if (n8 > 1) {
                            d3 = 0.0;
                            for (n6 = n7; n6 < n7 + n8 - 1; ++n6) {
                                d3 += this.columnMaxWidth[n6];
                            }
                            d4 -= d3 + (double)(n8 - 1) * d;
                        }
                        this.columnMaxWidth[n3] = Math.max(this.columnMaxWidth[n3], d4);
                    }
                    if (!bl3 || n8 != 1) continue;
                    this.columnGrow[n3] = Priority.max(this.columnGrow[n3], GridPane.getNodeHgrow(node));
                }
            }
            if (this.columnMinWidth[n3] == Double.NEGATIVE_INFINITY) {
                this.columnMinWidth[n3] = this.columnPrefWidth[n3];
            }
            if (this.columnMaxWidth[n3] == Double.NEGATIVE_INFINITY) {
                this.columnMaxWidth[n3] = this.columnPrefWidth[n3];
            }
            this.columnPrefWidth[n3] = GridPane.boundedSize(this.columnPrefWidth[n3], this.columnMinWidth[n3], this.columnMaxWidth[n3]);
        }
        this.columnPercentTotal = 0.0;
        for (n3 = 0; n3 < this.columnPercentWidth.length; ++n3) {
            if (!(this.columnPercentWidth[n3] > 0.0)) continue;
            this.columnPercentTotal += this.columnPercentWidth[n3];
        }
        if (this.columnPercentTotal > 100.0) {
            double d5 = 100.0 / this.columnPercentTotal;
            for (n2 = 0; n2 < this.columnPercentWidth.length; ++n2) {
                if (!(this.columnPercentWidth[n2] > 0.0)) continue;
                int n9 = n2;
                this.columnPercentWidth[n9] = this.columnPercentWidth[n9] * d5;
            }
            this.columnPercentTotal = 100.0;
        }
    }

    @Override
    public void requestLayout() {
        this.metricsDirty = true;
        super.requestLayout();
    }

    @Override
    protected void layoutChildren() {
        double d;
        int n;
        this.computeGridMetrics();
        double d2 = this.snapSpace(this.getHgap());
        double d3 = this.snapSpace(this.getVgap());
        double d4 = this.snapSpace(this.getInsets().getTop());
        double d5 = this.snapSpace(this.getInsets().getBottom());
        double d6 = this.snapSpace(this.getInsets().getLeft());
        double d7 = this.snapSpace(this.getInsets().getRight());
        int n2 = this.rowHeights.length;
        int n3 = this.columnWidths.length;
        double d8 = d3 * (double)(n2 - 1);
        double d9 = d2 * (double)(n3 - 1);
        double d10 = d8;
        double d11 = d9;
        double d12 = this.getHeight() - d4 - d5;
        double d13 = this.getWidth() - d6 - d7;
        if (this.rowPercentTotal > 0.0) {
            for (n = 0; n < this.rowPercentHeight.length; ++n) {
                if (!(this.rowPercentHeight[n] >= 0.0)) continue;
                this.rowHeights[n] = (d12 - d8) * (this.rowPercentHeight[n] / 100.0);
                d10 += this.rowHeights[n];
            }
        }
        for (n = 0; n < n2; ++n) {
            if (!(this.rowPercentHeight[n] < 0.0)) continue;
            this.rowHeights[n] = GridPane.boundedSize(this.rowPrefHeight[n], this.rowMinHeight[n], this.rowMaxHeight[n]);
            d10 += this.rowHeights[n];
        }
        double d14 = d12 - d10;
        if (d14 != 0.0) {
            double d15 = this.adjustRowHeights(Priority.ALWAYS, d14);
            d15 = this.adjustRowHeights(Priority.SOMETIMES, d15);
            d10 += d14 - d15;
        }
        if (this.columnPercentTotal > 0.0) {
            for (int i = 0; i < this.columnPercentWidth.length; ++i) {
                if (!(this.columnPercentWidth[i] >= 0.0)) continue;
                this.columnWidths[i] = (d13 - d9) * (this.columnPercentWidth[i] / 100.0);
                d11 += this.columnWidths[i];
            }
        }
        for (int i = 0; i < n3; ++i) {
            if (!(this.columnPercentWidth[i] < 0.0)) continue;
            this.columnWidths[i] = GridPane.boundedSize(this.columnPrefWidth[i], this.columnMinWidth[i], this.columnMaxWidth[i]);
            d11 += this.columnWidths[i];
        }
        double d16 = d13 - d11;
        d16 = d13 - d11;
        if (d16 != 0.0) {
            d = this.adjustColumnWidths(Priority.ALWAYS, d16);
            d = this.adjustColumnWidths(Priority.SOMETIMES, d);
            d11 += d16 - d;
        }
        d = d6 + GridPane.computeXOffset(d13, d11 + d2 * (double)(n3 - 1), this.getAlignment().getHpos());
        double d17 = d4 + GridPane.computeYOffset(d12, d10 + d3 * (double)(n2 - 1), this.getAlignment().getVpos());
        for (int i = 0; i < this.getChildren().size(); ++i) {
            int n4;
            Node node = (Node)this.getChildren().get(i);
            if (!node.isManaged()) continue;
            int n5 = GridPane.getNodeRowIndex(node);
            int n6 = GridPane.getNodeColumnIndex(node);
            int n7 = GridPane.getNodeColumnSpan(node);
            if (n7 == Integer.MAX_VALUE) {
                n7 = this.columnWidths.length - n6;
            }
            if ((n4 = GridPane.getNodeRowSpan(node)) == Integer.MAX_VALUE) {
                n4 = this.rowHeights.length - n5;
            }
            double d18 = d;
            for (int j = 0; j < n6; ++j) {
                d18 += this.columnWidths[j] + d2;
            }
            double d19 = d17;
            for (int j = 0; j < n5; ++j) {
                d19 += this.rowHeights[j] + d3;
            }
            double d20 = this.columnWidths[n6];
            for (int j = 2; j <= n7; ++j) {
                d20 += this.columnWidths[n6 + j - 1] + d2;
            }
            double d21 = this.rowHeights[n5];
            for (int j = 2; j <= n4; ++j) {
                d21 += this.rowHeights[n5 + j - 1] + d3;
            }
            HPos hPos = GridPane.getHalignment(node);
            VPos vPos = GridPane.getValignment(node);
            this.layoutInArea(node, d18, d19, d20, d21, this.rowBaseline[n5], GridPane.getMargin(node), this.shouldColumnFillWidth(n6), this.shouldRowFillHeight(n5), hPos != null ? hPos : this.getColumnHalignment(n6), vPos != null ? vPos : this.getRowValignment(n5));
        }
        this.layoutGridLines(d, d17, d10, d11);
    }

    private double adjustRowHeights(Priority priority, double d) {
        boolean bl = d < 0.0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < this.rowGrow.length; ++i) {
            if (!(this.rowPercentHeight[i] < 0.0) || !bl && this.rowGrow[i] != priority) continue;
            arrayList.add(i);
        }
        double d2 = d;
        while (Math.abs(d2) > 1.0 && arrayList.size() > 0) {
            int n;
            double d3 = d2 / (double)arrayList.size();
            for (n = 0; n < arrayList.size(); ++n) {
                int n2 = (Integer)arrayList.get(n);
                double d4 = (bl ? this.rowMinHeight[n2] : this.rowMaxHeight[n2]) - this.rowHeights[n2];
                double d5 = Math.abs(d4) <= Math.abs(d3) ? d4 : d3;
                int n3 = n2;
                this.rowHeights[n3] = this.rowHeights[n3] + d5;
                d2 -= d5;
                if (!(Math.abs(d5) < Math.abs(d3))) continue;
                arrayList2.add(n2);
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                arrayList.remove(arrayList2.get(n));
            }
            arrayList2.clear();
        }
        return d2;
    }

    private double adjustColumnWidths(Priority priority, double d) {
        boolean bl = d < 0.0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < this.columnGrow.length; ++i) {
            if (!(this.columnPercentWidth[i] < 0.0) || !bl && this.columnGrow[i] != priority) continue;
            arrayList.add(i);
        }
        double d2 = d;
        while (Math.abs(d2) > 1.0 && arrayList.size() > 0) {
            int n;
            double d3 = d2 / (double)arrayList.size();
            for (n = 0; n < arrayList.size(); ++n) {
                int n2 = (Integer)arrayList.get(n);
                double d4 = (bl ? this.columnMinWidth[n2] : this.columnMaxWidth[n2]) - this.columnWidths[n2];
                double d5 = Math.abs(d4) <= Math.abs(d3) ? d4 : d3;
                int n3 = n2;
                this.columnWidths[n3] = this.columnWidths[n3] + d5;
                d2 -= d5;
                if (!(Math.abs(d5) < Math.abs(d3))) continue;
                arrayList2.add(n2);
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                arrayList.remove(arrayList2.get(n));
            }
            arrayList2.clear();
        }
        return d2;
    }

    private void layoutGridLines(double d, double d2, double d3, double d4) {
        int n;
        if (!this.isGridLinesVisible()) {
            return;
        }
        if (!this.gridLines.getChildren().isEmpty()) {
            this.gridLines.getChildren().clear();
        }
        double d5 = this.snapSpace(this.getHgap());
        double d6 = this.snapSpace(this.getVgap());
        double d7 = d;
        double d8 = d2;
        for (n = 0; n <= this.columnWidths.length; ++n) {
            this.gridLines.getChildren().add(this.createGridLine(d7, d8, d7, d8 + d3));
            if (n > 0 && n < this.columnWidths.length && this.getHgap() != 0.0) {
                this.gridLines.getChildren().add(this.createGridLine(d7 += this.getHgap(), d8, d7, d8 + d3));
            }
            if (n >= this.columnWidths.length) continue;
            d7 += this.columnWidths[n];
        }
        d7 = d;
        for (n = 0; n <= this.rowHeights.length; ++n) {
            this.gridLines.getChildren().add(this.createGridLine(d7, d8, d7 + d4, d8));
            if (n > 0 && n < this.rowHeights.length && this.getVgap() != 0.0) {
                this.gridLines.getChildren().add(this.createGridLine(d7, d8 += this.getVgap(), d7 + d4, d8));
            }
            if (n >= this.rowHeights.length) continue;
            d8 += this.rowHeights[n];
        }
    }

    private Line createGridLine(double d, double d2, double d3, double d4) {
        Line line = new Line();
        line.setStartX(d);
        line.setStartY(d2);
        line.setEndX(d3);
        line.setEndY(d4);
        line.setStroke(GRID_LINE_COLOR);
        line.setStrokeDashOffset(3.0);
        return line;
    }

    @Override
    public String toString() {
        return "Grid hgap=" + this.getHgap() + ", vgap=" + this.getVgap() + ", alignment=" + (Object)((Object)this.getAlignment());
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-grid-lines-visible".equals(string)) {
            this.setGridLinesVisible((Boolean)object);
        } else if ("-fx-hgap".equals(string)) {
            this.setHgap((Double)object);
        } else if ("-fx-alignment".equals(string)) {
            this.setAlignment((Pos)((Object)object));
        } else if ("-fx-vgap".equals(string)) {
            this.setVgap((Double)object);
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-grid-lines-visible".equals(string)) {
            return this.gridLinesVisible == null || !this.gridLinesVisible.isBound();
        }
        if ("-fx-hgap".equals(string)) {
            return this.hgap == null || !this.hgap.isBound();
        }
        if ("-fx-alignment".equals(string)) {
            return this.alignment == null || !this.alignment.isBound();
        }
        if ("-fx-vgap".equals(string)) {
            return this.vgap == null || !this.vgap.isBound();
        }
        return super.impl_cssSettable(string);
    }

    private static class StyleableProperties {
        private static final StyleableProperty GRID_LINES_VISIBLE = new StyleableProperty(GridPane.class, "gridLinesVisible");
        private static final StyleableProperty HGAP = new StyleableProperty(GridPane.class, "hgap");
        private static final StyleableProperty ALIGNMENT = new StyleableProperty(GridPane.class, "alignment");
        private static final StyleableProperty VGAP = new StyleableProperty(GridPane.class, "vgap");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Region.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, GRID_LINES_VISIBLE, HGAP, ALIGNMENT, VGAP);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

