/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.tk.Toolkit;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.input.InputEvent;

public class ScrollEvent
extends InputEvent {
    public static final EventType<ScrollEvent> SCROLL = new EventType<InputEvent>(InputEvent.ANY, "SCROLL");
    public static final EventType<ScrollEvent> ANY = SCROLL;
    private double deltaX;
    private double deltaY;
    private HorizontalTextScrollUnits textDeltaXUnits;
    private VerticalTextScrollUnits textDeltaYUnits;
    private double textDeltaX;
    private double textDeltaY;
    private double x;
    private double y;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;
    private boolean shiftDown;
    private boolean controlDown;
    private boolean altDown;
    private boolean metaDown;

    private ScrollEvent(EventType<? extends ScrollEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    private ScrollEvent(Object object, EventTarget eventTarget, EventType<? extends ScrollEvent> eventType) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
    }

    private void recomputeCoordinatesToSource(ScrollEvent scrollEvent, Object object) {
        Point2D point2D = InputEventUtils.recomputeCoordinates(new Point2D(this.x, this.y), this.source, object);
        scrollEvent.x = point2D.getX();
        scrollEvent.y = point2D.getY();
        scrollEvent.sceneX = this.getSceneX();
        scrollEvent.sceneY = this.getSceneY();
    }

    @Override
    public Event copyFor(Object object, EventTarget eventTarget) {
        ScrollEvent scrollEvent = (ScrollEvent)super.copyFor(object, eventTarget);
        this.recomputeCoordinatesToSource(scrollEvent, object);
        return scrollEvent;
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public HorizontalTextScrollUnits getTextDeltaXUnits() {
        return this.textDeltaXUnits;
    }

    public VerticalTextScrollUnits getTextDeltaYUnits() {
        return this.textDeltaYUnits;
    }

    public double getTextDeltaX() {
        return this.textDeltaX;
    }

    public double getTextDeltaY() {
        return this.textDeltaY;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    @Deprecated
    public static ScrollEvent impl_scrollEvent(double d, double d2, HorizontalTextScrollUnits horizontalTextScrollUnits, double d3, VerticalTextScrollUnits verticalTextScrollUnits, double d4, double d5, double d6, double d7, double d8, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        ScrollEvent scrollEvent = new ScrollEvent((EventType<? extends ScrollEvent>)SCROLL);
        scrollEvent.deltaX = d;
        scrollEvent.deltaY = d2;
        scrollEvent.textDeltaXUnits = horizontalTextScrollUnits;
        scrollEvent.textDeltaX = d3;
        scrollEvent.textDeltaYUnits = verticalTextScrollUnits;
        scrollEvent.textDeltaY = d4;
        scrollEvent.x = d5;
        scrollEvent.y = d6;
        scrollEvent.screenX = d7;
        scrollEvent.screenY = d8;
        scrollEvent.sceneX = d5;
        scrollEvent.sceneY = d6;
        scrollEvent.shiftDown = bl;
        scrollEvent.controlDown = bl2;
        scrollEvent.altDown = bl3;
        scrollEvent.metaDown = bl4;
        return scrollEvent;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("ScrollEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", deltaX = ").append(this.getDeltaX()).append(", deltaY = ").append(this.getDeltaY());
        stringBuilder.append(", textDeltaXUnits = ").append((Object)this.getTextDeltaXUnits()).append(", textDeltaX = ").append(this.getTextDeltaX());
        stringBuilder.append(", textDeltaYUnits = ").append((Object)this.getTextDeltaYUnits()).append(", textDeltaY = ").append(this.getTextDeltaY());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        return stringBuilder.append("]").toString();
    }

    public static enum VerticalTextScrollUnits {
        NONE,
        LINES,
        PAGES;

    }

    public static enum HorizontalTextScrollUnits {
        NONE,
        CHARACTERS;

    }
}

