/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import com.sun.javafx.scene.input.InputEventUtils;
import com.sun.javafx.tk.Toolkit;
import javafx.event.Event;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.input.InputEvent;
import javafx.scene.input.MouseButton;

public class MouseEvent
extends InputEvent {
    public static final EventType<MouseEvent> ANY = new EventType<InputEvent>(InputEvent.ANY, "MOUSE");
    public static final EventType<MouseEvent> MOUSE_PRESSED = new EventType<MouseEvent>(ANY, "MOUSE_PRESSED");
    public static final EventType<MouseEvent> MOUSE_RELEASED = new EventType<MouseEvent>(ANY, "MOUSE_RELEASED");
    public static final EventType<MouseEvent> MOUSE_CLICKED = new EventType<MouseEvent>(ANY, "MOUSE_CLICKED");
    public static final EventType<MouseEvent> MOUSE_ENTERED_TARGET = new EventType<MouseEvent>(ANY, "MOUSE_ENTERED_TARGET");
    public static final EventType<MouseEvent> MOUSE_ENTERED = new EventType<MouseEvent>(MOUSE_ENTERED_TARGET, "MOUSE_ENTERED");
    public static final EventType<MouseEvent> MOUSE_EXITED_TARGET = new EventType<MouseEvent>(ANY, "MOUSE_EXITED_TARGET");
    public static final EventType<MouseEvent> MOUSE_EXITED = new EventType<MouseEvent>(MOUSE_EXITED_TARGET, "MOUSE_EXITED");
    public static final EventType<MouseEvent> MOUSE_MOVED = new EventType<MouseEvent>(ANY, "MOUSE_MOVED");
    public static final EventType<MouseEvent> MOUSE_DRAGGED = new EventType<MouseEvent>(ANY, "MOUSE_DRAGGED");
    @Deprecated
    public static final EventType<MouseEvent> IMPL_MOUSE_WHEEL_ROTATED = new EventType<MouseEvent>(ANY, "MOUSE_WHEEL_ROTATED");
    public static final EventType<MouseEvent> DRAG_DETECTED = new EventType<MouseEvent>(ANY, "DRAG_DETECTED");
    private Flags flags = new Flags();
    private double x;
    private double y;
    private double screenX;
    private double screenY;
    private double sceneX;
    private double sceneY;
    private double wheelRotation;
    private MouseButton button;
    private int clickCount;
    private boolean stillSincePress;
    private boolean shiftDown;
    private boolean controlDown;
    private boolean altDown;
    private boolean metaDown;
    private boolean popupTrigger;
    private boolean primaryButtonDown;
    private boolean secondaryButtonDown;
    private boolean middleButtonDown;

    private MouseEvent(EventType<? extends MouseEvent> eventType) {
        super((EventType<? extends InputEvent>)eventType);
    }

    private MouseEvent(Object object, EventTarget eventTarget, EventType<? extends MouseEvent> eventType) {
        super(object, eventTarget, (EventType<? extends InputEvent>)eventType);
    }

    @Deprecated
    public static MouseEvent impl_copy(Node node, Node node2, MouseEvent mouseEvent) {
        return MouseEvent.impl_copy(node, node2, mouseEvent, null);
    }

    private void recomputeCoordinatesToSource(MouseEvent mouseEvent, Object object) {
        Point2D point2D = InputEventUtils.recomputeCoordinates(new Point2D(this.x, this.y), this.source, object);
        mouseEvent.x = point2D.getX();
        mouseEvent.y = point2D.getY();
        mouseEvent.sceneX = this.getSceneX();
        mouseEvent.sceneY = this.getSceneY();
    }

    @Override
    public Event copyFor(Object object, EventTarget eventTarget) {
        MouseEvent mouseEvent = (MouseEvent)super.copyFor(object, eventTarget);
        this.recomputeCoordinatesToSource(mouseEvent, object);
        return mouseEvent;
    }

    @Deprecated
    public void impl_setClickParams(int n, boolean bl) {
        this.clickCount = n;
        this.stillSincePress = bl;
    }

    @Deprecated
    public static MouseEvent impl_copy(Object object, EventTarget eventTarget, MouseEvent mouseEvent, EventType<? extends MouseEvent> eventType) {
        MouseEvent mouseEvent2 = MouseEvent.impl_mouseEvent(object, eventTarget, mouseEvent.x, mouseEvent.y, mouseEvent.screenX, mouseEvent.screenY, mouseEvent.wheelRotation, mouseEvent.button, mouseEvent.clickCount, mouseEvent.stillSincePress, mouseEvent.shiftDown, mouseEvent.controlDown, mouseEvent.altDown, mouseEvent.metaDown, mouseEvent.popupTrigger, mouseEvent.primaryButtonDown, mouseEvent.middleButtonDown, mouseEvent.secondaryButtonDown, eventType != null ? eventType : mouseEvent.getEventType());
        mouseEvent.recomputeCoordinatesToSource(mouseEvent2, object);
        return mouseEvent2;
    }

    @Deprecated
    public static MouseEvent impl_mouseEvent(double d, double d2, double d3, double d4, double d5, MouseButton mouseButton, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, EventType<? extends MouseEvent> eventType) {
        MouseEvent mouseEvent = new MouseEvent(eventType);
        mouseEvent.x = d;
        mouseEvent.y = d2;
        mouseEvent.screenX = d3;
        mouseEvent.screenY = d4;
        mouseEvent.sceneX = d;
        mouseEvent.sceneY = d2;
        mouseEvent.wheelRotation = d5;
        mouseEvent.button = mouseButton;
        mouseEvent.clickCount = n;
        mouseEvent.stillSincePress = false;
        mouseEvent.shiftDown = bl;
        mouseEvent.controlDown = bl2;
        mouseEvent.altDown = bl3;
        mouseEvent.metaDown = bl4;
        mouseEvent.popupTrigger = bl5;
        mouseEvent.primaryButtonDown = bl6;
        mouseEvent.middleButtonDown = bl7;
        mouseEvent.secondaryButtonDown = bl8;
        return mouseEvent;
    }

    @Deprecated
    private static MouseEvent impl_mouseEvent(Object object, EventTarget eventTarget, double d, double d2, double d3, double d4, double d5, MouseButton mouseButton, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, EventType<? extends MouseEvent> eventType) {
        MouseEvent mouseEvent = new MouseEvent(object, eventTarget, eventType);
        mouseEvent.x = d;
        mouseEvent.y = d2;
        mouseEvent.screenX = d3;
        mouseEvent.screenY = d4;
        mouseEvent.sceneX = d;
        mouseEvent.sceneY = d2;
        mouseEvent.wheelRotation = d5;
        mouseEvent.button = mouseButton;
        mouseEvent.clickCount = n;
        mouseEvent.stillSincePress = bl;
        mouseEvent.shiftDown = bl2;
        mouseEvent.controlDown = bl3;
        mouseEvent.altDown = bl4;
        mouseEvent.metaDown = bl5;
        mouseEvent.popupTrigger = bl6;
        mouseEvent.primaryButtonDown = bl7;
        mouseEvent.middleButtonDown = bl8;
        mouseEvent.secondaryButtonDown = bl9;
        return mouseEvent;
    }

    @Deprecated
    public static boolean impl_getPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.popupTrigger;
    }

    public boolean isDragDetect() {
        return this.flags.dragDetect;
    }

    public void setDragDetect(boolean bl) {
        this.flags.dragDetect = bl;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getScreenX() {
        return this.screenX;
    }

    public final double getScreenY() {
        return this.screenY;
    }

    public final double getSceneX() {
        return this.sceneX;
    }

    public final double getSceneY() {
        return this.sceneY;
    }

    @Deprecated
    public final double impl_getWheelRotation() {
        return this.wheelRotation;
    }

    public final MouseButton getButton() {
        return this.button;
    }

    public final int getClickCount() {
        return this.clickCount;
    }

    public final boolean isStillSincePress() {
        return this.stillSincePress;
    }

    public final boolean isShiftDown() {
        return this.shiftDown;
    }

    public final boolean isControlDown() {
        return this.controlDown;
    }

    public final boolean isAltDown() {
        return this.altDown;
    }

    public final boolean isMetaDown() {
        return this.metaDown;
    }

    public final boolean isShortcutDown() {
        switch (Toolkit.getToolkit().getPlatformShortcutKey()) {
            case SHIFT: {
                return this.shiftDown;
            }
            case CONTROL: {
                return this.controlDown;
            }
            case ALT: {
                return this.altDown;
            }
            case META: {
                return this.metaDown;
            }
        }
        return false;
    }

    public final boolean isPrimaryButtonDown() {
        return this.primaryButtonDown;
    }

    public final boolean isSecondaryButtonDown() {
        return this.secondaryButtonDown;
    }

    public final boolean isMiddleButtonDown() {
        return this.middleButtonDown;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MouseEvent [");
        stringBuilder.append("source = ").append(this.getSource());
        stringBuilder.append(", target = ").append(this.getTarget());
        stringBuilder.append(", eventType = ").append(this.getEventType());
        stringBuilder.append(", consumed = ").append(this.isConsumed());
        stringBuilder.append(", x = ").append(this.getX()).append(", y = ").append(this.getY());
        if (this.getButton() != null) {
            stringBuilder.append(", button = ").append((Object)this.getButton());
        }
        if (this.getClickCount() > 1) {
            stringBuilder.append(", clickCount = ").append(this.getClickCount());
        }
        if (this.isPrimaryButtonDown()) {
            stringBuilder.append(", primaryButtonDown");
        }
        if (this.isMiddleButtonDown()) {
            stringBuilder.append(", middleButtonDown");
        }
        if (this.isSecondaryButtonDown()) {
            stringBuilder.append(", secondaryButtonDown");
        }
        if (this.isShiftDown()) {
            stringBuilder.append(", shiftDown");
        }
        if (this.isControlDown()) {
            stringBuilder.append(", controlDown");
        }
        if (this.isAltDown()) {
            stringBuilder.append(", altDown");
        }
        if (this.isMetaDown()) {
            stringBuilder.append(", metaDown");
        }
        if (this.isShortcutDown()) {
            stringBuilder.append(", shortcutDown");
        }
        return stringBuilder.append("]").toString();
    }

    private class Flags
    implements Cloneable {
        boolean dragDetect = true;

        private Flags() {
        }

        public Flags clone() {
            try {
                return (Flags)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

