/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.input;

import java.util.HashMap;
import java.util.Map;

public enum KeyCode {
    ENTER(10, "Enter"),
    BACK_SPACE(8, "Backspace"),
    TAB(9, "Tab"),
    CANCEL(3, "Cancel"),
    CLEAR(12, "Clear"),
    SHIFT(16, "Shift"),
    CONTROL(17, "Ctrl"),
    ALT(18, "Alt"),
    PAUSE(19, "Pause"),
    CAPS(20, "Caps Lock"),
    ESCAPE(27, "Esc"),
    SPACE(32, "Space"),
    PAGE_UP(33, "Page Up"),
    PAGE_DOWN(34, "Page Down"),
    END(35, "End"),
    HOME(36, "Home"),
    LEFT(37, "Left"),
    UP(38, "Up"),
    RIGHT(39, "Right"),
    DOWN(40, "Down"),
    COMMA(44, "Comma"),
    MINUS(45, "Minus"),
    PERIOD(46, "Period"),
    SLASH(47, "Slash"),
    DIGIT0(48, "0"),
    DIGIT1(49, "1"),
    DIGIT2(50, "2"),
    DIGIT3(51, "3"),
    DIGIT4(52, "4"),
    DIGIT5(53, "5"),
    DIGIT6(54, "6"),
    DIGIT7(55, "7"),
    DIGIT8(56, "8"),
    DIGIT9(57, "9"),
    SEMICOLON(59, "Semicolon"),
    EQUALS(61, "Equals"),
    A(65, "A"),
    B(66, "B"),
    C(67, "C"),
    D(68, "D"),
    E(69, "E"),
    F(70, "F"),
    G(71, "G"),
    H(72, "H"),
    I(73, "I"),
    J(74, "J"),
    K(75, "K"),
    L(76, "L"),
    M(77, "M"),
    N(78, "N"),
    O(79, "O"),
    P(80, "P"),
    Q(81, "Q"),
    R(82, "R"),
    S(83, "S"),
    T(84, "T"),
    U(85, "U"),
    V(86, "V"),
    W(87, "W"),
    X(88, "X"),
    Y(89, "Y"),
    Z(90, "Z"),
    OPEN_BRACKET(91, "Open Bracket"),
    BACK_SLASH(92, "Back Slash"),
    CLOSE_BRACKET(93, "Close Bracket"),
    NUMPAD0(96, "Numpad 0"),
    NUMPAD1(97, "Numpad 1"),
    NUMPAD2(98, "Numpad 2"),
    NUMPAD3(99, "Numpad 3"),
    NUMPAD4(100, "Numpad 4"),
    NUMPAD5(101, "Numpad 5"),
    NUMPAD6(102, "Numpad 6"),
    NUMPAD7(103, "Numpad 7"),
    NUMPAD8(104, "Numpad 8"),
    NUMPAD9(105, "Numpad 9"),
    MULTIPLY(106, "Multiply"),
    ADD(107, "Add"),
    SEPARATOR(108, "Separator"),
    SUBTRACT(109, "Subtract"),
    DECIMAL(110, "Decimal"),
    DIVIDE(111, "Divide"),
    DELETE(127, "Delete"),
    NUM_LOCK(144, "Num Lock"),
    SCROLL_LOCK(145, "Scroll Lock"),
    F1(112, "F1"),
    F2(113, "F2"),
    F3(114, "F3"),
    F4(115, "F4"),
    F5(116, "F5"),
    F6(117, "F6"),
    F7(118, "F7"),
    F8(119, "F8"),
    F9(120, "F9"),
    F10(121, "F10"),
    F11(122, "F11"),
    F12(123, "F12"),
    F13(61440, "F13"),
    F14(61441, "F14"),
    F15(61442, "F15"),
    F16(61443, "F16"),
    F17(61444, "F17"),
    F18(61445, "F18"),
    F19(61446, "F19"),
    F20(61447, "F20"),
    F21(61448, "F21"),
    F22(61449, "F22"),
    F23(61450, "F23"),
    F24(61451, "F24"),
    PRINTSCREEN(154, "Print Screen"),
    INSERT(155, "Insert"),
    HELP(156, "Help"),
    META(157, "Meta"),
    BACK_QUOTE(192, "Back Quote"),
    QUOTE(222, "Quote"),
    KP_UP(224, "Numpad Up"),
    KP_DOWN(225, "Numpad Down"),
    KP_LEFT(226, "Numpad Left"),
    KP_RIGHT(227, "Numpad Right"),
    DEAD_GRAVE(128, "Dead Grave"),
    DEAD_ACUTE(129, "Dead Acute"),
    DEAD_CIRCUMFLEX(130, "Circumflex"),
    DEAD_TILDE(131, "Dead Tilde"),
    DEAD_MACRON(132, "Dead Macron"),
    DEAD_BREVE(133, "Dead Breve"),
    DEAD_ABOVEDOT(134, "Dead Abovedot"),
    DEAD_DIAERESIS(135, "Dead Diaeresis"),
    DEAD_ABOVERING(136, "Dead Abovering"),
    DEAD_DOUBLEACUTE(137, "Dead Doubleacute"),
    DEAD_CARON(138, "Dead Caron"),
    DEAD_CEDILLA(139, "Dead Cedilla"),
    DEAD_OGONEK(140, "Dead Ogonek"),
    DEAD_IOTA(141, "Dead Iota"),
    DEAD_VOICED_SOUND(142, "Dead Voiced Sound"),
    DEAD_SEMIVOICED_SOUND(143, "Dead Semivoiced Sound"),
    AMPERSAND(150, "Ampersand"),
    ASTERISK(151, "Asterisk"),
    QUOTEDBL(152, "Double Quote"),
    LESS(153, "Less"),
    GREATER(160, "Greater"),
    BRACELEFT(161, "Left Brace"),
    BRACERIGHT(162, "Right Brace"),
    AT(512, "At"),
    COLON(513, "Colon"),
    CIRCUMFLEX(514, "Circumflex"),
    DOLLAR(515, "Dollar"),
    EURO_SIGN(516, "Euro Sign"),
    EXCLAMATION_MARK(517, "Exclamation Mark"),
    INVERTED_EXCLAMATION_MARK(518, "Inverted Exclamation Mark"),
    LEFT_PARENTHESIS(519, "Left Parenthesis"),
    NUMBER_SIGN(520, "Number Sign"),
    PLUS(521, "Plus"),
    RIGHT_PARENTHESIS(522, "Right Parenthesis"),
    UNDERSCORE(523, "Underscore"),
    WINDOWS(524, "Windows"),
    CONTEXT_MENU(525, "Context Menu"),
    FINAL(24, "Final"),
    CONVERT(28, "Convert"),
    NONCONVERT(29, "Nonconvert"),
    ACCEPT(30, "Accept"),
    MODECHANGE(31, "Mode Change"),
    KANA(21, "Kana"),
    KANJI(25, "Kanji"),
    ALPHANUMERIC(240, "Alphanumeric"),
    KATAKANA(241, "Katakana"),
    HIRAGANA(242, "Hiragana"),
    FULL_WIDTH(243, "Full Width"),
    HALF_WIDTH(244, "Half Width"),
    ROMAN_CHARACTERS(245, "Roman Characters"),
    ALL_CANDIDATES(256, "All Candidates"),
    PREVIOUS_CANDIDATE(257, "Previous Candidate"),
    CODE_INPUT(258, "Code Input"),
    JAPANESE_KATAKANA(259, "Japanese Katakana"),
    JAPANESE_HIRAGANA(260, "Japanese Hiragana"),
    JAPANESE_ROMAN(261, "Japanese Roman"),
    KANA_LOCK(262, "Kana Lock"),
    INPUT_METHOD_ON_OFF(263, "Input Method On/Off"),
    CUT(65489, "Cut"),
    COPY(65485, "Copy"),
    PASTE(65487, "Paste"),
    UNDO(65483, "Undo"),
    AGAIN(65481, "Again"),
    FIND(65488, "Find"),
    PROPS(65482, "Properties"),
    STOP(65480, "Stop"),
    COMPOSE(65312, "Compose"),
    ALT_GRAPH(65406, "Alt Graph"),
    BEGIN(65368, "Begin"),
    UNDEFINED(0, "Undefined"),
    SOFTKEY_0(4096, "Softkey 0"),
    SOFTKEY_1(4097, "Softkey 1"),
    SOFTKEY_2(4098, "Softkey 2"),
    SOFTKEY_3(4099, "Softkey 3"),
    SOFTKEY_4(4100, "Softkey 4"),
    SOFTKEY_5(4101, "Softkey 5"),
    SOFTKEY_6(4102, "Softkey 6"),
    SOFTKEY_7(4103, "Softkey 7"),
    SOFTKEY_8(4104, "Softkey 8"),
    SOFTKEY_9(4105, "Softkey 9"),
    GAME_A(4106, "Game A"),
    GAME_B(4107, "Game B"),
    GAME_C(4108, "Game C"),
    GAME_D(4109, "Game D"),
    STAR(4110, "Star"),
    POUND(4111, "Pound"),
    POWER(409, "Power"),
    INFO(457, "Info"),
    COLORED_KEY_0(403, "Colored Key 0"),
    COLORED_KEY_1(404, "Colored Key 1"),
    COLORED_KEY_2(405, "Colored Key 2"),
    COLORED_KEY_3(406, "Colored Key 3"),
    EJECT_TOGGLE(414, "Eject"),
    PLAY(415, "Play"),
    RECORD(416, "Record"),
    FAST_FWD(417, "Fast Forward"),
    REWIND(412, "Rewind"),
    TRACK_PREV(424, "Previous Track"),
    TRACK_NEXT(425, "Next Track"),
    CHANNEL_UP(427, "Channel Up"),
    CHANNEL_DOWN(428, "Channel Down"),
    VOLUME_UP(447, "Volume Up"),
    VOLUME_DOWN(448, "Volume Down"),
    MUTE(449, "Mute"),
    SHORTCUT(-1, "Shortcut");

    final int code;
    final String ch;
    final String name;
    private static final Map<Integer, KeyCode> charMap;
    private static final Map<String, KeyCode> nameMap;

    private KeyCode(int n2, String string2) {
        this.code = n2;
        this.name = string2;
        this.ch = String.valueOf((char)n2);
    }

    public final String getName() {
        return this.name;
    }

    @Deprecated
    public String impl_getChar() {
        return this.ch;
    }

    @Deprecated
    public int impl_getCode() {
        return this.code;
    }

    @Deprecated
    static KeyCode impl_valueOf(int n) {
        return charMap.get(n);
    }

    public static KeyCode getKeyCode(String string) {
        return nameMap.get(string);
    }

    static {
        charMap = new HashMap<Integer, KeyCode>(KeyCode.values().length);
        nameMap = new HashMap<String, KeyCode>(KeyCode.values().length);
        for (KeyCode keyCode : KeyCode.values()) {
            charMap.put(keyCode.code, keyCode);
            nameMap.put(keyCode.name, keyCode);
        }
    }
}

