/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.image;

import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.sg.PGImageView;
import com.sun.javafx.sg.PGNode;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;

public class ImageView
extends Node {
    @Styleable(property="-fx-image", converter="com.sun.javafx.css.converters.URLConverter")
    private ObjectProperty<Image> image;
    private Image oldImage;
    private final AbstractNotifyListener platformImageChangeListener = new AbstractNotifyListener(){

        @Override
        public void invalidated(Observable observable) {
            ImageView.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
            ImageView.this.impl_geomChanged();
        }
    };
    private DoubleProperty x;
    private DoubleProperty y;
    private DoubleProperty fitWidth;
    private DoubleProperty fitHeight;
    private BooleanProperty preserveRatio;
    private BooleanProperty smooth;
    public static final boolean SMOOTH_DEFAULT = Toolkit.getToolkit().getDefaultImageSmooth();
    private ObjectProperty<Rectangle2D> viewport;
    private double destWidth;
    private double destHeight;

    public ImageView() {
    }

    public ImageView(Image image) {
        this.setImage(image);
    }

    public final void setImage(Image image) {
        this.imageProperty().set(image);
    }

    public final Image getImage() {
        return this.image == null ? null : (Image)this.image.get();
    }

    public final ObjectProperty<Image> imageProperty() {
        if (this.image == null) {
            this.image = new ObjectPropertyBase<Image>(){
                private boolean needsListeners = false;

                @Override
                public void invalidated() {
                    boolean bl;
                    Image image = (Image)this.get();
                    boolean bl2 = bl = image == null || ImageView.this.oldImage == null || ImageView.this.oldImage.getWidth() != image.getWidth() || ImageView.this.oldImage.getHeight() != image.getHeight();
                    if (this.needsListeners) {
                        ImageView.this.oldImage.impl_platformImageProperty().removeListener(ImageView.this.platformImageChangeListener.getWeakListener());
                    }
                    this.needsListeners = image != null && (image.isAnimation() || image.getProgress() < 1.0);
                    ImageView.this.oldImage = image;
                    if (this.needsListeners) {
                        image.impl_platformImageProperty().addListener(ImageView.this.platformImageChangeListener.getWeakListener());
                    }
                    if (bl) {
                        ImageView.this.impl_geomChanged();
                    }
                    ImageView.this.impl_markDirty(DirtyBits.NODE_CONTENTS);
                    ImageView.this.impl_cssPropertyInvalidated(StyleableProperties.IMAGE);
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "image";
                }
            };
        }
        return this.image;
    }

    public final void setX(double d) {
        this.xProperty().set(d);
    }

    public final double getX() {
        return this.x == null ? 0.0 : this.x.get();
    }

    public final DoubleProperty xProperty() {
        if (this.x == null) {
            this.x = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "x";
                }
            };
        }
        return this.x;
    }

    public final void setY(double d) {
        this.yProperty().set(d);
    }

    public final double getY() {
        return this.y == null ? 0.0 : this.y.get();
    }

    public final DoubleProperty yProperty() {
        if (this.y == null) {
            this.y = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_GEOMETRY);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "y";
                }
            };
        }
        return this.y;
    }

    public final void setFitWidth(double d) {
        this.fitWidthProperty().set(d);
    }

    public final double getFitWidth() {
        return this.fitWidth == null ? 0.0 : this.fitWidth.get();
    }

    public final DoubleProperty fitWidthProperty() {
        if (this.fitWidth == null) {
            this.fitWidth = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "fitWidth";
                }
            };
        }
        return this.fitWidth;
    }

    public final void setFitHeight(double d) {
        this.fitHeightProperty().set(d);
    }

    public final double getFitHeight() {
        return this.fitHeight == null ? 0.0 : this.fitHeight.get();
    }

    public final DoubleProperty fitHeightProperty() {
        if (this.fitHeight == null) {
            this.fitHeight = new DoublePropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "fitHeight";
                }
            };
        }
        return this.fitHeight;
    }

    public final void setPreserveRatio(boolean bl) {
        this.preserveRatioProperty().set(bl);
    }

    public final boolean isPreserveRatio() {
        return this.preserveRatio == null ? false : this.preserveRatio.get();
    }

    public final BooleanProperty preserveRatioProperty() {
        if (this.preserveRatio == null) {
            this.preserveRatio = new BooleanPropertyBase(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "preserveRatio";
                }
            };
        }
        return this.preserveRatio;
    }

    public final void setSmooth(boolean bl) {
        this.smoothProperty().set(bl);
    }

    public final boolean isSmooth() {
        return this.smooth == null ? SMOOTH_DEFAULT : this.smooth.get();
    }

    public final BooleanProperty smoothProperty() {
        if (this.smooth == null) {
            this.smooth = new BooleanPropertyBase(SMOOTH_DEFAULT){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_SMOOTH);
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "smooth";
                }
            };
        }
        return this.smooth;
    }

    public final void setViewport(Rectangle2D rectangle2D) {
        this.viewportProperty().set(rectangle2D);
    }

    public final Rectangle2D getViewport() {
        return this.viewport == null ? null : (Rectangle2D)this.viewport.get();
    }

    public final ObjectProperty<Rectangle2D> viewportProperty() {
        if (this.viewport == null) {
            this.viewport = new ObjectPropertyBase<Rectangle2D>(){

                @Override
                protected void invalidated() {
                    ImageView.this.impl_markDirty(DirtyBits.NODE_VIEWPORT);
                    ImageView.this.impl_geomChanged();
                }

                @Override
                public Object getBean() {
                    return ImageView.this;
                }

                @Override
                public String getName() {
                    return "viewport";
                }
            };
        }
        return this.viewport;
    }

    @Override
    @Deprecated
    protected PGNode impl_createPGNode() {
        return Toolkit.getToolkit().createPGImageView();
    }

    private PGImageView getPGImageView() {
        return (PGImageView)this.impl_getPGNode();
    }

    @Override
    @Deprecated
    public BaseBounds impl_computeGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        double d = 0.0;
        double d2 = 0.0;
        Image image = this.getImage();
        if (image != null) {
            d = image.getWidth();
            d2 = image.getHeight();
        }
        double d3 = this.getFitWidth();
        double d4 = this.getFitHeight();
        double d5 = d3;
        double d6 = d4;
        double d7 = 0.0;
        double d8 = 0.0;
        Rectangle2D rectangle2D = this.getViewport();
        if (rectangle2D != null) {
            d7 = rectangle2D.getWidth();
            d8 = rectangle2D.getHeight();
        }
        if (d7 > 0.0 && d8 > 0.0) {
            d = d7;
            d2 = d8;
        }
        if (d3 <= 0.0 && d4 <= 0.0) {
            d5 = d;
            d6 = d2;
        } else if (this.isPreserveRatio()) {
            if (d3 <= 0.0) {
                d5 = d2 > 0.0 ? d * (d4 / d2) : 0.0;
                d6 = d4;
            } else if (d4 <= 0.0) {
                d5 = d3;
                d6 = d > 0.0 ? d2 * (d3 / d) : 0.0;
            } else {
                if (d == 0.0) {
                    d = d3;
                }
                if (d2 == 0.0) {
                    d2 = d4;
                }
                double d9 = Math.min(d3 / d, d4 / d2);
                d5 = d * d9;
                d6 = d2 * d9;
            }
        } else if (this.getFitHeight() <= 0.0) {
            d6 = d2;
        } else if (this.getFitWidth() <= 0.0) {
            d5 = d;
        }
        if (d6 < 1.0) {
            d6 = 1.0;
        }
        if (d5 < 1.0) {
            d5 = 1.0;
        }
        this.destWidth = d5;
        this.destHeight = d6;
        d = d5;
        d2 = d6;
        baseBounds = baseBounds.deriveWithNewBounds((float)this.getX(), (float)this.getY(), 0.0f, (float)(this.getX() + d), (float)(this.getY() + d2), 0.0f);
        baseBounds = baseTransform.transform(baseBounds, baseBounds);
        return baseBounds;
    }

    @Override
    @Deprecated
    protected boolean impl_computeContains(double d, double d2) {
        if (this.getImage() == null) {
            return false;
        }
        double d3 = d - this.getX();
        double d4 = d2 - this.getY();
        Image image = this.getImage();
        double d5 = image.getWidth();
        double d6 = image.getHeight();
        double d7 = d5;
        double d8 = d6;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        Rectangle2D rectangle2D = this.getViewport();
        if (rectangle2D != null) {
            d9 = rectangle2D.getWidth();
            d10 = rectangle2D.getHeight();
            d11 = rectangle2D.getMinX();
            d12 = rectangle2D.getMinY();
        }
        if (d9 > 0.0 && d10 > 0.0) {
            d7 = d9;
            d8 = d10;
        }
        d3 = d11 + d3 * d7 / this.destWidth;
        d4 = d12 + d4 * d8 / this.destHeight;
        if (d3 < 0.0 || d4 < 0.0 || d3 >= d5 || d4 >= d6 || d3 < d11 || d4 < d12 || d3 >= d11 + d7 || d4 >= d12 + d8) {
            return false;
        }
        return Toolkit.getToolkit().imageContains(image.impl_getPlatformImage(), (float)d3, (float)d4);
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-image".equals(string)) {
            Image image = this.getImage();
            if (image != null) {
                Image image2 = new Image((String)object, image.getWidth(), image.getHeight(), image.isPreserveRatio(), image.isSmooth(), image.isBackgroundLoading());
                this.setImage(image2);
            } else {
                this.setImage(new Image((String)object));
            }
        } else {
            return super.impl_cssSet(string, object);
        }
        return true;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-image".equals(string)) {
            return this.image == null || !this.image.isBound();
        }
        return super.impl_cssSettable(string);
    }

    void updateViewport() {
        if (this.getImage() == null || this.getImage().impl_getPlatformImage() == null) {
            return;
        }
        Rectangle2D rectangle2D = this.getViewport();
        if (rectangle2D != null) {
            this.getPGImageView().setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), (float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight(), this.isPreserveRatio());
        } else {
            this.getPGImageView().setViewport((float)this.getFitWidth(), (float)this.getFitHeight(), 0.0f, 0.0f, 0.0f, 0.0f, this.isPreserveRatio());
        }
    }

    @Override
    @Deprecated
    public void impl_updatePG() {
        super.impl_updatePG();
        if (this.impl_isDirty(DirtyBits.NODE_GEOMETRY)) {
            PGImageView pGImageView = this.getPGImageView();
            pGImageView.setX((float)this.getX());
            pGImageView.setY((float)this.getY());
        }
        if (this.impl_isDirty(DirtyBits.NODE_SMOOTH)) {
            this.getPGImageView().setSmooth(this.isSmooth());
        }
        if (this.impl_isDirty(DirtyBits.NODE_VIEWPORT)) {
            this.updateViewport();
        }
        if (this.impl_isDirty(DirtyBits.NODE_CONTENTS)) {
            this.getPGImageView().setImage(this.getImage() != null ? this.getImage().impl_getPlatformImage() : null);
            this.updateViewport();
        }
    }

    @Override
    @Deprecated
    public Object impl_processMXNode(MXNodeAlgorithm mXNodeAlgorithm, MXNodeAlgorithmContext mXNodeAlgorithmContext) {
        return mXNodeAlgorithm.processLeafNode(this, mXNodeAlgorithmContext);
    }

    private static class StyleableProperties {
        private static final StyleableProperty IMAGE = new StyleableProperty(ImageView.class, "image");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Node.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, IMAGE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

