/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Labeled;

public class TitledPane
extends Labeled {
    private ObjectProperty<Node> content;
    private BooleanProperty expanded = new BooleanPropertyBase(true){

        @Override
        protected void invalidated() {
            this.get();
            TitledPane.this.impl_pseudoClassStateChanged(TitledPane.PSEUDO_CLASS_EXPANDED);
            TitledPane.this.impl_pseudoClassStateChanged(TitledPane.PSEUDO_CLASS_COLLAPSED);
        }

        @Override
        public Object getBean() {
            return TitledPane.this;
        }

        @Override
        public String getName() {
            return TitledPane.PSEUDO_CLASS_EXPANDED;
        }
    };
    @Styleable(property="-fx-animated", initial="true")
    private BooleanProperty animated = new SimpleBooleanProperty(this, "animated", true);
    @Styleable(property="-fx-collapsible", initial="true")
    private BooleanProperty collapsible = new SimpleBooleanProperty(this, "collapsible", true);
    private static final String DEFAULT_STYLE_CLASS = "titled-pane";
    private static final String PSEUDO_CLASS_EXPANDED = "expanded";
    private static final String PSEUDO_CLASS_COLLAPSED = "collapsed";
    private static final long EXPANDED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("expanded");
    private static final long COLLAPSED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("collapsed");

    public TitledPane() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
    }

    public TitledPane(String string, Node node) {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setText(string);
        this.setContent(node);
    }

    public final void setContent(Node node) {
        this.contentProperty().set(node);
    }

    public final Node getContent() {
        return this.content == null ? null : (Node)this.content.get();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new SimpleObjectProperty<Node>(this, "content");
        }
        return this.content;
    }

    public final void setExpanded(boolean bl) {
        this.expandedProperty().set(bl);
    }

    public final boolean isExpanded() {
        return this.expanded.get();
    }

    public final BooleanProperty expandedProperty() {
        return this.expanded;
    }

    public final void setAnimated(boolean bl) {
        this.animatedProperty().set(bl);
    }

    public final boolean isAnimated() {
        return this.animated.get();
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final void setCollapsible(boolean bl) {
        this.collapsibleProperty().set(bl);
    }

    public final boolean isCollapsible() {
        return this.collapsible.get();
    }

    public final BooleanProperty collapsibleProperty() {
        return this.collapsible;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-collapsible".equals(string)) {
            this.setCollapsible((Boolean)object);
        } else if ("-fx-animated".equals(string)) {
            this.setAnimated((Boolean)object);
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-collapsible".equals(string)) {
            return this.collapsible == null || !this.collapsible.isBound();
        }
        if ("-fx-animated".equals(string)) {
            return this.animated == null || !this.animated.isBound();
        }
        return super.impl_cssSettable(string);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.isExpanded() ? EXPANDED_PSEUDOCLASS_STATE : COLLAPSED_PSEUDOCLASS_STATE;
    }

    private static class StyleableProperties {
        private static final StyleableProperty COLLAPSIBLE = new StyleableProperty(TitledPane.class, "collapsible");
        private static final StyleableProperty ANIMATED = new StyleableProperty(TitledPane.class, "animated");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, COLLAPSIBLE, ANIMATED);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

