/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class TableColumnBuilder<S, T, B extends TableColumnBuilder<S, T, B>> {
    private int __set;
    private Callback<TableColumn<S, T>, TableCell<S, T>> cellFactory;
    private Callback<TableColumn.CellDataFeatures<S, T>, ObservableValue<T>> cellValueFactory;
    private Collection<? extends TableColumn<S, ?>> columns;
    private Comparator<T> comparator;
    private ContextMenu contextMenu;
    private boolean editable;
    private double maxWidth;
    private double minWidth;
    private EventHandler<TableColumn.CellEditEvent<S, T>> onEditCancel;
    private EventHandler<TableColumn.CellEditEvent<S, T>> onEditCommit;
    private EventHandler<TableColumn.CellEditEvent<S, T>> onEditStart;
    private double prefWidth;
    private boolean resizable;
    private boolean sortable;
    private TableColumn.SortType sortType;
    private String text;
    private boolean visible;

    protected TableColumnBuilder() {
    }

    public static <S, T> TableColumnBuilder<S, T, ?> create() {
        return new TableColumnBuilder();
    }

    private void __set(int n) {
        this.__set |= 1 << n;
    }

    public void applyTo(TableColumn<S, T> tableColumn) {
        int n = this.__set;
        while (n != 0) {
            int n2 = Integer.numberOfTrailingZeros(n);
            n &= ~(1 << n2);
            switch (n2) {
                case 0: {
                    tableColumn.setCellFactory(this.cellFactory);
                    break;
                }
                case 1: {
                    tableColumn.setCellValueFactory(this.cellValueFactory);
                    break;
                }
                case 2: {
                    tableColumn.getColumns().setAll(this.columns);
                    break;
                }
                case 3: {
                    tableColumn.setComparator(this.comparator);
                    break;
                }
                case 4: {
                    tableColumn.setContextMenu(this.contextMenu);
                    break;
                }
                case 5: {
                    tableColumn.setEditable(this.editable);
                    break;
                }
                case 6: {
                    tableColumn.setMaxWidth(this.maxWidth);
                    break;
                }
                case 7: {
                    tableColumn.setMinWidth(this.minWidth);
                    break;
                }
                case 8: {
                    tableColumn.setOnEditCancel(this.onEditCancel);
                    break;
                }
                case 9: {
                    tableColumn.setOnEditCommit(this.onEditCommit);
                    break;
                }
                case 10: {
                    tableColumn.setOnEditStart(this.onEditStart);
                    break;
                }
                case 11: {
                    tableColumn.setPrefWidth(this.prefWidth);
                    break;
                }
                case 12: {
                    tableColumn.setResizable(this.resizable);
                    break;
                }
                case 13: {
                    tableColumn.setSortable(this.sortable);
                    break;
                }
                case 14: {
                    tableColumn.setSortType(this.sortType);
                    break;
                }
                case 15: {
                    tableColumn.setText(this.text);
                    break;
                }
                case 16: {
                    tableColumn.setVisible(this.visible);
                }
            }
        }
    }

    public B cellFactory(Callback<TableColumn<S, T>, TableCell<S, T>> callback) {
        this.cellFactory = callback;
        this.__set(0);
        return (B)this;
    }

    public B cellValueFactory(Callback<TableColumn.CellDataFeatures<S, T>, ObservableValue<T>> callback) {
        this.cellValueFactory = callback;
        this.__set(1);
        return (B)this;
    }

    public B columns(Collection<? extends TableColumn<S, ?>> collection) {
        this.columns = collection;
        this.__set(2);
        return (B)this;
    }

    public B columns(TableColumn<S, ?> ... tableColumnArray) {
        return this.columns(Arrays.asList(tableColumnArray));
    }

    public B comparator(Comparator<T> comparator) {
        this.comparator = comparator;
        this.__set(3);
        return (B)this;
    }

    public B contextMenu(ContextMenu contextMenu) {
        this.contextMenu = contextMenu;
        this.__set(4);
        return (B)this;
    }

    public B editable(boolean bl) {
        this.editable = bl;
        this.__set(5);
        return (B)this;
    }

    public B maxWidth(double d) {
        this.maxWidth = d;
        this.__set(6);
        return (B)this;
    }

    public B minWidth(double d) {
        this.minWidth = d;
        this.__set(7);
        return (B)this;
    }

    public B onEditCancel(EventHandler<TableColumn.CellEditEvent<S, T>> eventHandler) {
        this.onEditCancel = eventHandler;
        this.__set(8);
        return (B)this;
    }

    public B onEditCommit(EventHandler<TableColumn.CellEditEvent<S, T>> eventHandler) {
        this.onEditCommit = eventHandler;
        this.__set(9);
        return (B)this;
    }

    public B onEditStart(EventHandler<TableColumn.CellEditEvent<S, T>> eventHandler) {
        this.onEditStart = eventHandler;
        this.__set(10);
        return (B)this;
    }

    public B prefWidth(double d) {
        this.prefWidth = d;
        this.__set(11);
        return (B)this;
    }

    public B resizable(boolean bl) {
        this.resizable = bl;
        this.__set(12);
        return (B)this;
    }

    public B sortable(boolean bl) {
        this.sortable = bl;
        this.__set(13);
        return (B)this;
    }

    public B sortType(TableColumn.SortType sortType) {
        this.sortType = sortType;
        this.__set(14);
        return (B)this;
    }

    public B text(String string) {
        this.text = string;
        this.__set(15);
        return (B)this;
    }

    public B visible(boolean bl) {
        this.visible = bl;
        this.__set(16);
        return (B)this;
    }

    public TableColumn<S, T> build() {
        TableColumn tableColumn = new TableColumn();
        this.applyTo(tableColumn);
        return tableColumn;
    }
}

