/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.VPos;
import javafx.scene.control.Control;

public class Separator
extends Control {
    @Styleable(property="-fx-orientation", initial="vertical")
    private ObjectProperty<Orientation> orientation = new ObjectPropertyBase<Orientation>(Orientation.HORIZONTAL){

        @Override
        public void set(Orientation orientation) {
            super.set(orientation);
            Separator.this.impl_cssPropertyInvalidated(StyleableProperties.ORIENTATION);
        }

        @Override
        protected void invalidated() {
            Separator.this.impl_cssPropertyInvalidated(StyleableProperties.ORIENTATION);
            Separator.this.impl_pseudoClassStateChanged(Separator.PSEUDO_CLASS_VERTICAL);
            Separator.this.impl_pseudoClassStateChanged(Separator.PSEUDO_CLASS_HORIZONTAL);
        }

        @Override
        public Object getBean() {
            return Separator.this;
        }

        @Override
        public String getName() {
            return "orientation";
        }
    };
    @Styleable(property="-fx-halignment", initial="center")
    private ObjectProperty<HPos> halignment;
    @Styleable(property="-fx-valignment", initial="center")
    private ObjectProperty<VPos> valignment;
    private static final String DEFAULT_STYLE_CLASS = "separator";
    private static final String PSEUDO_CLASS_VERTICAL = "vertical";
    private static final String PSEUDO_CLASS_HORIZONTAL = "horizontal";
    private static final long VERTICAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("vertical");
    private static final long HORIZONTAL_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("horizontal");

    public Separator() {
        this.getStyleClass().setAll((String[])new String[]{DEFAULT_STYLE_CLASS});
        this.setFocusTraversable(false);
    }

    public Separator(Orientation orientation) {
        this();
        this.setOrientation(orientation);
    }

    public final void setOrientation(Orientation orientation) {
        this.orientation.set(orientation);
    }

    public final Orientation getOrientation() {
        return (Orientation)((Object)this.orientation.get());
    }

    public final ObjectProperty<Orientation> orientationProperty() {
        return this.orientation;
    }

    public final void setHalignment(HPos hPos) {
        this.halignmentProperty().set(hPos);
    }

    public final HPos getHalignment() {
        return this.halignment == null ? HPos.CENTER : (HPos)((Object)this.halignment.get());
    }

    public final ObjectProperty<HPos> halignmentProperty() {
        if (this.halignment == null) {
            this.halignment = new CSSProperty<HPos>(this, "halignment", (Object)HPos.CENTER, StyleableProperties.HPOS);
        }
        return this.halignment;
    }

    public final void setValignment(VPos vPos) {
        this.valignmentProperty().set(vPos);
    }

    public final VPos getValignment() {
        return this.valignment == null ? VPos.CENTER : (VPos)((Object)this.valignment.get());
    }

    public final ObjectProperty<VPos> valignmentProperty() {
        if (this.valignment == null) {
            this.valignment = new CSSProperty<VPos>(this, "valignment", (Object)VPos.CENTER, StyleableProperties.VPOS);
        }
        return this.valignment;
    }

    @Override
    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-orientation".equals(string)) {
            this.setOrientation((Orientation)((Object)object));
        } else if ("-fx-halignment".equals(string)) {
            this.setHalignment((HPos)((Object)object));
        } else if ("-fx-valignment".equals(string)) {
            this.setValignment((VPos)((Object)object));
        }
        return super.impl_cssSet(string, object);
    }

    @Override
    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-orientation".equals(string)) {
            return this.orientation == null || !this.orientation.isBound();
        }
        if ("-fx-halignment".equals(string)) {
            return this.halignment == null || !this.halignment.isBound();
        }
        if ("-fx-valignment".equals(string)) {
            return this.valignment == null || !this.valignment.isBound();
        }
        return super.impl_cssSettable(string);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        return l |= this.getOrientation() == Orientation.VERTICAL ? VERTICAL_PSEUDOCLASS_STATE : HORIZONTAL_PSEUDOCLASS_STATE;
    }

    private final class CSSProperty<T>
    extends SimpleObjectProperty<T> {
        private StyleableProperty property;

        private CSSProperty(Object object, String string, T t, StyleableProperty styleableProperty) {
            super(object, string, t);
            this.property = styleableProperty;
        }

        @Override
        public void set(T t) {
            super.set(t);
            Separator.this.impl_cssPropertyInvalidated(StyleableProperties.ORIENTATION);
        }

        @Override
        public void invalidated() {
            Separator.this.impl_cssPropertyInvalidated(this.property);
        }
    }

    private static class StyleableProperties {
        private static final StyleableProperty ORIENTATION = new StyleableProperty(Separator.class, "orientation");
        private static final StyleableProperty HPOS = new StyleableProperty(Separator.class, "halignment");
        private static final StyleableProperty VPOS = new StyleableProperty(Separator.class, "valignment");
        private static final List<StyleableProperty> STYLEABLES;
        private static final int[] bitIndices;

        private StyleableProperties() {
        }

        static {
            ArrayList<StyleableProperty> arrayList = new ArrayList<StyleableProperty>(Control.impl_CSS_STYLEABLES());
            Collections.addAll(arrayList, ORIENTATION, HPOS, VPOS);
            STYLEABLES = Collections.unmodifiableList(arrayList);
            bitIndices = new int[StyleableProperty.getMaxIndex()];
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }
}

