/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Separator;
import javafx.scene.control.SingleSelectionModel;

public class ChoiceBox<T>
extends Control {
    private ObjectProperty<SingleSelectionModel<T>> selectionModel = new SimpleObjectProperty<SingleSelectionModel<T>>(this, "selectionModel");
    private ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(){

        @Override
        protected void invalidated() {
            ChoiceBox.this.impl_pseudoClassStateChanged("showing");
        }

        @Override
        public Object getBean() {
            return ChoiceBox.this;
        }

        @Override
        public String getName() {
            return "showing";
        }
    };
    private ObjectProperty<ObservableList<T>> items = new ObjectPropertyBase<ObservableList<T>>(){
        ObservableList<T> old;

        @Override
        protected void invalidated() {
            ObservableList observableList = (ObservableList)this.get();
            if (this.old != observableList) {
                SingleSelectionModel singleSelectionModel;
                if (this.old != null) {
                    this.old.removeListener(ChoiceBox.this.itemsListener);
                }
                if (observableList != null) {
                    observableList.addListener(ChoiceBox.this.itemsListener);
                }
                if ((singleSelectionModel = ChoiceBox.this.getSelectionModel()) != null) {
                    if (observableList != null && observableList.isEmpty()) {
                        singleSelectionModel.setSelectedIndex(-1);
                    } else if (singleSelectionModel.getSelectedIndex() == -1 && singleSelectionModel.getSelectedItem() != null) {
                        int n = ChoiceBox.this.getItems().indexOf(singleSelectionModel.getSelectedItem());
                        if (n != -1) {
                            singleSelectionModel.setSelectedIndex(n);
                        }
                    } else {
                        singleSelectionModel.clearSelection();
                    }
                }
                this.old = observableList;
            }
        }

        @Override
        public Object getBean() {
            return ChoiceBox.this;
        }

        @Override
        public String getName() {
            return "items";
        }
    };
    private final ListChangeListener<T> itemsListener = new ListChangeListener<T>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends T> change) {
            SingleSelectionModel singleSelectionModel = ChoiceBox.this.getSelectionModel();
            if (singleSelectionModel != null) {
                Object t = singleSelectionModel.getSelectedItem();
                while (change.next()) {
                    if (t == null || !change.getRemoved().contains(t)) continue;
                    singleSelectionModel.clearSelection();
                    break;
                }
            }
        }
    };
    private static final long SHOWING_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("showing");

    public ChoiceBox() {
        this(FXCollections.observableArrayList());
    }

    public ChoiceBox(ObservableList<T> observableList) {
        this.getStyleClass().setAll((String[])new String[]{"choice-box"});
        this.setItems(observableList);
        this.setSelectionModel(new ChoiceBoxSelectionModel(this));
    }

    public final void setSelectionModel(SingleSelectionModel<T> singleSelectionModel) {
        this.selectionModel.set(singleSelectionModel);
    }

    public final SingleSelectionModel<T> getSelectionModel() {
        return (SingleSelectionModel)this.selectionModel.get();
    }

    public final ObjectProperty<SingleSelectionModel<T>> selectionModelProperty() {
        return this.selectionModel;
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    public final void setItems(ObservableList<T> observableList) {
        this.items.set(observableList);
    }

    public final ObservableList<T> getItems() {
        return (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        return this.items;
    }

    public void show() {
        if (!this.isDisabled()) {
            this.showing.set(true);
        }
    }

    public void hide() {
        this.showing.set(false);
    }

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isShowing()) {
            l |= SHOWING_PSEUDOCLASS_STATE;
        }
        return l;
    }

    static class ChoiceBoxSelectionModel<T>
    extends SingleSelectionModel<T> {
        private final ChoiceBox<T> choiceBox;

        public ChoiceBoxSelectionModel(ChoiceBox<T> choiceBox) {
            if (choiceBox == null) {
                throw new NullPointerException("ChoiceBox can not be null");
            }
            this.choiceBox = choiceBox;
            final ListChangeListener listChangeListener = new ListChangeListener<T>(){

                @Override
                public void onChanged(ListChangeListener.Change<? extends T> change) {
                    int n;
                    if (ChoiceBoxSelectionModel.this.choiceBox.getItems() == null || ChoiceBoxSelectionModel.this.choiceBox.getItems().isEmpty()) {
                        ChoiceBoxSelectionModel.this.setSelectedIndex(-1);
                    } else if (ChoiceBoxSelectionModel.this.getSelectedIndex() == -1 && ChoiceBoxSelectionModel.this.getSelectedItem() != null && (n = ChoiceBoxSelectionModel.this.choiceBox.getItems().indexOf(ChoiceBoxSelectionModel.this.getSelectedItem())) != -1) {
                        ChoiceBoxSelectionModel.this.setSelectedIndex(n);
                    }
                }
            };
            if (this.choiceBox.getItems() != null) {
                this.choiceBox.getItems().addListener(listChangeListener);
            }
            ChangeListener changeListener = new ChangeListener<ObservableList<T>>(){

                @Override
                public void changed(ObservableValue<? extends ObservableList<T>> observableValue, ObservableList<T> observableList, ObservableList<T> observableList2) {
                    int n;
                    if (observableList != null) {
                        observableList.removeListener(listChangeListener);
                    }
                    if (observableList2 != null) {
                        observableList2.addListener(listChangeListener);
                    }
                    ChoiceBoxSelectionModel.this.setSelectedIndex(-1);
                    if (ChoiceBoxSelectionModel.this.getSelectedItem() != null && (n = ChoiceBoxSelectionModel.this.choiceBox.getItems().indexOf(ChoiceBoxSelectionModel.this.getSelectedItem())) != -1) {
                        ChoiceBoxSelectionModel.this.setSelectedIndex(n);
                    }
                }
            };
            this.choiceBox.itemsProperty().addListener(changeListener);
        }

        @Override
        protected T getModelItem(int n) {
            ObservableList<T> observableList = this.choiceBox.getItems();
            if (observableList == null) {
                return null;
            }
            if (n < 0 || n >= observableList.size()) {
                return null;
            }
            return (T)observableList.get(n);
        }

        @Override
        protected int getItemCount() {
            ObservableList<T> observableList = this.choiceBox.getItems();
            return observableList == null ? 0 : observableList.size();
        }

        @Override
        public void select(int n) {
            int n2 = this.getItemCount();
            if (n2 == 0 || n < 0 || n >= n2) {
                return;
            }
            T t = this.getModelItem(n);
            if (t instanceof Separator) {
                this.select(++n);
            } else {
                super.select(n);
            }
            if (this.choiceBox.isShowing()) {
                this.choiceBox.hide();
            }
        }
    }
}

