/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.Logging;
import com.sun.javafx.TempState;
import com.sun.javafx.Utils;
import com.sun.javafx.beans.event.AbstractNotifyListener;
import com.sun.javafx.binding.ExpressionHelper;
import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.collections.UnmodifiableListSet;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.StyleHelper;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.Styleable;
import com.sun.javafx.css.StyleableProperty;
import com.sun.javafx.effect.EffectDirtyBits;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.PickRay;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.NoninvertibleTransformException;
import com.sun.javafx.jmx.MXNodeAlgorithm;
import com.sun.javafx.jmx.MXNodeAlgorithmContext;
import com.sun.javafx.logging.PlatformLogger;
import com.sun.javafx.perf.PerformanceTracker;
import com.sun.javafx.scene.BoundsAccessor;
import com.sun.javafx.scene.CSSFlags;
import com.sun.javafx.scene.DirtyBits;
import com.sun.javafx.scene.EventHandlerProperties;
import com.sun.javafx.scene.NodeEventDispatcher;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.sg.PGNode;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.property.StringPropertyBase;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.CacheHint;
import javafx.scene.Cursor;
import javafx.scene.DepthTest;
import javafx.scene.Group;
import javafx.scene.ImageCursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.Blend;
import javafx.scene.effect.BlendMode;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.InputEvent;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;

public abstract class Node
implements EventTarget {
    private int dirtyBits;
    private static final Object USER_DATA_KEY;
    private ObservableMap<Object, Object> properties;
    private ReadOnlyObjectWrapper<Parent> parent;
    private final InvalidationListener parentDisabledChangedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            Node.this.updateDisabled();
        }
    };
    private final InvalidationListener parentTreeVisibleChangedListener = new InvalidationListener(){

        @Override
        public void invalidated(Observable observable) {
            Node.this.updateTreeVisible();
        }
    };
    private ReadOnlyObjectWrapper<Scene> scene;
    private StringProperty id;
    private ObservableList<String> styleClass = new TrackableObservableList<String>(){

        @Override
        protected void onChanged(ListChangeListener.Change<String> change) {
            Node.this.impl_reapplyCSS();
        }

        @Override
        public String toString() {
            if (this.size() == 0) {
                return "";
            }
            if (this.size() == 1) {
                return (String)this.get(0);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < this.size(); ++i) {
                stringBuilder.append((String)this.get(i));
                if (i + 1 >= this.size()) continue;
                stringBuilder.append(' ');
            }
            return stringBuilder.toString();
        }
    };
    private StringProperty style;
    @Styleable(property="visibility", converter="com.sun.javafx.css.converters.StringConverter", inherits=true, initial="visible")
    private BooleanProperty visible;
    @Styleable(property="-fx-opacity", initial="1.0")
    private DoubleProperty opacity;
    @Styleable(property="-fx-blend-mode", initial="null")
    private ObjectProperty<BlendMode> blendMode;
    private boolean derivedDepthTest = true;
    private BooleanProperty pickOnBounds;
    private ReadOnlyBooleanWrapper disabled;
    private Node clipParent;
    private PGNode peer;
    private BooleanProperty managed;
    private DoubleProperty layoutX;
    private DoubleProperty layoutY;
    private LazyBoundsProperty layoutBounds = new LazyBoundsProperty(){

        @Override
        protected Bounds computeBounds() {
            return Node.this.impl_computeLayoutBounds();
        }

        @Override
        public Object getBean() {
            return Node.this;
        }

        @Override
        public String getName() {
            return "layoutBounds";
        }
    };
    private final Affine3D localToParentTx = new Affine3D();
    private boolean transformDirty = true;
    private BaseBounds txBounds = new RectBounds();
    private BaseBounds geomBounds = new RectBounds();
    boolean boundsChanged = true;
    private boolean geomBoundsInvalid = true;
    private boolean txBoundsInvalid = true;
    private static final double EPSILON_ABSOLUTE = 1.0E-5;
    private NodeTransformation nodeTransformation;
    private static final double DEFAULT_TRANSLATE_X = 0.0;
    private static final double DEFAULT_TRANSLATE_Y = 0.0;
    private static final double DEFAULT_TRANSLATE_Z = 0.0;
    private static final double DEFAULT_SCALE_X = 1.0;
    private static final double DEFAULT_SCALE_Y = 1.0;
    private static final double DEFAULT_SCALE_Z = 1.0;
    private static final double DEFAULT_ROTATE = 0.0;
    private static final Point3D DEFAULT_ROTATION_AXIS;
    private EventHandlerProperties eventHandlerProperties;
    private MiscProperties miscProperties;
    private static final boolean DEFAULT_CACHE = false;
    private static final CacheHint DEFAULT_CACHE_HINT;
    private static final Node DEFAULT_CLIP;
    private static final Cursor DEFAULT_CURSOR;
    private static final DepthTest DEFAULT_DEPTH_TEST;
    private static final boolean DEFAULT_DISABLE = false;
    private static final Effect DEFAULT_EFFECT;
    private static final InputMethodRequests DEFAULT_INPUT_METHOD_REQUESTS;
    private static final boolean DEFAULT_MOUSE_TRANSPARENT = false;
    private ReadOnlyBooleanWrapper hover;
    private ReadOnlyBooleanWrapper pressed;
    private ReadOnlyBooleanWrapper focused;
    @Styleable(property="-fx-focus-traversable", initial="false")
    private BooleanProperty focusTraversable;
    private boolean treeVisible;
    private TreeVisiblePropertyReadOnly treeVisibleRO;
    private boolean canReceiveFocus = false;
    @Deprecated
    private BooleanProperty impl_showMnemonics;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private NodeEventDispatcher internalEventDispatcher;
    private EventDispatcher preprocessMouseEventDispatcher;
    private BitSet propertyBits = null;
    private boolean propertySetFromCSS = false;
    CSSFlags cssFlag = CSSFlags.CLEAN;
    private Reference<StyleHelper> styleHelperRef;
    private Reference<StyleHelper.StyleCacheKey> styleCacheKeyRef;
    private static final long HOVER_PSEUDOCLASS_STATE;
    private static final long PRESSED_PSEUDOCLASS_STATE;
    private static final long DISABLED_PSEUDOCLASS_STATE;
    private static final long FOCUSED_PSEUDOCLASS_STATE;
    private static final long SHOW_MNEMONICS_PSEUDOCLASS_STATE;
    private static final BoundsAccessor boundsAccessor;

    @Deprecated
    protected void impl_markDirty(DirtyBits dirtyBits) {
        if (this.getScene() != null && this.impl_isDirtyEmpty()) {
            this.getScene().addToDirtyList(this);
        }
        this.impl_setDirty(dirtyBits);
    }

    @Deprecated
    protected boolean impl_isDirty(DirtyBits dirtyBits) {
        return ((long)this.dirtyBits & dirtyBits.getMask()) != 0L;
    }

    @Deprecated
    private void impl_setDirty(DirtyBits dirtyBits) {
        this.dirtyBits = (int)((long)this.dirtyBits | dirtyBits.getMask());
    }

    @Deprecated
    protected void impl_clearDirty(DirtyBits dirtyBits) {
        this.dirtyBits = (int)((long)this.dirtyBits & (dirtyBits.getMask() ^ 0xFFFFFFFFFFFFFFFFL));
    }

    private void setDirty() {
        this.dirtyBits = -1;
    }

    private void clearDirty() {
        this.dirtyBits = 0;
    }

    @Deprecated
    protected boolean impl_isDirtyEmpty() {
        return this.dirtyBits == 0;
    }

    @Deprecated
    public void impl_syncPGNodeDirect() {
        if (!this.impl_isDirtyEmpty()) {
            boolean bl = this.impl_isDirty(DirtyBits.NODE_TRANSFORM);
            this.impl_clearDirty(DirtyBits.NODE_TRANSFORM);
            boolean bl2 = this.impl_isDirty(DirtyBits.NODE_BOUNDS);
            this.impl_clearDirty(DirtyBits.NODE_BOUNDS);
            this.impl_updatePG();
            this.clearDirty();
            if (bl) {
                this.impl_setDirty(DirtyBits.NODE_TRANSFORM);
            }
            if (bl2) {
                this.impl_setDirty(DirtyBits.NODE_BOUNDS);
            }
        }
    }

    @Deprecated
    public final void impl_syncPGNode() {
        if (!this.impl_isDirtyEmpty()) {
            this.impl_updatePG();
            this.clearDirty();
        }
    }

    @Deprecated
    public void impl_updatePG() {
        PGNode pGNode = this.impl_getPGNode();
        TempState tempState = null;
        if (this.impl_isDirty(DirtyBits.NODE_TRANSFORM)) {
            tempState = TempState.getInstance();
            this.updateLocalToParentTransform();
            pGNode.setTransformMatrix(this.localToParentTx);
            tempState.bounds = this.getTransformedBounds(tempState.bounds, BaseTransform.IDENTITY_TRANSFORM);
            pGNode.setTransformedBounds(tempState.bounds);
        }
        if (this.impl_isDirty(DirtyBits.NODE_BOUNDS)) {
            if (tempState == null) {
                tempState = TempState.getInstance();
            }
            tempState.bounds = this.getGeomBounds(tempState.bounds, BaseTransform.IDENTITY_TRANSFORM);
            pGNode.setContentBounds(tempState.bounds);
            if (!this.impl_isDirty(DirtyBits.NODE_TRANSFORM)) {
                tempState.bounds = this.getTransformedBounds(tempState.bounds, BaseTransform.IDENTITY_TRANSFORM);
                pGNode.setTransformedBounds(tempState.bounds);
            }
        }
        if (this.impl_isDirty(DirtyBits.NODE_OPACITY)) {
            pGNode.setOpacity((float)Utils.clamp(0.0, this.getOpacity(), 1.0));
        }
        if (this.impl_isDirty(DirtyBits.NODE_CACHE)) {
            pGNode.setCachedAsBitmap(this.isCache(), this.toPGCacheHint(this.getCacheHint()));
        }
        if (this.impl_isDirty(DirtyBits.NODE_CLIP)) {
            pGNode.setClipNode(this.getClip() != null ? this.getClip().impl_getPGNode() : null);
        }
        if (this.impl_isDirty(DirtyBits.EFFECT_EFFECT) && this.getEffect() != null) {
            this.getEffect().impl_sync();
            pGNode.effectChanged();
        }
        if (this.impl_isDirty(DirtyBits.NODE_EFFECT)) {
            pGNode.setEffect(this.getEffect() != null ? this.getEffect().impl_getImpl() : null);
        }
        if (this.impl_isDirty(DirtyBits.NODE_VISIBLE)) {
            pGNode.setVisible(this.isVisible());
        }
        if (this.impl_isDirty(DirtyBits.NODE_DEPTH_TEST)) {
            pGNode.setDepthTest(this.isDerivedDepthTest());
        }
        if (this.impl_isDirty(DirtyBits.NODE_BLENDMODE)) {
            BlendMode blendMode = this.getBlendMode();
            pGNode.setNodeBlendMode(blendMode == null ? null : Blend.impl_getToolkitMode(blendMode));
        }
    }

    public final ObservableMap<Object, Object> getProperties() {
        if (this.properties == null) {
            this.properties = FXCollections.observableMap(new HashMap());
        }
        return this.properties;
    }

    public boolean hasProperties() {
        return this.properties != null;
    }

    public void setUserData(Object object) {
        this.getProperties().put(USER_DATA_KEY, object);
    }

    public Object getUserData() {
        return this.getProperties().get(USER_DATA_KEY);
    }

    final void setParent(Parent parent) {
        this.parentPropertyImpl().set(parent);
    }

    public final Parent getParent() {
        return this.parent == null ? null : (Parent)this.parent.get();
    }

    public final ReadOnlyObjectProperty<Parent> parentProperty() {
        return this.parentPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Parent> parentPropertyImpl() {
        if (this.parent == null) {
            this.parent = new ReadOnlyObjectWrapper<Parent>(){
                private Parent oldParent;

                @Override
                protected void invalidated() {
                    if (this.oldParent != null) {
                        this.oldParent.disabledProperty().removeListener(Node.this.parentDisabledChangedListener);
                        this.oldParent.treeVisibleProperty().removeListener(Node.this.parentTreeVisibleChangedListener);
                    }
                    Node.this.updateDisabled();
                    Node.this.computeDerivedDepthTest();
                    Parent parent = (Parent)this.get();
                    if (parent != null) {
                        parent.disabledProperty().addListener(Node.this.parentDisabledChangedListener);
                        parent.treeVisibleProperty().addListener(Node.this.parentTreeVisibleChangedListener);
                        Node.this.impl_reapplyCSS();
                    }
                    Node.this.updateTreeVisible();
                    this.oldParent = parent;
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "parent";
                }
            };
        }
        return this.parent;
    }

    final void setScene(Scene scene) {
        this.scenePropertyImpl().set(scene);
    }

    public final Scene getScene() {
        return this.scene == null ? null : (Scene)this.scene.get();
    }

    @Deprecated
    void impl_sceneChanged(Scene scene) {
    }

    public final ReadOnlyObjectProperty<Scene> sceneProperty() {
        return this.scenePropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyObjectWrapper<Scene> scenePropertyImpl() {
        if (this.scene == null) {
            this.scene = new ReadOnlyObjectWrapper<Scene>(){
                private Scene oldScene;

                @Override
                protected void invalidated() {
                    Scene scene = (Scene)this.get();
                    if (this.oldScene != scene) {
                        if (this.oldScene != null) {
                            this.oldScene.removeFromDirtyList(Node.this);
                        }
                        Node.this.impl_reapplyCSS();
                        if (scene != null && !Node.this.impl_isDirtyEmpty()) {
                            scene.addToDirtyList(Node.this);
                        }
                    }
                    if (Node.this.getClip() != null) {
                        Node.this.getClip().setScene(scene);
                    }
                    Node.this.updateCanReceiveFocus();
                    if (Node.this.isFocusTraversable()) {
                        if (this.oldScene != null) {
                            this.oldScene.unregisterTraversable(Node.this);
                        }
                        if (scene != null) {
                            scene.registerTraversable(Node.this);
                        }
                    }
                    Node.this.focusSetDirty(this.oldScene);
                    Node.this.focusSetDirty(scene);
                    Node.this.impl_sceneChanged(this.oldScene);
                    this.oldScene = scene;
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "scene";
                }
            };
        }
        return this.scene;
    }

    public final void setId(String string) {
        this.idProperty().set(string);
    }

    public final String getId() {
        return this.id == null ? null : (String)this.id.get();
    }

    public final StringProperty idProperty() {
        if (this.id == null) {
            this.id = new StringPropertyBase(){

                @Override
                protected void invalidated() {
                    Node.this.impl_reapplyCSS();
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "id";
                }
            };
        }
        return this.id;
    }

    public final ObservableList<String> getStyleClass() {
        return this.styleClass;
    }

    public final void setStyle(String string) {
        this.styleProperty().set(string);
    }

    public final String getStyle() {
        return this.style == null ? "" : (String)this.style.get();
    }

    public final StringProperty styleProperty() {
        if (this.style == null) {
            this.style = new StringPropertyBase(""){

                @Override
                public void set(String string) {
                    super.set(string != null ? string : "");
                }

                @Override
                protected void invalidated() {
                    Node.this.impl_reapplyCSS();
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "style";
                }
            };
        }
        return this.style;
    }

    public final void setVisible(boolean bl) {
        this.visibleProperty().set(bl);
    }

    public final boolean isVisible() {
        return this.visible == null ? true : this.visible.get();
    }

    public final BooleanProperty visibleProperty() {
        if (this.visible == null) {
            this.visible = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    Node.this.impl_cssPropertyInvalidated(StyleableProperties.VISIBILITY);
                    Node.this.impl_markDirty(DirtyBits.NODE_VISIBLE);
                    Node.this.impl_geomChanged();
                    Node.this.updateTreeVisible();
                    if (Node.this.getParent() != null) {
                        Node.this.getParent().childVisibilityChanged(Node.this);
                    }
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "visible";
                }
            };
        }
        return this.visible;
    }

    public final void setCursor(Cursor cursor) {
        this.cursorProperty().set(cursor);
    }

    public final Cursor getCursor() {
        return this.miscProperties == null ? DEFAULT_CURSOR : this.miscProperties.getCursor();
    }

    public final ObjectProperty<Cursor> cursorProperty() {
        return this.getMiscProperties().cursorProperty();
    }

    public final void setOpacity(double d) {
        this.opacityProperty().set(d);
    }

    public final double getOpacity() {
        return this.opacity == null ? 1.0 : this.opacity.get();
    }

    public final DoubleProperty opacityProperty() {
        if (this.opacity == null) {
            this.opacity = new DoublePropertyBase(1.0){

                @Override
                public void invalidated() {
                    Node.this.impl_cssPropertyInvalidated(StyleableProperties.OPACITY);
                    Node.this.impl_markDirty(DirtyBits.NODE_OPACITY);
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "opacity";
                }
            };
        }
        return this.opacity;
    }

    public final void setBlendMode(BlendMode blendMode) {
        this.blendModeProperty().set(blendMode);
    }

    public final BlendMode getBlendMode() {
        return this.blendMode == null ? null : (BlendMode)((Object)this.blendMode.get());
    }

    public final ObjectProperty<BlendMode> blendModeProperty() {
        if (this.blendMode == null) {
            this.blendMode = new ObjectPropertyBase<BlendMode>(null){

                @Override
                public void invalidated() {
                    Node.this.impl_markDirty(DirtyBits.NODE_BLENDMODE);
                    Node.this.impl_cssPropertyInvalidated(StyleableProperties.BLEND_MODE);
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "blendMode";
                }
            };
        }
        return this.blendMode;
    }

    public final void setClip(Node node) {
        this.clipProperty().set(node);
    }

    public final Node getClip() {
        return this.miscProperties == null ? DEFAULT_CLIP : this.miscProperties.getClip();
    }

    public final ObjectProperty<Node> clipProperty() {
        return this.getMiscProperties().clipProperty();
    }

    private PGNode.CacheHint toPGCacheHint(CacheHint cacheHint) {
        if (cacheHint == CacheHint.DEFAULT) {
            return PGNode.CacheHint.DEFAULT;
        }
        if (cacheHint == CacheHint.SCALE) {
            return PGNode.CacheHint.SCALE;
        }
        if (cacheHint == CacheHint.ROTATE) {
            return PGNode.CacheHint.ROTATE;
        }
        if (cacheHint == CacheHint.SCALE_AND_ROTATE) {
            return PGNode.CacheHint.SCALE_AND_ROTATE;
        }
        if (cacheHint == CacheHint.SPEED) {
            return PGNode.CacheHint.SCALE_AND_ROTATE;
        }
        if (cacheHint == CacheHint.QUALITY) {
            return PGNode.CacheHint.DEFAULT;
        }
        return PGNode.CacheHint.DEFAULT;
    }

    public final void setCache(boolean bl) {
        this.cacheProperty().set(bl);
    }

    public final boolean isCache() {
        return this.miscProperties == null ? false : this.miscProperties.isCache();
    }

    public final BooleanProperty cacheProperty() {
        return this.getMiscProperties().cacheProperty();
    }

    public final void setCacheHint(CacheHint cacheHint) {
        this.cacheHintProperty().set(cacheHint);
    }

    public final CacheHint getCacheHint() {
        return this.miscProperties == null ? DEFAULT_CACHE_HINT : this.miscProperties.getCacheHint();
    }

    public final ObjectProperty<CacheHint> cacheHintProperty() {
        return this.getMiscProperties().cacheHintProperty();
    }

    public final void setEffect(Effect effect) {
        this.effectProperty().set(effect);
    }

    public final Effect getEffect() {
        return this.miscProperties == null ? DEFAULT_EFFECT : this.miscProperties.getEffect();
    }

    public final ObjectProperty<Effect> effectProperty() {
        return this.getMiscProperties().effectProperty();
    }

    public final void setDepthTest(DepthTest depthTest) {
        this.depthTestProperty().set(depthTest);
    }

    public final DepthTest getDepthTest() {
        return this.miscProperties == null ? DEFAULT_DEPTH_TEST : this.miscProperties.getDepthTest();
    }

    public final ObjectProperty<DepthTest> depthTestProperty() {
        return this.getMiscProperties().depthTestProperty();
    }

    void computeDerivedDepthTest() {
        boolean bl = this.getDepthTest() == DepthTest.INHERIT ? (this.getParent() != null ? this.getParent().isDerivedDepthTest() : true) : this.getDepthTest() == DepthTest.ENABLE;
        if (this.isDerivedDepthTest() != bl) {
            this.impl_markDirty(DirtyBits.NODE_DEPTH_TEST);
            this.setDerivedDepthTest(bl);
        }
    }

    void setDerivedDepthTest(boolean bl) {
        this.derivedDepthTest = bl;
    }

    boolean isDerivedDepthTest() {
        return this.derivedDepthTest;
    }

    public final void setDisable(boolean bl) {
        this.disableProperty().set(bl);
    }

    public final boolean isDisable() {
        return this.miscProperties == null ? false : this.miscProperties.isDisable();
    }

    public final BooleanProperty disableProperty() {
        return this.getMiscProperties().disableProperty();
    }

    public final void setPickOnBounds(boolean bl) {
        this.pickOnBoundsProperty().set(bl);
    }

    public final boolean isPickOnBounds() {
        return this.pickOnBounds == null ? false : this.pickOnBounds.get();
    }

    public final BooleanProperty pickOnBoundsProperty() {
        if (this.pickOnBounds == null) {
            this.pickOnBounds = new SimpleBooleanProperty(this, "pickOnBounds");
        }
        return this.pickOnBounds;
    }

    protected final void setDisabled(boolean bl) {
        this.disabledPropertyImpl().set(bl);
    }

    public final boolean isDisabled() {
        return this.disabled == null ? false : this.disabled.get();
    }

    public final ReadOnlyBooleanProperty disabledProperty() {
        return this.disabledPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper disabledPropertyImpl() {
        if (this.disabled == null) {
            this.disabled = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    Node.this.impl_pseudoClassStateChanged("disabled");
                    Node.this.updateCanReceiveFocus();
                    Node.this.focusSetDirty(Node.this.getScene());
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "disabled";
                }
            };
        }
        return this.disabled;
    }

    private void updateDisabled() {
        this.setDisabled(this.isDisable() || this.getParent() != null && this.getParent().isDisabled());
    }

    public Node lookup(String string) {
        if (string == null) {
            return null;
        }
        Selector selector = Selector.createSelector(string);
        return selector != null && selector.applies(this) ? this : null;
    }

    public Set<Node> lookupAll(String string) {
        Selector selector = Selector.createSelector(string);
        UnmodifiableListSet<Node> unmodifiableListSet = Collections.emptySet();
        if (selector == null) {
            return unmodifiableListSet;
        }
        List<Node> list = this.lookupAll(selector, null);
        return list == null ? unmodifiableListSet : new UnmodifiableListSet<Node>(list);
    }

    List<Node> lookupAll(Selector selector, List<Node> list) {
        if (selector.applies(this)) {
            if (list == null) {
                list = new LinkedList<Node>();
            }
            list.add(this);
        }
        return list;
    }

    public void toBack() {
        if (this.getParent() != null) {
            this.getParent().impl_toBack(this);
        }
    }

    public void toFront() {
        if (this.getParent() != null) {
            this.getParent().impl_toFront(this);
        }
    }

    public final void setOnDragEntered(EventHandler<? super DragEvent> eventHandler) {
        this.onDragEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragEntered() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragEntered();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragEnteredProperty() {
        return this.getEventHandlerProperties().onDragEnteredProperty();
    }

    public final void setOnDragExited(EventHandler<? super DragEvent> eventHandler) {
        this.onDragExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragExited() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragExited();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragExitedProperty() {
        return this.getEventHandlerProperties().onDragExitedProperty();
    }

    public final void setOnDragOver(EventHandler<? super DragEvent> eventHandler) {
        this.onDragOverProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragOver() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragOver();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragOverProperty() {
        return this.getEventHandlerProperties().onDragOverProperty();
    }

    public final void setOnDragDropped(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDroppedProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDropped() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragDropped();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDroppedProperty() {
        return this.getEventHandlerProperties().onDragDroppedProperty();
    }

    public final void setOnDragDone(EventHandler<? super DragEvent> eventHandler) {
        this.onDragDoneProperty().set(eventHandler);
    }

    public final EventHandler<? super DragEvent> getOnDragDone() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragDone();
    }

    public final ObjectProperty<EventHandler<? super DragEvent>> onDragDoneProperty() {
        return this.getEventHandlerProperties().onDragDoneProperty();
    }

    public Dragboard startDragAndDrop(TransferMode ... transferModeArray) {
        if (this.getScene() != null) {
            return this.getScene().impl_startDragAndDrop(this, transferModeArray);
        }
        throw new IllegalStateException("Cannot start drag and drop on node that is not in scene");
    }

    Node impl_getClipParent() {
        return this.clipParent;
    }

    boolean isConnected() {
        return this.getParent() != null || this.clipParent != null;
    }

    boolean wouldCreateCycle(Node node, Node node2) {
        if (node2 != null && node2.getClip() == null && !(node2 instanceof Parent)) {
            return false;
        }
        Node node3 = node;
        while (node3 != node2) {
            if (node3.getParent() != null) {
                node3 = node3.getParent();
                continue;
            }
            if (node3.clipParent != null) {
                node3 = node3.clipParent;
                continue;
            }
            return false;
        }
        return true;
    }

    @Deprecated
    public PGNode impl_getPGNode() {
        if (Utils.assertionEnabled() && !Scene.impl_isPGAccessAllowed()) {
            System.err.println();
            System.err.println("*** unexpected PG access");
            Thread.dumpStack();
        }
        if (this.peer == null) {
            this.peer = this.impl_createPGNode();
        }
        return this.peer;
    }

    @Deprecated
    protected abstract PGNode impl_createPGNode();

    protected Node() {
        this.setDirty();
        this.updateTreeVisible();
    }

    public final void setManaged(boolean bl) {
        this.managedProperty().set(bl);
    }

    public final boolean isManaged() {
        return this.managed == null ? true : this.managed.get();
    }

    public final BooleanProperty managedProperty() {
        if (this.managed == null) {
            this.managed = new BooleanPropertyBase(true){

                @Override
                protected void invalidated() {
                    if (Node.this.getParent() != null) {
                        Node.this.getParent().requestLayout();
                    }
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "managed";
                }
            };
        }
        return this.managed;
    }

    public final void setLayoutX(double d) {
        this.layoutXProperty().set(d);
    }

    public final double getLayoutX() {
        return this.layoutX == null ? 0.0 : this.layoutX.get();
    }

    public final DoubleProperty layoutXProperty() {
        if (this.layoutX == null) {
            this.layoutX = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    Node.this.impl_transformsChanged();
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "layoutX";
                }
            };
        }
        return this.layoutX;
    }

    public final void setLayoutY(double d) {
        this.layoutYProperty().set(d);
    }

    public final double getLayoutY() {
        return this.layoutY == null ? 0.0 : this.layoutY.get();
    }

    public final DoubleProperty layoutYProperty() {
        if (this.layoutY == null) {
            this.layoutY = new DoublePropertyBase(0.0){

                @Override
                protected void invalidated() {
                    Node.this.impl_transformsChanged();
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "layoutY";
                }
            };
        }
        return this.layoutY;
    }

    public void relocate(double d, double d2) {
        this.setLayoutX(d - this.getLayoutBounds().getMinX());
        this.setLayoutY(d2 - this.getLayoutBounds().getMinY());
        PlatformLogger platformLogger = Logging.getLayoutLogger();
        if (platformLogger.isLoggable(400)) {
            platformLogger.finer(this.toString() + " moved to (" + d + "," + d2 + ")");
        }
    }

    public boolean isResizable() {
        return false;
    }

    public Orientation getContentBias() {
        return null;
    }

    public double minWidth(double d) {
        return this.prefWidth(d);
    }

    public double minHeight(double d) {
        return this.prefHeight(d);
    }

    public double prefWidth(double d) {
        return this.getLayoutBounds().getWidth();
    }

    public double prefHeight(double d) {
        return this.getLayoutBounds().getHeight();
    }

    public double maxWidth(double d) {
        return this.prefWidth(d);
    }

    public double maxHeight(double d) {
        return this.prefHeight(d);
    }

    public void resize(double d, double d2) {
    }

    public final void autosize() {
        if (this.isResizable()) {
            double d;
            double d2;
            Orientation orientation = this.getContentBias();
            if (orientation == null) {
                d2 = this.boundedSize(this.prefWidth(-1.0), this.minWidth(-1.0), this.maxWidth(-1.0));
                d = this.boundedSize(this.prefHeight(-1.0), this.minHeight(-1.0), this.maxHeight(-1.0));
            } else if (orientation == Orientation.HORIZONTAL) {
                d2 = this.boundedSize(this.prefWidth(-1.0), this.minWidth(-1.0), this.maxWidth(-1.0));
                d = this.prefHeight(d2);
            } else {
                d = this.boundedSize(this.prefHeight(-1.0), this.minHeight(-1.0), this.maxHeight(-1.0));
                d2 = this.prefWidth(d);
            }
            this.resize(d2, d);
        }
    }

    double boundedSize(double d, double d2, double d3) {
        return Math.min(Math.max(d, d2), Math.max(d2, d3));
    }

    public void resizeRelocate(double d, double d2, double d3, double d4) {
        this.resize(d3, d4);
        this.relocate(d, d2);
    }

    public double getBaselineOffset() {
        return this.getLayoutBounds().getHeight();
    }

    public final Bounds getBoundsInParent() {
        return (Bounds)this.boundsInParentProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> boundsInParentProperty() {
        return this.getMiscProperties().boundsInParentProperty();
    }

    private void invalidateBoundsInParent() {
        if (this.miscProperties != null) {
            this.miscProperties.invalidateBoundsInParent();
        }
    }

    public final Bounds getBoundsInLocal() {
        return (Bounds)this.boundsInLocalProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> boundsInLocalProperty() {
        return this.getMiscProperties().boundsInLocalProperty();
    }

    private void invalidateBoundsInLocal() {
        if (this.miscProperties != null) {
            this.miscProperties.invalidateBoundsInLocal();
        }
    }

    public final Bounds getLayoutBounds() {
        return (Bounds)this.layoutBoundsProperty().get();
    }

    public final ReadOnlyObjectProperty<Bounds> layoutBoundsProperty() {
        return this.layoutBounds;
    }

    @Deprecated
    protected Bounds impl_computeLayoutBounds() {
        BaseBounds baseBounds = TempState.getInstance().bounds;
        baseBounds = this.getGeomBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
        return new BoundingBox(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMinZ(), baseBounds.getWidth(), baseBounds.getHeight(), baseBounds.getDepth());
    }

    @Deprecated
    protected void impl_layoutBoundsChanged() {
        this.layoutBounds.invalidate();
        if (this.getScaleX() != 1.0 || this.getScaleY() != 1.0 || this.getScaleZ() != 1.0 || this.getRotate() != 0.0) {
            this.impl_transformsChanged();
        }
        if (this.isManaged() && this.getParent() != null && (!(this.getParent() instanceof Group) || this.isResizable())) {
            this.getParent().requestLayout();
        }
    }

    BaseBounds getTransformedBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        this.updateLocalToParentTransform();
        if (baseTransform.isIdentity()) {
            this.updateTxBounds();
            baseBounds = baseBounds.deriveWithNewBounds(this.txBounds);
            return baseBounds;
        }
        if (this.localToParentTx.isIdentity()) {
            return this.getLocalBounds(baseBounds, baseTransform);
        }
        double d = baseTransform.getMxx();
        double d2 = baseTransform.getMxy();
        double d3 = baseTransform.getMxz();
        double d4 = baseTransform.getMxt();
        double d5 = baseTransform.getMyx();
        double d6 = baseTransform.getMyy();
        double d7 = baseTransform.getMyz();
        double d8 = baseTransform.getMyt();
        double d9 = baseTransform.getMzx();
        double d10 = baseTransform.getMzy();
        double d11 = baseTransform.getMzz();
        double d12 = baseTransform.getMzt();
        BaseTransform baseTransform2 = baseTransform.deriveWithConcatenation(this.localToParentTx);
        baseBounds = this.getLocalBounds(baseBounds, baseTransform2);
        if (baseTransform2 == baseTransform) {
            baseTransform.restoreTransform(d, d2, d3, d4, d5, d6, d7, d8, d9, d10, d11, d12);
        }
        return baseBounds;
    }

    BaseBounds getLocalBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (this.getEffect() != null || this.getClip() != null) {
            if (this.getEffect() != null) {
                BaseBounds baseBounds2 = this.getEffect().impl_getBounds(baseBounds, baseTransform, this, boundsAccessor);
                baseBounds = baseBounds.deriveWithNewBounds(baseBounds2);
            } else {
                baseBounds = this.getGeomBounds(baseBounds, baseTransform);
            }
            if (this.getClip() != null) {
                double d = baseBounds.getMinX();
                double d2 = baseBounds.getMinY();
                double d3 = baseBounds.getMaxX();
                double d4 = baseBounds.getMaxY();
                double d5 = baseBounds.getMinZ();
                double d6 = baseBounds.getMaxZ();
                baseBounds = this.getClip().getTransformedBounds(baseBounds, baseTransform);
                baseBounds.intersectWith((float)d, (float)d2, (float)d5, (float)d3, (float)d4, (float)d6);
            }
            return baseBounds;
        }
        return this.getGeomBounds(baseBounds, baseTransform);
    }

    BaseBounds getGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        if (baseTransform.isTranslateOrIdentity()) {
            this.updateGeomBounds();
            baseBounds = baseBounds.deriveWithNewBounds(this.geomBounds);
            if (!baseTransform.isIdentity()) {
                double d = baseTransform.getMxt();
                double d2 = baseTransform.getMyt();
                double d3 = baseTransform.getMzt();
                baseBounds = baseBounds.deriveWithNewBounds((float)((double)baseBounds.getMinX() + d), (float)((double)baseBounds.getMinY() + d2), (float)((double)baseBounds.getMinZ() + d3), (float)((double)baseBounds.getMaxX() + d), (float)((double)baseBounds.getMaxY() + d2), (float)((double)baseBounds.getMaxZ() + d3));
            }
            return baseBounds;
        }
        if (baseTransform.is2D()) {
            return this.impl_computeGeomBounds(baseBounds, baseTransform);
        }
        this.updateGeomBounds();
        return baseTransform.transform(this.geomBounds, baseBounds);
    }

    @Deprecated
    public abstract BaseBounds impl_computeGeomBounds(BaseBounds var1, BaseTransform var2);

    void updateGeomBounds() {
        if (this.geomBoundsInvalid) {
            this.geomBounds = this.impl_computeGeomBounds(this.geomBounds, BaseTransform.IDENTITY_TRANSFORM);
            this.geomBoundsInvalid = false;
        }
    }

    void updateTxBounds() {
        if (this.txBoundsInvalid) {
            this.updateLocalToParentTransform();
            this.txBounds = this.getLocalBounds(this.txBounds, this.localToParentTx);
            this.txBoundsInvalid = false;
        }
    }

    @Deprecated
    protected abstract boolean impl_computeContains(double var1, double var3);

    private double min4(double d, double d2, double d3, double d4) {
        return Math.min(Math.min(d, d2), Math.min(d3, d4));
    }

    private double max4(double d, double d2, double d3, double d4) {
        return Math.max(Math.max(d, d2), Math.max(d3, d4));
    }

    private double min8(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Math.min(this.min4(d, d2, d3, d4), this.min4(d5, d6, d7, d8));
    }

    private double max8(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        return Math.max(this.max4(d, d2, d3, d4), this.max4(d5, d6, d7, d8));
    }

    Bounds createBoundingBox(Point3D point3D, Point3D point3D2, Point3D point3D3, Point3D point3D4, Point3D point3D5, Point3D point3D6, Point3D point3D7, Point3D point3D8) {
        double d = this.min8(point3D.getX(), point3D2.getX(), point3D3.getX(), point3D4.getX(), point3D5.getX(), point3D6.getX(), point3D7.getX(), point3D8.getX());
        double d2 = this.max8(point3D.getX(), point3D2.getX(), point3D3.getX(), point3D4.getX(), point3D5.getX(), point3D6.getX(), point3D7.getX(), point3D8.getX());
        double d3 = this.min8(point3D.getY(), point3D2.getY(), point3D3.getY(), point3D4.getY(), point3D5.getY(), point3D6.getY(), point3D7.getY(), point3D8.getY());
        double d4 = this.max8(point3D.getY(), point3D2.getY(), point3D3.getY(), point3D4.getY(), point3D5.getY(), point3D6.getY(), point3D7.getY(), point3D8.getY());
        double d5 = this.min8(point3D.getZ(), point3D2.getZ(), point3D3.getZ(), point3D4.getZ(), point3D5.getZ(), point3D6.getZ(), point3D7.getZ(), point3D8.getZ());
        double d6 = this.max8(point3D.getZ(), point3D2.getZ(), point3D3.getZ(), point3D4.getZ(), point3D5.getZ(), point3D6.getZ(), point3D7.getZ(), point3D8.getZ());
        return new BoundingBox(d, d3, d5, d2 - d, d4 - d3, d6 - d5);
    }

    Bounds createBoundingBox(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        double d = this.min4(point2D.getX(), point2D2.getX(), point2D3.getX(), point2D4.getX());
        double d2 = this.max4(point2D.getX(), point2D2.getX(), point2D3.getX(), point2D4.getX());
        double d3 = this.min4(point2D.getY(), point2D2.getY(), point2D3.getY(), point2D4.getY());
        double d4 = this.max4(point2D.getY(), point2D2.getY(), point2D3.getY(), point2D4.getY());
        return new BoundingBox(d, d3, d2 - d, d4 - d3);
    }

    @Deprecated
    protected void impl_geomChanged() {
        this.geomBounds.makeEmpty();
        this.geomBoundsInvalid = true;
        this.impl_markDirty(DirtyBits.NODE_BOUNDS);
        this.impl_notifyLayoutBoundsChanged();
        this.localBoundsChanged();
    }

    void localBoundsChanged() {
        this.invalidateBoundsInLocal();
        this.transformedBoundsChanged();
    }

    void transformedBoundsChanged() {
        boolean bl = !this.txBoundsInvalid;
        this.txBounds.makeEmpty();
        this.txBoundsInvalid = true;
        this.invalidateBoundsInParent();
        if (this.isVisible() && bl) {
            this.notifyParentOfBoundsChange();
        }
        this.impl_markDirty(DirtyBits.NODE_BOUNDS);
    }

    @Deprecated
    protected void impl_notifyLayoutBoundsChanged() {
        this.impl_layoutBoundsChanged();
    }

    void notifyParentOfBoundsChange() {
        if (this.getParent() != null) {
            this.getParent().childBoundsChanged(this);
        }
        if (this.clipParent != null) {
            this.clipParent.localBoundsChanged();
        }
    }

    public boolean contains(double d, double d2) {
        if (this.containsBounds(d, d2)) {
            return this.isPickOnBounds() || this.impl_computeContains(d, d2);
        }
        return false;
    }

    @Deprecated
    protected boolean containsBounds(double d, double d2) {
        TempState tempState = TempState.getInstance();
        BaseBounds baseBounds = tempState.bounds;
        if ((baseBounds = this.getLocalBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM)).contains((float)d, (float)d2)) {
            if (this.getClip() != null) {
                tempState.point.x = (float)d;
                tempState.point.y = (float)d2;
                try {
                    this.getClip().parentToLocal(tempState.point);
                }
                catch (NoninvertibleTransformException noninvertibleTransformException) {
                    return false;
                }
                if (!this.getClip().contains(tempState.point.x, tempState.point.y)) {
                    return false;
                }
            }
            return this.getEffect() == null || (baseBounds = this.getEffect().impl_getBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM, this, boundsAccessor)).contains((float)d, (float)d2);
        }
        return false;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        BaseBounds baseBounds = TempState.getInstance().bounds;
        baseBounds = this.getLocalBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
        return baseBounds.intersects((float)d, (float)d2, (float)d3, (float)d4);
    }

    public boolean intersects(Bounds bounds) {
        return this.intersects(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
    }

    public Point2D sceneToLocal(double d, double d2) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d, (float)d2);
        try {
            this.sceneToLocal(point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D sceneToLocal(Point2D point2D) {
        return this.sceneToLocal(point2D.getX(), point2D.getY());
    }

    private Point3D sceneToLocal(double d, double d2, double d3) {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d, d2, d3);
        try {
            this.sceneToLocal(vec3d);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Bounds sceneToLocal(Bounds bounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && bounds.getMinZ() == 0.0 && bounds.getMaxZ() == 0.0) {
            Point2D point2D = this.sceneToLocal(bounds.getMinX(), bounds.getMinY());
            Point2D point2D2 = this.sceneToLocal(bounds.getMaxX(), bounds.getMinY());
            Point2D point2D3 = this.sceneToLocal(bounds.getMaxX(), bounds.getMaxY());
            Point2D point2D4 = this.sceneToLocal(bounds.getMinX(), bounds.getMaxY());
            return this.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        Point3D point3D = this.sceneToLocal(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D2 = this.sceneToLocal(bounds.getMinX(), bounds.getMinY(), bounds.getMaxZ());
        Point3D point3D3 = this.sceneToLocal(bounds.getMinX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D4 = this.sceneToLocal(bounds.getMinX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D5 = this.sceneToLocal(bounds.getMaxX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D6 = this.sceneToLocal(bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D7 = this.sceneToLocal(bounds.getMaxX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D8 = this.sceneToLocal(bounds.getMaxX(), bounds.getMinY(), bounds.getMaxZ());
        return this.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, point3D8);
    }

    public Point2D localToScene(double d, double d2) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d, (float)d2);
        this.localToScene(point2D);
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D localToScene(Point2D point2D) {
        return this.localToScene(point2D.getX(), point2D.getY());
    }

    private Point3D localToScene(double d, double d2, double d3) {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d, d2, d3);
        this.localToScene(vec3d);
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Bounds localToScene(Bounds bounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && bounds.getMinZ() == 0.0 && bounds.getMaxZ() == 0.0) {
            Point2D point2D = this.localToScene(bounds.getMinX(), bounds.getMinY());
            Point2D point2D2 = this.localToScene(bounds.getMaxX(), bounds.getMinY());
            Point2D point2D3 = this.localToScene(bounds.getMaxX(), bounds.getMaxY());
            Point2D point2D4 = this.localToScene(bounds.getMinX(), bounds.getMaxY());
            return this.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        Point3D point3D = this.localToScene(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D2 = this.localToScene(bounds.getMinX(), bounds.getMinY(), bounds.getMaxZ());
        Point3D point3D3 = this.localToScene(bounds.getMinX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D4 = this.localToScene(bounds.getMinX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D5 = this.localToScene(bounds.getMaxX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D6 = this.localToScene(bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D7 = this.localToScene(bounds.getMaxX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D8 = this.localToScene(bounds.getMaxX(), bounds.getMinY(), bounds.getMaxZ());
        return this.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, point3D8);
    }

    public Point2D parentToLocal(double d, double d2) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d, (float)d2);
        try {
            this.parentToLocal(point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D parentToLocal(Point2D point2D) {
        return this.parentToLocal(point2D.getX(), point2D.getY());
    }

    private Point3D parentToLocal(double d, double d2, double d3) {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d, d2, d3);
        try {
            this.parentToLocal(vec3d);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Bounds parentToLocal(Bounds bounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && bounds.getMinZ() == 0.0 && bounds.getMaxZ() == 0.0) {
            Point2D point2D = this.parentToLocal(bounds.getMinX(), bounds.getMinY());
            Point2D point2D2 = this.parentToLocal(bounds.getMaxX(), bounds.getMinY());
            Point2D point2D3 = this.parentToLocal(bounds.getMaxX(), bounds.getMaxY());
            Point2D point2D4 = this.parentToLocal(bounds.getMinX(), bounds.getMaxY());
            return this.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        Point3D point3D = this.parentToLocal(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D2 = this.parentToLocal(bounds.getMinX(), bounds.getMinY(), bounds.getMaxZ());
        Point3D point3D3 = this.parentToLocal(bounds.getMinX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D4 = this.parentToLocal(bounds.getMinX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D5 = this.parentToLocal(bounds.getMaxX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D6 = this.parentToLocal(bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D7 = this.parentToLocal(bounds.getMaxX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D8 = this.parentToLocal(bounds.getMaxX(), bounds.getMinY(), bounds.getMaxZ());
        return this.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, point3D8);
    }

    public Point2D localToParent(double d, double d2) {
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d, (float)d2);
        this.localToParent(point2D);
        return new Point2D(point2D.x, point2D.y);
    }

    public Point2D localToParent(Point2D point2D) {
        return this.localToParent(point2D.getX(), point2D.getY());
    }

    private Point3D localToParent(double d, double d2, double d3) {
        Vec3d vec3d = TempState.getInstance().vec3d;
        vec3d.set(d, d2, d3);
        this.localToParent(vec3d);
        return new Point3D(vec3d.x, vec3d.y, vec3d.z);
    }

    public Bounds localToParent(Bounds bounds) {
        this.updateLocalToParentTransform();
        if (this.localToParentTx.is2D() && bounds.getMinZ() == 0.0 && bounds.getMaxZ() == 0.0) {
            Point2D point2D = this.localToParent(bounds.getMinX(), bounds.getMinY());
            Point2D point2D2 = this.localToParent(bounds.getMaxX(), bounds.getMinY());
            Point2D point2D3 = this.localToParent(bounds.getMaxX(), bounds.getMaxY());
            Point2D point2D4 = this.localToParent(bounds.getMinX(), bounds.getMaxY());
            return this.createBoundingBox(point2D, point2D2, point2D3, point2D4);
        }
        Point3D point3D = this.localToParent(bounds.getMinX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D2 = this.localToParent(bounds.getMinX(), bounds.getMinY(), bounds.getMaxZ());
        Point3D point3D3 = this.localToParent(bounds.getMinX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D4 = this.localToParent(bounds.getMinX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D5 = this.localToParent(bounds.getMaxX(), bounds.getMaxY(), bounds.getMinZ());
        Point3D point3D6 = this.localToParent(bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ());
        Point3D point3D7 = this.localToParent(bounds.getMaxX(), bounds.getMinY(), bounds.getMinZ());
        Point3D point3D8 = this.localToParent(bounds.getMaxX(), bounds.getMinY(), bounds.getMaxZ());
        return this.createBoundingBox(point3D, point3D2, point3D3, point3D4, point3D5, point3D6, point3D7, point3D8);
    }

    BaseTransform getLocalToParentTransform(BaseTransform baseTransform) {
        this.updateLocalToParentTransform();
        baseTransform.setTransform(this.localToParentTx);
        return baseTransform;
    }

    @Deprecated
    public BaseTransform impl_getLeafTransform() {
        return this.getLocalToParentTransform(TempState.getInstance().leafTx);
    }

    @Deprecated
    public void impl_transformsChanged() {
        this.impl_markDirty(DirtyBits.NODE_TRANSFORM);
        this.transformDirty = true;
        this.transformedBoundsChanged();
    }

    @Deprecated
    public double impl_getPivotX() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinX() + bounds.getWidth() / 2.0;
    }

    @Deprecated
    public double impl_getPivotY() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinY() + bounds.getHeight() / 2.0;
    }

    @Deprecated
    public double impl_getPivotZ() {
        Bounds bounds = this.getLayoutBounds();
        return bounds.getMinZ() + bounds.getDepth() / 2.0;
    }

    void updateLocalToParentTransform() {
        if (this.transformDirty) {
            this.localToParentTx.setToIdentity();
            if (this.getScaleX() != 1.0 || this.getScaleY() != 1.0 || this.getScaleZ() != 1.0 || this.getRotate() != 0.0) {
                double d = this.impl_getPivotX();
                double d2 = this.impl_getPivotY();
                double d3 = this.impl_getPivotZ();
                this.localToParentTx.translate(this.getTranslateX() + this.getLayoutX() + d, this.getTranslateY() + this.getLayoutY() + d2, this.getTranslateZ() + d3);
                this.localToParentTx.rotate(Math.toRadians(this.getRotate()), this.getRotationAxis().getX(), this.getRotationAxis().getY(), this.getRotationAxis().getZ());
                this.localToParentTx.scale(this.getScaleX(), this.getScaleY(), this.getScaleZ());
                this.localToParentTx.translate(-d, -d2, -d3);
            } else {
                this.localToParentTx.translate(this.getTranslateX() + this.getLayoutX(), this.getTranslateY() + this.getLayoutY(), this.getTranslateZ());
            }
            if (this.hasTransforms()) {
                for (Transform transform : this.getTransforms()) {
                    transform.impl_apply(this.localToParentTx);
                }
            }
            this.transformDirty = false;
        }
    }

    void parentToLocal(com.sun.javafx.geom.Point2D point2D) throws NoninvertibleTransformException {
        this.updateLocalToParentTransform();
        this.localToParentTx.inverseTransform(point2D, point2D);
    }

    void parentToLocal(Vec3d vec3d) throws NoninvertibleTransformException {
        this.updateLocalToParentTransform();
        this.localToParentTx.inverseTransform(vec3d, vec3d);
    }

    void sceneToLocal(com.sun.javafx.geom.Point2D point2D) throws NoninvertibleTransformException {
        if (this.getParent() != null) {
            this.getParent().sceneToLocal(point2D);
        }
        this.parentToLocal(point2D);
    }

    void sceneToLocal(Vec3d vec3d) throws NoninvertibleTransformException {
        if (this.getParent() != null) {
            this.getParent().sceneToLocal(vec3d);
        }
        this.parentToLocal(vec3d);
    }

    void localToScene(com.sun.javafx.geom.Point2D point2D) {
        this.localToParent(point2D);
        if (this.getParent() != null) {
            this.getParent().localToScene(point2D);
        }
    }

    void localToScene(Vec3d vec3d) {
        this.localToParent(vec3d);
        if (this.getParent() != null) {
            this.getParent().localToScene(vec3d);
        }
    }

    void localToParent(com.sun.javafx.geom.Point2D point2D) {
        this.updateLocalToParentTransform();
        this.localToParentTx.transform(point2D, point2D);
    }

    void localToParent(Vec3d vec3d) {
        this.updateLocalToParentTransform();
        this.localToParentTx.transform(vec3d, vec3d);
    }

    @Deprecated
    public Node impl_pickNode(double d, double d2) {
        if (this.getScene() == null || !this.isVisible() || this.isDisable() || this.isMouseTransparent()) {
            return null;
        }
        com.sun.javafx.geom.Point2D point2D = TempState.getInstance().point;
        point2D.setLocation((float)d, (float)d2);
        try {
            this.parentToLocal(point2D);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return null;
        }
        return this.impl_pickNodeLocal(point2D.x, point2D.y);
    }

    @Deprecated
    protected Node impl_pickNodeLocal(double d, double d2) {
        if (this.contains(d, d2)) {
            return this;
        }
        return null;
    }

    @Deprecated
    protected Node impl_pickNodeLocal(PickRay pickRay) {
        if (this.impl_intersects(pickRay)) {
            return this;
        }
        return null;
    }

    @Deprecated
    public Node impl_pickNode(PickRay pickRay) {
        if (this.getScene() == null || !this.isVisible() || this.isDisable() || this.isMouseTransparent()) {
            return null;
        }
        BaseTransform baseTransform = TempState.getInstance().pickTx;
        this.getLocalToParentTransform(baseTransform);
        try {
            baseTransform.invert();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            throw new RuntimeException(noninvertibleTransformException);
        }
        PickRay pickRay2 = pickRay.copy();
        pickRay2.transform(baseTransform);
        return this.impl_pickNodeLocal(pickRay2);
    }

    @Deprecated
    protected boolean impl_intersects(PickRay pickRay) {
        return this.contentIntersects(pickRay);
    }

    private boolean contentIntersects(PickRay pickRay) {
        double d = pickRay.getOriginNoClone().z;
        double d2 = pickRay.getDirectionNoClone().z;
        if (Node.almostZero(d2)) {
            return false;
        }
        double d3 = -d / d2;
        double d4 = pickRay.getOriginNoClone().x + pickRay.getDirectionNoClone().x * d3;
        double d5 = pickRay.getOriginNoClone().y + pickRay.getDirectionNoClone().y * d3;
        return this.contains((float)d4, (float)d5);
    }

    static boolean almostZero(double d) {
        return d < 1.0E-5 && d > -1.0E-5;
    }

    public final ObservableList<Transform> getTransforms() {
        return this.transformsProperty();
    }

    private ObservableList<Transform> transformsProperty() {
        return this.getNodeTransformation().getTransforms();
    }

    public final void setTranslateX(double d) {
        this.translateXProperty().set(d);
    }

    public final double getTranslateX() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getTranslateX();
    }

    public final DoubleProperty translateXProperty() {
        return this.getNodeTransformation().translateXProperty();
    }

    public final void setTranslateY(double d) {
        this.translateYProperty().set(d);
    }

    public final double getTranslateY() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getTranslateY();
    }

    public final DoubleProperty translateYProperty() {
        return this.getNodeTransformation().translateYProperty();
    }

    public final void setTranslateZ(double d) {
        this.translateZProperty().set(d);
    }

    public final double getTranslateZ() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getTranslateZ();
    }

    public final DoubleProperty translateZProperty() {
        return this.getNodeTransformation().translateZProperty();
    }

    public final void setScaleX(double d) {
        this.scaleXProperty().set(d);
    }

    public final double getScaleX() {
        return this.nodeTransformation == null ? 1.0 : this.nodeTransformation.getScaleX();
    }

    public final DoubleProperty scaleXProperty() {
        return this.getNodeTransformation().scaleXProperty();
    }

    public final void setScaleY(double d) {
        this.scaleYProperty().set(d);
    }

    public final double getScaleY() {
        return this.nodeTransformation == null ? 1.0 : this.nodeTransformation.getScaleY();
    }

    public final DoubleProperty scaleYProperty() {
        return this.getNodeTransformation().scaleYProperty();
    }

    public final void setScaleZ(double d) {
        this.scaleZProperty().set(d);
    }

    public final double getScaleZ() {
        return this.nodeTransformation == null ? 1.0 : this.nodeTransformation.getScaleZ();
    }

    public final DoubleProperty scaleZProperty() {
        return this.getNodeTransformation().scaleZProperty();
    }

    public final void setRotate(double d) {
        this.rotateProperty().set(d);
    }

    public final double getRotate() {
        return this.nodeTransformation == null ? 0.0 : this.nodeTransformation.getRotate();
    }

    public final DoubleProperty rotateProperty() {
        return this.getNodeTransformation().rotateProperty();
    }

    public final void setRotationAxis(Point3D point3D) {
        this.rotationAxisProperty().set(point3D);
    }

    public final Point3D getRotationAxis() {
        return this.nodeTransformation == null ? DEFAULT_ROTATION_AXIS : this.nodeTransformation.getRotationAxis();
    }

    public final ObjectProperty<Point3D> rotationAxisProperty() {
        return this.getNodeTransformation().rotationAxisProperty();
    }

    private NodeTransformation getNodeTransformation() {
        if (this.nodeTransformation == null) {
            this.nodeTransformation = new NodeTransformation();
        }
        return this.nodeTransformation;
    }

    private boolean hasTransforms() {
        return this.nodeTransformation != null && this.nodeTransformation.hasTransforms();
    }

    private EventHandlerProperties getEventHandlerProperties() {
        if (this.eventHandlerProperties == null) {
            this.eventHandlerProperties = new EventHandlerProperties(this.getInternalEventDispatcher().getEventHandlerManager(), this);
        }
        return this.eventHandlerProperties;
    }

    private MiscProperties getMiscProperties() {
        if (this.miscProperties == null) {
            this.miscProperties = new MiscProperties();
        }
        return this.miscProperties;
    }

    public final void setMouseTransparent(boolean bl) {
        this.mouseTransparentProperty().set(bl);
    }

    public final boolean isMouseTransparent() {
        return this.miscProperties == null ? false : this.miscProperties.isMouseTransparent();
    }

    public final BooleanProperty mouseTransparentProperty() {
        return this.getMiscProperties().mouseTransparentProperty();
    }

    protected final void setHover(boolean bl) {
        this.hoverPropertyImpl().set(bl);
    }

    public final boolean isHover() {
        return this.hover == null ? false : this.hover.get();
    }

    public final ReadOnlyBooleanProperty hoverProperty() {
        return this.hoverPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper hoverPropertyImpl() {
        if (this.hover == null) {
            this.hover = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    PlatformLogger platformLogger = Logging.getInputLogger();
                    if (platformLogger.isLoggable(400)) {
                        platformLogger.finer(this + " hover=" + this.get());
                    }
                    Node.this.impl_pseudoClassStateChanged("hover");
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "hover";
                }
            };
        }
        return this.hover;
    }

    protected final void setPressed(boolean bl) {
        this.pressedPropertyImpl().set(bl);
    }

    public final boolean isPressed() {
        return this.pressed == null ? false : this.pressed.get();
    }

    public final ReadOnlyBooleanProperty pressedProperty() {
        return this.pressedPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper pressedPropertyImpl() {
        if (this.pressed == null) {
            this.pressed = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    PlatformLogger platformLogger = Logging.getInputLogger();
                    if (platformLogger.isLoggable(400)) {
                        platformLogger.finer(this + " pressed=" + this.get());
                    }
                    Node.this.impl_pseudoClassStateChanged("pressed");
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "pressed";
                }
            };
        }
        return this.pressed;
    }

    public final void setOnMouseClicked(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseClickedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseClicked() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseClicked();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseClickedProperty() {
        return this.getEventHandlerProperties().onMouseClickedProperty();
    }

    public final void setOnMouseDragged(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseDraggedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseDragged() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseDragged();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseDraggedProperty() {
        return this.getEventHandlerProperties().onMouseDraggedProperty();
    }

    public final void setOnMouseEntered(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseEnteredProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseEntered() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseEntered();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseEnteredProperty() {
        return this.getEventHandlerProperties().onMouseEnteredProperty();
    }

    public final void setOnMouseExited(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseExitedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseExited() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseExited();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseExitedProperty() {
        return this.getEventHandlerProperties().onMouseExitedProperty();
    }

    public final void setOnMouseMoved(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseMovedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseMoved() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseMoved();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseMovedProperty() {
        return this.getEventHandlerProperties().onMouseMovedProperty();
    }

    public final void setOnMousePressed(EventHandler<? super MouseEvent> eventHandler) {
        this.onMousePressedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMousePressed() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMousePressed();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMousePressedProperty() {
        return this.getEventHandlerProperties().onMousePressedProperty();
    }

    public final void setOnMouseReleased(EventHandler<? super MouseEvent> eventHandler) {
        this.onMouseReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnMouseReleased() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseReleased();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onMouseReleasedProperty() {
        return this.getEventHandlerProperties().onMouseReleasedProperty();
    }

    @Deprecated
    public final void impl_setOnMouseWheelRotated(EventHandler<? super MouseEvent> eventHandler) {
        this.impl_onMouseWheelRotatedProperty().set(eventHandler);
    }

    @Deprecated
    public final EventHandler<? super MouseEvent> impl_getOnMouseWheelRotated() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnMouseWheelRotated();
    }

    @Deprecated
    public final ObjectProperty<EventHandler<? super MouseEvent>> impl_onMouseWheelRotatedProperty() {
        return this.getEventHandlerProperties().onMouseWheelRotatedProperty();
    }

    public final void setOnDragDetected(EventHandler<? super MouseEvent> eventHandler) {
        this.onDragDetectedProperty().set(eventHandler);
    }

    public final EventHandler<? super MouseEvent> getOnDragDetected() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnDragDetected();
    }

    public final ObjectProperty<EventHandler<? super MouseEvent>> onDragDetectedProperty() {
        return this.getEventHandlerProperties().onDragDetectedProperty();
    }

    public final void setOnScroll(EventHandler<? super ScrollEvent> eventHandler) {
        this.onScrollProperty().set(eventHandler);
    }

    public final EventHandler<? super ScrollEvent> getOnScroll() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnScroll();
    }

    public final ObjectProperty<EventHandler<? super ScrollEvent>> onScrollProperty() {
        return this.getEventHandlerProperties().onScrollProperty();
    }

    public final void setOnKeyPressed(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyPressedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyPressed() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnKeyPressed();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyPressedProperty() {
        return this.getEventHandlerProperties().onKeyPressedProperty();
    }

    public final void setOnKeyReleased(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyReleasedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyReleased() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnKeyReleased();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyReleasedProperty() {
        return this.getEventHandlerProperties().onKeyReleasedProperty();
    }

    public final void setOnKeyTyped(EventHandler<? super KeyEvent> eventHandler) {
        this.onKeyTypedProperty().set(eventHandler);
    }

    public final EventHandler<? super KeyEvent> getOnKeyTyped() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnKeyTyped();
    }

    public final ObjectProperty<EventHandler<? super KeyEvent>> onKeyTypedProperty() {
        return this.getEventHandlerProperties().onKeyTypedProperty();
    }

    public final void setOnInputMethodTextChanged(EventHandler<? super InputMethodEvent> eventHandler) {
        this.onInputMethodTextChangedProperty().set(eventHandler);
    }

    public final EventHandler<? super InputMethodEvent> getOnInputMethodTextChanged() {
        return this.eventHandlerProperties == null ? null : this.eventHandlerProperties.getOnInputMethodTextChanged();
    }

    public final ObjectProperty<EventHandler<? super InputMethodEvent>> onInputMethodTextChangedProperty() {
        return this.getEventHandlerProperties().onInputMethodTextChangedProperty();
    }

    public final void setInputMethodRequests(InputMethodRequests inputMethodRequests) {
        this.inputMethodRequestsProperty().set(inputMethodRequests);
    }

    public final InputMethodRequests getInputMethodRequests() {
        return this.miscProperties == null ? DEFAULT_INPUT_METHOD_REQUESTS : this.miscProperties.getInputMethodRequests();
    }

    public final ObjectProperty<InputMethodRequests> inputMethodRequestsProperty() {
        return this.getMiscProperties().inputMethodRequestsProperty();
    }

    protected final void setFocused(boolean bl) {
        this.focusedPropertyImpl().set(bl);
    }

    public final boolean isFocused() {
        return this.focused == null ? false : this.focused.get();
    }

    public final ReadOnlyBooleanProperty focusedProperty() {
        return this.focusedPropertyImpl().getReadOnlyProperty();
    }

    private ReadOnlyBooleanWrapper focusedPropertyImpl() {
        if (this.focused == null) {
            this.focused = new ReadOnlyBooleanWrapper(){

                @Override
                protected void invalidated() {
                    Node.this.impl_pseudoClassStateChanged("focused");
                    PlatformLogger platformLogger = Logging.getFocusLogger();
                    if (platformLogger.isLoggable(500)) {
                        platformLogger.fine(this + " focused=" + this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "focused";
                }
            };
        }
        return this.focused;
    }

    public final void setFocusTraversable(boolean bl) {
        this.focusTraversableProperty().set(bl);
    }

    public final boolean isFocusTraversable() {
        return this.focusTraversable == null ? false : this.focusTraversable.get();
    }

    public final BooleanProperty focusTraversableProperty() {
        if (this.focusTraversable == null) {
            this.focusTraversable = new BooleanPropertyBase(){

                @Override
                public void invalidated() {
                    Scene scene = Node.this.getScene();
                    if (scene != null) {
                        if (this.get()) {
                            scene.registerTraversable(Node.this);
                        } else {
                            scene.unregisterTraversable(Node.this);
                        }
                        Node.this.focusSetDirty(scene);
                    }
                    Node.this.impl_cssPropertyInvalidated(StyleableProperties.FOCUS_TRAVERSABLE);
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "focusTraversable";
                }
            };
        }
        return this.focusTraversable;
    }

    private void focusSetDirty(Scene scene) {
        if (scene != null && (this == scene.impl_getFocusOwner() || this.isFocusTraversable())) {
            scene.setFocusDirty(true);
        }
    }

    public void requestFocus() {
        if (this.getScene() != null) {
            this.getScene().requestFocus(this);
        }
    }

    @Deprecated
    public void impl_requestFocusImpl(Runnable runnable) {
        runnable.run();
    }

    @Deprecated
    public void impl_traverse(Direction direction) {
        if (this.getScene() == null) {
            return;
        }
        this.getScene().traverse(this, direction);
    }

    public String toString() {
        boolean bl;
        String string = this.getClass().getName();
        String string2 = string.substring(string.lastIndexOf(".") + 1);
        StringBuilder stringBuilder = new StringBuilder(string2);
        boolean bl2 = this.id != null && !"".equals(this.getId());
        boolean bl3 = bl = !this.getStyleClass().isEmpty();
        if (!bl2) {
            stringBuilder.append('@');
            stringBuilder.append(Integer.toHexString(this.hashCode()));
        } else {
            stringBuilder.append("[id=");
            stringBuilder.append(this.getId());
            if (!bl) {
                stringBuilder.append("]");
            }
        }
        if (bl) {
            if (!bl2) {
                stringBuilder.append('[');
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append("styleClass=");
            stringBuilder.append(this.getStyleClass());
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private void preprocessMouseEvent(MouseEvent mouseEvent) {
        EventType<? extends Event> eventType = mouseEvent.getEventType();
        if (eventType == MouseEvent.MOUSE_PRESSED) {
            for (Node node = this; node != null; node = node.getParent()) {
                node.setPressed(mouseEvent.isPrimaryButtonDown());
            }
            return;
        }
        if (eventType == MouseEvent.MOUSE_RELEASED) {
            for (Node node = this; node != null; node = node.getParent()) {
                node.setPressed(mouseEvent.isPrimaryButtonDown());
            }
            return;
        }
        if (mouseEvent.getTarget() == this) {
            if (eventType == MouseEvent.MOUSE_ENTERED || eventType == MouseEvent.MOUSE_ENTERED_TARGET) {
                this.setHover(true);
                return;
            }
            if (eventType == MouseEvent.MOUSE_EXITED || eventType == MouseEvent.MOUSE_EXITED_TARGET) {
                this.setHover(false);
                return;
            }
        }
    }

    private void updateTreeVisible() {
        this.setTreeVisible(this.isVisible() && (this.getParent() == null || this.getParent().impl_isTreeVisible()));
    }

    private void setTreeVisible(boolean bl) {
        if (this.treeVisible != bl) {
            this.treeVisible = bl;
            this.updateCanReceiveFocus();
            this.focusSetDirty(this.getScene());
            ((TreeVisiblePropertyReadOnly)this.treeVisibleProperty()).invalidate();
        }
    }

    @Deprecated
    public boolean impl_isTreeVisible() {
        return this.treeVisibleProperty().get();
    }

    BooleanExpression treeVisibleProperty() {
        if (this.treeVisibleRO == null) {
            this.treeVisibleRO = new TreeVisiblePropertyReadOnly();
        }
        return this.treeVisibleRO;
    }

    private void setCanReceiveFocus(boolean bl) {
        this.canReceiveFocus = bl;
    }

    final boolean isCanReceiveFocus() {
        return this.canReceiveFocus;
    }

    private void updateCanReceiveFocus() {
        this.setCanReceiveFocus(this.getScene() != null && !this.isDisabled() && this.impl_isTreeVisible());
    }

    String indent() {
        String string = "";
        for (Parent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            string = string + "  ";
        }
        return string;
    }

    @Deprecated
    public final void impl_setShowMnemonics(boolean bl) {
        this.impl_showMnemonicsProperty().set(bl);
    }

    @Deprecated
    public final boolean impl_isShowMnemonics() {
        return this.impl_showMnemonics == null ? false : this.impl_showMnemonics.get();
    }

    @Deprecated
    public BooleanProperty impl_showMnemonicsProperty() {
        if (this.impl_showMnemonics == null) {
            this.impl_showMnemonics = new BooleanPropertyBase(false){

                @Override
                protected void invalidated() {
                    Node.this.impl_pseudoClassStateChanged("show-mnemonics");
                }

                @Override
                public Object getBean() {
                    return Node.this;
                }

                @Override
                public String getName() {
                    return "showMnemonics";
                }
            };
        }
        return this.impl_showMnemonics;
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcherProperty().set(eventDispatcher);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventHandler);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    private NodeEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<NodeEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    private NodeEventDispatcher createInternalEventDispatcher() {
        return new NodeEventDispatcher(this);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        if (this.preprocessMouseEventDispatcher == null) {
            this.preprocessMouseEventDispatcher = new EventDispatcher(){

                @Override
                public Event dispatchEvent(Event event, EventDispatchChain eventDispatchChain) {
                    if ((event = eventDispatchChain.dispatchEvent(event)) instanceof MouseEvent) {
                        Node.this.preprocessMouseEvent((MouseEvent)event);
                    }
                    return event;
                }
            };
        }
        eventDispatchChain = eventDispatchChain.prepend(this.preprocessMouseEventDispatcher);
        Node node = this;
        do {
            if (node.eventDispatcher == null) continue;
            eventDispatchChain = eventDispatchChain.prepend((EventDispatcher)node.eventDispatcher.get());
        } while ((node = node.getParent()) != null);
        if (this.getScene() != null) {
            eventDispatchChain = this.getScene().buildEventDispatchChain(eventDispatchChain);
        }
        return eventDispatchChain;
    }

    public final void fireEvent(Event event) {
        PlatformLogger platformLogger;
        if (event instanceof InputEvent && (platformLogger = Logging.getInputLogger()).isLoggable(500)) {
            EventType<? extends Event> eventType = event.getEventType();
            if (eventType == MouseEvent.MOUSE_ENTERED || eventType == MouseEvent.MOUSE_EXITED) {
                platformLogger.finer(event.toString());
            } else if (eventType == MouseEvent.MOUSE_MOVED || eventType == MouseEvent.MOUSE_DRAGGED) {
                platformLogger.finest(event.toString());
            } else {
                platformLogger.fine(event.toString());
            }
        }
        Event.fireEvent(this, event);
    }

    @Deprecated
    protected int[] impl_cssStyleablePropertyBitIndices() {
        return StyleableProperties.bitIndices;
    }

    private int impl_cssStyleablePropertyBitIndex(StyleableProperty styleableProperty) {
        int n = styleableProperty.getIndex();
        int[] nArray = this.impl_cssStyleablePropertyBitIndices();
        if (0 <= n && n < nArray.length) {
            return nArray[n];
        }
        return -1;
    }

    private BitSet getPropertyBits() {
        if (this.propertyBits == null) {
            List<StyleableProperty> list = StyleableProperty.getStyleables(this);
            this.propertyBits = new BitSet(list.size());
        }
        return this.propertyBits;
    }

    @Deprecated
    protected final void impl_cssClearUserSetProperties() {
        this.propertyBits = null;
        if (this.propertyBits != null) {
            this.propertyBits.clear();
        }
    }

    @Deprecated
    protected final void impl_cssPropertyInvalidated(StyleableProperty styleableProperty) {
        if (this.propertySetFromCSS) {
            return;
        }
        int n = this.impl_cssStyleablePropertyBitIndex(styleableProperty);
        if (n != -1) {
            BitSet bitSet = this.getPropertyBits();
            bitSet.set(n);
        }
    }

    @Deprecated
    public final boolean impl_cssUserSetProperty(StyleableProperty styleableProperty) {
        int n = this.impl_cssStyleablePropertyBitIndex(styleableProperty);
        if (n != -1) {
            BitSet bitSet = this.getPropertyBits();
            boolean bl = bitSet.get(n);
            return bl;
        }
        return false;
    }

    @Deprecated
    public static List<StyleableProperty> impl_CSS_STYLEABLES() {
        return StyleableProperties.STYLEABLES;
    }

    @Deprecated
    public Class impl_getClassToStyle() {
        return this.getClass();
    }

    @Deprecated
    CSSFlags impl_getCSSFlags() {
        return this.cssFlag;
    }

    @Deprecated
    protected void impl_pseudoClassStateChanged(String string) {
        if (this.getScene() == null) {
            return;
        }
        if ((this.cssFlag == CSSFlags.CLEAN || this.cssFlag == CSSFlags.DIRTY_BRANCH) && this.isPseudoclassUsed(string)) {
            this.cssFlag = CSSFlags.UPDATE;
            this.notifyParentsOfInvalidatedCSS();
        }
    }

    private void notifyParentsOfInvalidatedCSS() {
        if (!this.getScene().getRoot().impl_isDirty(DirtyBits.NODE_CSS)) {
            this.getScene().getRoot().impl_markDirty(DirtyBits.NODE_CSS);
        }
        Parent parent = this.getParent();
        while (parent != null) {
            if (parent.cssFlag == CSSFlags.CLEAN) {
                parent.cssFlag = CSSFlags.DIRTY_BRANCH;
                parent = parent.getParent();
                continue;
            }
            parent = null;
        }
    }

    boolean isPseudoclassUsed(String string) {
        StyleHelper styleHelper = this.impl_getStyleHelper();
        return styleHelper != null ? styleHelper.isPseudoclassUsed(string) : false;
    }

    @Deprecated
    public void impl_reapplyCSS() {
        if (this.getScene() == null) {
            return;
        }
        if (this.cssFlag == CSSFlags.REAPPLY) {
            return;
        }
        this.cssFlag = CSSFlags.REAPPLY;
        if (this.getParent() != null && this.getParent().performingLayout) {
            this.impl_processCSS(true);
        } else if (this.getScene() != null) {
            this.notifyParentsOfInvalidatedCSS();
        }
    }

    void processCSS() {
        switch (this.cssFlag) {
            case CLEAN: {
                break;
            }
            case DIRTY_BRANCH: {
                Parent parent = (Parent)this;
                parent.cssFlag = CSSFlags.CLEAN;
                ObservableList<Node> observableList = parent.getChildren();
                int n = observableList.size();
                for (int i = 0; i < n; ++i) {
                    ((Node)observableList.get(i)).processCSS();
                }
                break;
            }
            default: {
                this.impl_processCSS(false);
            }
        }
    }

    @Deprecated
    public void impl_processCSS(boolean bl) {
        StyleHelper styleHelper = null;
        styleHelper = bl || this.cssFlag == CSSFlags.REAPPLY ? this.impl_createStyleHelper() : this.impl_getStyleHelper();
        this.cssFlag = CSSFlags.CLEAN;
        if (styleHelper != null) {
            styleHelper.transitionToState(this);
        }
    }

    @Deprecated
    public StyleHelper impl_createStyleHelper() {
        StyleHelper styleHelper = null;
        if (this.styleHelperRef != null && (styleHelper = this.styleHelperRef.get()) != null) {
            styleHelper.clearCachedValues(this.styleCacheKeyRef);
        }
        this.styleHelperRef = StyleManager.getInstance().getStyleHelper(this);
        if (this.styleHelperRef != null) {
            styleHelper = this.styleHelperRef.get();
        }
        this.styleCacheKeyRef = null;
        return styleHelper;
    }

    @Deprecated
    public StyleHelper impl_getStyleHelper() {
        StyleHelper styleHelper = null;
        if (this.styleHelperRef != null && (styleHelper = this.styleHelperRef.get()) == null) {
            styleHelper = this.impl_createStyleHelper();
        }
        return styleHelper;
    }

    public Reference<StyleHelper.StyleCacheKey> impl_getStyleCacheKey() {
        StyleHelper styleHelper = this.impl_getStyleHelper();
        if (styleHelper == null) {
            this.styleCacheKeyRef = null;
            return null;
        }
        if (this.styleCacheKeyRef == null || this.styleCacheKeyRef.get() == null) {
            this.styleCacheKeyRef = styleHelper.createStyleCacheKey(this);
        }
        return this.styleCacheKeyRef;
    }

    @Deprecated
    public long impl_getPseudoClassState() {
        long l = 0L;
        if (this.isHover()) {
            l |= HOVER_PSEUDOCLASS_STATE;
        }
        if (this.isPressed()) {
            l |= PRESSED_PSEUDOCLASS_STATE;
        }
        if (this.isDisabled()) {
            l |= DISABLED_PSEUDOCLASS_STATE;
        }
        if (this.isFocused()) {
            l |= FOCUSED_PSEUDOCLASS_STATE;
        }
        if (this.impl_isShowMnemonics()) {
            l |= SHOW_MNEMONICS_PSEUDOCLASS_STATE;
        }
        return l;
    }

    @Deprecated
    protected boolean impl_cssSet(String string, Object object) {
        if ("-fx-cursor".equals(string)) {
            if (object instanceof String) {
                Image image = new Image((String)object);
                this.setCursor(new ImageCursor(image));
            } else {
                this.setCursor((Cursor)object);
            }
        } else if ("-fx-effect".equals(string)) {
            this.setEffect((Effect)object);
        } else if ("-fx-focus-traversable".equals(string)) {
            this.setFocusTraversable((Boolean)object);
        } else if ("-fx-opacity".equals(string)) {
            this.setOpacity(object == null ? 1.0 : ((Number)object).doubleValue());
        } else if ("-fx-blend-mode".equals(string)) {
            this.setBlendMode((BlendMode)((Object)object));
        } else if ("-fx-rotate".equals(string)) {
            this.setRotate(object == null ? 0.0 : ((Number)object).doubleValue());
        } else if ("-fx-scale-x".equals(string)) {
            this.setScaleX(object == null ? 1.0 : ((Number)object).doubleValue());
        } else if ("-fx-scale-y".equals(string)) {
            this.setScaleY(object == null ? 1.0 : ((Number)object).doubleValue());
        } else if ("-fx-scale-z".equals(string)) {
            this.setScaleZ(object == null ? 1.0 : ((Number)object).doubleValue());
        } else if ("-fx-translate-x".equals(string)) {
            this.setTranslateX(object == null ? 0.0 : ((Number)object).doubleValue());
        } else if ("-fx-translate-y".equals(string)) {
            this.setTranslateY(object == null ? 0.0 : ((Number)object).doubleValue());
        } else if ("-fx-translate-z".equals(string)) {
            this.setTranslateZ(object == null ? 0.0 : ((Number)object).doubleValue());
        } else if ("visibility".equals(string)) {
            String string2;
            String string3 = string2 = object != null ? ((String)object).toLowerCase() : null;
            if ("visible".equals(string2)) {
                this.setVisible(true);
            } else if ("hidden".equals(string2) || "collapse".equals(string2)) {
                this.setVisible(false);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void impl_cssSet(StyleableProperty styleableProperty, Object object) {
        try {
            this.propertySetFromCSS = true;
            this.impl_cssSet(styleableProperty.getProperty(), object);
        }
        catch (Exception exception) {
            PlatformLogger platformLogger = Logging.getCSSLogger();
            if (platformLogger.isLoggable(900)) {
                platformLogger.warning(String.format("Failed to set css [%s]\n", styleableProperty), exception);
            }
        }
        finally {
            this.propertySetFromCSS = false;
        }
    }

    @Deprecated
    public boolean impl_cssSettable(StyleableProperty styleableProperty) {
        return this.impl_cssSettable(styleableProperty.getProperty());
    }

    @Deprecated
    protected boolean impl_cssSettable(String string) {
        if ("-fx-cursor".equals(string)) {
            return this.miscProperties == null || this.miscProperties.canSetCursor();
        }
        if ("-fx-effect".equals(string)) {
            return this.miscProperties == null || this.miscProperties.canSetEffect();
        }
        if ("-fx-focus-traversable".equals(string)) {
            return this.focusTraversable == null || !this.focusTraversable.isBound();
        }
        if ("-fx-opacity".equals(string)) {
            return this.opacity == null || !this.opacity.isBound();
        }
        if ("-fx-blend-mode".equals(string)) {
            return this.blendMode == null || !this.blendMode.isBound();
        }
        if ("-fx-rotate".equals(string)) {
            return this.nodeTransformation == null || this.nodeTransformation.canSetRotate();
        }
        if ("-fx-scale-x".equals(string)) {
            return this.nodeTransformation == null || this.nodeTransformation.canSetScaleX();
        }
        if ("-fx-scale-y".equals(string)) {
            return this.nodeTransformation == null || this.nodeTransformation.canSetScaleY();
        }
        if ("-fx-scale-z".equals(string)) {
            return this.nodeTransformation == null || this.nodeTransformation.canSetScaleZ();
        }
        if ("-fx-translate-x".equals(string)) {
            return this.nodeTransformation == null || this.nodeTransformation.canSetTranslateX();
        }
        if ("-fx-translate-y".equals(string)) {
            return this.nodeTransformation == null || this.nodeTransformation.canSetTranslateY();
        }
        if ("-fx-translate-z".equals(string)) {
            return this.nodeTransformation == null || this.nodeTransformation.canSetTranslateZ();
        }
        if ("visibility".equals(string)) {
            return this.visible == null || !this.visible.isBound();
        }
        return false;
    }

    @Deprecated
    public abstract Object impl_processMXNode(MXNodeAlgorithm var1, MXNodeAlgorithmContext var2);

    static {
        PerformanceTracker.logEvent("Node.fx class loaded");
        USER_DATA_KEY = new Object();
        DEFAULT_ROTATION_AXIS = Rotate.Z_AXIS;
        DEFAULT_CACHE_HINT = CacheHint.DEFAULT;
        DEFAULT_CLIP = null;
        DEFAULT_CURSOR = null;
        DEFAULT_DEPTH_TEST = DepthTest.INHERIT;
        DEFAULT_EFFECT = null;
        DEFAULT_INPUT_METHOD_REQUESTS = null;
        HOVER_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("hover");
        PRESSED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("pressed");
        DISABLED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("disabled");
        FOCUSED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("focused");
        SHOW_MNEMONICS_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("show-mnemonics");
        boundsAccessor = new BoundsAccessor(){

            @Override
            public BaseBounds getGeomBounds(BaseBounds baseBounds, BaseTransform baseTransform, Node node) {
                return node.getGeomBounds(baseBounds, baseTransform);
            }
        };
    }

    private static abstract class LazyBoundsProperty
    extends ReadOnlyObjectProperty<Bounds> {
        private ExpressionHelper<Bounds> helper;
        private boolean valid;
        private Bounds bounds;

        private LazyBoundsProperty() {
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
        }

        @Override
        public void addListener(ChangeListener<? super Bounds> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super Bounds> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }

        @Override
        public Bounds get() {
            if (!this.valid) {
                this.bounds = this.computeBounds();
                this.valid = true;
            }
            return this.bounds;
        }

        public void invalidate() {
            if (this.valid) {
                this.valid = false;
                ExpressionHelper.fireValueChangedEvent(this.helper);
            }
        }

        protected abstract Bounds computeBounds();
    }

    private static class StyleableProperties {
        private static final StyleableProperty CURSOR = new StyleableProperty(MiscProperties.class, "cursor");
        private static final StyleableProperty EFFECT = new StyleableProperty(MiscProperties.class, "effect");
        private static final StyleableProperty FOCUS_TRAVERSABLE = new StyleableProperty(Node.class, "focusTraversable");
        private static final StyleableProperty OPACITY = new StyleableProperty(Node.class, "opacity");
        private static final StyleableProperty BLEND_MODE = new StyleableProperty(Node.class, "blendMode");
        private static final StyleableProperty ROTATE = new StyleableProperty(NodeTransformation.class, "rotate");
        private static final StyleableProperty SCALE_X = new StyleableProperty(NodeTransformation.class, "scaleX");
        private static final StyleableProperty SCALE_Y = new StyleableProperty(NodeTransformation.class, "scaleY");
        private static final StyleableProperty SCALE_Z = new StyleableProperty(NodeTransformation.class, "scaleZ");
        private static final StyleableProperty TRANSLATE_X = new StyleableProperty(NodeTransformation.class, "translateX");
        private static final StyleableProperty TRANSLATE_Y = new StyleableProperty(NodeTransformation.class, "translateY");
        private static final StyleableProperty TRANSLATE_Z = new StyleableProperty(NodeTransformation.class, "translateZ");
        private static final StyleableProperty VISIBILITY = new StyleableProperty(Node.class, "visible");
        private static final List<StyleableProperty> STYLEABLES = Collections.unmodifiableList(Arrays.asList(CURSOR, EFFECT, FOCUS_TRAVERSABLE, OPACITY, BLEND_MODE, ROTATE, SCALE_X, SCALE_Y, SCALE_Z, TRANSLATE_X, TRANSLATE_Y, TRANSLATE_Z, VISIBILITY));
        private static final int[] bitIndices = new int[StyleableProperty.getMaxIndex()];

        private StyleableProperties() {
        }

        static {
            Arrays.fill(bitIndices, -1);
            for (int i = 0; i < STYLEABLES.size(); ++i) {
                StyleableProperties.bitIndices[StyleableProperties.STYLEABLES.get((int)i).getIndex()] = i;
            }
        }
    }

    class TreeVisiblePropertyReadOnly
    extends BooleanExpression {
        private ExpressionHelper<Boolean> helper;
        private boolean valid;

        TreeVisiblePropertyReadOnly() {
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, invalidationListener);
        }

        @Override
        public void addListener(ChangeListener<? super Boolean> changeListener) {
            this.helper = ExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super Boolean> changeListener) {
            this.helper = ExpressionHelper.removeListener(this.helper, changeListener);
        }

        protected void invalidate() {
            if (this.valid) {
                this.valid = false;
                ExpressionHelper.fireValueChangedEvent(this.helper);
            }
        }

        @Override
        public boolean get() {
            this.valid = true;
            return Node.this.treeVisible;
        }
    }

    private final class MiscProperties {
        private LazyBoundsProperty boundsInParent;
        private LazyBoundsProperty boundsInLocal;
        private BooleanProperty cache;
        private ObjectProperty<CacheHint> cacheHint;
        private ObjectProperty<Node> clip;
        @Styleable(property="-fx-cursor", converter="com.sun.javafx.css.converters.CursorConverter")
        private ObjectProperty<Cursor> cursor;
        private ObjectProperty<DepthTest> depthTest;
        private BooleanProperty disable;
        @Styleable(property="-fx-effect", converter="com.sun.javafx.css.converters.EffectConverter")
        private ObjectProperty<Effect> effect;
        private ObjectProperty<InputMethodRequests> inputMethodRequests;
        private BooleanProperty mouseTransparent;

        private MiscProperties() {
        }

        public final Bounds getBoundsInParent() {
            return (Bounds)this.boundsInParentProperty().get();
        }

        public final ReadOnlyObjectProperty<Bounds> boundsInParentProperty() {
            if (this.boundsInParent == null) {
                this.boundsInParent = new LazyBoundsProperty(){

                    @Override
                    protected Bounds computeBounds() {
                        BaseBounds baseBounds = TempState.getInstance().bounds;
                        baseBounds = Node.this.getTransformedBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
                        return new BoundingBox(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMinZ(), baseBounds.getWidth(), baseBounds.getHeight(), baseBounds.getDepth());
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "boundsInParent";
                    }
                };
            }
            return this.boundsInParent;
        }

        public void invalidateBoundsInParent() {
            if (this.boundsInParent != null) {
                this.boundsInParent.invalidate();
            }
        }

        public final Bounds getBoundsInLocal() {
            return (Bounds)this.boundsInLocalProperty().get();
        }

        public final ReadOnlyObjectProperty<Bounds> boundsInLocalProperty() {
            if (this.boundsInLocal == null) {
                this.boundsInLocal = new LazyBoundsProperty(){

                    @Override
                    protected Bounds computeBounds() {
                        BaseBounds baseBounds = TempState.getInstance().bounds;
                        baseBounds = Node.this.getLocalBounds(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
                        return new BoundingBox(baseBounds.getMinX(), baseBounds.getMinY(), baseBounds.getMinZ(), baseBounds.getWidth(), baseBounds.getHeight(), baseBounds.getDepth());
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "boundsInLocal";
                    }
                };
            }
            return this.boundsInLocal;
        }

        public void invalidateBoundsInLocal() {
            if (this.boundsInLocal != null) {
                this.boundsInLocal.invalidate();
            }
        }

        public final boolean isCache() {
            return this.cache == null ? false : this.cache.get();
        }

        public final BooleanProperty cacheProperty() {
            if (this.cache == null) {
                this.cache = new BooleanPropertyBase(false){

                    @Override
                    protected void invalidated() {
                        Node.this.impl_markDirty(DirtyBits.NODE_CACHE);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "cache";
                    }
                };
            }
            return this.cache;
        }

        public final CacheHint getCacheHint() {
            return this.cacheHint == null ? DEFAULT_CACHE_HINT : (CacheHint)((Object)this.cacheHint.get());
        }

        public final ObjectProperty<CacheHint> cacheHintProperty() {
            if (this.cacheHint == null) {
                this.cacheHint = new ObjectPropertyBase<CacheHint>(DEFAULT_CACHE_HINT){

                    @Override
                    protected void invalidated() {
                        Node.this.impl_markDirty(DirtyBits.NODE_CACHE);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "cacheHint";
                    }
                };
            }
            return this.cacheHint;
        }

        public final Node getClip() {
            return this.clip == null ? DEFAULT_CLIP : (Node)this.clip.get();
        }

        public final ObjectProperty<Node> clipProperty() {
            if (this.clip == null) {
                this.clip = new ObjectPropertyBase<Node>(DEFAULT_CLIP){
                    private Node oldClip;

                    @Override
                    protected void invalidated() {
                        Node node = (Node)this.get();
                        if (node != null && (node.isConnected() && node.clipParent != Node.this || Node.this.wouldCreateCycle(Node.this, node))) {
                            String string;
                            String string2 = string = node.isConnected() && node.clipParent != Node.this ? "node already connected" : "cycle detected";
                            if (this.isBound()) {
                                this.unbind();
                                this.set(this.oldClip);
                                throw new IllegalArgumentException("Node's clip set to incorrect value  through binding (" + string + ", node  = " + Node.this + ", clip = " + MiscProperties.this.clip + ")." + " Binding has been removed.");
                            }
                            this.set(this.oldClip);
                            throw new IllegalArgumentException("Node's clip set to incorrect value (" + string + ", node  = " + Node.this + ", clip = " + MiscProperties.this.clip + ").");
                        }
                        if (this.oldClip != null) {
                            this.oldClip.clipParent = null;
                            this.oldClip.setScene(null);
                        }
                        if (node != null) {
                            node.clipParent = Node.this;
                            node.setScene(Node.this.getScene());
                        }
                        Node.this.impl_markDirty(DirtyBits.NODE_CLIP);
                        Node.this.localBoundsChanged();
                        this.oldClip = node;
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "clip";
                    }
                };
            }
            return this.clip;
        }

        public final Cursor getCursor() {
            return this.cursor == null ? DEFAULT_CURSOR : (Cursor)this.cursor.get();
        }

        public final ObjectProperty<Cursor> cursorProperty() {
            if (this.cursor == null) {
                this.cursor = new ObjectPropertyBase<Cursor>(DEFAULT_CURSOR){

                    @Override
                    public void invalidated() {
                        Node.this.impl_cssPropertyInvalidated(StyleableProperties.CURSOR);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "cursor";
                    }
                };
            }
            return this.cursor;
        }

        public final DepthTest getDepthTest() {
            return this.depthTest == null ? DEFAULT_DEPTH_TEST : (DepthTest)((Object)this.depthTest.get());
        }

        public final ObjectProperty<DepthTest> depthTestProperty() {
            if (this.depthTest == null) {
                this.depthTest = new ObjectPropertyBase<DepthTest>(DEFAULT_DEPTH_TEST){

                    @Override
                    protected void invalidated() {
                        Node.this.computeDerivedDepthTest();
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "depthTest";
                    }
                };
            }
            return this.depthTest;
        }

        public final boolean isDisable() {
            return this.disable == null ? false : this.disable.get();
        }

        public final BooleanProperty disableProperty() {
            if (this.disable == null) {
                this.disable = new BooleanPropertyBase(false){

                    @Override
                    protected void invalidated() {
                        Node.this.updateDisabled();
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "disable";
                    }
                };
            }
            return this.disable;
        }

        public final Effect getEffect() {
            return this.effect == null ? DEFAULT_EFFECT : (Effect)this.effect.get();
        }

        public final ObjectProperty<Effect> effectProperty() {
            if (this.effect == null) {
                this.effect = new ObjectPropertyBase<Effect>(DEFAULT_EFFECT){
                    private Effect oldEffect;
                    private int oldBits;
                    private final AbstractNotifyListener effectChangeListener;
                    {
                        this.oldEffect = null;
                        this.effectChangeListener = new AbstractNotifyListener(){

                            @Override
                            public void invalidated(Observable observable) {
                                int n = ((IntegerProperty)observable).get();
                                int n2 = n ^ oldBits;
                                oldBits = n;
                                if (EffectDirtyBits.isSet(n2, EffectDirtyBits.EFFECT_DIRTY) && EffectDirtyBits.isSet(n, EffectDirtyBits.EFFECT_DIRTY)) {
                                    Node.this.impl_markDirty(DirtyBits.EFFECT_EFFECT);
                                }
                                if (EffectDirtyBits.isSet(n2, EffectDirtyBits.BOUNDS_CHANGED)) {
                                    Node.this.localBoundsChanged();
                                }
                            }
                        };
                    }

                    @Override
                    protected void invalidated() {
                        Effect effect = (Effect)this.get();
                        if (this.oldEffect != null) {
                            this.oldEffect.impl_effectDirtyProperty().removeListener(this.effectChangeListener.getWeakListener());
                        }
                        this.oldEffect = effect;
                        if (effect != null) {
                            effect.impl_effectDirtyProperty().addListener(this.effectChangeListener.getWeakListener());
                            if (effect.impl_isEffectDirty()) {
                                Node.this.impl_markDirty(DirtyBits.EFFECT_EFFECT);
                            }
                            this.oldBits = effect.impl_effectDirtyProperty().get();
                        }
                        Node.this.impl_markDirty(DirtyBits.NODE_EFFECT);
                        Node.this.localBoundsChanged();
                        Node.this.impl_cssPropertyInvalidated(StyleableProperties.EFFECT);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "effect";
                    }
                };
            }
            return this.effect;
        }

        public final InputMethodRequests getInputMethodRequests() {
            return this.inputMethodRequests == null ? DEFAULT_INPUT_METHOD_REQUESTS : (InputMethodRequests)this.inputMethodRequests.get();
        }

        public ObjectProperty<InputMethodRequests> inputMethodRequestsProperty() {
            if (this.inputMethodRequests == null) {
                this.inputMethodRequests = new SimpleObjectProperty<InputMethodRequests>(Node.this, "inputMethodRequests", DEFAULT_INPUT_METHOD_REQUESTS);
            }
            return this.inputMethodRequests;
        }

        public final boolean isMouseTransparent() {
            return this.mouseTransparent == null ? false : this.mouseTransparent.get();
        }

        public final BooleanProperty mouseTransparentProperty() {
            if (this.mouseTransparent == null) {
                this.mouseTransparent = new SimpleBooleanProperty(Node.this, "mouseTransparent", false);
            }
            return this.mouseTransparent;
        }

        public boolean canSetCursor() {
            return this.cursor == null || !this.cursor.isBound();
        }

        public boolean canSetEffect() {
            return this.effect == null || !this.effect.isBound();
        }
    }

    private final class NodeTransformation {
        @Styleable(property="-fx-translate-x", initial="0")
        private DoubleProperty translateX;
        @Styleable(property="-fx-translate-y", initial="0")
        private DoubleProperty translateY;
        @Styleable(property="-fx-translate-z", initial="0")
        private DoubleProperty translateZ;
        @Styleable(property="-fx-scale-x", initial="1")
        private DoubleProperty scaleX;
        @Styleable(property="-fx-scale-y", initial="1")
        private DoubleProperty scaleY;
        @Styleable(property="-fx-scale-z", initial="1")
        private DoubleProperty scaleZ;
        @Styleable(property="-fx-rotate", initial="0")
        private DoubleProperty rotate;
        private ObjectProperty<Point3D> rotationAxis;
        private ObservableList<Transform> transforms;

        private NodeTransformation() {
        }

        public double getTranslateX() {
            return this.translateX == null ? 0.0 : this.translateX.get();
        }

        public final DoubleProperty translateXProperty() {
            if (this.translateX == null) {
                this.translateX = new DoublePropertyBase(0.0){

                    @Override
                    public void invalidated() {
                        NodeTransformation.this.invalidated(StyleableProperties.TRANSLATE_X);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "translateX";
                    }
                };
            }
            return this.translateX;
        }

        public double getTranslateY() {
            return this.translateY == null ? 0.0 : this.translateY.get();
        }

        public final DoubleProperty translateYProperty() {
            if (this.translateY == null) {
                this.translateY = new DoublePropertyBase(0.0){

                    @Override
                    public void invalidated() {
                        NodeTransformation.this.invalidated(StyleableProperties.TRANSLATE_Y);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "translateY";
                    }
                };
            }
            return this.translateY;
        }

        public double getTranslateZ() {
            return this.translateZ == null ? 0.0 : this.translateZ.get();
        }

        public final DoubleProperty translateZProperty() {
            if (this.translateZ == null) {
                this.translateZ = new DoublePropertyBase(0.0){

                    @Override
                    public void invalidated() {
                        NodeTransformation.this.invalidated(StyleableProperties.TRANSLATE_Z);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "translateZ";
                    }
                };
            }
            return this.translateZ;
        }

        public double getScaleX() {
            return this.scaleX == null ? 1.0 : this.scaleX.get();
        }

        public final DoubleProperty scaleXProperty() {
            if (this.scaleX == null) {
                this.scaleX = new DoublePropertyBase(1.0){

                    @Override
                    public void invalidated() {
                        NodeTransformation.this.invalidated(StyleableProperties.SCALE_X);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "scaleX";
                    }
                };
            }
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY == null ? 1.0 : this.scaleY.get();
        }

        public final DoubleProperty scaleYProperty() {
            if (this.scaleY == null) {
                this.scaleY = new DoublePropertyBase(1.0){

                    @Override
                    public void invalidated() {
                        NodeTransformation.this.invalidated(StyleableProperties.SCALE_Y);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "scaleY";
                    }
                };
            }
            return this.scaleY;
        }

        public double getScaleZ() {
            return this.scaleZ == null ? 1.0 : this.scaleZ.get();
        }

        public final DoubleProperty scaleZProperty() {
            if (this.scaleZ == null) {
                this.scaleZ = new DoublePropertyBase(1.0){

                    @Override
                    public void invalidated() {
                        NodeTransformation.this.invalidated(StyleableProperties.SCALE_Z);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "scaleZ";
                    }
                };
            }
            return this.scaleZ;
        }

        public double getRotate() {
            return this.rotate == null ? 0.0 : this.rotate.get();
        }

        public final DoubleProperty rotateProperty() {
            if (this.rotate == null) {
                this.rotate = new DoublePropertyBase(0.0){

                    @Override
                    public void invalidated() {
                        NodeTransformation.this.invalidated(StyleableProperties.ROTATE);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "rotate";
                    }
                };
            }
            return this.rotate;
        }

        public Point3D getRotationAxis() {
            return this.rotationAxis == null ? DEFAULT_ROTATION_AXIS : (Point3D)this.rotationAxis.get();
        }

        public final ObjectProperty<Point3D> rotationAxisProperty() {
            if (this.rotationAxis == null) {
                this.rotationAxis = new ObjectPropertyBase<Point3D>(DEFAULT_ROTATION_AXIS){

                    @Override
                    protected void invalidated() {
                        NodeTransformation.this.invalidated(null);
                    }

                    @Override
                    public Object getBean() {
                        return Node.this;
                    }

                    @Override
                    public String getName() {
                        return "rotationAxis";
                    }
                };
            }
            return this.rotationAxis;
        }

        public ObservableList<Transform> getTransforms() {
            if (this.transforms == null) {
                this.transforms = new TrackableObservableList<Transform>(){

                    @Override
                    protected void onChanged(ListChangeListener.Change<Transform> change) {
                        while (change.next()) {
                            for (Transform transform : change.getRemoved()) {
                                transform.impl_remove(Node.this);
                            }
                            for (Transform transform : change.getAddedSubList()) {
                                transform.impl_add(Node.this);
                            }
                        }
                        NodeTransformation.this.invalidated(null);
                    }
                };
            }
            return this.transforms;
        }

        public boolean canSetTranslateX() {
            return this.translateX == null || !this.translateX.isBound();
        }

        public boolean canSetTranslateY() {
            return this.translateY == null || !this.translateY.isBound();
        }

        public boolean canSetTranslateZ() {
            return this.translateZ == null || !this.translateZ.isBound();
        }

        public boolean canSetScaleX() {
            return this.scaleX == null || !this.scaleX.isBound();
        }

        public boolean canSetScaleY() {
            return this.scaleY == null || !this.scaleY.isBound();
        }

        public boolean canSetScaleZ() {
            return this.scaleZ == null || !this.scaleZ.isBound();
        }

        public boolean canSetRotate() {
            return this.rotate == null || !this.rotate.isBound();
        }

        public boolean hasTransforms() {
            return this.transforms != null;
        }

        private void invalidated(StyleableProperty styleableProperty) {
            Node.this.impl_transformsChanged();
            if (styleableProperty != null) {
                Node.this.impl_cssPropertyInvalidated(styleableProperty);
            }
        }
    }
}

