/*
 * Decompiled with CFR 0.152.
 */
package javafx.fxml;

import com.sun.javafx.fxml.builder.JavaFXFontBuilder;
import com.sun.javafx.fxml.builder.JavaFXImageBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.fxml.FXMLLoader;
import javafx.fxml.JavaFXBuilder;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.util.Builder;
import javafx.util.BuilderFactory;

public final class JavaFXBuilderFactory
implements BuilderFactory {
    private final JavaFXBuilder NO_BUILDER = new JavaFXBuilder();
    private final Map<Class<?>, JavaFXBuilder> builders = new HashMap();
    private final boolean alwaysUseBuilders;

    public JavaFXBuilderFactory() {
        this(true);
    }

    public JavaFXBuilderFactory(boolean bl) {
        this.alwaysUseBuilders = bl;
    }

    @Override
    public Builder<?> getBuilder(Class<?> clazz) {
        if (Font.class.equals(clazz)) {
            return new JavaFXFontBuilder();
        }
        if (Image.class.equals(clazz)) {
            return new JavaFXImageBuilder();
        }
        Builder<Object> builder = null;
        JavaFXBuilder javaFXBuilder = this.builders.get(clazz);
        if (javaFXBuilder != this.NO_BUILDER) {
            if (javaFXBuilder == null) {
                try {
                    clazz.getConstructor(new Class[0]);
                    if (this.alwaysUseBuilders) {
                        throw new Exception();
                    }
                }
                catch (Exception exception) {
                    try {
                        javaFXBuilder = this.createTypeBuilder(clazz);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                this.builders.put(clazz, javaFXBuilder == null ? this.NO_BUILDER : javaFXBuilder);
            }
            if (javaFXBuilder != null) {
                builder = javaFXBuilder.createBuilder();
            }
        }
        return builder;
    }

    JavaFXBuilder createTypeBuilder(Class<?> clazz) throws ClassNotFoundException {
        JavaFXBuilder javaFXBuilder = null;
        Class<?> clazz2 = FXMLLoader.loadType(clazz.getName() + "Builder");
        try {
            javaFXBuilder = new JavaFXBuilder(clazz2);
        }
        catch (Exception exception) {
            Logger.getLogger(JavaFXBuilderFactory.class.getName()).log(Level.WARNING, "Failed to instantiate JavaFXBuilder for " + clazz2, exception);
        }
        if (!this.alwaysUseBuilders) {
            Logger.getLogger(JavaFXBuilderFactory.class.getName()).log(Level.FINER, "class {0} requires a builder.", clazz);
        }
        return javaFXBuilder;
    }
}

