/*
 * Decompiled with CFR 0.152.
 */
package javafx.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.concurrent.Worker;

public abstract class Task<V>
extends FutureTask<V>
implements Worker<V> {
    private AtomicReference<ProgressUpdate> progressUpdate = new AtomicReference();
    private AtomicReference<String> messageUpdate = new AtomicReference();
    private AtomicReference<String> titleUpdate = new AtomicReference();
    private ObjectProperty<Worker.State> status = new SimpleObjectProperty<Worker.State>(this, "state", Worker.State.READY);
    private ObjectProperty<V> value = new SimpleObjectProperty<V>(this, "value");
    private ObjectProperty<Throwable> exception = new SimpleObjectProperty<Throwable>(this, "exception");
    private DoubleProperty workDone = new SimpleDoubleProperty(this, "workDone", -1.0);
    private DoubleProperty totalWork = new SimpleDoubleProperty(this, "totalWork", -1.0);
    private DoubleProperty progress = new SimpleDoubleProperty(this, "progress", -1.0);
    private BooleanProperty running = new SimpleBooleanProperty(this, "running", false);
    private StringProperty message = new SimpleStringProperty(this, "message", "");
    private StringProperty title = new SimpleStringProperty(this, "title", "");

    public Task() {
        this(new TaskCallable());
    }

    private Task(TaskCallable<V> taskCallable) {
        super(taskCallable);
        ((TaskCallable)taskCallable).task = this;
    }

    protected abstract V call() throws Exception;

    final void setStatus(Worker.State state) {
        this.checkThread();
        Worker.State state2 = this.getState();
        if (state2 != Worker.State.CANCELLED) {
            this.status.set(state);
            this.setRunning(state == Worker.State.SCHEDULED || state == Worker.State.RUNNING);
        }
    }

    @Override
    public final Worker.State getState() {
        this.checkThread();
        return (Worker.State)((Object)this.status.get());
    }

    @Override
    public final ReadOnlyObjectProperty<Worker.State> stateProperty() {
        this.checkThread();
        return this.status;
    }

    private final void setValue(V v) {
        this.checkThread();
        this.value.set(v);
    }

    @Override
    public final V getValue() {
        this.checkThread();
        return (V)this.value.get();
    }

    @Override
    public final ReadOnlyObjectProperty<V> valueProperty() {
        this.checkThread();
        return this.value;
    }

    private final void _setException(Throwable throwable) {
        this.checkThread();
        this.exception.set(throwable);
    }

    @Override
    public final Throwable getException() {
        this.checkThread();
        return (Throwable)this.exception.get();
    }

    @Override
    public final ReadOnlyObjectProperty<Throwable> exceptionProperty() {
        this.checkThread();
        return this.exception;
    }

    private final void setWorkDone(double d) {
        this.checkThread();
        this.workDone.set(d);
    }

    @Override
    public final double getWorkDone() {
        this.checkThread();
        return this.workDone.get();
    }

    @Override
    public final ReadOnlyDoubleProperty workDoneProperty() {
        this.checkThread();
        return this.workDone;
    }

    private final void setTotalWork(double d) {
        this.checkThread();
        this.totalWork.set(d);
    }

    @Override
    public final double getTotalWork() {
        this.checkThread();
        return this.totalWork.get();
    }

    @Override
    public final ReadOnlyDoubleProperty totalWorkProperty() {
        this.checkThread();
        return this.totalWork;
    }

    private final void setProgress(double d) {
        this.checkThread();
        this.progress.set(d);
    }

    @Override
    public final double getProgress() {
        this.checkThread();
        return this.progress.get();
    }

    @Override
    public final ReadOnlyDoubleProperty progressProperty() {
        this.checkThread();
        return this.progress;
    }

    private final void setRunning(boolean bl) {
        this.checkThread();
        this.running.set(bl);
    }

    @Override
    public final boolean isRunning() {
        this.checkThread();
        return this.running.get();
    }

    @Override
    public final ReadOnlyBooleanProperty runningProperty() {
        this.checkThread();
        return this.running;
    }

    @Override
    public final String getMessage() {
        return (String)this.message.get();
    }

    @Override
    public final ReadOnlyStringProperty messageProperty() {
        return this.message;
    }

    @Override
    public final String getTitle() {
        return (String)this.title.get();
    }

    @Override
    public final ReadOnlyStringProperty titleProperty() {
        return this.title;
    }

    @Override
    public final boolean cancel() {
        return this.cancel(true);
    }

    @Override
    public boolean cancel(boolean bl) {
        boolean bl2 = super.cancel(bl);
        if (bl2) {
            if (this.isFxApplicationThread()) {
                this.setStatus(Worker.State.CANCELLED);
            } else {
                this.runLater(new Runnable(){

                    @Override
                    public void run() {
                        Task.this.setStatus(Worker.State.CANCELLED);
                    }
                });
            }
        }
        return bl2;
    }

    protected void updateProgress(long l, long l2) {
        if (l > l2) {
            throw new IllegalArgumentException("The workDone must be <= the max");
        }
        if (l < -1L || l2 < -1L) {
            throw new IllegalArgumentException("The workDone and max cannot be less than -1");
        }
        if (this.isFxApplicationThread()) {
            this._updateProgress(l, l2);
        } else if (this.progressUpdate.getAndSet(new ProgressUpdate(l, l2)) == null) {
            this.runLater(new Runnable(){

                @Override
                public void run() {
                    ProgressUpdate progressUpdate = Task.this.progressUpdate.getAndSet(null);
                    Task.this._updateProgress(progressUpdate.workDone, progressUpdate.totalWork);
                }
            });
        }
    }

    private void _updateProgress(double d, double d2) {
        this.setTotalWork(d2);
        this.setWorkDone(d);
        if (d == -1.0) {
            this.setProgress(-1.0);
        } else {
            this.setProgress(d / d2);
        }
    }

    protected void updateMessage(String string) {
        if (this.isFxApplicationThread()) {
            this.message.set(string);
        } else if (this.messageUpdate.getAndSet(string) == null) {
            this.runLater(new Runnable(){

                @Override
                public void run() {
                    String string = Task.this.messageUpdate.getAndSet(null);
                    Task.this.message.set(string);
                }
            });
        }
    }

    protected void updateTitle(String string) {
        if (this.isFxApplicationThread()) {
            this.title.set(string);
        } else if (this.titleUpdate.getAndSet(string) == null) {
            this.runLater(new Runnable(){

                @Override
                public void run() {
                    String string = Task.this.titleUpdate.getAndSet(null);
                    Task.this.title.set(string);
                }
            });
        }
    }

    private void checkThread() {
        if (!this.isFxApplicationThread()) {
            throw new IllegalStateException("Task must only be used from the FX Application Thread");
        }
    }

    void runLater(Runnable runnable) {
        Platform.runLater(runnable);
    }

    boolean isFxApplicationThread() {
        return Platform.isFxApplicationThread();
    }

    private static final class TaskCallable<V>
    implements Callable<V> {
        private Task<V> task;

        private TaskCallable() {
        }

        @Override
        public V call() throws Exception {
            this.task.runLater(new Runnable(){

                @Override
                public void run() {
                    TaskCallable.this.task.setStatus(Worker.State.SCHEDULED);
                    TaskCallable.this.task.setStatus(Worker.State.RUNNING);
                }
            });
            try {
                final V v = this.task.call();
                this.task.runLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskCallable.this.task.setValue(v);
                        TaskCallable.this.task.setStatus(Worker.State.SUCCEEDED);
                    }
                });
                return v;
            }
            catch (Throwable throwable) {
                this.task.runLater(new Runnable(){

                    @Override
                    public void run() {
                        TaskCallable.this.task._setException(throwable);
                        TaskCallable.this.task.setStatus(Worker.State.FAILED);
                    }
                });
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw new Exception(throwable);
            }
        }
    }

    private static final class ProgressUpdate {
        private double workDone;
        private double totalWork;

        private ProgressUpdate(double d, double d2) {
            this.workDone = d;
            this.totalWork = d2;
        }
    }
}

