/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import com.sun.javafx.collections.ListInvalidationListenerWrapper;
import com.sun.javafx.collections.ObservableListWrapper;
import com.sun.javafx.collections.ObservableMapWrapper;
import com.sun.javafx.collections.SortableList;
import com.sun.javafx.collections.UnmodifiableObservableMap;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import javafx.beans.InvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;

public class FXCollections {
    private static ObservableList EMPTY_OBSERVABLE_LIST = new EmptyObservableList();
    private static Random r;

    private FXCollections() {
    }

    public static <E> ObservableList<E> observableList(List<E> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        return new ObservableListWrapper<E>(list);
    }

    public static <K, V> ObservableMap<K, V> observableMap(Map<K, V> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        return new ObservableMapWrapper<K, V>(map);
    }

    public static <K, V> ObservableMap<K, V> unmodifiableObservableMap(ObservableMap<K, V> observableMap) {
        if (observableMap == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableMap<K, V>(observableMap);
    }

    public static <E> ObservableList<E> observableArrayList() {
        return FXCollections.observableList(new ArrayList());
    }

    public static <E> ObservableList<E> observableArrayList(E ... EArray) {
        ObservableList<E> observableList = FXCollections.observableArrayList();
        observableList.addAll(EArray);
        return observableList;
    }

    public static <E> ObservableList<E> observableArrayList(Collection<? extends E> collection) {
        ObservableList<? extends E> observableList = FXCollections.observableArrayList();
        observableList.addAll(collection);
        return observableList;
    }

    public static <K, V> ObservableMap<K, V> observableHashMap() {
        return FXCollections.observableMap(new HashMap());
    }

    public static <E> ObservableList<E> concat(ObservableList<E> ... observableListArray) {
        if (observableListArray.length == 0) {
            return FXCollections.observableArrayList();
        }
        if (observableListArray.length == 1) {
            return FXCollections.observableArrayList(observableListArray[0]);
        }
        ArrayList<E> arrayList = new ArrayList<E>();
        for (ObservableList<E> observableList : observableListArray) {
            arrayList.addAll(observableList);
        }
        return FXCollections.observableList(arrayList);
    }

    public static <E> ObservableList<E> unmodifiableObservableList(ObservableList<E> observableList) {
        if (observableList == null) {
            throw new NullPointerException();
        }
        return new UnmodifiableObservableListImpl<E>(observableList);
    }

    public static <E> ObservableList<E> checkedObservableList(ObservableList<E> observableList, Class<E> clazz) {
        if (observableList == null) {
            throw new NullPointerException();
        }
        return new CheckedObservableList<E>(observableList, clazz);
    }

    public static <E> ObservableList<E> synchronizedObservableList(ObservableList<E> observableList) {
        if (observableList == null) {
            throw new NullPointerException();
        }
        return new SynchronizedObservableList<E>(observableList);
    }

    public static <E> ObservableList<E> emptyObservableList() {
        return EMPTY_OBSERVABLE_LIST;
    }

    public static <E> ObservableList<E> singletonObservableList(E e) {
        return new SingletonObservableList<E>(e);
    }

    public static <T> void copy(ObservableList<? super T> observableList, List<? extends T> list) {
        int n = list.size();
        if (n > observableList.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Object[] objectArray = observableList.toArray();
        System.arraycopy(list.toArray(), 0, objectArray, 0, n);
        observableList.setAll(objectArray);
    }

    public static <T> void fill(ObservableList<? super T> observableList, T t) {
        Object[] objectArray = new Object[observableList.size()];
        Arrays.fill(objectArray, t);
        observableList.setAll(objectArray);
    }

    public static <T> boolean replaceAll(ObservableList<T> observableList, T t, T t2) {
        Object[] objectArray = observableList.toArray();
        boolean bl = false;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!objectArray[i].equals(t)) continue;
            objectArray[i] = t2;
            bl = true;
        }
        if (bl) {
            observableList.setAll(objectArray);
        }
        return bl;
    }

    public static void reverse(ObservableList observableList) {
        Object[] objectArray = observableList.toArray();
        for (int i = 0; i < objectArray.length / 2; ++i) {
            Object object = objectArray[i];
            objectArray[i] = objectArray[objectArray.length - i - 1];
            objectArray[objectArray.length - i - 1] = object;
        }
        observableList.setAll(objectArray);
    }

    public static void rotate(ObservableList observableList, int n) {
        Object[] objectArray = observableList.toArray();
        int n2 = observableList.size();
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            Object object = objectArray[n3];
            int n5 = n3;
            do {
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                Object object2 = objectArray[n5];
                objectArray[n5] = object;
                object = object2;
                ++n4;
            } while (n5 != n3);
            ++n3;
        }
        observableList.setAll(objectArray);
    }

    public static void shuffle(ObservableList<?> observableList) {
        if (r == null) {
            r = new Random();
        }
        FXCollections.shuffle(observableList, r);
    }

    public static void shuffle(ObservableList observableList, Random random) {
        Object[] objectArray = observableList.toArray();
        for (int i = observableList.size(); i > 1; --i) {
            FXCollections.swap(objectArray, i - 1, random.nextInt(i));
        }
        observableList.setAll(objectArray);
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static <T extends Comparable<? super T>> void sort(ObservableList<T> observableList) {
        if (observableList instanceof SortableList) {
            ((SortableList)((Object)observableList)).sort();
        } else {
            ArrayList<T> arrayList = new ArrayList<T>(observableList);
            Collections.sort(arrayList);
            observableList.setAll((Collection<T>)arrayList);
        }
    }

    public static <T> void sort(ObservableList<T> observableList, Comparator<? super T> comparator) {
        if (observableList instanceof SortableList) {
            ((SortableList)((Object)observableList)).sort(comparator);
        } else {
            ArrayList<T> arrayList = new ArrayList<T>(observableList);
            Collections.sort(arrayList, comparator);
            observableList.setAll((Collection<T>)arrayList);
        }
    }

    private static class CheckedObservableList<T>
    implements ObservableList<T> {
        final ObservableList<T> list;
        final Class<T> type;

        CheckedObservableList(ObservableList<T> observableList, Class<T> clazz) {
            if (observableList == null || clazz == null) {
                throw new NullPointerException();
            }
            this.list = observableList;
            this.type = clazz;
        }

        void typeCheck(Object object) {
            if (!this.type.isInstance(object)) {
                throw new ClassCastException("Attempt to insert " + object.getClass() + " element into collection with element type " + this.type);
            }
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            return this.list.contains(object);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.list.toArray(TArray);
        }

        public String toString() {
            return this.list.toString();
        }

        @Override
        public boolean remove(Object object) {
            return this.list.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return this.list.containsAll(collection);
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            return this.list.removeAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            return this.list.retainAll(collection);
        }

        @Override
        public boolean removeAll(T ... TArray) {
            return this.list.removeAll(TArray);
        }

        @Override
        public boolean retainAll(T ... TArray) {
            return this.list.retainAll(TArray);
        }

        @Override
        public void remove(int n, int n2) {
            this.list.remove(n, n2);
        }

        @Override
        public void clear() {
            this.list.clear();
        }

        @Override
        public boolean equals(Object object) {
            return object == this || this.list.equals(object);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public T get(int n) {
            return (T)this.list.get(n);
        }

        @Override
        public T remove(int n) {
            return (T)this.list.remove(n);
        }

        @Override
        public int indexOf(Object object) {
            return this.list.indexOf(object);
        }

        @Override
        public int lastIndexOf(Object object) {
            return this.list.lastIndexOf(object);
        }

        @Override
        public T set(int n, T t) {
            this.typeCheck(t);
            return this.list.set(n, t);
        }

        @Override
        public void add(int n, T t) {
            this.typeCheck(t);
            this.list.add(n, t);
        }

        @Override
        public boolean addAll(int n, Collection<? extends T> collection) {
            Object[] objectArray = null;
            try {
                objectArray = collection.toArray((Object[])Array.newInstance(this.type, 0));
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
            return this.list.addAll(n, (Collection<T>)Arrays.asList(objectArray));
        }

        @Override
        public boolean addAll(Collection<? extends T> collection) {
            Object[] objectArray = null;
            try {
                objectArray = collection.toArray((Object[])Array.newInstance(this.type, 0));
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
            return this.list.addAll((Collection<T>)Arrays.asList(objectArray));
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<T> listIterator(final int n) {
            return new ListIterator<T>(){
                ListIterator<T> i;
                {
                    this.i = CheckedObservableList.this.list.listIterator(n);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public T next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public T previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    this.i.remove();
                }

                @Override
                public void set(T t) {
                    CheckedObservableList.this.typeCheck(t);
                    this.i.set(t);
                }

                @Override
                public void add(T t) {
                    CheckedObservableList.this.typeCheck(t);
                    this.i.add(t);
                }
            };
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private final Iterator<T> it;
                {
                    this.it = CheckedObservableList.this.list.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.it.hasNext();
                }

                @Override
                public T next() {
                    return this.it.next();
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }

        @Override
        public boolean add(T t) {
            this.typeCheck(t);
            return this.list.add(t);
        }

        @Override
        public List<T> subList(int n, int n2) {
            return Collections.checkedList(this.list.subList(n, n2), this.type);
        }

        @Override
        public boolean addAll(T ... TArray) {
            try {
                Object[] objectArray = (Object[])Array.newInstance(this.type, TArray.length);
                System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
                return this.list.addAll(objectArray);
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
        }

        @Override
        public boolean setAll(T ... TArray) {
            try {
                Object[] objectArray = (Object[])Array.newInstance(this.type, TArray.length);
                System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
                return this.list.setAll(objectArray);
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
        }

        @Override
        public boolean setAll(Collection<? extends T> collection) {
            Object[] objectArray = null;
            try {
                objectArray = collection.toArray((Object[])Array.newInstance(this.type, 0));
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
            return this.list.setAll((Collection<T>)Arrays.asList(objectArray));
        }

        @Override
        public final void addListener(InvalidationListener invalidationListener) {
            this.list.addListener(new ListInvalidationListenerWrapper(this, invalidationListener));
        }

        @Override
        public final void removeListener(InvalidationListener invalidationListener) {
            this.list.removeListener(new ListInvalidationListenerWrapper(this, invalidationListener));
        }

        @Override
        public void addListener(ListChangeListener<? super T> listChangeListener) {
            this.list.addListener(listChangeListener);
        }

        @Override
        public void removeListener(ListChangeListener<? super T> listChangeListener) {
            this.list.removeListener(listChangeListener);
        }
    }

    private static class SynchronizedObservableList<T>
    extends SynchronizedList<T>
    implements ObservableList<T> {
        private final ObservableList<T> backingList;

        SynchronizedObservableList(ObservableList<T> observableList, Object object) {
            super(observableList, object);
            this.backingList = observableList;
        }

        SynchronizedObservableList(ObservableList<T> observableList) {
            this(observableList, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(T ... TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.addAll(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setAll(T ... TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.setAll(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(T ... TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.removeAll(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(T ... TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.retainAll(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                this.backingList.remove(n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean setAll(Collection<? extends T> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.setAll(collection);
            }
        }

        @Override
        public final void addListener(InvalidationListener invalidationListener) {
            this.backingList.addListener(new ListInvalidationListenerWrapper(this, invalidationListener));
        }

        @Override
        public final void removeListener(InvalidationListener invalidationListener) {
            this.backingList.removeListener(new ListInvalidationListenerWrapper(this, invalidationListener));
        }

        @Override
        public void addListener(ListChangeListener<? super T> listChangeListener) {
            this.backingList.addListener(listChangeListener);
        }

        @Override
        public void removeListener(ListChangeListener<? super T> listChangeListener) {
            this.backingList.removeListener(listChangeListener);
        }
    }

    private static class SynchronizedList<T>
    implements List<T> {
        final Object mutex;
        private final List<T> backingList;

        SynchronizedList(List<T> list, Object object) {
            this.backingList = list;
            this.mutex = object;
        }

        SynchronizedList(List<T> list) {
            this(list, new Object());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.backingList.contains(object);
            }
        }

        @Override
        public Iterator<T> iterator() {
            return this.backingList.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] TArray) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.toArray(TArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(T t) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.add(t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.backingList.remove(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.containsAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends T> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.addAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int n, Collection<? extends T> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.addAll(n, collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.removeAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> collection) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.retainAll(collection);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.backingList.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.get(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T set(int n, T t) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.set(n, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int n, T t) {
            Object object = this.mutex;
            synchronized (object) {
                this.backingList.add(n, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T remove(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.remove(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.backingList.indexOf(object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object object) {
            Object object2 = this.mutex;
            synchronized (object2) {
                return this.backingList.lastIndexOf(object);
            }
        }

        @Override
        public ListIterator<T> listIterator() {
            return this.backingList.listIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ListIterator<T> listIterator(int n) {
            Object object = this.mutex;
            synchronized (object) {
                return this.backingList.listIterator(n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<T> subList(int n, int n2) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<T>(this.backingList.subList(n, n2), this.mutex);
            }
        }
    }

    private static class UnmodifiableObservableListImpl<T>
    extends AbstractList<T>
    implements ObservableList<T> {
        private final ObservableList<T> backingList;

        public UnmodifiableObservableListImpl(ObservableList<T> observableList) {
            this.backingList = observableList;
        }

        @Override
        public T get(int n) {
            return (T)this.backingList.get(n);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }

        @Override
        public final void addListener(InvalidationListener invalidationListener) {
            this.backingList.addListener(new ListInvalidationListenerWrapper(this, invalidationListener));
        }

        @Override
        public final void removeListener(InvalidationListener invalidationListener) {
            this.backingList.removeListener(new ListInvalidationListenerWrapper(this, invalidationListener));
        }

        @Override
        public void addListener(ListChangeListener<? super T> listChangeListener) {
            this.backingList.addListener(listChangeListener);
        }

        @Override
        public void removeListener(ListChangeListener<? super T> listChangeListener) {
            this.backingList.removeListener(listChangeListener);
        }

        @Override
        public boolean addAll(T ... TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(T ... TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(Collection<? extends T> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(T ... TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(T ... TArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int n, int n2) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SingletonObservableList<E>
    extends AbstractList<E>
    implements ObservableList<E> {
        private final E element;

        public SingletonObservableList(E e) {
            if (e == null) {
                throw new NullPointerException();
            }
            this.element = e;
        }

        @Override
        public boolean addAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int n, int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
        }

        @Override
        public void addListener(ListChangeListener<? super E> listChangeListener) {
        }

        @Override
        public void removeListener(ListChangeListener<? super E> listChangeListener) {
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object object) {
            return this.element.equals(object);
        }

        @Override
        public E get(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }
    }

    private static class EmptyObservableList<E>
    extends AbstractList<E>
    implements ObservableList<E> {
        private static final ListIterator iterator = new ListIterator(){

            @Override
            public boolean hasNext() {
                return false;
            }

            @Override
            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasPrevious() {
                return false;
            }

            public Object previous() {
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return 0;
            }

            @Override
            public int previousIndex() {
                return -1;
            }

            public void set(Object object) {
                throw new UnsupportedOperationException();
            }

            public void add(Object object) {
                throw new UnsupportedOperationException();
            }
        };

        @Override
        public final void addListener(InvalidationListener invalidationListener) {
        }

        @Override
        public final void removeListener(InvalidationListener invalidationListener) {
        }

        @Override
        public void addListener(ListChangeListener<? super E> listChangeListener) {
        }

        @Override
        public void removeListener(ListChangeListener<? super E> listChangeListener) {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object object) {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return iterator;
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            return collection.isEmpty();
        }

        @Override
        public E get(int n) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        public int indexOf(Object object) {
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            return -1;
        }

        @Override
        public ListIterator<E> listIterator() {
            return iterator;
        }

        @Override
        public ListIterator<E> listIterator(int n) {
            if (n != 0) {
                throw new IndexOutOfBoundsException();
            }
            return iterator;
        }

        @Override
        public List<E> subList(int n, int n2) {
            if (n != 0 || n2 != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this;
        }

        @Override
        public boolean addAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean setAll(Collection<? extends E> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(E ... EArray) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void remove(int n, int n2) {
            throw new UnsupportedOperationException();
        }
    }
}

