/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.value;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public abstract class ObservableValueBase<T>
implements ObservableValue<T> {
    private List<InvalidationListener> listeners;
    private boolean locked = false;

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException("Parameter listener cannot be null.");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<InvalidationListener>(1);
        } else if (this.locked) {
            this.listeners = new ArrayList<InvalidationListener>(this.listeners);
        }
        this.listeners.add(invalidationListener);
    }

    @Override
    public void addListener(ChangeListener<? super T> changeListener) {
        if (changeListener == null) {
            throw new NullPointerException("Parameter listener cannot be null.");
        }
        this.addListener(new ChangeListenerWrapper(changeListener, this.getValue()));
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException("Parameter listener cannot be null.");
        }
        if (this.listeners != null) {
            if (this.locked) {
                this.listeners = new ArrayList<InvalidationListener>(this.listeners);
            }
            this.listeners.remove(invalidationListener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    @Override
    public void removeListener(ChangeListener<? super T> changeListener) {
        if (changeListener == null) {
            throw new NullPointerException("Parameter listener cannot be null.");
        }
        this.removeListener(new ChangeListenerWrapper(changeListener, this.getValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireValueChangedEvent() {
        if (this.listeners != null) {
            List<InvalidationListener> list = this.listeners;
            try {
                this.locked = true;
                int n = list.size();
                for (int i = 0; i < n; ++i) {
                    list.get(i).invalidated(this);
                }
            }
            finally {
                this.locked = false;
            }
        }
    }

    private static class ChangeListenerWrapper<T>
    implements InvalidationListener {
        private final ChangeListener<? super T> listener;
        private T oldValue;

        private ChangeListenerWrapper(ChangeListener<? super T> changeListener, T t) {
            this.listener = changeListener;
            this.oldValue = t;
        }

        @Override
        public void invalidated(Observable observable) {
            ObservableValue observableValue;
            Object t;
            if (observable instanceof ObservableValue && ((t = (observableValue = (ObservableValue)observable).getValue()) == null ? this.oldValue != null : !t.equals(this.oldValue))) {
                this.listener.changed(observableValue, this.oldValue, t);
                this.oldValue = t;
            }
        }

        public int hashCode() {
            return this.listener == null ? 0 : this.listener.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ChangeListenerWrapper) {
                return this.listener.equals(((ChangeListenerWrapper)object).listener);
            }
            return false;
        }
    }
}

