/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.WebPage;
import com.sun.webpane.webkit.JSObject;
import com.sun.webpane.webkit.dom.AttrImpl;
import com.sun.webpane.webkit.dom.CDATASectionImpl;
import com.sun.webpane.webkit.dom.CommentImpl;
import com.sun.webpane.webkit.dom.DocumentFragmentImpl;
import com.sun.webpane.webkit.dom.DocumentImpl;
import com.sun.webpane.webkit.dom.DocumentTypeImpl;
import com.sun.webpane.webkit.dom.ElementImpl;
import com.sun.webpane.webkit.dom.EntityImpl;
import com.sun.webpane.webkit.dom.EntityReferenceImpl;
import com.sun.webpane.webkit.dom.EventImpl;
import com.sun.webpane.webkit.dom.HTMLDocumentImpl;
import com.sun.webpane.webkit.dom.HTMLElementImpl;
import com.sun.webpane.webkit.dom.NamedNodeMapImpl;
import com.sun.webpane.webkit.dom.NodeListImpl;
import com.sun.webpane.webkit.dom.NotationImpl;
import com.sun.webpane.webkit.dom.ProcessingInstructionImpl;
import com.sun.webpane.webkit.dom.TextImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventException;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class NodeImpl
extends JSObject
implements Node,
EventTarget {
    private static SelfDisposer[] hashTable = new SelfDisposer[64];
    private static int hashCount;
    protected final long peer;

    private static int hashPeer(long peer) {
        return (int)(peer ^ 0xFFFFFFFFFFFFFFFFL ^ peer >> 7) & hashTable.length - 1;
    }

    static Node getImpl(long peer, long contextPeer, long jsPeer) {
        int hash = NodeImpl.hashPeer(peer);
        SelfDisposer head = hashTable[hash];
        SelfDisposer prev = null;
        SelfDisposer disposer = head;
        while (disposer != null) {
            SelfDisposer next = disposer.next;
            if (disposer.peer == peer) {
                NodeImpl node = (NodeImpl)disposer.get();
                if (node != null) {
                    return node;
                }
                if (prev != null) {
                    prev.next = next;
                    break;
                }
                NodeImpl.hashTable[hash] = next;
                break;
            }
            prev = disposer;
            disposer = next;
        }
        NodeImpl node = NodeImpl.instantiateNode(peer, contextPeer);
        SelfDisposer disposer2 = new SelfDisposer((Object)node, peer);
        disposer2.next = head;
        NodeImpl.hashTable[hash] = disposer2;
        if (3 * hashCount >= 2 * hashTable.length) {
            NodeImpl.rehash();
        }
        ++hashCount;
        node.jsPeer = jsPeer;
        return node;
    }

    static Node getImpl(long peer, long contextPeer) {
        return NodeImpl.getImpl(peer, contextPeer, 0L);
    }

    private static void rehash() {
        SelfDisposer[] oldTable = hashTable;
        int oldLength = oldTable.length;
        SelfDisposer[] newTable = new SelfDisposer[2 * oldLength];
        hashTable = newTable;
        int i = oldLength;
        while (--i >= 0) {
            SelfDisposer disposer = oldTable[i];
            while (disposer != null) {
                SelfDisposer next = disposer.next;
                int hash = NodeImpl.hashPeer(disposer.peer);
                disposer.next = newTable[hash];
                newTable[hash] = disposer;
                disposer = next;
            }
        }
    }

    protected long getPeer() {
        return this.peer;
    }

    static native long getJSPeerImpl(long var0, long var2);

    @Override
    protected long getJSPeer() {
        if (this.jsPeer == 0L) {
            this.jsPeer = NodeImpl.getJSPeerImpl(this.peer, this.contextPeer);
        }
        return this.jsPeer;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof NodeImpl && this.peer == ((NodeImpl)other).peer;
    }

    NodeImpl(long _peer, long contextPeer) {
        super(0L, contextPeer);
        this.peer = _peer;
    }

    @Override
    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static NodeImpl instantiateNode(long p, long contextPeer) {
        short nodeType = NodeImpl.getNodeTypeImpl(p);
        switch (nodeType) {
            case 1: {
                if (WebPage.twkIsHtmlElement(p)) {
                    return new HTMLElementImpl(p, contextPeer);
                }
                return new ElementImpl(p, contextPeer);
            }
            case 2: {
                return new AttrImpl(p, contextPeer);
            }
            case 3: {
                return new TextImpl(p, contextPeer);
            }
            case 4: {
                return new CDATASectionImpl(p, contextPeer);
            }
            case 5: {
                return new EntityReferenceImpl(p, contextPeer);
            }
            case 6: {
                return new EntityImpl(p, contextPeer);
            }
            case 7: {
                return new ProcessingInstructionImpl(p, contextPeer);
            }
            case 8: {
                return new CommentImpl(p, contextPeer);
            }
            case 9: {
                if (WebPage.twkIsHtmlDocument(p)) {
                    return new HTMLDocumentImpl(p, contextPeer);
                }
                return new DocumentImpl(p, contextPeer);
            }
            case 10: {
                return new DocumentTypeImpl(p, contextPeer);
            }
            case 11: {
                return new DocumentFragmentImpl(p, contextPeer);
            }
            case 12: {
                return new NotationImpl(p, contextPeer);
            }
        }
        return new NodeImpl(p, contextPeer);
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        long p = NodeImpl.insertBeforeImpl(this.getPeer(), ((NodeImpl)newChild).getPeer(), refChild == null ? 0L : ((NodeImpl)refChild).getPeer());
        return p == 0L ? null : newChild;
    }

    static native long insertBeforeImpl(long var0, long var2, long var4);

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        long p = NodeImpl.replaceChildImpl(this.getPeer(), ((NodeImpl)newChild).getPeer(), ((NodeImpl)oldChild).getPeer());
        return p == 0L ? null : oldChild;
    }

    static native long replaceChildImpl(long var0, long var2, long var4);

    @Override
    public Node removeChild(Node oldChild) throws DOMException {
        long p = NodeImpl.removeChildImpl(this.getPeer(), ((NodeImpl)oldChild).getPeer());
        return p == 0L ? null : oldChild;
    }

    static native long removeChildImpl(long var0, long var2);

    @Override
    public Node appendChild(Node newChild) throws DOMException {
        long p = NodeImpl.appendChildImpl(this.getPeer(), ((NodeImpl)newChild).getPeer());
        return p == 0L ? null : newChild;
    }

    static native long appendChildImpl(long var0, long var2);

    @Override
    public boolean hasChildNodes() {
        boolean p = NodeImpl.hasChildNodesImpl(this.getPeer());
        return p;
    }

    static native boolean hasChildNodesImpl(long var0);

    @Override
    public Node cloneNode(boolean deep) {
        long p = NodeImpl.cloneNodeImpl(this.getPeer(), deep);
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long cloneNodeImpl(long var0, boolean var2);

    @Override
    public void normalize() {
        NodeImpl.normalizeImpl(this.getPeer());
    }

    static native void normalizeImpl(long var0);

    @Override
    public boolean isSupported(String feature, String version) {
        boolean p = NodeImpl.isSupportedImpl(this.getPeer(), feature, version);
        return p;
    }

    static native boolean isSupportedImpl(long var0, String var2, String var3);

    @Override
    public boolean hasAttributes() {
        boolean p = NodeImpl.hasAttributesImpl(this.getPeer());
        return p;
    }

    static native boolean hasAttributesImpl(long var0);

    @Override
    public boolean isSameNode(Node other) {
        boolean p = NodeImpl.isSameNodeImpl(this.getPeer(), ((NodeImpl)other).getPeer());
        return p;
    }

    static native boolean isSameNodeImpl(long var0, long var2);

    @Override
    public boolean isEqualNode(Node other) {
        boolean p = NodeImpl.isEqualNodeImpl(this.getPeer(), ((NodeImpl)other).getPeer());
        return p;
    }

    static native boolean isEqualNodeImpl(long var0, long var2);

    @Override
    public String lookupPrefix(String namespaceURI) {
        String p = NodeImpl.lookupPrefixImpl(this.getPeer(), namespaceURI);
        return p;
    }

    static native String lookupPrefixImpl(long var0, String var2);

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        boolean p = NodeImpl.isDefaultNamespaceImpl(this.getPeer(), namespaceURI);
        return p;
    }

    static native boolean isDefaultNamespaceImpl(long var0, String var2);

    @Override
    public String lookupNamespaceURI(String prefix) {
        String p = NodeImpl.lookupNamespaceURIImpl(this.getPeer(), prefix);
        return p;
    }

    static native String lookupNamespaceURIImpl(long var0, String var2);

    @Override
    public short compareDocumentPosition(Node other) {
        short p = NodeImpl.compareDocumentPositionImpl(this.getPeer(), ((NodeImpl)other).getPeer());
        return p;
    }

    static native short compareDocumentPositionImpl(long var0, long var2);

    @Override
    public void addEventListener(String type, EventListener listener, boolean useCapture) {
        NodeImpl.addEventListenerImpl(this.getPeer(), this.contextPeer, type, listener, useCapture);
    }

    static native void addEventListenerImpl(long var0, long var2, String var4, EventListener var5, boolean var6);

    @Override
    public void removeEventListener(String type, EventListener listener, boolean useCapture) {
        NodeImpl.removeEventListenerImpl(this.getPeer(), this.contextPeer, type, listener, useCapture);
    }

    static native void removeEventListenerImpl(long var0, long var2, String var4, EventListener var5, boolean var6);

    @Override
    public boolean dispatchEvent(Event event) throws EventException {
        boolean p = NodeImpl.dispatchEventImpl(this.getPeer(), ((EventImpl)event).getPeer());
        return p;
    }

    static native boolean dispatchEventImpl(long var0, long var2);

    @Override
    public String getNodeName() {
        String p = NodeImpl.getNodeNameImpl(this.getPeer());
        return p;
    }

    static native String getNodeNameImpl(long var0);

    @Override
    public String getNodeValue() {
        String p = NodeImpl.getNodeValueImpl(this.getPeer());
        return p;
    }

    static native String getNodeValueImpl(long var0);

    @Override
    public void setNodeValue(String nodeValue) throws DOMException {
        NodeImpl.setNodeValueImpl(this.getPeer(), nodeValue);
    }

    static native void setNodeValueImpl(long var0, String var2);

    @Override
    public short getNodeType() {
        short p = NodeImpl.getNodeTypeImpl(this.getPeer());
        return p;
    }

    static native short getNodeTypeImpl(long var0);

    @Override
    public Node getParentNode() {
        long p = NodeImpl.getParentNodeImpl(this.getPeer());
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long getParentNodeImpl(long var0);

    @Override
    public NodeList getChildNodes() {
        long p = NodeImpl.getChildNodesImpl(this.getPeer());
        return p == 0L ? null : NodeListImpl.getImpl(p, this.contextPeer);
    }

    static native long getChildNodesImpl(long var0);

    @Override
    public Node getFirstChild() {
        long p = NodeImpl.getFirstChildImpl(this.getPeer());
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long getFirstChildImpl(long var0);

    @Override
    public Node getLastChild() {
        long p = NodeImpl.getLastChildImpl(this.getPeer());
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long getLastChildImpl(long var0);

    @Override
    public Node getPreviousSibling() {
        long p = NodeImpl.getPreviousSiblingImpl(this.getPeer());
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long getPreviousSiblingImpl(long var0);

    @Override
    public Node getNextSibling() {
        long p = NodeImpl.getNextSiblingImpl(this.getPeer());
        return p == 0L ? null : NodeImpl.getImpl(p, this.contextPeer);
    }

    static native long getNextSiblingImpl(long var0);

    @Override
    public NamedNodeMap getAttributes() {
        long p = NodeImpl.getAttributesImpl(this.getPeer());
        return p == 0L ? null : NamedNodeMapImpl.getImpl(p, this.contextPeer);
    }

    static native long getAttributesImpl(long var0);

    @Override
    public Document getOwnerDocument() {
        long p = NodeImpl.getOwnerDocumentImpl(this.getPeer());
        return p == 0L ? null : DocumentImpl.getImpl(p, this.contextPeer);
    }

    static native long getOwnerDocumentImpl(long var0);

    @Override
    public String getNamespaceURI() {
        String p = NodeImpl.getNamespaceURIImpl(this.getPeer());
        return p;
    }

    static native String getNamespaceURIImpl(long var0);

    @Override
    public String getPrefix() {
        String p = NodeImpl.getPrefixImpl(this.getPeer());
        return p;
    }

    static native String getPrefixImpl(long var0);

    @Override
    public void setPrefix(String prefix) throws DOMException {
        NodeImpl.setPrefixImpl(this.getPeer(), prefix);
    }

    static native void setPrefixImpl(long var0, String var2);

    @Override
    public String getLocalName() {
        String p = NodeImpl.getLocalNameImpl(this.getPeer());
        return p;
    }

    static native String getLocalNameImpl(long var0);

    @Override
    public String getBaseURI() {
        String p = NodeImpl.getBaseURIImpl(this.getPeer());
        return p;
    }

    static native String getBaseURIImpl(long var0);

    @Override
    public String getTextContent() {
        String p = NodeImpl.getTextContentImpl(this.getPeer());
        return p;
    }

    static native String getTextContentImpl(long var0);

    @Override
    public void setTextContent(String textContent) throws DOMException {
        NodeImpl.setTextContentImpl(this.getPeer(), textContent);
    }

    static native void setTextContentImpl(long var0, String var2);

    public Element getParentElement() {
        long p = NodeImpl.getParentElementImpl(this.getPeer());
        return p == 0L ? null : ElementImpl.getImpl(p, this.contextPeer);
    }

    static native long getParentElementImpl(long var0);

    @Override
    public Object getUserData(String key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Object getFeature(String feature, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static class SelfDisposer
    extends Disposer.WeakDisposerRecord {
        private final long peer;
        SelfDisposer next;

        SelfDisposer(Object referent, long _peer) {
            super(referent);
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            int hash = NodeImpl.hashPeer(this.peer);
            SelfDisposer head = hashTable[hash];
            SelfDisposer prev = null;
            SelfDisposer disposer = head;
            while (disposer != null) {
                SelfDisposer next = disposer.next;
                if (disposer.peer == this.peer) {
                    disposer.clear();
                    if (prev != null) {
                        prev.next = next;
                    } else {
                        hashTable[hash] = next;
                    }
                    hashCount--;
                    break;
                }
                prev = disposer;
                disposer = next;
            }
            NodeImpl.dispose(this.peer);
        }
    }
}

