/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.webkit.dom;

import com.sun.webpane.platform.Disposer;
import com.sun.webpane.platform.DisposerRecord;
import com.sun.webpane.webkit.dom.MouseEventImpl;
import com.sun.webpane.webkit.dom.NodeImpl;
import com.sun.webpane.webkit.dom.UIEventImpl;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class EventImpl
implements Event {
    protected final long peer;
    protected final long contextPeer;
    static Map<String, Integer> eventTypeMap = new HashMap<String, Integer>();

    protected long getPeer() {
        return this.peer;
    }

    static Event getImpl(long peer, long contextPeer) {
        return new EventImpl(peer, contextPeer);
    }

    EventImpl(long _peer, long contextPeer) {
        this.peer = _peer;
        this.contextPeer = contextPeer;
        Disposer.addRecord(this, new SelfDisposer(_peer));
    }

    public boolean equals(Object that) {
        if (that instanceof EventImpl) {
            return this.peer == ((EventImpl)that).peer;
        }
        return false;
    }

    public int hashCode() {
        long p = this.peer;
        return (int)(p ^ p >> 17);
    }

    private static native void dispose(long var0);

    static void instantiateAndDispatchEvent(long p, long contextPeer, String type, EventListener listener) {
        Event event;
        Integer eventInteger = eventTypeMap.get(type);
        int eventType = eventInteger == null ? 0 : eventInteger;
        switch (eventType) {
            case 1: {
                event = MouseEventImpl.getImpl(p, contextPeer);
                break;
            }
            case 2: {
                event = UIEventImpl.getImpl(p, contextPeer);
                break;
            }
            default: {
                event = EventImpl.getImpl(p, contextPeer);
            }
        }
        listener.handleEvent(event);
    }

    @Override
    public void stopPropagation() {
        EventImpl.stopPropagationImpl(this.getPeer());
    }

    static native void stopPropagationImpl(long var0);

    @Override
    public void preventDefault() {
        EventImpl.preventDefaultImpl(this.getPeer());
    }

    static native void preventDefaultImpl(long var0);

    @Override
    public void initEvent(String eventTypeArg, boolean canBubbleArg, boolean cancelableArg) {
        EventImpl.initEventImpl(this.getPeer(), eventTypeArg, canBubbleArg, cancelableArg);
    }

    static native void initEventImpl(long var0, String var2, boolean var3, boolean var4);

    public void stopImmediatePropagation() {
        EventImpl.stopImmediatePropagationImpl(this.getPeer());
    }

    static native void stopImmediatePropagationImpl(long var0);

    @Override
    public String getType() {
        String p = EventImpl.getTypeImpl(this.getPeer());
        return p;
    }

    static native String getTypeImpl(long var0);

    @Override
    public EventTarget getTarget() {
        long p = EventImpl.getTargetImpl(this.getPeer());
        return p == 0L ? null : (EventTarget)((Object)NodeImpl.getImpl(p, this.contextPeer));
    }

    static native long getTargetImpl(long var0);

    @Override
    public EventTarget getCurrentTarget() {
        long p = EventImpl.getCurrentTargetImpl(this.getPeer());
        return p == 0L ? null : (EventTarget)((Object)NodeImpl.getImpl(p, this.contextPeer));
    }

    static native long getCurrentTargetImpl(long var0);

    @Override
    public short getEventPhase() {
        short p = EventImpl.getEventPhaseImpl(this.getPeer());
        return p;
    }

    static native short getEventPhaseImpl(long var0);

    @Override
    public boolean getBubbles() {
        boolean p = EventImpl.getBubblesImpl(this.getPeer());
        return p;
    }

    static native boolean getBubblesImpl(long var0);

    @Override
    public boolean getCancelable() {
        boolean p = EventImpl.getCancelableImpl(this.getPeer());
        return p;
    }

    static native boolean getCancelableImpl(long var0);

    @Override
    public long getTimeStamp() {
        long p = EventImpl.getTimeStampImpl(this.getPeer());
        return p;
    }

    static native long getTimeStampImpl(long var0);

    public boolean getDefaultPrevented() {
        boolean p = EventImpl.getDefaultPreventedImpl(this.getPeer());
        return p;
    }

    static native boolean getDefaultPreventedImpl(long var0);

    public EventTarget getSrcElement() {
        long p = EventImpl.getSrcElementImpl(this.getPeer());
        return p == 0L ? null : (EventTarget)((Object)NodeImpl.getImpl(p, this.contextPeer));
    }

    static native long getSrcElementImpl(long var0);

    public boolean getReturnValue() {
        boolean p = EventImpl.getReturnValueImpl(this.getPeer());
        return p;
    }

    static native boolean getReturnValueImpl(long var0);

    public void setReturnValue(boolean returnValue) {
        EventImpl.setReturnValueImpl(this.getPeer(), returnValue);
    }

    static native void setReturnValueImpl(long var0, boolean var2);

    public boolean getCancelBubble() {
        boolean p = EventImpl.getCancelBubbleImpl(this.getPeer());
        return p;
    }

    static native boolean getCancelBubbleImpl(long var0);

    public void setCancelBubble(boolean cancelBubble) {
        EventImpl.setCancelBubbleImpl(this.getPeer(), cancelBubble);
    }

    static native void setCancelBubbleImpl(long var0, boolean var2);

    static {
        eventTypeMap.put("mousedown", 1);
        eventTypeMap.put("mouseup", 1);
        eventTypeMap.put("mouseover", 1);
        eventTypeMap.put("mouseout", 1);
        eventTypeMap.put("mousemove", 1);
        eventTypeMap.put("mousedrag", 1);
        eventTypeMap.put("click", 1);
        eventTypeMap.put("dblclick", 1);
        eventTypeMap.put("keydown", 2);
        eventTypeMap.put("keyup", 2);
        eventTypeMap.put("keypress", 2);
        eventTypeMap.put("dragdrop", 2);
        eventTypeMap.put("focus", 2);
        eventTypeMap.put("blur", 2);
        eventTypeMap.put("select", 2);
        eventTypeMap.put("change", 2);
    }

    static class SelfDisposer
    implements DisposerRecord {
        private final long peer;

        SelfDisposer(long _peer) {
            this.peer = _peer;
        }

        @Override
        public void dispose() {
            EventImpl.dispose(this.peer);
        }
    }
}

