/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Ellipse2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.webpane.platform.graphics.WCPath;
import com.sun.webpane.platform.graphics.WCPathIterator;
import com.sun.webpane.platform.graphics.WCRectangle;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

class WCPathImpl
extends WCPath<Path2D> {
    private Path2D path;
    private boolean hasCP = false;
    private static final Logger log = Logger.getLogger(WCPathImpl.class.getName());

    public WCPathImpl() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create empty WCPathImpl({0})", this.getID());
        }
        this.path = new Path2D();
    }

    public WCPathImpl(WCPathImpl wCPathImpl) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Create WCPathImpl({0}) from WCPathImpl({1})", new Object[]{this.getID(), wCPathImpl.getID()});
        }
        this.path = new Path2D(wCPathImpl.path);
        this.hasCP = wCPathImpl.hasCP;
    }

    @Override
    public void addRect(double d, double d2, double d3, double d4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addRect({1},{2},{3},{4})", new Object[]{this.getID(), d, d2, d3, d4});
        }
        this.hasCP = true;
        this.path.append(new RoundRectangle2D((float)d, (float)d2, (float)d3, (int)d4, 0.0f, 0.0f), false);
    }

    @Override
    public void addEllipse(double d, double d2, double d3, double d4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addEllipse({1},{2},{3},{4})", new Object[]{this.getID(), d, d2, d3, d4});
        }
        this.hasCP = true;
        this.path.append(new Ellipse2D((float)d, (float)d2, (float)d3, (float)d4), false);
    }

    @Override
    public void addArcTo(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addArcTo({1},{2},{3},{4})", new Object[]{this.getID(), d, d2, d3, d4});
        }
        this.hasCP = true;
        double d12 = this.path.getCurrentPoint().x;
        double d13 = this.path.getCurrentPoint().y;
        double d14 = d12 - d;
        double d15 = d13 - d2;
        double d16 = d3 - d;
        double d17 = d4 - d2;
        double d18 = Math.sqrt(d14 * d14 + d15 * d15);
        double d19 = Math.sqrt(d16 * d16 + d17 * d17);
        double d20 = (d14 * d16 + d15 * d17) / (d18 * d19);
        double d21 = Math.acos(d20);
        double d22 = d5 / (Math.tan(d21 / 2.0) * d18);
        double d23 = d5 / (Math.tan(d21 / 2.0) * d19);
        double d24 = d + d14 * d22;
        double d25 = d2 + d15 * d22;
        double d26 = d + d16 * d23;
        double d27 = d2 + d17 * d23;
        double d28 = d15 / d18;
        double d29 = -d14 / d18;
        if (d28 * d16 + d29 * d17 < 0.0) {
            d28 = -d28;
            d29 = -d29;
        }
        double d30 = d24 + d28 * d5;
        double d31 = d25 + d29 * d5;
        double d32 = d17 / d19;
        double d33 = -d16 / d19;
        if (d32 * d14 + d29 * d15 < 0.0) {
            d32 = -d32;
            d33 = -d33;
        }
        if (d24 * ((d11 = (d31 + (d10 = d27 + d33 * d5)) / 2.0) - d27) - d25 * ((d9 = (d30 + (d8 = d26 + d32 * d5)) / 2.0) - d26) + d9 * d27 - d11 * d26 < 0.0) {
            d7 = Math.acos((d26 - d9) / d5) * 180.0 / Math.PI;
            if (d27 > d11) {
                d7 += 180.0;
            }
            d6 = 180.0 - d21 * 180.0 / Math.PI + d7;
        } else {
            d7 = Math.acos((d24 - d9) / d5) * 180.0 / Math.PI;
            if (d25 > d11) {
                d7 += 180.0;
            }
            d6 = 180.0 - d21 * 180.0 / Math.PI + d7;
        }
        this.path.lineTo((float)d24, (float)d25);
        this.path.append(new Arc2D((float)(d9 - d5), (float)(d11 - d5), (float)(2.0 * d5), (float)(2.0 * d5), (float)d7, (float)d6, 0), true);
        this.path.lineTo((float)d3, (float)d4);
    }

    @Override
    public void addArc(double d, double d2, double d3, double d4, double d5, boolean bl) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addArc({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), d, d2, d3, d4, d5, bl});
        }
        this.hasCP = true;
        double d6 = 0.001;
        if (!bl) {
            int n;
            if (d5 < 0.0) {
                if (d5 < Math.PI * -2 - d6) {
                    n = (int)(-d5 / (Math.PI * 2));
                    d5 += (double)n * 2.0 * Math.PI;
                }
                d5 += Math.PI * 2;
            } else if (d5 > Math.PI * 2 + d6) {
                n = (int)(d5 / (Math.PI * 2));
                d5 -= (double)n * 2.0 * Math.PI;
            }
            if (d4 < 0.0) {
                if (d4 < Math.PI * -2 - d6) {
                    n = (int)(-d4 / (Math.PI * 2));
                    d4 += (double)n * 2.0 * Math.PI;
                }
                d4 += Math.PI * 2;
            } else if (d4 > Math.PI * 2 + d6) {
                n = (int)(d4 / (Math.PI * 2));
                d4 -= (double)n * 2.0 * Math.PI;
            }
            double d7 = d4 - d5;
            if (d4 < d5) {
                d7 = Math.abs(d7);
            }
            d5 = (float)(Math.PI * 2 - d5);
            Arc2D arc2D = new Arc2D((float)(d - d3), (float)(d2 - d3), (float)(2.0 * d3), (float)(2.0 * d3), (float)(d5 * 180.0 / Math.PI), (float)(d7 * 180.0 / Math.PI), 0);
            PathIterator pathIterator = ((Shape)arc2D).getPathIterator(null);
            Stack<Integer> stack = new Stack<Integer>();
            Stack<Float> stack2 = new Stack<Float>();
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        stack2.add(Float.valueOf(fArray[1]));
                        stack2.add(Float.valueOf(fArray[0]));
                        break;
                    }
                    case 2: {
                        throw new RuntimeException("Unexpected segment: SEG_QUADTO");
                    }
                    case 3: {
                        stack2.add(Float.valueOf(fArray[1]));
                        stack2.add(Float.valueOf(fArray[0]));
                        stack2.add(Float.valueOf(fArray[3]));
                        stack2.add(Float.valueOf(fArray[2]));
                        stack2.add(Float.valueOf(fArray[5]));
                        stack2.add(Float.valueOf(fArray[4]));
                        stack.add(3);
                        break;
                    }
                    case 4: {
                        throw new RuntimeException("Unexpected segment: SEG_CLOSE");
                    }
                }
                pathIterator.next();
            }
            stack.add(0);
            Path2D path2D = new Path2D();
            while (stack.size() > 0) {
                switch ((Integer)stack.pop()) {
                    case 0: {
                        path2D.moveTo(((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue());
                        break;
                    }
                    case 1: {
                        path2D.lineTo(((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue());
                        break;
                    }
                    case 2: {
                        path2D.quadTo(((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue());
                        break;
                    }
                    case 3: {
                        path2D.curveTo(((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue(), ((Float)stack2.pop()).floatValue());
                    }
                }
            }
            this.path.append(path2D, true);
        } else {
            int n;
            if (d5 < 0.0) {
                if (d5 < Math.PI * -2 - d6) {
                    n = (int)(-d5 / (Math.PI * 2));
                    d5 += (double)n * 2.0 * Math.PI;
                }
                d5 += Math.PI * 2;
            } else if (d5 > Math.PI * 2 + d6) {
                n = (int)(d5 / (Math.PI * 2));
                d5 -= (double)n * 2.0 * Math.PI;
            }
            if (d4 < 0.0) {
                if (d4 < Math.PI * -2 - d6) {
                    n = (int)(-d4 / (Math.PI * 2));
                    d4 += (double)n * 2.0 * Math.PI;
                }
                d4 += Math.PI * 2;
            } else if (d4 > Math.PI * 2 + d6) {
                n = (int)(d4 / (Math.PI * 2));
                d4 -= (double)n * 2.0 * Math.PI;
            }
            double d8 = d4 - d5;
            if (d4 < d5 && (d8 += Math.PI * 2) < d6) {
                d8 += Math.PI * 2;
            }
            if (Math.abs(d4) > d6) {
                d4 = (float)(Math.PI * 2 - d4);
            }
            this.path.append(new Arc2D((float)(d - d3), (float)(d2 - d3), (float)(2.0 * d3), (float)(2.0 * d3), (float)(d4 * 180.0 / Math.PI), (float)(d8 * 180.0 / Math.PI), 0), true);
        }
    }

    @Override
    public boolean contains(int n, double d, double d2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).contains({1},{2},{3})", new Object[]{this.getID(), n, d, d2});
        }
        int n2 = this.path.getWindingRule();
        this.path.setWindingRule(n);
        boolean bl = this.path.contains((float)d, (float)d2);
        this.path.setWindingRule(n2);
        return bl;
    }

    @Override
    public WCRectangle getBounds() {
        RectBounds rectBounds = this.path.getBounds();
        return new WCRectangle(rectBounds.getMinX(), rectBounds.getMinY(), rectBounds.getWidth(), rectBounds.getHeight());
    }

    @Override
    public void clear() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).clear()", this.getID());
        }
        this.hasCP = false;
        this.path.reset();
    }

    @Override
    public void moveTo(double d, double d2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).moveTo({1},{2})", new Object[]{this.getID(), d, d2});
        }
        this.hasCP = true;
        this.path.moveTo((float)d, (float)d2);
    }

    @Override
    public void addLineTo(double d, double d2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addLineTo({1},{2})", new Object[]{this.getID(), d, d2});
        }
        this.hasCP = true;
        this.path.lineTo((float)d, (float)d2);
    }

    @Override
    public void addQuadCurveTo(double d, double d2, double d3, double d4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addQuadCurveTo({1},{2},{3},{4})", new Object[]{this.getID(), d, d2, d3, d4});
        }
        this.hasCP = true;
        this.path.quadTo((float)d, (float)d2, (float)d3, (float)d4);
    }

    @Override
    public void addBezierCurveTo(double d, double d2, double d3, double d4, double d5, double d6) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addBezierCurveTo({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), d, d2, d3, d4, d5, d6});
        }
        this.hasCP = true;
        this.path.curveTo((float)d, (float)d2, (float)d3, (float)d4, (float)d5, (float)d6);
    }

    @Override
    public void addPath(WCPath wCPath) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).addPath({1})", new Object[]{this.getID(), wCPath.getID()});
        }
        this.hasCP = this.hasCP || ((WCPathImpl)wCPath).hasCP;
        this.path.append(((WCPathImpl)wCPath).path, false);
    }

    @Override
    public void closeSubpath() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).closeSubpath()", this.getID());
        }
        this.path.closePath();
    }

    @Override
    public boolean hasCurrentPoint() {
        return this.hasCP;
    }

    @Override
    public boolean isEmpty() {
        PathIterator pathIterator = this.path.getPathIterator(null);
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 1: 
                case 2: 
                case 3: {
                    return false;
                }
            }
            pathIterator.next();
        }
        return true;
    }

    @Override
    public int getWindingRule() {
        return 1 - this.path.getWindingRule();
    }

    @Override
    public void setWindingRule(int n) {
        this.path.setWindingRule(1 - n);
    }

    @Override
    public Path2D getPlatformPath() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).getPath() BEGIN=====", this.getID());
            PathIterator pathIterator = this.path.getPathIterator(null);
            float[] fArray = new float[6];
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        log.log(Level.FINE, "SEG_MOVETO ({0},{1})", new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1])});
                        break;
                    }
                    case 1: {
                        log.log(Level.FINE, "SEG_LINETO ({0},{1})", new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1])});
                        break;
                    }
                    case 2: {
                        log.log(Level.FINE, "SEG_QUADTO ({0},{1},{2},{3})", new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3])});
                        break;
                    }
                    case 3: {
                        log.log(Level.FINE, "SEG_CUBICTO ({0},{1},{2},{3},{4},{5})", new Object[]{Float.valueOf(fArray[0]), Float.valueOf(fArray[1]), Float.valueOf(fArray[2]), Float.valueOf(fArray[3]), Float.valueOf(fArray[4]), Float.valueOf(fArray[5])});
                        break;
                    }
                    case 4: {
                        log.fine("SEG_CLOSE");
                    }
                }
                pathIterator.next();
            }
            log.fine("========getPath() END=====");
        }
        return this.path;
    }

    @Override
    public WCPathIterator getPathIterator() {
        final PathIterator pathIterator = this.path.getPathIterator(null);
        return new WCPathIterator(){

            @Override
            public int getWindingRule() {
                return pathIterator.getWindingRule();
            }

            @Override
            public boolean isDone() {
                return pathIterator.isDone();
            }

            @Override
            public void next() {
                pathIterator.next();
            }

            @Override
            public int currentSegment(double[] dArray) {
                float[] fArray = new float[6];
                int n = pathIterator.currentSegment(fArray);
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = fArray[i];
                }
                return n;
            }
        };
    }

    @Override
    public void translate(double d, double d2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).translate({1}, {2})", new Object[]{this.getID(), d, d2});
        }
        this.path.transform(BaseTransform.getTranslateInstance(d, d2));
    }

    @Override
    public void transform(double d, double d2, double d3, double d4, double d5, double d6) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCPathImpl({0}).transform({1},{2},{3},{4},{5},{6})", new Object[]{this.getID(), d, d2, d3, d4, d5, d6});
        }
        this.path.transform(BaseTransform.getInstance(d, d2, d3, d4, d5, d6));
    }
}

