/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.sg.prism.NGPath;
import com.sun.javafx.sg.prism.NGPolygon;
import com.sun.javafx.sg.prism.NGRectangle;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.javafx.sg.prism.NGText;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.Image;
import com.sun.prism.Texture;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.Paint;
import com.sun.prism.shape.ShapeRep;
import com.sun.scenario.effect.Blend;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.DropShadow;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.prism.PrDrawable;
import com.sun.scenario.effect.impl.prism.PrEffectHelper;
import com.sun.scenario.effect.impl.prism.PrFilterContext;
import com.sun.webpane.platform.graphics.Ref;
import com.sun.webpane.platform.graphics.RenderTheme;
import com.sun.webpane.platform.graphics.ScrollBarTheme;
import com.sun.webpane.platform.graphics.WCFont;
import com.sun.webpane.platform.graphics.WCGradient;
import com.sun.webpane.platform.graphics.WCGraphicsContext;
import com.sun.webpane.platform.graphics.WCGraphicsManager;
import com.sun.webpane.platform.graphics.WCIcon;
import com.sun.webpane.platform.graphics.WCImage;
import com.sun.webpane.platform.graphics.WCPath;
import com.sun.webpane.platform.graphics.WCPoint;
import com.sun.webpane.platform.graphics.WCRectangle;
import com.sun.webpane.platform.graphics.WCTransform;
import com.sun.webpane.sg.prism.PrismImage;
import com.sun.webpane.sg.prism.WCLinearGradient;
import com.sun.webpane.sg.prism.WCPathImpl;
import com.sun.webpane.sg.prism.WCRadialGradient;
import com.sun.webpane.sg.prism.WCStrokeImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCGraphicsPrismContext
extends WCGraphicsContext {
    private static final Logger log = Logger.getLogger(WCGraphicsPrismContext.class.getName());
    private Graphics baseGraphics;
    private Stack<ContextState> states = new Stack();
    private ContextState state = new ContextState();
    private boolean isInitialized;
    private Graphics cachedGraphics = null;
    private static final BasicStroke focusRingStroke = new BasicStroke(1.1f, 0, 1, 0.0f, new float[]{1.0f}, 0.0f);

    public WCGraphicsPrismContext(Graphics graphics) {
        this.init(graphics, true);
    }

    protected WCGraphicsPrismContext() {
    }

    protected final void init(Graphics graphics, boolean bl) {
        if (this.isInitialized) {
            return;
        }
        if (graphics != null && bl) {
            this.state.setClip(graphics.getClipRect());
            this.state.setTransform(new Affine2D(graphics.getTransformNoClone()));
            this.state.setAlpha(graphics.getExtraAlpha());
        }
        this.baseGraphics = graphics != null ? graphics.getRenderTarget().createGraphics() : null;
        this.isInitialized = true;
    }

    protected boolean isInitialized() {
        return this.isInitialized;
    }

    private void resetCachedGraphics() {
        this.cachedGraphics = null;
    }

    @Override
    public Object getPlatformGraphics() {
        return this.getGraphics(false);
    }

    public Graphics getGraphics(boolean bl) {
        Object object;
        if (this.cachedGraphics == null) {
            object = this.state.getLayerNoClone();
            this.cachedGraphics = object != null ? ((Layer)object).getGraphics() : this.baseGraphics;
            this.state.apply(this.cachedGraphics);
            if (log.isLoggable(Level.FINE)) {
                log.fine("getPlatformGraphics for " + this + " : " + this.cachedGraphics);
            }
        }
        object = this.cachedGraphics.getClipRectNoClone();
        return bl && object != null && ((Rectangle)object).isEmpty() ? null : this.cachedGraphics;
    }

    @Override
    public void saveState() {
        log.fine("saving state");
        this.states.push(this.state);
        this.state = this.state.clone();
    }

    private void startNewLayer(Layer layer) {
        Rectangle rectangle = this.state.getClipNoClone();
        Affine2D affine2D = new Affine2D(BaseTransform.getTranslateInstance(-rectangle.x, -rectangle.y));
        affine2D.concatenate(this.state.getTransformNoClone());
        rectangle.x = 0;
        rectangle.y = 0;
        this.state.setTransform(affine2D);
        this.state.setLayer(layer);
        this.resetCachedGraphics();
    }

    private void renderLayer(Layer layer) {
        WCTransform wCTransform = this.getTransform();
        this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, layer.getX(), layer.getY()));
        Graphics graphics = this.getGraphics(true);
        if (graphics != null) {
            layer.render(graphics);
        }
        layer.dispose();
        this.setTransform(wCTransform);
    }

    @Override
    public void restoreState() {
        log.fine("restoring state");
        if (this.states.isEmpty()) {
            assert (false) : "Unbalanced restoreState";
            return;
        }
        Layer layer = this.state.getLayerNoClone();
        this.state = this.states.pop();
        if (layer != this.state.getLayerNoClone()) {
            this.renderLayer(layer);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Popped layer " + layer);
            }
        } else {
            this.resetCachedGraphics();
        }
    }

    @Override
    public void setClip(WCPath wCPath) {
        Affine2D affine2D = new Affine2D(this.state.getTransformNoClone());
        Rectangle rectangle = this.state.getClipNoClone();
        wCPath.transform(affine2D.getMxx(), affine2D.getMyx(), affine2D.getMxy(), affine2D.getMyy(), affine2D.getMxt(), affine2D.getMyt());
        wCPath.translate(-rectangle.x, -rectangle.y);
        ClipLayer clipLayer = new ClipLayer(this.getGraphics(false), rectangle, wCPath);
        this.startNewLayer(clipLayer);
        if (log.isLoggable(Level.FINE)) {
            log.fine("setClip(WCPath " + wCPath.getID() + ")");
            log.fine("Pushed layer " + clipLayer);
        }
    }

    public Rectangle transformClip(Rectangle rectangle) {
        if (rectangle == null) {
            return null;
        }
        float[] fArray = new float[]{rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y, rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height};
        this.state.getTransformNoClone().transform(fArray, 0, fArray, 0, 4);
        float f = Math.min(fArray[0], Math.min(fArray[2], Math.min(fArray[4], fArray[6])));
        float f2 = Math.max(fArray[0], Math.max(fArray[2], Math.max(fArray[4], fArray[6])));
        float f3 = Math.min(fArray[1], Math.min(fArray[3], Math.min(fArray[5], fArray[7])));
        float f4 = Math.max(fArray[1], Math.max(fArray[3], Math.max(fArray[5], fArray[7])));
        return new Rectangle(new RectBounds(f, f3, f2, f4));
    }

    public void setClip(Rectangle rectangle) {
        this.state.clip(this.transformClip(rectangle));
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setClip({0})", rectangle);
            Rectangle rectangle2 = this.state.getClipNoClone();
            if (rectangle2 != null && rectangle2.width >= 2 && rectangle2.height >= 2) {
                WCTransform wCTransform = this.getTransform();
                this.setTransform(new WCTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0));
                Graphics graphics = this.getGraphics(true);
                if (graphics != null) {
                    float f = (float)Math.random();
                    graphics.setPaint(new Color(f, 1.0f - f, 0.5f, 0.1f));
                    graphics.setStroke(new BasicStroke());
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics.setPaint(new Color(1.0f - f, f, 0.5f, 1.0f));
                    graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.setTransform(wCTransform);
                this.state.clip(new Rectangle(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2));
            }
        }
        if (this.cachedGraphics != null) {
            this.cachedGraphics.setClipRect(this.state.getClipNoClone());
        }
    }

    @Override
    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    @Override
    public void setClip(WCRectangle wCRectangle) {
        this.setClip(new Rectangle((int)wCRectangle.getX(), (int)wCRectangle.getY(), (int)wCRectangle.getWidth(), (int)wCRectangle.getHeight()));
    }

    @Override
    public WCRectangle getClip() {
        Rectangle rectangle = this.state.getClipNoClone();
        return rectangle == null ? null : new WCRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    public void translate(float f, float f2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "translate({0},{1})", new Object[]{Float.valueOf(f), Float.valueOf(f2)});
        }
        this.state.translate(f, f2);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.translate(f, f2);
        }
    }

    @Override
    public void scale(float f, float f2) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("scale(" + f + " " + f2 + ")");
        }
        this.state.scale(f, f2);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.scale(f, f2);
        }
    }

    @Override
    public void rotate(float f) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("rotate(" + f + ")");
        }
        this.state.rotate(f);
        if (this.cachedGraphics != null) {
            this.cachedGraphics.setTransform(this.state.getTransformNoClone());
        }
    }

    @Override
    public void setPlatformFont(WCFont wCFont) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setPlatformFont(" + wCFont + ")");
        }
        this.state.setFont(wCFont);
    }

    @Override
    public void fillRect(float f, float f2, float f3, float f4, Integer n) {
        Object object;
        if (log.isLoggable(Level.FINE)) {
            object = n != null ? "fillRect(%f, %f, %f, %f, 0x%x)" : "fillRect(%f, %f, %f, %f, null)";
            log.fine(String.format((String)object, Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), n));
        }
        if ((object = this.getGraphics(true)) != null) {
            Paint paint = n != null ? WCGraphicsPrismContext.createColor(n) : this.state.getPaintNoClone();
            DropShadow dropShadow = this.state.getShadowNoClone();
            if (dropShadow != null) {
                WCGraphicsPrismContext.render((Graphics)object, dropShadow, WCGraphicsPrismContext.createShape(paint, f, f2, f3, f4, 0.0f, 0.0f));
            } else {
                object.setPaint(paint);
                object.fillRect(f, f2, f3, f4);
            }
        }
    }

    @Override
    public void fillRoundedRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, int n) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("fillRoundedRect(%f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, %f, 0x%x)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8), Float.valueOf(f9), Float.valueOf(f10), Float.valueOf(f11), Float.valueOf(f12), n));
        }
        if ((graphics = this.getGraphics(true)) != null) {
            float f13 = (f5 + f7 + f9 + f11) / 2.0f;
            float f14 = (f6 + f8 + f10 + f12) / 2.0f;
            Color color = WCGraphicsPrismContext.createColor(n);
            DropShadow dropShadow = this.state.getShadowNoClone();
            if (dropShadow != null) {
                WCGraphicsPrismContext.render(graphics, dropShadow, WCGraphicsPrismContext.createShape(color, f, f2, f3, f4, f13, f14));
            } else {
                graphics.setPaint(color);
                graphics.fillRoundRect(f, f2, f3, f4, f13, f14);
            }
        }
    }

    @Override
    public void clearRect(float f, float f2, float f3, float f4) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("clearRect(%f, %f, %f, %f)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4)));
        }
        if ((graphics = this.getGraphics(true)) != null) {
            graphics.clearQuad(f, f2, f + f3, f2 + f4);
        }
    }

    @Override
    public void setFillColor(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("setFillColor(0x%x)", n));
        }
        this.state.setPaint(WCGraphicsPrismContext.createColor(n));
    }

    @Override
    public void setFillGradient(WCGradient wCGradient) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setFillGradient(" + wCGradient + ")");
        }
        this.state.setPaint((Gradient)wCGradient.getPlatformGradient());
    }

    @Override
    public void setStrokeStyle(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setStrokeStyle({0})", n);
        }
        this.state.getStrokeNoClone().setStyle(n);
    }

    @Override
    public void setStrokeColor(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("setStrokeColor(0x%x)", n));
        }
        this.state.getStrokeNoClone().setPaint(WCGraphicsPrismContext.createColor(n));
    }

    @Override
    public void setStrokeWidth(float f) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setStrokeWidth({0})", new Object[]{Float.valueOf(f)});
        }
        this.state.getStrokeNoClone().setThickness(f);
    }

    @Override
    public void setStrokeGradient(WCGradient wCGradient) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setStrokeGradient(" + wCGradient + ")");
        }
        this.state.getStrokeNoClone().setPaint((Gradient)wCGradient.getPlatformGradient());
    }

    @Override
    public void setLineDash(float f, float ... fArray) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setLineDash(" + f + ":" + fArray + ")");
        }
        this.state.getStrokeNoClone().setDashOffset(f);
        this.state.getStrokeNoClone().setDashSizes(fArray);
    }

    @Override
    public void setLineCap(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setLineCap(" + n + ")");
        }
        this.state.getStrokeNoClone().setLineCap(n);
    }

    @Override
    public void setLineJoin(int n) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setLineJoin(" + n + ")");
        }
        this.state.getStrokeNoClone().setLineJoin(n);
    }

    @Override
    public void setMiterLimit(float f) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("setMiterLimit(" + f + ")");
        }
        this.state.getStrokeNoClone().setMiterLimit(f);
    }

    @Override
    public void setShadow(float f, float f2, float f3, int n) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "setShadow({0},{1},{2},{3})", new Object[]{Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), n});
        }
        this.state.setShadow(WCGraphicsPrismContext.createShadow(f, f2, f3, n));
    }

    @Override
    public void drawPolygon(float[] fArray, boolean bl) {
        Object object;
        if (log.isLoggable(Level.FINE)) {
            object = "[";
            for (int i = 0; i < fArray.length; ++i) {
                object = (String)object + fArray[i] + ",";
            }
            object = (String)object + "]";
            log.log(Level.FINE, "drawPolygon({0},{1})", new Object[]{object, bl});
        }
        if ((object = this.getGraphics(true)) != null) {
            Polygon polygon = new Polygon();
            polygon.updatePolygon(fArray);
            polygon.setAntialiased(bl);
            ShapeRep shapeRep = object.getResourceFactory().createPathRep(false);
            object.setPaint(this.state.getPaintNoClone());
            shapeRep.fill((Graphics)object, polygon.getShape());
            BasicStroke basicStroke = this.state.getStrokeNoClone().getPlatformStroke();
            if (basicStroke != null) {
                object.setPaint(this.state.getStrokeNoClone().getPaint());
                shapeRep.draw((Graphics)object, polygon.getStrokeShape());
            }
        }
    }

    @Override
    public void drawLine(int n, int n2, int n3, int n4) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawLine({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        if ((graphics = this.getGraphics(true)) != null && this.state.getStrokeNoClone().apply(graphics)) {
            graphics.drawLine(n, n2, n3, n4);
        }
    }

    @Override
    public void drawPattern(WCImage wCImage, WCRectangle wCRectangle, WCTransform wCTransform, WCPoint wCPoint, WCRectangle wCRectangle2) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawPattern({0}, {1}, {2}, {3})", new Object[]{wCRectangle2.getIntX(), wCRectangle2.getIntY(), wCRectangle2.getIntWidth(), wCRectangle2.getIntHeight()});
        }
        if (wCImage != null && (graphics = this.getGraphics(true)) != null) {
            float f = wCPoint.getX() + wCRectangle.getX() * (float)wCTransform.getMatrix()[0];
            float f2 = wCPoint.getY() + wCRectangle.getY() * (float)wCTransform.getMatrix()[3];
            float f3 = wCRectangle.getWidth() * (float)wCTransform.getMatrix()[0];
            float f4 = wCRectangle.getHeight() * (float)wCTransform.getMatrix()[3];
            graphics.setPaint(new ImagePattern(((PrismImage)wCImage).getImage(), f, f2, f3, f4, false));
            graphics.fillRect(wCRectangle2.getX(), wCRectangle2.getY(), wCRectangle2.getWidth(), wCRectangle2.getHeight());
        }
    }

    @Override
    public void drawImage(WCImage wCImage, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawImage(img, dst({0},{1},{2},{3}), src({4},{5},{6},{7}))", new Object[]{Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5), Float.valueOf(f6), Float.valueOf(f7), Float.valueOf(f8)});
        }
        if (wCImage != null && (graphics = this.getGraphics(true)) != null) {
            ((PrismImage)wCImage).draw(graphics, (int)f, (int)f2, (int)(f + f3), (int)(f2 + f4), (int)f5, (int)f6, (int)(f5 + f7), (int)(f6 + f8));
        }
    }

    @Override
    public void drawBitmapImage(ByteBuffer byteBuffer, int n, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics(true);
        if (graphics != null) {
            byteBuffer.order(ByteOrder.nativeOrder());
            Image image = Image.fromByteBgraPreData(byteBuffer, n3, n4);
            Texture texture = graphics.getResourceFactory().createTexture(image);
            graphics.drawTexture(texture, n, n2, n + n3, n2 + n4, 0.0f, 0.0f, n3, n4);
            texture.dispose();
        }
    }

    @Override
    public void drawIcon(WCIcon wCIcon, int n, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "UNIMPLEMENTED drawIcon ({0}, {1})", new Object[]{n, n2});
        }
    }

    @Override
    public void drawRect(int n, int n2, int n3, int n4) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawRect({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        if ((graphics = this.getGraphics(true)) != null) {
            Paint paint = this.state.getPaintNoClone();
            if (paint != null && paint.isOpaque()) {
                graphics.setPaint(paint);
                graphics.fillRect(n, n2, n3, n4);
            }
            if (this.state.getStrokeNoClone().apply(graphics)) {
                graphics.drawRect(n, n2, n3, n4);
            }
        }
    }

    @Override
    public void drawString(WCFont wCFont, int[] nArray, float[] fArray, float f, float f2) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawStringAsGlyph({0} {1}, {2})", new Object[]{nArray, Float.valueOf(f), Float.valueOf(f2)});
        }
        if ((graphics = this.getGraphics(true)) != null) {
            String string = new String(nArray, 0, nArray.length);
            PGFont pGFont = (PGFont)wCFont.getPlatformFont();
            Paint paint = this.state.getPaintNoClone();
            DropShadow dropShadow = this.state.getShadowNoClone();
            if (dropShadow != null) {
                WCGraphicsPrismContext.render(graphics, dropShadow, WCGraphicsPrismContext.createShape(paint, string, pGFont, f, f2));
            } else {
                graphics.setPaint(paint);
                graphics.drawString(string, pGFont.getStrike(graphics.getTransformNoClone()), f, f2);
            }
        }
    }

    @Override
    public void drawString(WCFont wCFont, String string, boolean bl, int n, int n2, float f, float f2, float f3, float f4) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawString({0}, {1}, {2})", new Object[]{string, Float.valueOf(f3), Float.valueOf(f4)});
        }
        int[] nArray = new int[n2 - n];
        for (int i = 0; i < n2 - n; ++i) {
            nArray[i] = string.codePointAt(bl ? n2 - i - 1 : n + i);
        }
        this.drawString(wCFont, nArray, null, f3, f4);
    }

    @Override
    public void setComposite(int n) {
        log.log(Level.FINE, "(NOT SUPPORTED) setComposite({0})", n);
    }

    @Override
    public void drawEllipse(int n, int n2, int n3, int n4) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "drawEllipse({0}, {1}, {2}, {3})", new Object[]{n, n2, n3, n4});
        }
        if ((graphics = this.getGraphics(true)) != null) {
            graphics.setPaint(this.state.getPaintNoClone());
            graphics.fillEllipse(n, n2, n3, n4);
            if (this.state.getStrokeNoClone().apply(graphics)) {
                graphics.drawEllipse(n, n2, n3, n4);
            }
        }
    }

    @Override
    public void drawFocusRing(int n, int n2, int n3, int n4, int n5) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, String.format("drawFocusRing: %d, %d, %d, %d, 0x%x", n, n2, n3, n4, n5));
        }
        if ((graphics = this.getGraphics(true)) != null) {
            graphics.setPaint(WCGraphicsPrismContext.createColor(n5));
            BasicStroke basicStroke = graphics.getStroke();
            graphics.setStroke(focusRingStroke);
            graphics.drawRoundRect(n, n2, n3, n4, 4.0f, 4.0f);
            graphics.setStroke(basicStroke);
        }
    }

    @Override
    public void setAlpha(float f) {
        log.log(Level.FINE, "setAlpha({0})", Float.valueOf(f));
        this.state.setAlpha(f);
        if (null != this.cachedGraphics) {
            this.cachedGraphics.setExtraAlpha(this.state.getAlpha());
        }
    }

    @Override
    public float getAlpha() {
        return this.state.getAlpha();
    }

    @Override
    public void beginTransparencyLayer(float f) {
        TransparencyLayer transparencyLayer = new TransparencyLayer(this.getGraphics(false), this.state.getClipNoClone(), f);
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("beginTransparencyLayer(%s)", transparencyLayer));
        }
        this.saveState();
        this.startNewLayer(transparencyLayer);
    }

    @Override
    public void endTransparencyLayer() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("endTransparencyLayer(%s)", this.state.getLayerNoClone()));
        }
        this.restoreState();
    }

    @Override
    public void drawWidget(RenderTheme renderTheme, Ref ref, int n, int n2) {
        renderTheme.drawWidget(this, ref, n, n2);
    }

    @Override
    public void drawScrollbar(ScrollBarTheme scrollBarTheme, Ref ref, int n, int n2, int n3, int n4) {
        scrollBarTheme.paint(this, ref, n, n2, n3, n4);
    }

    private static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null) {
            return rectangle2;
        }
        RectBounds rectBounds = rectangle.toRectBounds();
        rectBounds.intersectWith(rectangle2);
        rectangle.setBounds(rectBounds);
        return rectangle;
    }

    static Color createColor(int n) {
        float f = (float)(0xFF & n >> 24) / 255.0f;
        float f2 = (float)(0xFF & n >> 16) / 255.0f;
        float f3 = (float)(0xFF & n >> 8) / 255.0f;
        float f4 = (float)(0xFF & n) / 255.0f;
        return new Color(f2, f3, f4, f);
    }

    private static Color4f createColor4f(int n) {
        float f = (float)(0xFF & n >> 24) / 255.0f;
        float f2 = (float)(0xFF & n >> 16) / 255.0f;
        float f3 = (float)(0xFF & n >> 8) / 255.0f;
        float f4 = (float)(0xFF & n) / 255.0f;
        return new Color4f(f2, f3, f4, f);
    }

    private static DropShadow createShadow(float f, float f2, float f3, int n) {
        DropShadow dropShadow = new DropShadow();
        dropShadow.setOffsetX((int)f);
        dropShadow.setOffsetY((int)f2);
        dropShadow.setRadius(f3 < 0.0f ? 0.0f : (f3 > 127.0f ? 127.0f : f3));
        dropShadow.setColor(WCGraphicsPrismContext.createColor4f(n));
        return dropShadow;
    }

    private static NGShape createShape(Paint paint, String string, PGFont pGFont, float f, float f2) {
        NGText nGText = new NGText();
        nGText.setFillPaint(paint);
        nGText.setText(string);
        nGText.setFont(pGFont);
        nGText.setLocation(f, f2);
        nGText.setTextOrigin(2);
        nGText.setContentBounds(nGText.computeContentBounds(new RectBounds(), null));
        return nGText;
    }

    private static NGShape createShape(Paint paint, float f, float f2, float f3, float f4, float f5, float f6) {
        NGRectangle nGRectangle = new NGRectangle();
        nGRectangle.setFillPaint(paint);
        nGRectangle.updateRectangle(f, f2, f3, f4, f5, f6);
        nGRectangle.setContentBounds(new RectBounds(f, f2, f + f3, f2 + f4));
        return nGRectangle;
    }

    private static void render(Graphics graphics, Effect effect, NGShape nGShape) {
        boolean bl = graphics.hasPreCullingBits();
        graphics.setHasPreCullingBits(false);
        nGShape.setEffect(effect);
        nGShape.render(graphics, null, null);
        graphics.setHasPreCullingBits(bl);
    }

    @Override
    public void strokeArc(int n, int n2, int n3, int n4, int n5, int n6) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("strokeArc(%d, %d, %d, %d, %d, %d)", n, n2, n3, n4, n5, n6));
        }
        if ((graphics = this.getGraphics(true)) != null && this.state.getStrokeNoClone().apply(graphics)) {
            graphics.draw(new Arc2D(n, n2, n3, n4, n5, n6, 0));
        }
    }

    @Override
    public WCImage getImage() {
        return null;
    }

    @Override
    public void strokeRect(float f, float f2, float f3, float f4, float f5, int n) {
        Graphics graphics;
        if (log.isLoggable(Level.FINE)) {
            log.fine(String.format("strokeRect_FFFFF(%f, %f, %f, %f, %f)", Float.valueOf(f), Float.valueOf(f2), Float.valueOf(f3), Float.valueOf(f4), Float.valueOf(f5)));
        }
        if ((graphics = this.getGraphics(true)) != null) {
            graphics.setStroke(new BasicStroke(f5, 0, 0, Math.max(1.0f, f5)));
            graphics.setPaint(this.state.getStrokeNoClone().getPaint());
            graphics.drawRect(f, f2, f3, f4);
        }
    }

    @Override
    public void strokePath(WCPath wCPath) {
        Graphics graphics;
        log.fine("strokePath");
        if (wCPath != null && (graphics = this.getGraphics(true)) != null && this.state.getStrokeNoClone().apply(graphics)) {
            graphics.draw((Path2D)wCPath.getPlatformPath());
        }
    }

    @Override
    public void fillPath(WCPath wCPath) {
        Graphics graphics;
        log.fine("fillPath");
        if (wCPath != null && (graphics = this.getGraphics(true)) != null) {
            graphics.setPaint(this.state.getPaintNoClone());
            graphics.fill((Path2D)wCPath.getPlatformPath());
        }
    }

    @Override
    public void setTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine2D affine2D = new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        this.state.setTransform(affine2D);
        this.resetCachedGraphics();
    }

    @Override
    public WCTransform getTransform() {
        Affine2D affine2D = this.state.getTransformNoClone();
        return new WCTransform(affine2D.getMxx(), affine2D.getMyx(), affine2D.getMxy(), affine2D.getMyy(), affine2D.getMxt(), affine2D.getMyt());
    }

    @Override
    public void concatTransform(WCTransform wCTransform) {
        double[] dArray = wCTransform.getMatrix();
        Affine2D affine2D = new Affine2D(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        this.state.concatTransform(affine2D);
        this.resetCachedGraphics();
    }

    @Override
    public void dispose() {
        assert (this.states.isEmpty()) : "Unbalanced saveState/restoreState";
        while (!this.states.isEmpty()) {
            this.restoreState();
        }
        Layer layer = this.state.getLayerNoClone();
        if (layer != null) {
            this.renderLayer(layer);
        }
    }

    @Override
    public WCGradient createLinearGradient(WCPoint wCPoint, WCPoint wCPoint2) {
        return new WCLinearGradient(wCPoint, wCPoint2);
    }

    @Override
    public WCGradient createRadialGradient(WCPoint wCPoint, float f, WCPoint wCPoint2, float f2) {
        return new WCRadialGradient(wCPoint, f, wCPoint2, f2);
    }

    private static class ClipLayer
    extends Layer {
        private WCPath normalizedToClipPath;

        public ClipLayer(Graphics graphics, Rectangle rectangle, WCPath wCPath) {
            super(graphics, rectangle);
            this.normalizedToClipPath = wCPath;
        }

        @Override
        public void render(Graphics graphics) {
            Path2D path2D = ((WCPathImpl)this.normalizedToClipPath).getPlatformPath();
            NGPath nGPath = new NGPath();
            nGPath.updateWithPath2d(path2D);
            nGPath.setFillPaint(Color.BLACK);
            PrDrawable prDrawable = (PrDrawable)Effect.getCompatibleImage(this.fctx, this.buffer.getPhysicalWidth(), this.buffer.getPhysicalHeight());
            Graphics graphics2 = prDrawable.createGraphics();
            nGPath.render(graphics2, null, null);
            Blend blend = new Blend(Blend.Mode.SRC_IN, new PassThrough(prDrawable), new PassThrough(this.buffer));
            PrEffectHelper.render(blend, graphics, 0.0f, 0.0f, null);
            Effect.releaseCompatibleImage(this.fctx, prDrawable);
        }

        public String toString() {
            return String.format("ClipLayer[%d,%d + %dx%d, path %s]", this.x, this.y, this.buffer.getPhysicalWidth(), this.buffer.getPhysicalHeight(), this.normalizedToClipPath);
        }

        public static class PassThrough
        extends Effect {
            private PrDrawable img;

            public PassThrough(PrDrawable prDrawable) {
                this.img = prDrawable;
            }

            @Override
            public ImageData filter(FilterContext filterContext, BaseTransform baseTransform, Rectangle rectangle, Object object, Effect effect) {
                return new ImageData(filterContext, this.img, new Rectangle((int)baseTransform.getMxt(), (int)baseTransform.getMyt(), this.img.getPhysicalWidth(), this.img.getPhysicalHeight()));
            }

            @Override
            public RectBounds getBounds(BaseTransform baseTransform, Effect effect) {
                return null;
            }

            @Override
            public Effect.AccelType getAccelType(FilterContext filterContext) {
                return Effect.AccelType.INTRINSIC;
            }
        }
    }

    private static class TransparencyLayer
    extends Layer {
        private float opacity;

        public TransparencyLayer(Graphics graphics, Rectangle rectangle, float f) {
            super(graphics, rectangle);
            this.opacity = f;
        }

        @Override
        public void render(Graphics graphics) {
            float f = graphics.getExtraAlpha();
            graphics.setExtraAlpha(this.opacity);
            graphics.drawTexture(this.buffer.getTextureObject(), 0.0f, 0.0f, this.buffer.getPhysicalWidth(), this.buffer.getPhysicalHeight());
            graphics.setExtraAlpha(f);
        }

        public String toString() {
            return String.format("TransparencyLayer[%d,%d + %dx%d, opacity %.2f]", this.x, this.y, this.buffer.getPhysicalWidth(), this.buffer.getPhysicalHeight(), Float.valueOf(this.opacity));
        }
    }

    private static abstract class Layer {
        FilterContext fctx;
        PrDrawable buffer;
        int x;
        int y;

        Layer(Graphics graphics, Rectangle rectangle) {
            this.x = rectangle.x;
            this.y = rectangle.y;
            assert (rectangle.width > 0 && rectangle.height > 0) : "Zero sized layer";
            int n = Math.max(rectangle.width, 1);
            int n2 = Math.max(rectangle.height, 1);
            this.fctx = PrFilterContext.getInstance(graphics.getAssociatedScreen());
            this.buffer = (PrDrawable)Effect.getCompatibleImage(this.fctx, n, n2);
        }

        public Graphics getGraphics() {
            return this.buffer.createGraphics();
        }

        public abstract void render(Graphics var1);

        public void dispose() {
            Effect.releaseCompatibleImage(this.fctx, this.buffer);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }

    private static class ContextState {
        private final WCStrokeImpl stroke = new WCStrokeImpl();
        private WCFont font;
        private Rectangle clip;
        private Paint paint;
        private float alpha;
        private DropShadow shadow;
        private Affine2D xform;
        private Layer layer;

        public ContextState() {
            this.clip = null;
            this.paint = Color.BLACK;
            this.alpha = 1.0f;
            this.xform = new Affine2D();
        }

        private ContextState(WCStrokeImpl wCStrokeImpl, Paint paint, WCFont wCFont, Rectangle rectangle, Affine2D affine2D, DropShadow dropShadow, Layer layer, float f) {
            this.stroke.copyFrom(wCStrokeImpl);
            this.paint = paint;
            this.font = wCFont == null ? null : wCFont.copy();
            this.clip = rectangle == null ? null : new Rectangle(rectangle);
            this.xform = new Affine2D(affine2D);
            this.shadow = dropShadow;
            this.layer = layer;
            this.alpha = f;
        }

        protected ContextState clone() {
            return new ContextState(this.getStrokeNoClone(), this.getPaintNoClone(), this.getFontNoClone(), this.getClipNoClone(), this.getTransformNoClone(), this.getShadowNoClone(), this.getLayerNoClone(), this.getAlpha());
        }

        public void apply(Graphics graphics) {
            graphics.setTransform(this.getTransformNoClone());
            graphics.setClipRect(this.getClipNoClone());
            graphics.setExtraAlpha(this.getAlpha());
        }

        public WCStrokeImpl getStrokeNoClone() {
            return this.stroke;
        }

        public Paint getPaintNoClone() {
            return this.paint;
        }

        public void setPaint(Paint paint) {
            this.paint = paint;
        }

        public WCFont getFontNoClone() {
            if (this.font == null) {
                this.font = WCGraphicsManager.getGraphicsManager().getWCFont("Times New Roman", "Times New Roman", 12.0, false, false);
            }
            return this.font;
        }

        public void setFont(WCFont wCFont) {
            this.font = wCFont;
        }

        public Rectangle getClipNoClone() {
            return this.clip;
        }

        public Layer getLayerNoClone() {
            return this.layer;
        }

        public void setLayer(Layer layer) {
            this.layer = layer;
        }

        public void setClip(Rectangle rectangle) {
            this.clip = rectangle;
        }

        public void clip(Rectangle rectangle) {
            if (null == this.clip) {
                this.clip = rectangle;
            } else {
                this.clip.intersectWith(rectangle);
            }
        }

        public void setAlpha(float f) {
            this.alpha = f;
        }

        public float getAlpha() {
            return this.alpha;
        }

        public void setShadow(DropShadow dropShadow) {
            this.shadow = dropShadow;
        }

        public DropShadow getShadowNoClone() {
            return this.shadow;
        }

        public Affine2D getTransformNoClone() {
            return this.xform;
        }

        public void setTransform(Affine2D affine2D) {
            this.xform.setTransform(affine2D);
        }

        public void concatTransform(Affine2D affine2D) {
            this.xform.concatenate(affine2D);
        }

        public void translate(double d, double d2) {
            this.xform.translate(d, d2);
        }

        public void scale(double d, double d2) {
            this.xform.scale(d, d2);
        }

        public void rotate(double d) {
            this.xform.rotate(d);
        }
    }

    static class Polygon
    extends NGPolygon {
        Polygon() {
        }

        @Override
        public Shape getStrokeShape() {
            return super.getStrokeShape();
        }
    }
}

