/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webpane.sg.prism;

import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.GraphicsPipeline;
import com.sun.webpane.platform.graphics.WCFont;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCFontImpl
extends WCFont {
    private static final Logger log = Logger.getLogger(WCFontImpl.class.getName());
    private static final double MIN_FONT_WIDTH = 5.0;
    private static final HashMap<String, String> availableFonts;
    private final PGFont font;
    private FontStrike strike;
    private double xheight = Double.MAX_VALUE;

    static String mapLogicalFontFamilyName(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("serif")) {
            return "Serif";
        }
        if (string2.equals("sans-serif") || string2.equals("sansserif") || string2.equals("helvetica") || string2.equals("dialog")) {
            return "SansSerif";
        }
        if (string2.equals("monospace") || string2.equals("monospaced")) {
            return "Monospaced";
        }
        return null;
    }

    static String getDefaultWebFontFamilyName() {
        return "Serif";
    }

    WCFontImpl(String string, String string2, double d, boolean bl, boolean bl2) {
        String string3;
        if (d < 5.0) {
            d = 5.0;
        }
        if (string == null) {
            string = WCFontImpl.getDefaultWebFontFamilyName();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "WCFontImpl({0}, {1}, {2}, {3})", new Object[]{string, d, bl, bl2});
        }
        if ((string3 = availableFonts.get(string.toLowerCase())) != null) {
            this.font = GraphicsPipeline.getPipeline().getFontFactory().createFont(string3, bl2, bl, (float)d);
            return;
        }
        String string4 = WCFontImpl.mapLogicalFontFamilyName(string);
        if (string4 != null) {
            this.font = GraphicsPipeline.getPipeline().getFontFactory().createFont(string4, bl2, bl, (float)d);
            return;
        }
        String string5 = WCFontImpl.getDefaultWebFontFamilyName();
        this.font = GraphicsPipeline.getPipeline().getFontFactory().createFont(string5, bl2, bl, (float)d);
    }

    private WCFontImpl(PGFont pGFont) {
        this.font = pGFont;
    }

    @Override
    public int getOffsetForPosition(String string, int n, float f, float f2) {
        return 0;
    }

    private FontStrike getFontStrike() {
        if (this.strike == null) {
            this.strike = this.font.getStrike(BaseTransform.IDENTITY_TRANSFORM);
        }
        return this.strike;
    }

    @Override
    public double getGlyphWidth(int n) {
        double d = this.getFontStrike().getCharAdvance((char)n);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getGlyphWidth({0}, {1}, {2})= {3}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), new String(Character.toChars(n)), d});
        }
        return (float)d;
    }

    @Override
    public double getXHeight() {
        if (this.xheight == Double.MAX_VALUE) {
            this.xheight = this.getFontStrike().getGlyph('x').getBBox().getHeight();
            if (this.xheight == 0.0) {
                this.xheight = (double)this.getFontStrike().getMetrics().getAscent() * 0.56;
            }
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getXHeight({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), (int)this.xheight});
        }
        return this.xheight;
    }

    @Override
    public int[] getGlyphCodes(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i] == 8226 ? 42 : nArray[i];
        }
        return nArray2;
    }

    @Override
    public double getStringLength(String string, float f, float f2) {
        if (string.length() == 0) {
            return 0.0;
        }
        double d = this.getFontStrike().getStringWidth(string);
        log.log(Level.FINER, "getStringLength({0}) = {1}", new Object[]{string, d});
        return d;
    }

    @Override
    public double[] getStringBounds(String string, int n, int n2, boolean bl, float f, float f2) {
        RectBounds rectBounds = this.getFontStrike().getStringBounds(string.substring(n, n2));
        log.log(Level.FINER, "getStringBounds({0}, {1}, {2}) = [{3}, {4}, {5}, {6}])", new Object[]{string, n, n2, Float.valueOf(rectBounds.getMinX()), Float.valueOf(rectBounds.getMinY()), Float.valueOf(rectBounds.getWidth()), Float.valueOf(rectBounds.getHeight())});
        return new double[]{rectBounds.getMinX(), rectBounds.getMinY(), rectBounds.getWidth(), rectBounds.getHeight()};
    }

    @Override
    public int getAscent() {
        int n = -((int)this.getFontStrike().getMetrics().getAscent());
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getAscent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), n});
        }
        return n;
    }

    @Override
    public int getDescent() {
        int n = (int)this.getFontStrike().getMetrics().getDescent();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getDescent({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), n});
        }
        return n;
    }

    @Override
    public int getHeight() {
        int n = (int)this.getFontStrike().getMetrics().getLineHeight();
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "getHeight({0}, {1}) = {2}", new Object[]{this.font.getName(), Float.valueOf(this.font.getSize()), n});
        }
        return n;
    }

    @Override
    public boolean hasUniformLineMetrics() {
        return false;
    }

    @Override
    public WCFont copy() {
        return new WCFontImpl(this.font);
    }

    @Override
    public Object getPlatformFont() {
        return this.font;
    }

    @Override
    public int hash() {
        return this.font.hashCode();
    }

    @Override
    public boolean compare(WCFont wCFont) {
        if (wCFont == null) {
            return false;
        }
        return this.font.equals((PGFont)wCFont.getPlatformFont());
    }

    static {
        String[] stringArray = GraphicsPipeline.getPipeline().getFontFactory().getFontFamilyNames();
        availableFonts = new HashMap(stringArray.length);
        for (String string : stringArray) {
            availableFonts.put(string.toLowerCase(), string);
        }
    }
}

