/*
 * Decompiled with CFR 0.152.
 */
package com.sun.t2k;

import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.runtime.NativeLibLoader;
import com.sun.t2k.CompositeFontResource;
import com.sun.t2k.LogicalFont;
import com.sun.t2k.MacFontFinder;
import com.sun.t2k.T2KCompositeFontResource;
import com.sun.t2k.T2KFont;
import com.sun.t2k.T2KFontFile;
import com.sun.t2k.WindowsFontMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class T2KFontFactory
implements FontFactory {
    static boolean debugFonts = false;
    static boolean isWindows;
    static boolean isMacOSX;
    private static String jreFontDir;
    private static final String jreDefaultFont = "Lucida Sans Regular";
    private static final String jreDefaultFontLC = "lucida sans regular";
    private static final String jreDefaultFontFamily = "Lucida Sans";
    private static final String jreDefaultFontFile = "LucidaSansRegular.ttf";
    private static MacFontFinder macFontFinder;
    static HashMap<String, FontResource> fontResourceMap;
    static HashMap<String, CompositeFontResource> compResourceMap;
    static T2KFontFactory theT2KFontFactory;
    private static final String[] STR_ARRAY;
    private static volatile HashMap<String, String> fontToFileMap;
    private static HashMap<String, String> fileToFontMap;
    private static HashMap<String, String> fontToFamilyNameMap;
    private static HashMap<String, ArrayList<String>> familyToFontListMap;
    static String sysFontDir;
    static String userFontDir;
    private static ArrayList<String> allFamilyNames;
    private static ArrayList<String> allFontNames;
    private static Thread fileCloser;
    HashMap<String, T2KFontFile> embeddedFonts;
    private static float systemFontSize;
    private static String systemFontFamily;

    public static synchronized T2KFontFactory getFontFactory() {
        if (theT2KFontFactory == null) {
            theT2KFontFactory = new T2KFontFactory();
        }
        return theT2KFontFactory;
    }

    private T2KFontFactory() {
    }

    static String dotStyleStr(boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2) {
                return "";
            }
            return ".italic";
        }
        if (!bl2) {
            return ".bold";
        }
        return ".bolditalic";
    }

    static void storeInMap(String string, FontResource fontResource) {
        if (string == null || fontResource == null) {
            return;
        }
        if (fontResource instanceof T2KCompositeFontResource) {
            System.err.println(string + " is a composite " + fontResource);
            Thread.dumpStack();
            return;
        }
        fontResourceMap.put(string.toLowerCase(), fontResource);
    }

    /*
     * WARNING - void declaration
     */
    synchronized FontResource getFontResource(String string, boolean bl, boolean bl2, boolean bl3) {
        void var9_16;
        int n;
        String string2;
        Object object;
        if (string == null || string.isEmpty()) {
            return null;
        }
        String string22 = string.toLowerCase();
        String string3 = T2KFontFactory.dotStyleStr(bl, bl2);
        Object object3 = T2KFontFactory.lookupResource(string22 + string3, bl3);
        if (object3 != null) {
            return object3;
        }
        if (this.embeddedFonts != null && bl3) {
            object3 = T2KFontFactory.lookupResource(string22 + string3, false);
            if (object3 != null) {
                return new T2KCompositeFontResource((FontResource)object3, string22 + string3);
            }
            for (T2KFontFile object22 : this.embeddedFonts.values()) {
                object = object22.getFamilyName().toLowerCase();
                if (!((String)object).equals(string22)) continue;
                return new T2KCompositeFontResource(object22, string22 + string3);
            }
        }
        if (isWindows && (string2 = WindowsFontMap.findFontFile(string22, n = (bl ? 1 : 0) + (bl2 ? 2 : 0))) != null && (object3 = T2KFontFile.createFontResource(null, string2)) != null) {
            if (bl == object3.isBold() && bl2 == object3.isItalic() && !string3.equals("")) {
                T2KFontFactory.storeInMap(string22 + string3, (FontResource)object3);
            }
            if (bl3) {
                object3 = new T2KCompositeFontResource((FontResource)object3, string22 + string3);
            }
            return object3;
        }
        ArrayList<String> arrayList = null;
        if (isMacOSX) {
            String[] stringArray;
            object3 = MacFontFinder.getMacFontResource(string, bl, bl2, bl3);
            if (object3 != null) {
                return object3;
            }
            if (familyToFontListMap != null) {
                arrayList = familyToFontListMap.get(string22);
            } else {
                familyToFontListMap = new HashMap(10);
            }
            if (arrayList == null && (stringArray = macFontFinder.getFontNamesOfFontFamily(string)) != null) {
                arrayList = new ArrayList(stringArray.length);
                Collections.addAll(arrayList, stringArray);
                familyToFontListMap.put(string22, arrayList);
            }
        } else {
            T2KFontFactory.getFullNameToFileMap();
            arrayList = familyToFontListMap.get(string22);
        }
        if (arrayList == null) {
            return null;
        }
        Object var9_15 = null;
        object = null;
        Object object2 = null;
        Object object4 = null;
        for (String string4 : arrayList) {
            String string5 = string4.toLowerCase();
            object3 = fontResourceMap.get(string5);
            if (object3 == null) {
                String string6 = T2KFontFactory.findFile(string5);
                object3 = T2KFontFile.createFontResource(string4, string6);
                if (object3 == null) continue;
                T2KFontFactory.storeInMap(string5, (FontResource)object3);
            }
            if (bl == object3.isBold() && bl2 == object3.isItalic()) {
                T2KFontFactory.storeInMap(string22 + string3, (FontResource)object3);
                if (bl3) {
                    object3 = new T2KCompositeFontResource((FontResource)object3, string22 + string3);
                }
                return object3;
            }
            if (!object3.isBold()) {
                if (!object3.isItalic()) {
                    Object object5 = object3;
                    continue;
                }
                object2 = object3;
                continue;
            }
            if (!object3.isItalic()) {
                object = object3;
                continue;
            }
            object4 = object3;
        }
        object3 = !bl && !bl2 ? (object != null ? object : (object2 != null ? object2 : object4)) : (bl && !bl2 ? (var9_16 != null ? var9_16 : (object4 != null ? object4 : object2)) : (!bl && bl2 ? (object4 != null ? object4 : (var9_16 != null ? var9_16 : object)) : (object2 != null ? object2 : (object != null ? object : var9_16))));
        if (object3 != null) {
            T2KFontFactory.storeInMap(string22 + string3, (FontResource)object3);
            if (bl3) {
                object3 = new T2KCompositeFontResource((FontResource)object3, string22 + string3);
            }
        }
        return object3;
    }

    @Override
    public synchronized PGFont createFont(String string, boolean bl, boolean bl2, float f) {
        FontResource fontResource = null;
        if (string != null && !string.isEmpty()) {
            PGFont pGFont = LogicalFont.getLogicalFont(string, bl, bl2, f);
            if (pGFont != null) {
                return pGFont;
            }
            fontResource = this.getFontResource(string, bl, bl2, true);
        }
        if (fontResource == null) {
            return LogicalFont.getLogicalFont("System", bl, bl2, f);
        }
        return new T2KFont(fontResource, fontResource.getFullName(), f);
    }

    @Override
    public synchronized PGFont createFont(String string, float f) {
        FontResource fontResource = null;
        if (string != null && !string.isEmpty()) {
            PGFont pGFont = LogicalFont.getLogicalFont(string, f);
            if (pGFont != null) {
                return pGFont;
            }
            fontResource = this.getFontResource(string, null, true);
        }
        if (fontResource == null) {
            return LogicalFont.getLogicalFont("System Regular", f);
        }
        return new T2KFont(fontResource, fontResource.getFullName(), f);
    }

    static FontResource lookupResource(String string, boolean bl) {
        if (bl) {
            return compResourceMap.get(string);
        }
        return fontResourceMap.get(string);
    }

    synchronized FontResource getFontResource(String string, String string2, boolean bl) {
        Object object;
        String string3;
        FontResource fontResource = null;
        if (string != null) {
            string3 = string.toLowerCase();
            object = T2KFontFactory.lookupResource(string3, bl);
            if (object != null) {
                return object;
            }
            if (this.embeddedFonts != null && bl) {
                fontResource = T2KFontFactory.lookupResource(string3, false);
                if (fontResource != null) {
                    fontResource = new T2KCompositeFontResource(fontResource, string3);
                }
                if (fontResource != null) {
                    return fontResource;
                }
            }
        }
        if (isWindows && string != null && (object = WindowsFontMap.findFontFile(string3 = string.toLowerCase(), -1)) != null && (fontResource = T2KFontFile.createFontResource(null, (String)object)) != null) {
            if (bl) {
                fontResource = new T2KCompositeFontResource(fontResource, string3);
            }
            return fontResource;
        }
        T2KFontFactory.getFullNameToFileMap();
        if (string != null && string2 != null) {
            fontResource = T2KFontFile.createFontResource(string, string2);
            if (bl) {
                fontResource = new T2KCompositeFontResource(fontResource, string.toLowerCase());
            }
            if (fontResource != null) {
                return fontResource;
            }
        }
        if (string != null && (fontResource = this.getFontResourceByFullName(string, bl)) != null) {
            return fontResource;
        }
        if (string2 != null && (fontResource = this.getFontResourceByFileName(string2, bl)) != null) {
            return fontResource;
        }
        return null;
    }

    static boolean isInstalledFont(String string) {
        if (isWindows && string.toLowerCase().contains("\\windows\\fonts")) {
            return true;
        }
        T2KFontFactory.getFullNameToFileMap();
        File file = new File(string);
        String string2 = file.getName();
        return fileToFontMap.get(string2.toLowerCase()) != null;
    }

    private synchronized FontResource getFontResourceByFileName(String string, boolean bl) {
        String string2;
        Object object;
        if (fontToFileMap.size() <= 1) {
            return null;
        }
        String string3 = fileToFontMap.get(string.toLowerCase());
        if (string3 == null && (object = T2KFontFile.createFontResource(string, 0)) != null) {
            String string4 = object.getFullName().toLowerCase();
            if (object != null) {
                T2KFontFactory.storeInMap(string4, (FontResource)object);
            }
            if (bl) {
                object = new T2KCompositeFontResource((FontResource)object, string4);
            }
            return object;
        }
        object = string3.toLowerCase();
        FontResource fontResource = T2KFontFactory.lookupResource((String)object, bl);
        if (fontResource == null && (string2 = T2KFontFactory.findFile((String)object)) != null) {
            fontResource = T2KFontFile.createFontResource(string3, string2);
            if (fontResource != null) {
                T2KFontFactory.storeInMap((String)object, fontResource);
            }
            if (bl) {
                fontResource = new T2KCompositeFontResource(fontResource, (String)object);
            }
        }
        return fontResource;
    }

    private synchronized FontResource getFontResourceByFullName(String string, boolean bl) {
        String string2 = string.toLowerCase();
        if (fontToFileMap.size() <= 1) {
            string = jreDefaultFont;
        }
        FontResource fontResource = null;
        String string3 = T2KFontFactory.findFile(string2);
        if (string3 != null && (fontResource = T2KFontFile.createFontResource(string, string3)) != null) {
            T2KFontFactory.storeInMap(string2, fontResource);
            if (bl) {
                fontResource = new T2KCompositeFontResource(fontResource, string2);
            }
        }
        return fontResource;
    }

    static FontResource getDefaultFontResource(boolean bl) {
        FontResource fontResource = T2KFontFactory.lookupResource(jreDefaultFontLC, bl);
        if (fontResource == null) {
            fontResource = T2KFontFile.createFontResource(jreDefaultFont, jreFontDir + jreDefaultFontFile);
            if (fontResource == null) {
                String string;
                String string2;
                Iterator<String> iterator = fontToFileMap.keySet().iterator();
                while (iterator.hasNext() && (fontResource = T2KFontFile.createFontResource(jreDefaultFontLC, string2 = T2KFontFactory.findFile(string = iterator.next()))) == null) {
                }
                if (fontResource == null) {
                    return null;
                }
            }
            T2KFontFactory.storeInMap(jreDefaultFontLC, fontResource);
            if (bl) {
                fontResource = new T2KCompositeFontResource(fontResource, jreDefaultFontLC);
            }
        }
        return fontResource;
    }

    static String findFile(String string) {
        if (string.equals(jreDefaultFont.toLowerCase())) {
            return jreFontDir + jreDefaultFontFile;
        }
        String string2 = null;
        if (isWindows) {
            T2KFontFactory.getFullNameToFileMap();
            string2 = T2KFontFactory.findFileWindows(string);
        } else if (isMacOSX) {
            File file;
            if (fontToFileMap != null) {
                string2 = fontToFileMap.get(string);
            }
            if (string2 == null) {
                string2 = macFontFinder.getFilePathOfFont(string, 12.0f);
            }
            if (string2 != null && (file = new File(string2)).isAbsolute()) {
                return string2;
            }
        }
        return string2;
    }

    private static native byte[] getFontPath();

    private static native String regReadFontLink(String var0);

    private static native String getEUDCFontFile();

    static void getPlatformFontDirs() {
        if (userFontDir != null || sysFontDir != null) {
            return;
        }
        byte[] byArray = T2KFontFactory.getFontPath();
        String string = new String(byArray);
        int n = string.indexOf(59);
        if (n < 0) {
            sysFontDir = string;
        } else {
            sysFontDir = string.substring(0, n);
            userFontDir = string.substring(n + 1, string.length());
        }
    }

    static ArrayList<String>[] getLinkedFonts(String string, boolean bl) {
        String[] stringArray;
        String string2;
        ArrayList[] arrayListArray = new ArrayList[]{new ArrayList(), new ArrayList()};
        if (isMacOSX) {
            arrayListArray[0].add("file:///Library/Fonts/Arial%20Unicode.ttf");
            arrayListArray[1].add("Arial Unicode MS");
            return arrayListArray;
        }
        if (!isWindows) {
            return arrayListArray;
        }
        if (bl) {
            arrayListArray[0].add(null);
            arrayListArray[1].add(string);
        }
        if ((string2 = T2KFontFactory.regReadFontLink(string)) != null && string2.length() > 0) {
            stringArray = string2.split("\u0000");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string3;
                String[] stringArray2 = stringArray[i].split(",");
                int n2 = stringArray2.length;
                String string4 = stringArray2[0];
                String string5 = string3 = n2 > 1 ? stringArray2[1] : null;
                if (string3 != null && arrayListArray[1].contains(string3) || string3 == null && arrayListArray[0].contains(string4)) continue;
                arrayListArray[0].add(string4);
                arrayListArray[1].add(string3);
            }
        }
        if ((stringArray = T2KFontFactory.getEUDCFontFile()) != null) {
            arrayListArray[0].add(stringArray);
            arrayListArray[1].add(null);
        }
        return arrayListArray;
    }

    private static void resolveWindowsFonts(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        String string;
        ArrayList<String> arrayList = null;
        for (String object : hashMap2.keySet()) {
            Object n = hashMap.get(object);
            if (n != null) continue;
            int string2 = object.indexOf("  ");
            if (string2 > 0) {
                string = object.substring(0, string2);
                n = hashMap.get(string = string.concat(object.substring(string2 + 1)));
                if (n == null || hashMap2.containsKey(string)) continue;
                hashMap.remove(string);
                hashMap.put(object, (String)n);
                continue;
            }
            if (object.equals("marlett")) {
                hashMap.put(object, "marlett.ttf");
                continue;
            }
            if (object.equals("david")) {
                n = hashMap.get("david regular");
                if (n == null) continue;
                hashMap.remove("david regular");
                hashMap.put("david", (String)n);
                continue;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(object);
        }
        if (arrayList != null) {
            HashSet hashSet = new HashSet();
            HashMap<String, String> hashMap4 = new HashMap<String, String>();
            hashMap4.putAll(hashMap);
            for (String string3 : hashMap2.keySet()) {
                hashMap4.remove(string3);
            }
            for (String i : hashMap4.keySet()) {
                hashSet.add(hashMap4.get(i));
                hashMap.remove(i);
            }
            T2KFontFactory.resolveFontFiles(hashSet, arrayList, hashMap, hashMap2, hashMap3);
            if (arrayList.size() > 0) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    ArrayList<String> arrayList2;
                    string = arrayList.get(i);
                    String string2 = hashMap2.get(string);
                    if (string2 != null && (arrayList2 = hashMap3.get(string2)) != null && arrayList2.size() <= 1) {
                        hashMap3.remove(string2);
                    }
                    hashMap2.remove(string);
                }
            }
        }
    }

    static void resolveFontFiles(HashSet<String> hashSet, ArrayList<String> arrayList, HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3) {
        for (String string : hashSet) {
            try {
                T2KFontFile t2KFontFile;
                int n = 0;
                String string2 = T2KFontFactory.getPathName(string);
                do {
                    t2KFontFile = T2KFontFile.createFontResource(string2, n++);
                    String string3 = t2KFontFile.getFullName().toLowerCase();
                    String string4 = t2KFontFile.getLocaleFullName().toLowerCase();
                    if (!arrayList.contains(string3) && !arrayList.contains(string4)) continue;
                    hashMap.put(string3, string);
                    arrayList.remove(string3);
                    if (!arrayList.contains(string4)) continue;
                    arrayList.remove(string4);
                    String string5 = t2KFontFile.getFamilyName();
                    String string6 = string5.toLowerCase();
                    hashMap2.remove(string4);
                    hashMap2.put(string3, string5);
                    ArrayList<String> arrayList2 = hashMap3.get(string6);
                    if (arrayList2 != null) {
                        arrayList2.remove(t2KFontFile.getLocaleFullName());
                    } else {
                        String string7 = t2KFontFile.getLocaleFamilyName().toLowerCase();
                        arrayList2 = hashMap3.get(string7);
                        if (arrayList2 != null) {
                            hashMap3.remove(string7);
                        }
                        arrayList2 = new ArrayList();
                        hashMap3.put(string6, arrayList2);
                    }
                    arrayList2.add(t2KFontFile.getFullName());
                } while (n < t2KFontFile.getFontCount());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    static native void populateFontFileNameMap(HashMap<String, String> var0, HashMap<String, String> var1, HashMap<String, ArrayList<String>> var2, Locale var3);

    static String findFileWindows(String string) {
        String string2 = fontToFileMap.get(string);
        return T2KFontFactory.getPathName(string2);
    }

    static String getPathName(final String string) {
        if (string == null) {
            return null;
        }
        T2KFontFactory.getPlatformFontDirs();
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        if (userFontDir == null) {
            return sysFontDir + "\\" + string;
        }
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                File file = new File(sysFontDir + "\\" + string);
                if (file.exists()) {
                    return file.getAbsolutePath();
                }
                return userFontDir + "\\" + string;
            }
        });
        if (string2 != null) {
            return string2;
        }
        return null;
    }

    @Override
    public String[] getFontFamilyNames() {
        if (allFamilyNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LogicalFont.addFamilies(arrayList);
            arrayList.add(jreDefaultFontFamily);
            if (this.embeddedFonts != null) {
                for (T2KFontFile object2 : this.embeddedFonts.values()) {
                    if (arrayList.contains(object2.getFamilyName())) continue;
                    arrayList.add(object2.getFamilyName());
                }
            }
            if (isMacOSX) {
                String[] object = macFontFinder.getAllAvailableFontFamilies();
                for (String string : object) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            } else {
                T2KFontFactory.getFullNameToFileMap();
                for (String string : fontToFamilyNameMap.values()) {
                    if (arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            allFamilyNames = new ArrayList<String>(arrayList);
        }
        return allFamilyNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames() {
        if (allFontNames == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            LogicalFont.addFullNames(arrayList);
            arrayList.add(jreDefaultFont);
            if (this.embeddedFonts != null) {
                for (T2KFontFile object : this.embeddedFonts.values()) {
                    if (arrayList.contains(object.getFullName())) continue;
                    arrayList.add(object.getFullName());
                }
            }
            T2KFontFactory.getFullNameToFileMap();
            for (ArrayList arrayList2 : familyToFontListMap.values()) {
                for (String string : arrayList2) {
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            allFontNames = arrayList;
        }
        return allFontNames.toArray(STR_ARRAY);
    }

    @Override
    public String[] getFontFullNames(String string) {
        ArrayList<String> arrayList;
        String[] stringArray = LogicalFont.getFontsInFamily(string);
        if (stringArray != null) {
            return stringArray;
        }
        if (this.embeddedFonts != null) {
            arrayList = null;
            for (T2KFontFile t2KFontFile : this.embeddedFonts.values()) {
                if (!t2KFontFile.getFamilyName().equalsIgnoreCase(string)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(t2KFontFile.getFullName());
            }
            if (arrayList != null) {
                return arrayList.toArray(STR_ARRAY);
            }
        }
        T2KFontFactory.getFullNameToFileMap();
        string = string.toLowerCase();
        arrayList = familyToFontListMap.get(string);
        if (arrayList != null) {
            return arrayList.toArray(STR_ARRAY);
        }
        return STR_ARRAY;
    }

    private synchronized void addFileCloserHook() {
        if (fileCloser == null) {
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    for (T2KFontFile t2KFontFile : T2KFontFactory.this.embeddedFonts.values()) {
                        t2KFontFile.disposeOnShutdown();
                    }
                }
            };
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    fileCloser = new Thread(threadGroup, runnable);
                    fileCloser.setContextClassLoader(null);
                    Runtime.getRuntime().addShutdownHook(fileCloser);
                    return null;
                }
            });
        }
    }

    private static boolean hasTempPermission() {
        if (System.getSecurityManager() == null) {
            return true;
        }
        File file = null;
        boolean bl = false;
        try {
            file = File.createTempFile("+JXF", ".tmp", null);
            file.delete();
            file = null;
            bl = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String registerEmbeddedFont(String string, InputStream inputStream) {
        String string2;
        block16: {
            boolean bl = false;
            string2 = string;
            try {
                File file;
                block17: {
                    file = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                        @Override
                        public File run() throws IOException {
                            File file = File.createTempFile("+JXF", ".tmp", null);
                            return file;
                        }
                    });
                    int n = 0;
                    FontTracker fontTracker = null;
                    try {
                        OutputStream outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                            @Override
                            public OutputStream run() throws IOException {
                                return new FileOutputStream(file);
                            }
                        });
                        if (!T2KFontFactory.hasTempPermission()) {
                            fontTracker = FontTracker.getTracker();
                        }
                        try {
                            int n2;
                            byte[] byArray = new byte[8192];
                            while ((n2 = inputStream.read(byArray)) >= 0) {
                                if (fontTracker != null) {
                                    if (n + n2 > 0x2000000) {
                                        throw new IOException("File too big.");
                                    }
                                    if (n + fontTracker.getNumBytes() > 0x14000000) {
                                        throw new IOException("Total files too big.");
                                    }
                                    n += n2;
                                    fontTracker.addBytes(n2);
                                }
                                outputStream.write(byArray, 0, n2);
                            }
                        }
                        finally {
                            outputStream.close();
                        }
                        bl = true;
                        string2 = this.registerEmbeddedFont(string, file.getPath(), true, fontTracker != null);
                        this.addFileCloserHook();
                        if (bl && string2 != null) break block16;
                        if (fontTracker == null) break block17;
                        fontTracker.subBytes(n);
                    }
                    catch (Throwable throwable) {
                        if (!bl || string2 == null) {
                            if (fontTracker != null) {
                                fontTracker.subBytes(n);
                            }
                            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(file){
                                final /* synthetic */ File val$tFile;
                                {
                                    this.val$tFile = file;
                                }

                                @Override
                                public Void run() {
                                    this.val$tFile.delete();
                                    return null;
                                }
                            });
                        }
                        throw throwable;
                    }
                }
                AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return string2;
    }

    @Override
    public String registerEmbeddedFont(String string, String string2) {
        this.addFileCloserHook();
        return this.registerEmbeddedFont(string, string2, false, false);
    }

    private void removeEmbeddedFont(String string) {
        T2KFontFile t2KFontFile = this.embeddedFonts.get(string);
        if (t2KFontFile == null) {
            return;
        }
        this.embeddedFonts.remove(string);
        String string2 = string.toLowerCase();
        fontResourceMap.remove(string2);
        compResourceMap.remove(string2);
        for (String string3 : compResourceMap.keySet()) {
            CompositeFontResource compositeFontResource = compResourceMap.get(string3);
            if (compositeFontResource.getSlotResource(0) != t2KFontFile) continue;
            compResourceMap.remove(string3);
        }
    }

    private String registerEmbeddedFont(String string, String string2, boolean bl, boolean bl2) {
        T2KFontFile t2KFontFile;
        if (this.embeddedFonts == null) {
            this.embeddedFonts = new HashMap();
        }
        if ((t2KFontFile = T2KFontFile.createFontResource(string, string2)) == null) {
            return null;
        }
        t2KFontFile.setIsCopy(bl, bl2);
        if (string != null && !"".equals(string)) {
            this.embeddedFonts.put(string, t2KFontFile);
            T2KFontFactory.storeInMap(string, t2KFontFile);
        }
        String string3 = t2KFontFile.getFullName();
        this.removeEmbeddedFont(string3);
        this.embeddedFonts.put(string3, t2KFontFile);
        T2KFontFactory.storeInMap(string3, t2KFontFile);
        String string4 = t2KFontFile.getFamilyName() + T2KFontFactory.dotStyleStr(t2KFontFile.isBold(), t2KFontFile.isItalic());
        T2KFontFactory.storeInMap(string4, t2KFontFile);
        compResourceMap.remove(string4.toLowerCase());
        return string3;
    }

    private static synchronized HashMap<String, String> getFullNameToFileMap() {
        if (fontToFileMap == null) {
            HashMap<String, String> hashMap = new HashMap<String, String>(100);
            fontToFamilyNameMap = new HashMap(100);
            familyToFontListMap = new HashMap(50);
            fileToFontMap = new HashMap(100);
            if (!isWindows && !isMacOSX) {
                fontToFileMap = hashMap;
                return fontToFileMap;
            }
            if (isWindows) {
                T2KFontFactory.getPlatformFontDirs();
                T2KFontFactory.populateFontFileNameMap(hashMap, fontToFamilyNameMap, familyToFontListMap, Locale.ENGLISH);
                if (debugFonts) {
                    System.err.println("Windows Locale ID=" + T2KFontFactory.getSystemLCID());
                    System.err.println(" *** WINDOWS FONTS BEFORE RESOLVING");
                    for (String string : hashMap.keySet()) {
                        System.err.println("font=" + string + " file=" + hashMap.get(string));
                    }
                    for (String string : fontToFamilyNameMap.keySet()) {
                        System.err.println("font=" + string + " family=" + fontToFamilyNameMap.get(string));
                    }
                    for (String string : familyToFontListMap.keySet()) {
                        System.err.println("family=" + string + " fonts=" + familyToFontListMap.get(string));
                    }
                }
                T2KFontFactory.resolveWindowsFonts(hashMap, fontToFamilyNameMap, familyToFontListMap);
                if (debugFonts) {
                    System.err.println("*** WINDOWS FONTS AFTER RESOLVING");
                    for (String string : hashMap.keySet()) {
                        System.err.println("font=" + string + " file=" + hashMap.get(string));
                    }
                    for (String string : fontToFamilyNameMap.keySet()) {
                        System.err.println("font=" + string + " family=" + fontToFamilyNameMap.get(string));
                    }
                    for (String string : familyToFontListMap.keySet()) {
                        System.err.println("family=" + string + " fonts=" + familyToFontListMap.get(string));
                    }
                }
            } else if (isMacOSX) {
                macFontFinder.populateFontFileNameMap(hashMap, fontToFamilyNameMap, familyToFontListMap, Locale.ENGLISH);
            }
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() {
                        T2KFontFactory.populateFontFileNameMapGeneric(jreFontDir);
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String string : hashMap.keySet()) {
                String string2 = hashMap.get(string);
                fileToFontMap.put(string2.toLowerCase(), string);
            }
            fontToFileMap = hashMap;
        }
        return fontToFileMap;
    }

    static void addToMaps(T2KFontFile t2KFontFile) {
        if (t2KFontFile == null) {
            return;
        }
        String string = t2KFontFile.getFullName();
        String string2 = t2KFontFile.getFamilyName();
        if (string == null || string2 == null) {
            return;
        }
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        fontToFileMap.put(string3, t2KFontFile.getFileName());
        fontToFamilyNameMap.put(string3, string2);
        ArrayList<String> arrayList = familyToFontListMap.get(string4);
        if (arrayList == null) {
            arrayList = new ArrayList();
            familyToFontListMap.put(string4, arrayList);
        }
        arrayList.add(string);
    }

    static void populateFontFileNameMapGeneric(String string) {
        File file = new File(string);
        String[] stringArray = file.list(TTFilter.getInstance());
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                String string2 = string + File.separator + stringArray[i];
                int n = 0;
                T2KFontFile t2KFontFile = T2KFontFile.createFontResource(string2, n++);
                if (t2KFontFile == null) continue;
                T2KFontFactory.addToMaps(t2KFontFile);
                while (n < t2KFontFile.getFontCount() && (t2KFontFile = T2KFontFile.createFontResource(string2, n++)) != null) {
                    T2KFontFactory.addToMaps(t2KFontFile);
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static native int getSystemFontSizeNative();

    private static native String getSystemFontNative();

    public static float getSystemFontSize() {
        if (systemFontSize == -1.0f) {
            systemFontSize = isWindows ? (float)T2KFontFactory.getSystemFontSizeNative() : (isMacOSX ? 13.0f : 13.0f);
        }
        return systemFontSize;
    }

    public static String getSystemFont() {
        if (systemFontFamily == null) {
            if (isWindows) {
                systemFontFamily = T2KFontFactory.getSystemFontNative();
                if (systemFontFamily == null) {
                    systemFontFamily = "Arial";
                }
            } else {
                systemFontFamily = isMacOSX ? "Lucida Grande" : jreDefaultFontFamily;
            }
        }
        return systemFontFamily;
    }

    static native short getSystemLCID();

    static {
        macFontFinder = null;
        fontResourceMap = new HashMap();
        compResourceMap = new HashMap();
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                NativeLibLoader.loadLibrary("javafx-font");
                String string = System.getProperty("prism.debugfonts", "");
                debugFonts = "true".equals(string);
                jreFontDir = System.getProperty("java.home", "") + File.separator + "lib" + File.separator + "fonts" + File.separator;
                return System.getProperty("os.name", "");
            }
        });
        isWindows = string.startsWith("Win");
        isMacOSX = string.startsWith("Mac");
        if (isMacOSX) {
            macFontFinder = MacFontFinder.getInstance();
        }
        theT2KFontFactory = null;
        STR_ARRAY = new String[0];
        fontToFileMap = null;
        fileToFontMap = null;
        fontToFamilyNameMap = null;
        familyToFontListMap = null;
        sysFontDir = null;
        userFontDir = null;
        fileCloser = null;
        systemFontSize = -1.0f;
        systemFontFamily = null;
    }

    private static class TTFilter
    implements FilenameFilter {
        static TTFilter ttFilter;

        @Override
        public boolean accept(File file, String string) {
            int n = string.length() - 4;
            if (n <= 0) {
                return false;
            }
            return string.startsWith(".ttf", n) || string.startsWith(".TTF", n) || string.startsWith(".ttc", n) || string.startsWith(".TTC", n) || string.startsWith(".otf", n) || string.startsWith(".OTF", n);
        }

        private TTFilter() {
        }

        static TTFilter getInstance() {
            if (ttFilter == null) {
                ttFilter = new TTFilter();
            }
            return ttFilter;
        }
    }

    static class FontTracker {
        public static final int MAX_FILE_SIZE = 0x2000000;
        public static final int MAX_TOTAL_BYTES = 0x14000000;
        static int numBytes;
        static FontTracker tracker;

        FontTracker() {
        }

        public static synchronized FontTracker getTracker() {
            if (tracker == null) {
                tracker = new FontTracker();
            }
            return tracker;
        }

        public synchronized int getNumBytes() {
            return numBytes;
        }

        public synchronized void addBytes(int n) {
            numBytes += n;
        }

        public synchronized void subBytes(int n) {
            numBytes -= n;
        }
    }
}

