/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.nativewindow.impl;

import com.sun.prism.nativewindow.ToolkitLock;
import com.sun.prism.nativewindow.impl.NativeWindowFactoryImpl;

public class LockingNativeWindowFactory
extends NativeWindowFactoryImpl {
    private ToolkitLock toolkitLock = new ToolkitLock(){
        private Thread owner;
        private int recursionCount;

        public synchronized void lock() {
            Thread thread = Thread.currentThread();
            if (this.owner == thread) {
                ++this.recursionCount;
                return;
            }
            while (this.owner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
            }
            this.owner = thread;
        }

        public synchronized void unlock() {
            if (this.owner != Thread.currentThread()) {
                throw new RuntimeException("Not owner");
            }
            if (this.recursionCount > 0) {
                --this.recursionCount;
                return;
            }
            this.owner = null;
            this.notifyAll();
        }
    };

    public ToolkitLock getToolkitLock() {
        return this.toolkitLock;
    }
}

