/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.j2d;

import com.sun.javafx.font.FontFactory;
import com.sun.javafx.font.PGFont;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;

public final class J2DFontFactory
implements FontFactory {
    FontFactory prismFontFactory;
    private static boolean compositeFontMethodsInitialized = false;
    private static Method getCompositeFontUIResource = null;

    J2DFontFactory(FontFactory fontFactory) {
        this.prismFontFactory = fontFactory;
    }

    @Override
    public PGFont createFont(String string, float f) {
        return this.prismFontFactory.createFont(string, f);
    }

    @Override
    public PGFont createFont(String string, boolean bl, boolean bl2, float f) {
        return this.prismFontFactory.createFont(string, bl, bl2, f);
    }

    @Override
    public String[] getFontFamilyNames() {
        return this.prismFontFactory.getFontFamilyNames();
    }

    @Override
    public String[] getFontFullNames() {
        return this.prismFontFactory.getFontFullNames();
    }

    @Override
    public String[] getFontFullNames(String string) {
        return this.prismFontFactory.getFontFullNames(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String registerEmbeddedFont(String string, InputStream inputStream) {
        boolean bl = false;
        String string2 = string;
        try {
            final File file = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                @Override
                public File run() throws IOException {
                    File file = File.createTempFile("+JXF", ".tmp", null);
                    file.deleteOnExit();
                    return file;
                }
            });
            try {
                OutputStream outputStream = AccessController.doPrivileged(new PrivilegedExceptionAction<OutputStream>(){

                    @Override
                    public OutputStream run() throws IOException {
                        return new FileOutputStream(file);
                    }
                });
                try {
                    int n;
                    byte[] byArray = new byte[8192];
                    while ((n = inputStream.read(byArray)) >= 0) {
                        outputStream.write(byArray, 0, n);
                    }
                }
                finally {
                    inputStream.close();
                    outputStream.close();
                }
                string2 = this.prismFontFactory.registerEmbeddedFont(string, file.getPath());
                this.registerJ2DFont(file.getPath());
                bl = true;
                if (bl) return string2;
            }
            catch (Throwable throwable) {
                if (bl) throw throwable;
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(file){
                    final /* synthetic */ File val$tFile;
                    {
                        this.val$tFile = file;
                    }

                    @Override
                    public Void run() {
                        this.val$tFile.delete();
                        return null;
                    }
                });
                throw throwable;
            }
            AccessController.doPrivileged(new /* invalid duplicate definition of identical inner class */);
            return string2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return string2;
    }

    @Override
    public String registerEmbeddedFont(String string, String string2) {
        String string3 = this.prismFontFactory.registerEmbeddedFont(string, string2);
        this.registerJ2DFont(string2);
        return string3;
    }

    void registerJ2DFont(final String string) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    File file = new File(string);
                    Font font = Font.createFont(0, file);
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    boolean bl = graphicsEnvironment.registerFont(font);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Font getCompositeFont(Font font) {
        String string = System.getProperty("os.name");
        if (string.startsWith("Mac")) {
            return font;
        }
        Class<J2DFontFactory> clazz = J2DFontFactory.class;
        synchronized (J2DFontFactory.class) {
            if (!compositeFontMethodsInitialized) {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Class<?> clazz;
                        compositeFontMethodsInitialized = true;
                        try {
                            clazz = Class.forName("sun.font.FontUtilities", true, null);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            try {
                                clazz = Class.forName("sun.font.FontManager", true, null);
                            }
                            catch (ClassNotFoundException classNotFoundException2) {
                                return null;
                            }
                        }
                        try {
                            getCompositeFontUIResource = clazz.getMethod("getCompositeFontUIResource", Font.class);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (getCompositeFontUIResource != null) {
                try {
                    return (Font)getCompositeFontUIResource.invoke(null, font);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return font;
        }
    }
}

