/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.Vec3f;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.AATessCallbacks;
import com.sun.prism.opengl.glu.GLU;
import com.sun.prism.opengl.glu.GLUtessellator;
import java.util.ArrayList;

final class AATesselatorImpl {
    private static final float EPSILON = 1.0E-4f;
    private final AATessCallbacks listener;
    private final GLUtessellator tess;
    private final float[] coords = new float[6];

    AATesselatorImpl() {
        this.listener = new AATessCallbacks();
        this.tess = GLU.gluNewTess();
        GLU.gluTessCallback(this.tess, 100100, this.listener);
        GLU.gluTessCallback(this.tess, 100101, this.listener);
        GLU.gluTessCallback(this.tess, 100102, this.listener);
        GLU.gluTessCallback(this.tess, 100105, this.listener);
        GLU.gluTessCallback(this.tess, 100103, this.listener);
        GLU.gluTessCallback(this.tess, 100104, this.listener);
    }

    int[] generate(Shape shape, VertexBuffer vertexBuffer, VertexBuffer vertexBuffer2) {
        int n;
        this.listener.setVertexBuffer(vertexBuffer);
        BaseTransform baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        PathIterator pathIterator = shape.getPathIterator(baseTransform);
        ArrayList<Segment> arrayList = new ArrayList<Segment>();
        int n2 = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        boolean bl = false;
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(this.coords);
            switch (n) {
                case 0: {
                    if (bl) {
                        return null;
                    }
                    bl = true;
                    f6 = f4 = this.coords[0];
                    f2 = f4;
                    f7 = f5 = this.coords[1];
                    f3 = f5;
                    arrayList.add(new MoveTo(f4, f5));
                    break;
                }
                case 1: {
                    if (AATesselatorImpl.hasInfOrNaN(this.coords, 2)) break;
                    bl = true;
                    f4 = this.coords[0];
                    f5 = this.coords[1];
                    if (f4 != f6 || f5 != f7) {
                        f += f4 * f7 - f6 * f5;
                        arrayList.add(new LineTo(f6, f7, f4, f5));
                    }
                    f6 = f4;
                    f7 = f5;
                    break;
                }
                case 2: {
                    int n3;
                    float f10 = this.coords[0];
                    float f11 = this.coords[1];
                    this.coords[4] = this.coords[2];
                    this.coords[5] = this.coords[3];
                    this.coords[0] = (f6 + 2.0f * f10) / 3.0f;
                    this.coords[1] = (f7 + 2.0f * f11) / 3.0f;
                    this.coords[2] = (this.coords[4] + 2.0f * f10) / 3.0f;
                    this.coords[3] = (this.coords[5] + 2.0f * f11) / 3.0f;
                    if (AATesselatorImpl.hasInfOrNaN(this.coords, 6)) break;
                    bl = true;
                    f8 = f6;
                    f9 = f7;
                    for (n3 = 0; n3 < 6; n3 += 2) {
                        f4 = this.coords[n3];
                        f5 = this.coords[n3 + 1];
                        f += f4 * f7 - f6 * f5;
                        f6 = f4;
                        f7 = f5;
                    }
                    arrayList.add(new CubicTo(f8, f9, this.coords[0], this.coords[1], this.coords[2], this.coords[3], f4, f5));
                    break;
                }
                case 3: {
                    int n3;
                    if (AATesselatorImpl.hasInfOrNaN(this.coords, 6)) break;
                    bl = true;
                    f8 = f6;
                    f9 = f7;
                    for (n3 = 0; n3 < 6; n3 += 2) {
                        f4 = this.coords[n3];
                        f5 = this.coords[n3 + 1];
                        f += f4 * f7 - f6 * f5;
                        f6 = f4;
                        f7 = f5;
                    }
                    arrayList.add(new CubicTo(f8, f9, this.coords[0], this.coords[1], this.coords[2], this.coords[3], f4, f5));
                    break;
                }
                case 4: {
                    if (!bl) break;
                    bl = false;
                    f4 = f2;
                    f5 = f3;
                    arrayList.add(new Close(f6, f7, f2, f3));
                    break;
                }
                default: {
                    throw new InternalError("Unknown segment type");
                }
            }
            pathIterator.next();
        }
        if (bl) {
            arrayList.add(new Close(f6, f7, f2, f3));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            Segment segment = (Segment)arrayList.get(n);
            for (int i = n + 1; i < arrayList.size(); ++i) {
                Segment segment2 = (Segment)arrayList.get(i);
                if (!segment.overlaps(segment2)) continue;
                return null;
            }
        }
        GLU.gluTessProperty(this.tess, 100140, pathIterator.getWindingRule() == 1 ? 100131.0 : 100130.0);
        GLU.gluTessBeginPolygon(this.tess, null);
        for (n = 0; n < arrayList.size(); ++n) {
            Segment segment = (Segment)arrayList.get(n);
            if (f < 0.0f) {
                segment.convex = !segment.convex;
            }
            n2 += segment.emitVertices(this.tess, vertexBuffer2);
        }
        GLU.gluTessEndPolygon(this.tess);
        int[] nArray = new int[]{this.listener.getNumVerts(), n2};
        return nArray;
    }

    static boolean pointOnLine(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7;
        float f8;
        float f9;
        return (f9 = (f -= f3) * f + (f2 -= f4) * f2 - (f8 = (f7 = f * (f5 -= f3) + f2 * (f6 -= f4)) * f7 / (f5 * f5 + f6 * f6))) < 1.0E-4f;
    }

    static boolean linesCross(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (AATesselatorImpl.pointOnLine(f, f2, f5, f6, f7, f8) || AATesselatorImpl.pointOnLine(f3, f4, f5, f6, f7, f8) || AATesselatorImpl.pointOnLine(f5, f6, f, f2, f3, f4) || AATesselatorImpl.pointOnLine(f7, f8, f, f2, f3, f4)) {
            return false;
        }
        float f9 = f4 - f2;
        float f10 = f5 - f7;
        float f11 = f3 - f;
        float f12 = f6 - f8;
        float f13 = f9 * f10 - f11 * f12;
        if (AATesselatorImpl.isCloseToZero(f13)) {
            return false;
        }
        float f14 = f - f5;
        float f15 = f2 - f6;
        float f16 = f12 * f14 - f10 * f15;
        if (f13 > 0.0f ? f16 < 0.0f || f16 > f13 : f16 > 0.0f || f16 < f13) {
            return false;
        }
        float f17 = f11 * f15 - f9 * f14;
        return !(f13 > 0.0f ? f17 < 0.0f || f17 > f13 : f17 > 0.0f || f17 < f13);
    }

    static boolean triangleContainsPoint(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        f -= f3;
        f2 -= f4;
        float f9 = (f5 -= f3) * (f8 -= f4) - (f7 -= f3) * (f6 -= f4);
        if (AATesselatorImpl.isCloseToZero(f9)) {
            return false;
        }
        float f10 = (f * f8 - f2 * f7) / f9;
        float f11 = (f * f6 - f2 * f5) / -f9;
        return f10 > 0.0f && f11 > 0.0f && f10 + f11 < 1.0f;
    }

    static boolean isCloseToZero(float f) {
        return f < 1.0E-4f && f > -1.0E-4f;
    }

    static boolean hasInfOrNaN(float[] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isInfinite(fArray[i]) && !Float.isNaN(fArray[i])) continue;
            return true;
        }
        return false;
    }

    static void emitVert(GLUtessellator gLUtessellator, float f, float f2) {
        double[] dArray = new double[]{f, f2, 0.0};
        GLU.gluTessVertex(gLUtessellator, dArray, 0, dArray);
    }

    private static class Close
    extends Segment {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;

        Close(float f, float f2, float f3, float f4) {
            super(Segment.Type.CLOSE);
            this.x1 = f;
            this.y1 = f2;
            this.x2 = f3;
            this.y2 = f4;
        }

        @Override
        int getEdges(float[] fArray) {
            fArray[0] = this.x1;
            fArray[1] = this.y1;
            fArray[2] = this.x2;
            fArray[3] = this.y2;
            return 1;
        }

        @Override
        int emitVertices(GLUtessellator gLUtessellator, VertexBuffer vertexBuffer) {
            GLU.gluTessEndContour(gLUtessellator);
            return 0;
        }
    }

    private static class CubicTo
    extends Segment {
        private final float x1;
        private final float y1;
        private final float ctrlx1;
        private final float ctrly1;
        private final float ctrlx2;
        private final float ctrly2;
        private final float x2;
        private final float y2;
        private final int ccw1;
        private final int ccw2;
        private int hullType = -1;
        private static final Vec3f b0 = new Vec3f();
        private static final Vec3f b1 = new Vec3f();
        private static final Vec3f b2 = new Vec3f();
        private static final Vec3f b3 = new Vec3f();
        private static final Vec3f m0 = new Vec3f();
        private static final Vec3f m1 = new Vec3f();
        private static final Vec3f m2 = new Vec3f();
        private static final Vec3f m3 = new Vec3f();
        private static final Vec3f tmp = new Vec3f();
        private static final float ONE_THIRD = 0.33333334f;
        private static final float TWO_THIRDS = 0.6666667f;

        CubicTo(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
            super(Segment.Type.CUBICTO);
            this.x1 = f;
            this.y1 = f2;
            this.ctrlx1 = f3;
            this.ctrly1 = f4;
            this.ctrlx2 = f5;
            this.ctrly2 = f6;
            this.x2 = f7;
            this.y2 = f8;
            this.ccw1 = Line2D.relativeCCW(f, f2, f3, f4, f7, f8);
            this.ccw2 = Line2D.relativeCCW(f, f2, f5, f6, f7, f8);
            this.convex = this.ccw1 > 0 && this.ccw2 > 0;
        }

        private int calculateHullType() {
            if (AATesselatorImpl.triangleContainsPoint(this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2, this.x2, this.y2)) {
                return 2;
            }
            if (AATesselatorImpl.triangleContainsPoint(this.x2, this.y2, this.x1, this.y1, this.ctrlx1, this.ctrly1, this.ctrlx2, this.ctrly2)) {
                return 3;
            }
            if (AATesselatorImpl.triangleContainsPoint(this.ctrlx1, this.ctrly1, this.x1, this.y1, this.ctrlx2, this.ctrly2, this.x2, this.y2)) {
                return 4;
            }
            if (AATesselatorImpl.triangleContainsPoint(this.ctrlx2, this.ctrly2, this.x1, this.y1, this.ctrlx1, this.ctrly1, this.x2, this.y2)) {
                return 5;
            }
            if (this.ccw1 == this.ccw2) {
                return 0;
            }
            return 1;
        }

        @Override
        int getEdges(float[] fArray) {
            if (this.hullType < 0) {
                this.hullType = this.calculateHullType();
            }
            switch (this.hullType) {
                case 0: {
                    fArray[0] = this.x1;
                    fArray[1] = this.y1;
                    fArray[2] = this.ctrlx1;
                    fArray[3] = this.ctrly1;
                    fArray[4] = this.ctrlx2;
                    fArray[5] = this.ctrly2;
                    fArray[6] = this.x1;
                    fArray[7] = this.y1;
                    fArray[8] = this.ctrlx2;
                    fArray[9] = this.ctrly2;
                    fArray[10] = this.x2;
                    fArray[11] = this.y2;
                    return 6;
                }
                case 1: {
                    fArray[0] = this.x1;
                    fArray[1] = this.y1;
                    fArray[2] = this.ctrlx1;
                    fArray[3] = this.ctrly1;
                    fArray[4] = this.ctrlx2;
                    fArray[5] = this.ctrly2;
                    fArray[6] = this.ctrlx1;
                    fArray[7] = this.ctrly1;
                    fArray[8] = this.ctrlx2;
                    fArray[9] = this.ctrly2;
                    fArray[10] = this.x2;
                    fArray[11] = this.y2;
                    return 6;
                }
                case 2: {
                    fArray[0] = this.ctrlx1;
                    fArray[1] = this.ctrly1;
                    fArray[2] = this.ctrlx2;
                    fArray[3] = this.ctrly2;
                    fArray[4] = this.x2;
                    fArray[5] = this.y2;
                    return 3;
                }
                case 3: {
                    fArray[0] = this.x1;
                    fArray[1] = this.y1;
                    fArray[2] = this.ctrlx1;
                    fArray[3] = this.ctrly1;
                    fArray[4] = this.ctrlx2;
                    fArray[5] = this.ctrly2;
                    return 3;
                }
                case 4: {
                    fArray[0] = this.x1;
                    fArray[1] = this.y1;
                    fArray[2] = this.ctrlx2;
                    fArray[3] = this.ctrly2;
                    fArray[4] = this.x2;
                    fArray[5] = this.y2;
                    return 3;
                }
                case 5: {
                    fArray[0] = this.x1;
                    fArray[1] = this.y1;
                    fArray[2] = this.ctrlx1;
                    fArray[3] = this.ctrly1;
                    fArray[4] = this.x2;
                    fArray[5] = this.y2;
                    return 3;
                }
            }
            throw new InternalError("Unknown hull type");
        }

        @Override
        int emitVertices(GLUtessellator gLUtessellator, VertexBuffer vertexBuffer) {
            b0.set(this.x1, this.y1, 1.0f);
            b1.set(this.ctrlx1, this.ctrly1, 1.0f);
            b2.set(this.ctrlx2, this.ctrly2, 1.0f);
            b3.set(this.x2, this.y2, 1.0f);
            tmp.cross(b3, b2);
            float f = b0.dot(tmp);
            tmp.cross(b0, b3);
            float f2 = b1.dot(tmp);
            tmp.cross(b1, b0);
            float f3 = b2.dot(tmp);
            float f4 = 3.0f * f3;
            float f5 = -f2 + f4;
            float f6 = f - 2.0f * f2 + f4;
            tmp.set(f6, f5, f4);
            tmp.normalize();
            f6 = CubicTo.tmp.x;
            f5 = CubicTo.tmp.y;
            f4 = CubicTo.tmp.z;
            float f7 = 3.0f * f5 * f5 - 4.0f * f6 * f4;
            float f8 = f6 * f6 * f7;
            if (AATesselatorImpl.isCloseToZero(f6)) {
                f6 = 0.0f;
            }
            if (AATesselatorImpl.isCloseToZero(f5)) {
                f5 = 0.0f;
            }
            if (AATesselatorImpl.isCloseToZero(f4)) {
                f4 = 0.0f;
            }
            if (AATesselatorImpl.isCloseToZero(f8)) {
                f8 = 0.0f;
            }
            if (f8 > 0.0f) {
                return this.emitSerpent(gLUtessellator, vertexBuffer, f6, f5, f7);
            }
            if (f8 < 0.0f) {
                return this.emitLoop(gLUtessellator, vertexBuffer, f6, f5, f7);
            }
            if (f6 == 0.0f && f5 == 0.0f) {
                if (f4 != 0.0f) {
                    return this.emitQuadratic(gLUtessellator, vertexBuffer);
                }
                throw new InternalError("Line/point segment not yet supported");
            }
            throw new InternalError("Cusp segment not yet supported");
        }

        private int emitQuadratic(GLUtessellator gLUtessellator, VertexBuffer vertexBuffer) {
            float f;
            if (this.convex) {
                AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                f = 1.0f;
            } else {
                AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx1, this.ctrly1);
                AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx2, this.ctrly2);
                AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                f = -1.0f;
            }
            float f2 = 0.33333334f;
            float f3 = 0.6666667f;
            vertexBuffer.addVert(this.x1, this.y1, 0.0f, 0.0f, 0.0f, f);
            vertexBuffer.addVert(this.ctrlx1, this.ctrly1, f2, 0.0f, f2, f);
            vertexBuffer.addVert(this.x2, this.y2, 1.0f, 1.0f, 1.0f, f);
            vertexBuffer.addVert(this.ctrlx1, this.ctrly1, f2, 0.0f, f2, f);
            vertexBuffer.addVert(this.ctrlx2, this.ctrly2, f3, f2, f3, f);
            vertexBuffer.addVert(this.x2, this.y2, 1.0f, 1.0f, 1.0f, f);
            return 6;
        }

        private int emitSerpent(GLUtessellator gLUtessellator, VertexBuffer vertexBuffer, float f, float f2, float f3) {
            float f4;
            float f5 = (float)Math.sqrt(3.0f * f3);
            float f6 = 3.0f * f2 - f5;
            float f7 = 6.0f * f;
            float f8 = 3.0f * f2 + f5;
            float f9 = f7;
            CubicTo.m0.x = f6 * f8;
            CubicTo.m0.y = f6 * f6 * f6;
            CubicTo.m0.z = f8 * f8 * f8;
            CubicTo.m1.x = 0.33333334f * (3.0f * f6 * f8 - f6 * f9 - f7 * f8);
            CubicTo.m1.y = f6 * f6 * (f6 - f7);
            CubicTo.m1.z = f8 * f8 * (f8 - f9);
            float f10 = f7 - f6;
            float f11 = f9 - f8;
            CubicTo.m2.x = 0.33333334f * (f7 * (f9 - 2.0f * f8) + f6 * (3.0f * f8 - 2.0f * f9));
            CubicTo.m2.y = f6 * f10 * f10;
            CubicTo.m2.z = f8 * f11 * f11;
            CubicTo.m3.x = f10 * f11;
            CubicTo.m3.y = -(f10 * f10 * f10);
            CubicTo.m3.z = -(f11 * f11 * f11);
            if (this.ccw1 != this.ccw2) {
                if (this.ccw1 > 0) {
                    AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx1, this.ctrly1);
                } else {
                    AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx2, this.ctrly2);
                }
                AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                float f12 = -1.0f;
                vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f12);
                vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f12);
                vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f12);
                vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f12);
                vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f12);
                vertexBuffer.addVert(this.x2, this.y2, CubicTo.m3.x, CubicTo.m3.y, CubicTo.m3.z, f12);
                return 6;
            }
            if (this.hullType == 4) {
                float f13;
                if (this.convex) {
                    AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                    f13 = -1.0f;
                } else {
                    AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx2, this.ctrly2);
                    AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                    f13 = 1.0f;
                }
                vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f13);
                vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f13);
                vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f13);
                vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f13);
                vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f13);
                vertexBuffer.addVert(this.x2, this.y2, CubicTo.m3.x, CubicTo.m3.y, CubicTo.m3.z, f13);
                vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f13);
                vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f13);
                vertexBuffer.addVert(this.x2, this.y2, CubicTo.m3.x, CubicTo.m3.y, CubicTo.m3.z, f13);
                return 9;
            }
            if (this.hullType == 5) {
                float f14;
                if (this.convex) {
                    AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                    f14 = -1.0f;
                } else {
                    AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx1, this.ctrly1);
                    AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                    f14 = 1.0f;
                }
                vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f14);
                vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f14);
                vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f14);
                vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f14);
                vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f14);
                vertexBuffer.addVert(this.x2, this.y2, CubicTo.m3.x, CubicTo.m3.y, CubicTo.m3.z, f14);
                vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f14);
                vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f14);
                vertexBuffer.addVert(this.x2, this.y2, CubicTo.m3.x, CubicTo.m3.y, CubicTo.m3.z, f14);
                return 9;
            }
            if (this.convex) {
                AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                f4 = -1.0f;
            } else {
                AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx1, this.ctrly1);
                AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx2, this.ctrly2);
                AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                f4 = 1.0f;
            }
            vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f4);
            vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f4);
            vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f4);
            vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f4);
            vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f4);
            vertexBuffer.addVert(this.x2, this.y2, CubicTo.m3.x, CubicTo.m3.y, CubicTo.m3.z, f4);
            return 6;
        }

        private int emitLoop(GLUtessellator gLUtessellator, VertexBuffer vertexBuffer, float f, float f2, float f3) {
            float f4;
            float f5 = (float)Math.sqrt(-f3);
            float f6 = f2 - f5;
            float f7 = 2.0f * f;
            float f8 = f2 + f5;
            float f9 = f7;
            CubicTo.m0.x = f6 * f8;
            CubicTo.m0.y = f6 * f6 * f8;
            CubicTo.m0.z = f6 * f8 * f8;
            CubicTo.m1.x = 0.33333334f * (-(f6 * f9) - f7 * f8 + 3.0f * f6 * f8);
            CubicTo.m1.y = -0.33333334f * f6 * (f6 * (f9 - 3.0f * f8) + 2.0f * f7 * f8);
            CubicTo.m1.z = -0.33333334f * f8 * (f6 * (2.0f * f9 - 3.0f * f8) + f7 * f8);
            float f10 = f7 - f6;
            float f11 = f9 - f8;
            CubicTo.m2.x = 0.33333334f * (f7 * (f9 - 2.0f * f8) + f6 * (3.0f * f8 - 2.0f * f9));
            CubicTo.m2.y = 0.33333334f * f10 * (f6 * (2.0f * f9 - 3.0f * f8) + f7 * f8);
            CubicTo.m2.z = 0.33333334f * f11 * (f6 * (f9 - 3.0f * f8) + 2.0f * f7 * f8);
            CubicTo.m3.x = f10 * f11;
            CubicTo.m3.y = -(f10 * f10 * f11);
            CubicTo.m3.z = -(f10 * f11 * f11);
            if (this.convex) {
                AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                f4 = -1.0f;
            } else {
                AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx1, this.ctrly1);
                AATesselatorImpl.emitVert(gLUtessellator, this.ctrlx2, this.ctrly2);
                AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
                f4 = 1.0f;
            }
            vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f4);
            vertexBuffer.addVert(this.ctrlx1, this.ctrly1, CubicTo.m1.x, CubicTo.m1.y, CubicTo.m1.z, f4);
            vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f4);
            vertexBuffer.addVert(this.x1, this.y1, CubicTo.m0.x, CubicTo.m0.y, CubicTo.m0.z, f4);
            vertexBuffer.addVert(this.ctrlx2, this.ctrly2, CubicTo.m2.x, CubicTo.m2.y, CubicTo.m2.z, f4);
            vertexBuffer.addVert(this.x2, this.y2, CubicTo.m3.x, CubicTo.m3.y, CubicTo.m3.z, f4);
            return 6;
        }
    }

    private static class LineTo
    extends Segment {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;

        LineTo(float f, float f2, float f3, float f4) {
            super(Segment.Type.LINETO);
            this.x1 = f;
            this.y1 = f2;
            this.x2 = f3;
            this.y2 = f4;
        }

        @Override
        int getEdges(float[] fArray) {
            fArray[0] = this.x1;
            fArray[1] = this.y1;
            fArray[2] = this.x2;
            fArray[3] = this.y2;
            return 1;
        }

        @Override
        int emitVertices(GLUtessellator gLUtessellator, VertexBuffer vertexBuffer) {
            AATesselatorImpl.emitVert(gLUtessellator, this.x2, this.y2);
            return 0;
        }
    }

    private static class MoveTo
    extends Segment {
        private final float x;
        private final float y;

        MoveTo(float f, float f2) {
            super(Segment.Type.MOVETO);
            this.x = f;
            this.y = f2;
        }

        @Override
        int getEdges(float[] fArray) {
            return 0;
        }

        @Override
        int emitVertices(GLUtessellator gLUtessellator, VertexBuffer vertexBuffer) {
            GLU.gluTessBeginContour(gLUtessellator);
            AATesselatorImpl.emitVert(gLUtessellator, this.x, this.y);
            return 0;
        }
    }

    private static abstract class Segment {
        final Type type;
        boolean convex;
        private static final int[] triOffsets = new int[]{0, 2, 2, 4, 4, 0, 6, 8, 8, 10, 10, 6};
        private static final float[] tmpThis = new float[12];
        private static final float[] tmpThat = new float[12];

        protected Segment(Type type) {
            this.type = type;
        }

        abstract int getEdges(float[] var1);

        abstract int emitVertices(GLUtessellator var1, VertexBuffer var2);

        boolean overlaps(Segment segment) {
            int n;
            int n2;
            int n3 = this.getEdges(tmpThis);
            int n4 = segment.getEdges(tmpThat);
            if (n3 < 1 || n4 < 1) {
                return false;
            }
            if (n3 == 1 && n4 == 1) {
                return AATesselatorImpl.linesCross(tmpThis[0], tmpThis[1], tmpThis[2], tmpThis[3], tmpThat[0], tmpThat[1], tmpThat[2], tmpThat[3]);
            }
            int n5 = n3 * 2;
            int n6 = n4 * 2;
            for (n2 = 0; n2 < n5; n2 += 2) {
                n = triOffsets[n2];
                int n7 = triOffsets[n2 + 1];
                for (int i = 0; i < n6; i += 2) {
                    int n8 = triOffsets[i];
                    int n9 = triOffsets[i + 1];
                    if (!AATesselatorImpl.linesCross(tmpThis[n + 0], tmpThis[n + 1], tmpThis[n7 + 0], tmpThis[n7 + 1], tmpThat[n8 + 0], tmpThat[n8 + 1], tmpThat[n9 + 0], tmpThat[n9 + 1])) continue;
                    return true;
                }
            }
            for (n2 = 0; n2 < n3 * 2; n2 += 6) {
                for (n = 0; n < n4 * 2; n += 6) {
                    if (n4 > 1 && AATesselatorImpl.triangleContainsPoint(tmpThis[n2 + 0], tmpThis[n2 + 1], tmpThat[n + 0], tmpThat[n + 1], tmpThat[n + 2], tmpThat[n + 3], tmpThat[n + 4], tmpThat[n + 5])) {
                        return true;
                    }
                    if (n3 <= 1 || !AATesselatorImpl.triangleContainsPoint(tmpThat[n + 0], tmpThat[n + 1], tmpThis[n2 + 0], tmpThis[n2 + 1], tmpThis[n2 + 2], tmpThis[n2 + 3], tmpThis[n2 + 4], tmpThis[n2 + 5])) continue;
                    return true;
                }
            }
            return false;
        }

        static enum Type {
            MOVETO,
            LINETO,
            QUADTO,
            CUBICTO,
            CLOSE;

        }
    }
}

