/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.prism.BasicStroke;
import com.sun.prism.Graphics;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.AATesselatorImpl;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.Paint;
import java.util.ArrayList;
import java.util.List;

class AATessShapeRepState {
    private static final AATesselatorImpl tess = new AATesselatorImpl();
    private static final GeomCache geomCache = new GeomCache();
    private final GeomData geomData;
    private Boolean useGeom = null;
    private final Object disposerReferent = new Object();
    private final Disposer.Record disposerRecord;

    AATessShapeRepState() {
        this.geomData = new GeomData();
        this.disposerRecord = new AATessDisposerRecord(this.geomData);
        Disposer.addRecord(this.disposerReferent, this.disposerRecord);
    }

    void invalidate() {
        geomCache.unref(this.geomData);
        this.useGeom = null;
    }

    void render(Graphics graphics, Shape shape, BasicStroke basicStroke, float f, float f2) {
        Object object;
        Object object2;
        BaseShaderGraphics baseShaderGraphics = (BaseShaderGraphics)graphics;
        Paint paint = baseShaderGraphics.getPaint();
        float f3 = baseShaderGraphics.getExtraAlpha();
        boolean bl = false;
        if (this.useGeom == null) {
            if (basicStroke != null) {
                shape = basicStroke.createStrokedShape(shape);
            }
            object2 = baseShaderGraphics.getContext();
            object = shape.getBounds();
            geomCache.get((BaseShaderContext)object2, this.geomData, shape, (RectBounds)object);
            if (this.geomData.vbSolid != null) {
                this.useGeom = Boolean.TRUE;
                bl = true;
            } else {
                this.useGeom = Boolean.FALSE;
            }
        }
        if (this.useGeom == Boolean.FALSE) {
            graphics.translate(f, f2);
            graphics.fill(shape);
            graphics.translate(-f, -f2);
            return;
        }
        object2 = this.geomData.vbSolid;
        object = this.geomData.vbCurve;
        int n = this.geomData.numSolidVerts;
        int n2 = this.geomData.numCurveVerts;
        if (bl || paint != this.geomData.cacheEntry.lastPaint || f3 != this.geomData.cacheEntry.lastExtraAlpha) {
            if (paint.getType() == Paint.Type.COLOR) {
                ((VertexBuffer)object2).setPerVertexColor((Color)paint, f3);
                ((VertexBuffer)object2).updateVertexColors(n);
                ((VertexBuffer)object).setPerVertexColor((Color)paint, f3);
                ((VertexBuffer)object).updateVertexColors(n2);
            } else {
                ((VertexBuffer)object2).setPerVertexColor(f3);
                ((VertexBuffer)object2).updateVertexColors(n);
                ((VertexBuffer)object).setPerVertexColor(f3);
                ((VertexBuffer)object).updateVertexColors(n2);
            }
            this.geomData.cacheEntry.lastPaint = paint;
            this.geomData.cacheEntry.lastExtraAlpha = f3;
        }
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (paint.getType().isGradient() && ((Gradient)paint).isProportional()) {
            RectBounds rectBounds = shape.getBounds();
            f4 = rectBounds.getMinX();
            f5 = rectBounds.getMinY();
            f6 = rectBounds.getWidth();
            f7 = rectBounds.getHeight();
        }
        baseShaderGraphics.translate(f, f2);
        if (n > 0) {
            baseShaderGraphics.fillTriangles((VertexBuffer)object2, n, f4, f5, f6, f7);
        }
        if (n2 > 0) {
            baseShaderGraphics.fillCubicCurves((VertexBuffer)object, n2, f4, f5, f6, f7);
        }
        baseShaderGraphics.translate(-f, -f2);
    }

    private static class AATessDisposerRecord
    implements Disposer.Record {
        private GeomData geomData;

        private AATessDisposerRecord(GeomData geomData) {
            this.geomData = geomData;
        }

        @Override
        public void dispose() {
            if (this.geomData != null) {
                geomCache.unref(this.geomData);
                this.geomData = null;
            }
        }
    }

    private static class GeomCache {
        private final List<CacheEntry> entries = new ArrayList<CacheEntry>();

        private GeomCache() {
        }

        void get(BaseShaderContext baseShaderContext, GeomData geomData, Shape shape, RectBounds rectBounds) {
            Object object;
            if (geomData == null) {
                throw new InternalError("GeomData must be non-null");
            }
            if (geomData.cacheEntry != null) {
                throw new InternalError("CacheEntry should already be null");
            }
            for (int i = 0; i < this.entries.size(); ++i) {
                object = this.entries.get(i);
                if (!GeomCache.dimensionsAreSimilar(rectBounds, ((CacheEntry)object).shapeBounds) || !((CacheEntry)object).shape.equals(shape)) continue;
                ++((CacheEntry)object).refCount;
                ((CacheEntry)object).geomData.copyInto(geomData);
                geomData.cacheEntry = object;
                return;
            }
            VertexBuffer vertexBuffer = baseShaderContext.getResourceFactory().createVertexBuffer(16, true);
            object = baseShaderContext.getResourceFactory().createVertexBuffer(16, true);
            int[] nArray = tess.generate(shape, vertexBuffer, (VertexBuffer)object);
            if (nArray != null) {
                geomData.vbSolid = vertexBuffer;
                geomData.vbCurve = object;
                geomData.numSolidVerts = nArray[0];
                geomData.numCurveVerts = nArray[1];
            } else {
                geomData.vbSolid = null;
                geomData.vbCurve = null;
                geomData.numSolidVerts = 0;
                geomData.numCurveVerts = 0;
            }
            CacheEntry cacheEntry = new CacheEntry();
            cacheEntry.shape = shape.copy();
            cacheEntry.shapeBounds = new RectBounds(rectBounds);
            cacheEntry.geomData = geomData.copy();
            cacheEntry.refCount = 1;
            geomData.cacheEntry = cacheEntry;
            this.entries.add(cacheEntry);
        }

        void unref(GeomData geomData) {
            if (geomData == null) {
                throw new InternalError("GeomData must be non-null");
            }
            CacheEntry cacheEntry = geomData.cacheEntry;
            if (cacheEntry == null) {
                return;
            }
            geomData.cacheEntry = null;
            geomData.vbSolid = null;
            geomData.vbCurve = null;
            --cacheEntry.refCount;
            if (cacheEntry.refCount <= 0) {
                cacheEntry.shape = null;
                cacheEntry.shapeBounds = null;
                cacheEntry.geomData.vbSolid = null;
                cacheEntry.geomData.vbCurve = null;
                cacheEntry.geomData = null;
                this.entries.remove(cacheEntry);
            }
        }

        private static boolean dimensionsAreSimilar(RectBounds rectBounds, RectBounds rectBounds2) {
            return (double)Math.abs(rectBounds.getWidth() - rectBounds2.getWidth()) < 0.001 && (double)Math.abs(rectBounds.getHeight() - rectBounds2.getHeight()) < 0.001;
        }
    }

    private static class CacheEntry {
        Shape shape;
        RectBounds shapeBounds;
        GeomData geomData;
        int refCount;
        Paint lastPaint;
        float lastExtraAlpha = -1.0f;

        private CacheEntry() {
        }
    }

    private static class GeomData {
        CacheEntry cacheEntry;
        VertexBuffer vbSolid;
        VertexBuffer vbCurve;
        int numSolidVerts;
        int numCurveVerts;

        private GeomData() {
        }

        GeomData copy() {
            GeomData geomData = new GeomData();
            geomData.cacheEntry = this.cacheEntry;
            geomData.vbSolid = this.vbSolid;
            geomData.vbCurve = this.vbCurve;
            geomData.numSolidVerts = this.numSolidVerts;
            geomData.numCurveVerts = this.numCurveVerts;
            return geomData;
        }

        void copyInto(GeomData geomData) {
            if (geomData == null) {
                throw new InternalError("MaskTexData must be non-null");
            }
            geomData.cacheEntry = this.cacheEntry;
            geomData.vbSolid = this.vbSolid;
            geomData.vbCurve = this.vbCurve;
            geomData.numSolidVerts = this.numSolidVerts;
            geomData.numCurveVerts = this.numCurveVerts;
        }
    }
}

