/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.StringTokenizer;

public class PrismSettings {
    public static boolean verbose;
    public static boolean debug;
    public static boolean trace;
    public static boolean printAllocs;
    public static boolean isVsyncEnabled;
    public static boolean dirtyOptsEnabled;
    public static boolean threadCheck;
    public static boolean cacheSimpleShapes;
    public static boolean cacheComplexShapes;
    public static boolean tessShapes;
    public static boolean tessShapesAA;
    public static boolean useNewImageLoader;
    public static String[] tryOrder;
    public static int numSamples;
    public static boolean doPiscesText;
    public static boolean doOpenPiscesText;
    public static boolean doT2KText;
    public static String refType;
    public static boolean forceRepaint;
    public static boolean isDevice;
    public static boolean noFallback;
    public static boolean showDirtyRegions;
    public static boolean showCull;
    public static boolean shutdownHook;
    public static int minTextureSize;
    public static int dirtyRegionCount;
    public static boolean disableBadDriverWarning;
    public static final boolean isMac;
    public static final boolean isWindows;
    public static final boolean isLinux;
    public static final boolean isSolaris;

    private static void checkSettings() {
        String string;
        isVsyncEnabled = "true".equals(System.getProperty("prism.vsync", "true")) && !Boolean.getBoolean("javafx.animation.fullspeed");
        dirtyOptsEnabled = "true".equals(System.getProperty("prism.dirtyopts", Boolean.toString(isWindows)));
        Integer n = Integer.getInteger("prism.dirtyregioncount");
        dirtyRegionCount = n != null ? n : 6;
        threadCheck = "true".equals(System.getProperty("prism.threadcheck", "false"));
        showDirtyRegions = Boolean.getBoolean("prism.showdirty");
        showCull = Boolean.getBoolean("prism.showcull");
        forceRepaint = Boolean.getBoolean("prism.forcerepaint");
        noFallback = Boolean.getBoolean("prism.noFallback");
        String string2 = System.getProperty("prism.cacheshapes", "complex");
        if ("all".equals(string2) || "true".equals(string2)) {
            cacheSimpleShapes = true;
            cacheComplexShapes = true;
        } else if ("complex".equals(string2)) {
            cacheSimpleShapes = false;
            cacheComplexShapes = true;
        }
        tessShapes = Boolean.getBoolean("prism.tess");
        tessShapesAA = Boolean.getBoolean("prism.tessaa");
        if (tessShapesAA) {
            tessShapes = true;
        }
        String string3 = System.getProperty("prism.newiio", "true");
        useNewImageLoader = "true".equals(string3);
        verbose = Boolean.getBoolean("prism.verbose");
        debug = Boolean.getBoolean("prism.debug");
        trace = Boolean.getBoolean("prism.trace");
        printAllocs = Boolean.getBoolean("prism.printallocs");
        disableBadDriverWarning = Boolean.getBoolean("prism.disableBadDriverWarning");
        numSamples = 0;
        String string4 = System.getProperty("prism.order");
        tryOrder = string4 != null ? PrismSettings.split(string4, ",") : (isWindows ? new String[]{"d3d", "j2d"} : (isMac ? new String[]{"es2", "j2d"} : (isLinux ? new String[]{"j2d"} : new String[]{"j2d"})));
        String string5 = System.getProperty("prism.multisample");
        if (string5 != null) {
            if ("true".equals(string5)) {
                numSamples = 2;
            } else {
                try {
                    numSamples = Integer.parseInt(string5);
                }
                catch (Exception exception) {
                    System.err.println("Try -Dprism.multisample=<true|2|4|8>");
                }
            }
            if (numSamples > 0) {
                System.out.println("Enabling multisampling with " + numSamples + " samples per pixel");
            }
        }
        String string6 = System.getProperty("prism.text", "t2k");
        doPiscesText = "pisces".equals(string6);
        doOpenPiscesText = "openpisces".equals(string6);
        boolean bl = doT2KText = !doPiscesText && !doOpenPiscesText;
        if (doT2KText) {
            string6 = "t2k";
        }
        refType = System.getProperty("prism.reftype");
        shutdownHook = isLinux ? ((string = System.getProperty("prism.shutdownHook")) == null ? true : Boolean.getBoolean("prism.shutdownHook")) : Boolean.getBoolean("prism.shutdownHook");
        string = System.getProperty("nativewindow.ws.name");
        isDevice = Boolean.getBoolean("prism.device");
        if (verbose) {
            System.out.print("Prism pipeline init order: ");
            for (String string7 : tryOrder) {
                System.out.print(string7 + " ");
            }
            System.out.println("");
            System.out.println("Using " + string6 + " for text rasterization");
            if (dirtyOptsEnabled) {
                System.out.println("Using dirty region optimizations");
            } else {
                System.out.println("Not using dirty region optimizations");
            }
        }
        if (isDevice) {
            minTextureSize = 0;
            String string8 = System.getProperty("prism.mintexturesize");
            if (string8 != null) {
                try {
                    minTextureSize = Integer.parseInt(string8);
                }
                catch (Exception exception) {
                    System.err.println("Try -Dprism.mintexturesize=<number>");
                }
            }
        }
    }

    private static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    static {
        isMac = System.getProperty("os.name").startsWith("Mac");
        isWindows = System.getProperty("os.name").startsWith("Windows");
        isLinux = System.getProperty("os.name").startsWith("Linux");
        isSolaris = System.getProperty("os.name").startsWith("Solaris");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PrismSettings.checkSettings();
                return null;
            }
        });
    }
}

