/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageStorage;
import com.sun.prism.Image;
import java.nio.ByteBuffer;

public class ImageFormatTool {
    public static Image convertImageFrame(ImageFrame imageFrame) {
        ByteBuffer byteBuffer = (ByteBuffer)imageFrame.getImageData();
        ImageStorage.ImageType imageType = imageFrame.getImageType();
        int n = imageFrame.getWidth();
        int n2 = imageFrame.getHeight();
        switch (imageType) {
            case GRAY: {
                return Image.fromByteGrayData(byteBuffer, n, n2, imageFrame.getStride());
            }
            case RGB: {
                return Image.fromByteRgbData(byteBuffer, n, n2, imageFrame.getStride());
            }
            case RGBA: {
                byteBuffer = ImageFormatTool.BGRAtoBGRA_PRE(byteBuffer);
            }
            case RGBA_PRE: {
                return Image.fromByteBgraPreData(ImageFormatTool.RGBAtoBGRA(byteBuffer), n, n2, imageFrame.getStride());
            }
            case GRAY_ALPHA: {
                byteBuffer = ImageFormatTool.LumAtoLumA_PRE(byteBuffer);
            }
            case GRAY_ALPHA_PRE: {
                if (imageFrame.getStride() != imageFrame.getWidth() * 2) {
                    throw new AssertionError((Object)"Bad stride for GRAY_ALPHA");
                }
                return Image.fromByteBgraPreData(ImageFormatTool.LumAtoBGRA(byteBuffer), n, n2);
            }
        }
        throw new RuntimeException("Unknown image type: " + (Object)((Object)imageType));
    }

    public static byte[] LumAtoLumA_PRE(byte[] byArray) {
        int n = byArray.length & 0xFFFFFFFE;
        for (int i = 0; i != n; i += 2) {
            int n2 = byArray[i + 1] & 0xFF;
            byArray[i] = (byte)(((byArray[i] & 0xFF) * n2 + 127) / 255);
        }
        return byArray;
    }

    public static ByteBuffer LumAtoLumA_PRE(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            ImageFormatTool.LumAtoLumA_PRE(byteBuffer.array());
        } else {
            int n = byteBuffer.capacity() & 0xFFFFFFFE;
            for (int i = 0; i != n; i += 2) {
                int n2 = byteBuffer.get(i + 1) & 0xFF;
                byteBuffer.put(i, (byte)(((byteBuffer.get(i) & 0xFF) * n2 + 127) / 255));
            }
        }
        return byteBuffer;
    }

    public static byte[] LumAtoBGRA(byte[] byArray) {
        int n = byArray.length & 0xFFFFFFFE;
        byte[] byArray2 = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i != n; i += 2) {
            byte by = byArray[i];
            byte by2 = byArray[i + 1];
            byte by3 = by;
            byArray2[n2 + 2] = by3;
            byArray2[n2 + 1] = by3;
            byArray2[n2] = by3;
            byArray2[n2 + 3] = by2;
            n2 += 4;
        }
        return byArray2;
    }

    public static ByteBuffer LumAtoBGRA(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            return ByteBuffer.wrap(ImageFormatTool.LumAtoBGRA(byteBuffer.array()));
        }
        int n = byteBuffer.capacity() & 0xFFFFFFFE;
        byte[] byArray = new byte[n * 2];
        int n2 = 0;
        for (int i = 0; i != n; i += 2) {
            byte by = byteBuffer.get(i);
            byte by2 = byteBuffer.get(i + 1);
            byte by3 = by;
            byArray[n2 + 2] = by3;
            byArray[n2 + 1] = by3;
            byArray[n2] = by3;
            byArray[n2 + 3] = by2;
            n2 += 4;
        }
        return ByteBuffer.wrap(byArray);
    }

    public static byte[] BGRAtoBGRA_PRE(byte[] byArray) {
        int n = byArray.length & 0xFFFFFFFC;
        for (int i = 0; i != n; i += 4) {
            int n2 = byArray[i + 3] & 0xFF;
            byArray[i + 0] = (byte)(((byArray[i + 0] & 0xFF) * n2 + 127) / 255);
            byArray[i + 1] = (byte)(((byArray[i + 1] & 0xFF) * n2 + 127) / 255);
            byArray[i + 2] = (byte)(((byArray[i + 2] & 0xFF) * n2 + 127) / 255);
        }
        return byArray;
    }

    public static ByteBuffer BGRAtoBGRA_PRE(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            ImageFormatTool.BGRAtoBGRA_PRE(byteBuffer.array());
        } else {
            int n = byteBuffer.capacity() & 0xFFFFFFFC;
            for (int i = 0; i != n; i += 4) {
                int n2 = byteBuffer.get(i + 3) & 0xFF;
                byteBuffer.put(i + 0, (byte)(((byteBuffer.get(i + 0) & 0xFF) * n2 + 127) / 255));
                byteBuffer.put(i + 1, (byte)(((byteBuffer.get(i + 1) & 0xFF) * n2 + 127) / 255));
                byteBuffer.put(i + 2, (byte)(((byteBuffer.get(i + 2) & 0xFF) * n2 + 127) / 255));
            }
        }
        return byteBuffer;
    }

    public static byte[] RGBAtoBGRA(byte[] byArray) {
        int n = byArray.length & 0xFFFFFFFC;
        for (int i = 0; i != n; i += 4) {
            byte by = byArray[i];
            byArray[i] = byArray[i + 2];
            byArray[i + 2] = by;
        }
        return byArray;
    }

    public static ByteBuffer RGBAtoBGRA(ByteBuffer byteBuffer) {
        if (byteBuffer.hasArray()) {
            ImageFormatTool.RGBAtoBGRA(byteBuffer.array());
        } else {
            int n = byteBuffer.capacity() & 0xFFFFFFFC;
            for (int i = 0; i != n; i += 4) {
                byte by = byteBuffer.get(i);
                byteBuffer.put(i, byteBuffer.get(i + 2));
                byteBuffer.put(i + 2, by);
            }
        }
        return byteBuffer;
    }

    public static ByteBuffer RGBtoARGB(ByteBuffer byteBuffer) {
        int n = byteBuffer.capacity();
        byte by = -1;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n / 3 * 4);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byteBuffer2.put(n3 + 0, by);
            byteBuffer2.put(n3 + 1, byteBuffer.get(n2 + 0));
            byteBuffer2.put(n3 + 2, byteBuffer.get(n2 + 1));
            byteBuffer2.put(n3 + 3, byteBuffer.get(n2 + 2));
            n2 += 3;
            n3 += 4;
        }
        return byteBuffer2;
    }

    public static ByteBuffer RGBtoBGRA(ByteBuffer byteBuffer) {
        int n = byteBuffer.capacity();
        byte by = -1;
        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n / 3 * 4);
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byteBuffer2.put(n3 + 0, byteBuffer.get(n2 + 2));
            byteBuffer2.put(n3 + 1, byteBuffer.get(n2 + 1));
            byteBuffer2.put(n3 + 2, byteBuffer.get(n2 + 0));
            byteBuffer2.put(n3 + 3, by);
            n2 += 3;
            n3 += 4;
        }
        return byteBuffer2;
    }
}

