/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism;

import com.sun.glass.ui.Screen;
import com.sun.javafx.font.FontFactory;
import com.sun.prism.ResourceFactory;
import com.sun.prism.impl.PrismSettings;
import com.sun.t2k.T2KFontFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;

public abstract class GraphicsPipeline {
    private FontFactory fontFactory;
    protected Map deviceDetails = null;
    private static GraphicsPipeline installedPipeline;

    public abstract boolean init();

    public void dispose() {
        installedPipeline = null;
    }

    public abstract ResourceFactory getResourceFactory(Screen var1);

    public abstract ResourceFactory getDefaultResourceFactory(List<Screen> var1);

    public abstract boolean is3DSupported();

    public static ResourceFactory getDefaultResourceFactory() {
        List<Screen> list = Screen.getScreens();
        return GraphicsPipeline.getPipeline().getDefaultResourceFactory(list);
    }

    public FontFactory getFontFactory() {
        if (this.fontFactory == null) {
            this.fontFactory = T2KFontFactory.getFontFactory();
        }
        return this.fontFactory;
    }

    public Map getDeviceDetails() {
        return this.deviceDetails;
    }

    protected void setDeviceDetails(Map map) {
        this.deviceDetails = map;
    }

    public static GraphicsPipeline createPipeline() {
        if (PrismSettings.tryOrder.length == 0) {
            if (PrismSettings.verbose) {
                System.out.println("No Prism pipelines specified");
            }
            return null;
        }
        if (installedPipeline != null) {
            throw new IllegalStateException("pipeline already created:" + installedPipeline);
        }
        for (String string : PrismSettings.tryOrder) {
            if (PrismSettings.verbose && "j2d".equals(string)) {
                System.err.println("*** Fallback to Prism SW pipeline");
            }
            String string2 = "com.sun.prism." + string + "." + string.toUpperCase() + "Pipeline";
            try {
                Method method;
                GraphicsPipeline graphicsPipeline;
                if (PrismSettings.verbose) {
                    System.out.println("Prism pipeline name = " + string2);
                }
                Class<?> clazz = Class.forName(string2);
                if (PrismSettings.verbose) {
                    System.out.println("(X) Got class = " + clazz);
                }
                if ((graphicsPipeline = (GraphicsPipeline)(method = clazz.getMethod("getInstance", null)).invoke(null, (Object[])null)) != null && graphicsPipeline.init()) {
                    if (PrismSettings.verbose) {
                        System.out.println("Initialized prism pipeline: " + clazz.getName());
                    }
                    installedPipeline = graphicsPipeline;
                    return installedPipeline;
                }
                if (graphicsPipeline != null) {
                    graphicsPipeline.dispose();
                    graphicsPipeline = null;
                }
                if (!PrismSettings.verbose) continue;
                System.err.println("GraphicsPipeline.createPipeline: error initializing pipeline " + string2);
            }
            catch (Throwable throwable) {
                if (!PrismSettings.verbose) continue;
                System.err.println("GraphicsPipeline.createPipeline failed for " + string2);
                throwable.printStackTrace();
            }
        }
        StringBuffer stringBuffer = new StringBuffer("Graphics Device initialization failed for :  ");
        for (int i = 0; i < PrismSettings.tryOrder.length; ++i) {
            stringBuffer.append(PrismSettings.tryOrder[i]);
            if (i >= PrismSettings.tryOrder.length - 1) continue;
            stringBuffer.append(", ");
        }
        System.err.println(stringBuffer);
        return null;
    }

    public static GraphicsPipeline getPipeline() {
        return installedPipeline;
    }

    public boolean isEffectSupported() {
        return true;
    }
}

