/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import com.sun.media.jfxmedia.AudioClip;
import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmediaimpl.MediaDisposer;
import com.sun.media.jfxmediaimpl.NativeMediaAudioClipPlayer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public final class NativeMediaAudioClip
extends AudioClip {
    private URI sourceURI;
    private Locator mediaLocator;
    private AtomicInteger playCount;
    private static final Map<URI, File> tempFiles = new WeakHashMap<URI, File>();
    private static final TempFileDisposer tempFileDisposer = new TempFileDisposer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized URI getTempURI(URI source) {
        URI outURI = null;
        File tempFile = tempFiles.get(source);
        if (null != tempFile) {
            return tempFile.toURI();
        }
        BufferedInputStream reader = null;
        FilterOutputStream writer = null;
        try {
            int count;
            String suffix = null;
            URLConnection connection = source.toURL().openConnection();
            connection.setAllowUserInteraction(false);
            connection.connect();
            String contentType = connection.getContentType().toLowerCase();
            if (contentType.contains("aiff")) {
                suffix = ".aiff";
            } else if (contentType.contains("wav")) {
                suffix = ".wav";
            } else if (contentType.contains("mp3")) {
                suffix = ".mp3";
            }
            tempFile = File.createTempFile(Integer.toString(source.hashCode()), suffix);
            tempFile.deleteOnExit();
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "Creating temp file at " + tempFile + " for " + source);
            }
            int length = connection.getContentLength();
            reader = new BufferedInputStream(connection.getInputStream());
            writer = new BufferedOutputStream(new FileOutputStream(tempFile));
            byte[] tempData = new byte[8192];
            for (int offset = 0; offset < length; offset += count) {
                count = reader.read(tempData);
                if (count > 0) {
                    ((BufferedOutputStream)writer).write(tempData, 0, count);
                    continue;
                }
                if (!Logger.canLog(3)) break;
                Logger.logMsg(3, "reader returned bad count!");
                break;
            }
            outURI = tempFile.toURI();
            MediaDisposer.addResourceDisposer(outURI, tempFile, tempFileDisposer);
        }
        catch (Throwable t) {
            try {
                if (Logger.canLog(1)) {
                    Logger.logMsg(1, "Exception while trying to download " + source + ": " + t);
                }
                if (null != tempFile) {
                    tempFile.delete();
                }
                URI uRI = null;
                return uRI;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (null != writer) {
                        writer.close();
                    }
                    if (null != reader) {
                        reader.close();
                    }
                }
                catch (Throwable t2) {}
            }
        }
        try {
            if (null != writer) {
                writer.close();
            }
            if (null == reader) return outURI;
            reader.close();
            return outURI;
        }
        catch (Throwable t) {
            return outURI;
        }
    }

    private NativeMediaAudioClip(URI source) throws URISyntaxException, FileNotFoundException, IOException {
        this.sourceURI = source;
        this.playCount = new AtomicInteger(0);
        if (Logger.canLog(1)) {
            Logger.logMsg(1, "Creating AudioClip for URI " + source);
        }
        if (source.getScheme().equals("http")) {
            URI tempURI = NativeMediaAudioClip.getTempURI(source);
            if (null != tempURI) {
                this.sourceURI = tempURI;
            }
            if (Logger.canLog(1)) {
                Logger.logMsg(1, "  - New URI: " + this.sourceURI);
            }
        }
        this.mediaLocator = new Locator(this.sourceURI);
        this.mediaLocator.init();
    }

    Locator getLocator() {
        return this.mediaLocator;
    }

    public static AudioClip load(URI source) throws URISyntaxException, FileNotFoundException, IOException {
        return new NativeMediaAudioClip(source);
    }

    public static AudioClip create(byte[] data, int dataOffset, int sampleCount, int sampleFormat, int channels, int sampleRate) {
        throw new UnsupportedOperationException("NativeMediaAudioClip does not support creating clips from raw sample data");
    }

    public AudioClip createSegment(double startTime, double stopTime) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip createSegment(int startSample, int endSample) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip resample(int startSample, int endSample, int newSampleRate) throws IllegalArgumentException, IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip append(AudioClip clip) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public AudioClip flatten() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean isPlaying() {
        return this.playCount.get() > 0;
    }

    public void play() {
        this.play(this.clipVolume, this.clipBalance, this.clipRate, this.clipPan, this.loopCount, this.clipPriority);
    }

    public void play(double volume) {
        this.play(volume, this.clipBalance, this.clipRate, this.clipPan, this.loopCount, this.clipPriority);
    }

    public void play(double volume, double balance, double rate, double pan, int loopCount, int priority) {
        this.playCount.getAndIncrement();
        NativeMediaAudioClipPlayer.playClip(this, volume, balance, rate, pan, loopCount, priority);
    }

    public void stop() {
        NativeMediaAudioClipPlayer.stopPlayers(this.mediaLocator);
    }

    public static void stopAllClips() {
        NativeMediaAudioClipPlayer.stopPlayers(null);
    }

    void playFinished() {
        this.playCount.decrementAndGet();
    }

    private static class TempFileDisposer
    implements MediaDisposer.ResourceDisposer {
        private TempFileDisposer() {
        }

        public void disposeResource(Object resource) {
            if (resource instanceof File) {
                final File theFile = (File)resource;
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        theFile.delete();
                        return null;
                    }
                });
            }
        }
    }
}

