/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmediaimpl;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;

public class NativeLibLoader {
    private static final HashSet<String> loaded = new HashSet();
    private static boolean usingJNLPAppletLauncher;
    private static Method jnlpLoadLibraryMethod;
    private static boolean verbose;
    private static File libDir;
    private static String libPrefix;
    private static String libSuffix;
    private static String libSuffixAlt;

    public static synchronized void loadLibrary(String libname) {
        if (!loaded.contains(libname)) {
            NativeLibLoader.loadLibraryInternal(libname);
            loaded.add(libname);
        }
    }

    private static void loadLibraryInternal(String libraryName) {
        if (usingJNLPAppletLauncher && !libraryName.equals("jawt")) {
            try {
                if (jnlpLoadLibraryMethod == null) {
                    Class<?> jnlpAppletLauncherClass = Class.forName("org.jdesktop.applet.util.JNLPAppletLauncher");
                    jnlpLoadLibraryMethod = jnlpAppletLauncherClass.getDeclaredMethod("loadLibrary", String.class);
                }
                jnlpLoadLibraryMethod.invoke(null, libraryName);
            }
            catch (Exception e) {
                Throwable t = e;
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(e);
            }
        }
        try {
            NativeLibLoader.loadLibraryFullPath(libraryName);
        }
        catch (UnsatisfiedLinkError ex) {
            try {
                System.loadLibrary(libraryName);
                if (verbose) {
                    System.err.println("WARNING: " + ex.toString());
                    System.err.println("    using System.loadLibrary(" + libraryName + ") as a fallback");
                }
            }
            catch (UnsatisfiedLinkError ex2) {
                throw ex;
            }
        }
    }

    private static void loadLibraryFullPath(String libraryName) {
        block13: {
            try {
                if (libDir == null) {
                    Class<NativeLibLoader> theClass = NativeLibLoader.class;
                    String theClassFile = "NativeLibLoader.class";
                    String classUrlString = theClass.getResource(theClassFile).toString();
                    if (!classUrlString.startsWith("jar:file:") || classUrlString.indexOf("!") == -1) {
                        throw new UnsatisfiedLinkError("Invalid URL for class: " + classUrlString);
                    }
                    String tmpStr = classUrlString.substring(4, classUrlString.lastIndexOf("!"));
                    int lastIndexOfSlash = Math.max(tmpStr.lastIndexOf("/"), tmpStr.lastIndexOf("\\"));
                    String libDirUrlString = tmpStr.substring(0, lastIndexOfSlash) + "/../bin";
                    libDir = new File(new URI(libDirUrlString).getPath());
                    String osName = System.getProperty("os.name");
                    if (osName.startsWith("Windows")) {
                        File libDir64;
                        if (System.getProperty("sun.arch.data.model", "").startsWith("64") && (libDir64 = new File(libDir, "64bit")).isDirectory()) {
                            libDir = libDir64;
                        }
                        libPrefix = "";
                        libSuffix = ".dll";
                    } else if (osName.startsWith("Mac")) {
                        libPrefix = "lib";
                        libSuffix = ".jnilib";
                        libSuffixAlt = ".dylib";
                    } else if (osName.startsWith("Linux")) {
                        libPrefix = "lib";
                        libSuffix = ".so";
                    }
                }
                File libFile = new File(libDir, libPrefix + libraryName + libSuffix);
                String libFileName = libFile.getCanonicalPath();
                try {
                    System.load(libFileName);
                }
                catch (UnsatisfiedLinkError ex) {
                    if (libSuffixAlt != null) {
                        libFile = new File(libDir, libPrefix + libraryName + libSuffixAlt);
                        libFileName = libFile.getAbsolutePath();
                        System.load(libFileName);
                        break block13;
                    }
                    throw ex;
                }
            }
            catch (Exception e) {
                throw (UnsatisfiedLinkError)new UnsatisfiedLinkError().initCause(e);
            }
        }
    }

    static {
        verbose = false;
        libDir = null;
        libPrefix = "";
        libSuffix = "";
        libSuffixAlt = null;
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String sunAppletLauncher = System.getProperty("sun.jnlp.applet.launcher");
                usingJNLPAppletLauncher = Boolean.valueOf(sunAppletLauncher);
                verbose = Boolean.getBoolean("javafx.verbose");
                return null;
            }
        });
    }
}

