/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jfxmedia.metadata;

import com.sun.media.jfxmedia.locator.Locator;
import com.sun.media.jfxmedia.logging.Logger;
import com.sun.media.jfxmedia.metadata.MetadataParser;
import java.io.IOException;
import java.util.Arrays;

public class ID3MetadataParser
extends MetadataParser {
    private static final int ID3_VERSION_MIN = 3;
    private static final int ID3_VERSION_MAX = 4;
    private int COMMCount = 0;
    private int version = 3;
    private boolean unsyrchronized = false;

    public ID3MetadataParser(Locator locator) {
        super(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parse() {
        block21: {
            try {
                byte[] buf = this.getBytes(10);
                this.version = buf[3] & 0xFF;
                if (buf[0] != 73 || buf[1] != 68 || buf[2] != 51 || this.version < 3 || this.version > 4) break block21;
                int flags = buf[5] & 0xFF;
                if ((flags & 0x80) == 128) {
                    this.unsyrchronized = true;
                }
                int tagSize = 0;
                int shift = 21;
                for (int i = 6; i < 10; ++i) {
                    tagSize += (buf[i] & 0x7F) << shift;
                    shift -= 7;
                }
                this.startRawMetadata(tagSize + 10);
                this.stuffRawMetadata(buf, 0, 10);
                this.readRawMetadata(tagSize);
                this.setParseRawMetadata(true);
                this.skipBytes(10);
                while (this.getStreamPosition() < tagSize + 10) {
                    byte[] data;
                    String encoding;
                    String frameID = this.getString(4);
                    int frameSize = this.getFrameSize();
                    this.skipBytes(2);
                    if (frameID.equals("APIC")) {
                        byte[] image;
                        byte[] data2 = this.getBytes(frameSize);
                        if (this.unsyrchronized) {
                            data2 = this.unsyrchronizeBuffer(data2);
                        }
                        if ((image = this.getImageFromAPIC(data2)) == null) continue;
                        this.addMetadataItem("image", image);
                        continue;
                    }
                    if (frameID.startsWith("T") && !frameID.equals("TXXX")) {
                        encoding = this.getEncoding();
                        data = this.getBytes(frameSize - 1);
                        if (this.unsyrchronized) {
                            data = this.unsyrchronizeBuffer(data);
                        }
                        String value = new String(data, encoding);
                        String[] tag = this.getTagFromFrameID(frameID);
                        if (tag == null) continue;
                        for (int i = 0; i < tag.length; ++i) {
                            Object tagValue = this.convertValue(tag[i], value);
                            if (tagValue == null) continue;
                            this.addMetadataItem(tag[i], tagValue);
                        }
                        continue;
                    }
                    if (frameID.equals("COMM")) {
                        String[] tag;
                        String value;
                        encoding = this.getEncoding();
                        data = this.getBytes(3);
                        if (this.unsyrchronized) {
                            data = this.unsyrchronizeBuffer(data);
                        }
                        String language = new String(data);
                        data = this.getBytes(frameSize - 4);
                        if (this.unsyrchronized) {
                            data = this.unsyrchronizeBuffer(data);
                        }
                        if ((value = new String(data, encoding)) == null) continue;
                        int index = value.indexOf(0);
                        String content = "";
                        String comment = "";
                        if (index == 0) {
                            comment = encoding.equals("UTF-16") ? value.substring(2) : value.substring(1);
                        } else {
                            content = value.substring(0, index);
                            comment = encoding.equals("UTF-16") ? value.substring(index + 2) : value.substring(index + 1);
                        }
                        if ((tag = this.getTagFromFrameID(frameID)) == null) continue;
                        for (int i = 0; i < tag.length; ++i) {
                            this.addMetadataItem(tag[i] + "-" + this.COMMCount, content + "[" + language + "]=" + comment);
                            ++this.COMMCount;
                        }
                        continue;
                    }
                    this.skipBytes(frameSize);
                }
            }
            catch (Exception ex) {
                if (Logger.canLog(3)) {
                    Logger.logMsg(3, "Exception while processing ID3v2 metadata: " + ex);
                }
            }
            finally {
                if (null != this.rawMetaBlob) {
                    this.setParseRawMetadata(false);
                    this.addRawMetadata("ID3");
                    this.disposeRawMetadata();
                }
                this.done();
            }
        }
    }

    private int getFrameSize() throws IOException {
        if (this.version == 4) {
            byte[] buf = this.getBytes(4);
            int size = 0;
            int shift = 21;
            for (int i = 0; i < 4; ++i) {
                size += (buf[i] & 0x7F) << shift;
                shift -= 7;
            }
            return size;
        }
        return this.getInteger();
    }

    private String getEncoding() throws IOException {
        byte encodingType = this.getNextByte();
        if (encodingType == 0) {
            return "ISO-8859-1";
        }
        if (encodingType == 1) {
            return "UTF-16";
        }
        if (encodingType == 2) {
            return "UTF-16BE";
        }
        if (encodingType == 3) {
            return "UTF-8";
        }
        throw new IllegalArgumentException();
    }

    private String[] getTagFromFrameID(String frameID) {
        if (frameID.equals("TPE2")) {
            return new String[]{"album artist"};
        }
        if (frameID.equals("TALB")) {
            return new String[]{"album"};
        }
        if (frameID.equals("TPE1")) {
            return new String[]{"artist"};
        }
        if (frameID.equals("COMM")) {
            return new String[]{"comment"};
        }
        if (frameID.equals("TCOM")) {
            return new String[]{"composer"};
        }
        if (frameID.equals("TLEN")) {
            return new String[]{"duration"};
        }
        if (frameID.equals("TCON")) {
            return new String[]{"genre"};
        }
        if (frameID.equals("TIT2")) {
            return new String[]{"title"};
        }
        if (frameID.equals("TRCK")) {
            return new String[]{"track number", "track count"};
        }
        if (frameID.equals("TPOS")) {
            return new String[]{"disc number", "disc count"};
        }
        if (frameID.equals("TYER") || frameID.equals("TDRC")) {
            return new String[]{"year"};
        }
        return null;
    }

    private byte[] getImageFromAPIC(byte[] data) {
        int j;
        int upperBound;
        boolean isSignatureFound;
        boolean isImageJPEG = false;
        boolean isImagePNG = false;
        int maxIndex = data.length - 10;
        int offset = 0;
        for (int j2 = 0; j2 < maxIndex; ++j2) {
            if (data[j2] != 105 || data[j2 + 1] != 109 || data[j2 + 2] != 97 || data[j2 + 3] != 103 || data[j2 + 4] != 101 || data[j2 + 5] != 47) continue;
            if (data[j2 += 6] == 106 && data[j2 + 1] == 112 && data[j2 + 2] == 101 && data[j2 + 3] == 103) {
                isImageJPEG = true;
                offset = j2 + 4;
                break;
            }
            if (data[j2] != 112 || data[j2 + 1] != 110 || data[j2 + 2] != 103) continue;
            isImagePNG = true;
            offset = j2 + 3;
            break;
        }
        if (isImageJPEG) {
            isSignatureFound = false;
            upperBound = data.length - 1;
            for (j = offset; j < upperBound; ++j) {
                if (-1 != data[j] || -40 != data[j + 1]) continue;
                isSignatureFound = true;
                offset = j;
                break;
            }
            if (isSignatureFound) {
                return Arrays.copyOfRange(data, offset, data.length);
            }
        }
        if (isImagePNG) {
            isSignatureFound = false;
            upperBound = data.length - 7;
            for (j = offset; j < upperBound; ++j) {
                if (-119 != data[j] || 80 != data[j + 1] || 78 != data[j + 2] || 71 != data[j + 3] || 13 != data[j + 4] || 10 != data[j + 5] || 26 != data[j + 6] || 10 != data[j + 7]) continue;
                isSignatureFound = true;
                offset = j;
                break;
            }
            if (isSignatureFound) {
                return Arrays.copyOfRange(data, offset, data.length);
            }
        }
        return null;
    }

    private byte[] unsyrchronizeBuffer(byte[] data) {
        byte[] udata = new byte[data.length];
        int udatalen = 0;
        for (int i = 0; i < data.length; ++i) {
            if ((data[i] & 0xFF) == 255 && data[i + 1] == 0 && data[i + 2] == 0 || (data[i] & 0xFF) == 255 && data[i + 1] == 0 && (data[i + 2] & 0xE0) == 224) {
                udata[udatalen] = data[i];
                udata[++udatalen] = data[i + 2];
                ++udatalen;
                i += 2;
                continue;
            }
            udata[udatalen] = data[i];
            ++udatalen;
        }
        return Arrays.copyOf(udata, udatalen);
    }
}

