/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.tk.quantum.OverlayRunnable;
import com.sun.javafx.tk.quantum.PaintRunnable;
import com.sun.javafx.tk.quantum.ViewScene;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.PauseTransition;
import javafx.animation.SequentialTransition;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Scene;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.stage.Screen;
import javafx.util.Duration;

public class OverlayWarning {
    private static final Locale LOCALE = Locale.getDefault();
    private static final ResourceBundle RESOURCES = ResourceBundle.getBundle(OverlayWarning.class.getPackage().getName() + ".QuantumMessagesBundle", LOCALE);
    private static final float PAD = 40.0f;
    private static final float RECTW = 600.0f;
    private static final float RECTH = 100.0f;
    private static final float ARC = 20.0f;
    private static final int FONTSIZE = 24;
    private ViewScene view;
    private Group sceneRoot;
    private OverlayRunnable overlayPainter;
    private SequentialTransition overlayTransition;
    private PaintRunnable origPainter;

    public static String localize(String string) {
        return RESOURCES.getString(string);
    }

    public OverlayWarning(ViewScene viewScene) {
        this.view = viewScene;
        this.sceneRoot = this.createOverlayGroup();
        this.overlayPainter = new OverlayRunnable(this.view, this.view.getPen());
        this.overlayPainter.setOverlayRoot((NGNode)this.sceneRoot.impl_getPGNode());
        this.overlayTransition = new SequentialTransition();
        PauseTransition pauseTransition = new PauseTransition(Duration.millis(4000.0));
        FadeTransition fadeTransition = new FadeTransition(Duration.millis(1000.0), this.sceneRoot);
        fadeTransition.setFromValue(1.0);
        fadeTransition.setToValue(0.0);
        this.overlayTransition.getChildren().add(pauseTransition);
        this.overlayTransition.getChildren().add(fadeTransition);
        final PaintRunnable paintRunnable = this.origPainter = this.view.getPen().getPaintRunnable();
        this.overlayTransition.setOnFinished(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent actionEvent) {
                OverlayWarning.this.view.getPen().setPaintRunnable(paintRunnable);
                OverlayWarning.this.view.entireSceneNeedsRepaint();
            }
        });
    }

    protected void warn() {
        this.view.getPen().setPaintRunnable(this.overlayPainter);
        this.overlayTransition.play();
    }

    protected void cancel() {
        if (this.overlayTransition != null && this.overlayTransition.getStatus() == Animation.Status.RUNNING) {
            this.overlayTransition.stop();
            if (this.overlayPainter != null) {
                this.view.getPen().setPaintRunnable(this.origPainter);
                this.view.entireSceneNeedsRepaint();
            }
        }
    }

    private Group createOverlayGroup() {
        Scene scene = new Scene(new Group());
        Font font = new Font(Font.getDefault().getFamily(), 24.0);
        Text text = new Text();
        Rectangle2D rectangle2D = Screen.getPrimary().getBounds();
        scene.setFill(null);
        String string = "-fx-effect: dropshadow(two-pass-box, rgba(0,0,0,0.75), 3, 0.0, 0, 2);";
        text.setText(OverlayWarning.localize("OverlayWarningESC"));
        text.setStroke(Color.WHITE);
        text.setFill(Color.WHITE);
        text.setFont(font);
        text.setWrappingWidth(520.0);
        text.setStyle(string);
        text.setTextAlignment(TextAlignment.CENTER);
        Rectangle rectangle = this.createBackground(text, rectangle2D);
        Group group = (Group)scene.getRoot();
        group.getChildren().add(rectangle);
        group.getChildren().add(text);
        text.impl_updatePG();
        rectangle.impl_updatePG();
        group.impl_updatePG();
        return group;
    }

    private Rectangle createBackground(Text text, Rectangle2D rectangle2D) {
        Rectangle rectangle = new Rectangle();
        double d = text.getLayoutBounds().getWidth();
        double d2 = text.getLayoutBounds().getHeight();
        double d3 = (rectangle2D.getWidth() - 600.0) / 2.0;
        double d4 = rectangle2D.getHeight() / 2.0;
        rectangle.setWidth(600.0);
        rectangle.setHeight(100.0);
        rectangle.setX(d3);
        rectangle.setY(d4 - 100.0);
        rectangle.setArcWidth(20.0);
        rectangle.setArcHeight(20.0);
        rectangle.setFill(Color.gray(0.0, 0.6));
        text.setX(d3 + (600.0 - d) / 2.0);
        text.setY(d4 - 50.0 + (d2 - text.getBaselineOffset()) / 2.0);
        return rectangle;
    }
}

