/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.svgpath.ext.geom;

import com.sun.javafx.geom.Arc2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.svgpath.ext.geom.ExtendedPathIterator;
import com.sun.javafx.svgpath.ext.geom.ExtendedShape;

public class ExtendedGeneralPath
extends ExtendedShape {
    protected Path2D path;
    int numVals = 0;
    int numSeg = 0;
    double[] values = null;
    int[] types = null;

    public ExtendedGeneralPath() {
        this.path = new Path2D();
    }

    public ExtendedGeneralPath(int n) {
        this.path = new Path2D(n);
    }

    public ExtendedGeneralPath(int n, int n2) {
        this.path = new Path2D(n, n2);
    }

    public ExtendedGeneralPath(Shape shape) {
        this();
        this.append(shape, false);
    }

    public synchronized void arcTo(double d, double d2, double d3, boolean bl, boolean bl2, double d4, double d5) {
        if (d == 0.0 || d2 == 0.0) {
            this.lineTo((float)d4, (float)d5);
            return;
        }
        Point2D point2D = this.path.getCurrentPoint();
        double d6 = point2D.x;
        double d7 = point2D.y;
        if (d6 == d4 && d7 == d5) {
            return;
        }
        Arc2D arc2D = ExtendedGeneralPath.computeArc(d6, d7, d, d2, d3, bl, bl2, d4, d5);
        if (arc2D == null) {
            return;
        }
        BaseTransform baseTransform = BaseTransform.getRotateInstance(Math.toRadians(d3), arc2D.getCenterX(), arc2D.getCenterY());
        this.path.append(arc2D.getPathIterator(baseTransform), true);
        this.makeRoom(7);
        this.types[this.numSeg++] = 4321;
        this.values[this.numVals++] = d;
        this.values[this.numVals++] = d2;
        this.values[this.numVals++] = d3;
        this.values[this.numVals++] = bl ? 1.0 : 0.0;
        this.values[this.numVals++] = bl2 ? 1.0 : 0.0;
        this.values[this.numVals++] = d4;
        this.values[this.numVals++] = d5;
    }

    public static Arc2D computeArc(double d, double d2, double d3, double d4, double d5, boolean bl, boolean bl2, double d6, double d7) {
        double d8;
        double d9;
        double d10 = (d - d6) / 2.0;
        double d11 = (d2 - d7) / 2.0;
        d5 = Math.toRadians(d5 % 360.0);
        double d12 = Math.cos(d5);
        double d13 = Math.sin(d5);
        double d14 = d12 * d10 + d13 * d11;
        double d15 = -d13 * d10 + d12 * d11;
        double d16 = d14 * d14;
        double d17 = (d3 = Math.abs(d3)) * d3;
        double d18 = d16 / d17 + (d9 = d15 * d15) / (d8 = (d4 = Math.abs(d4)) * d4);
        if (d18 > 1.0) {
            d3 = Math.sqrt(d18) * d3;
            d4 = Math.sqrt(d18) * d4;
            d17 = d3 * d3;
            d8 = d4 * d4;
        }
        double d19 = bl != bl2 ? 1.0 : -1.0;
        double d20 = (d17 * d8 - d17 * d9 - d8 * d16) / (d17 * d9 + d8 * d16);
        d20 = d20 >= 0.0 ? d20 : 0.0;
        double d21 = d19 * Math.sqrt(d20);
        double d22 = d21 * (d3 * d15 / d4);
        double d23 = d21 * -(d4 * d14 / d3);
        double d24 = (d + d6) / 2.0;
        double d25 = (d2 + d7) / 2.0;
        double d26 = d24 + (d12 * d22 - d13 * d23);
        double d27 = d25 + (d13 * d22 + d12 * d23);
        double d28 = (d14 - d22) / d3;
        double d29 = (d15 - d23) / d4;
        double d30 = (-d14 - d22) / d3;
        double d31 = (-d15 - d23) / d4;
        double d32 = Math.sqrt(d28 * d28 + d29 * d29);
        double d33 = d28;
        d19 = d29 >= 0.0 ? 1.0 : -1.0;
        double d34 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        d32 = Math.sqrt((d28 * d28 + d29 * d29) * (d30 * d30 + d31 * d31));
        d33 = d28 * d30 + d29 * d31;
        d19 = d28 * d31 - d29 * d30 >= 0.0 ? 1.0 : -1.0;
        double d35 = Math.toDegrees(d19 * Math.acos(d33 / d32));
        if (!bl2 && d35 > 0.0) {
            d35 -= 360.0;
        } else if (bl2 && d35 < 0.0) {
            d35 += 360.0;
        }
        d35 %= 360.0;
        d34 %= 360.0;
        Arc2D arc2D = new Arc2D();
        arc2D.x = (float)(d26 - d3);
        arc2D.y = (float)(d27 - d4);
        arc2D.width = (float)(d3 * 2.0);
        arc2D.height = (float)(d4 * 2.0);
        arc2D.start = (float)(-d34);
        arc2D.extent = (float)(-d35);
        return arc2D;
    }

    public synchronized void moveTo(float f, float f2) {
        this.path.moveTo(f, f2);
        this.makeRoom(2);
        this.types[this.numSeg++] = 0;
        this.values[this.numVals++] = f;
        this.values[this.numVals++] = f2;
    }

    public synchronized void lineTo(float f, float f2) {
        this.path.lineTo(f, f2);
        this.makeRoom(2);
        this.types[this.numSeg++] = 1;
        this.values[this.numVals++] = f;
        this.values[this.numVals++] = f2;
    }

    public synchronized void quadTo(float f, float f2, float f3, float f4) {
        this.path.quadTo(f, f2, f3, f4);
        this.makeRoom(4);
        this.types[this.numSeg++] = 2;
        this.values[this.numVals++] = f;
        this.values[this.numVals++] = f2;
        this.values[this.numVals++] = f3;
        this.values[this.numVals++] = f4;
    }

    public synchronized void curveTo(float f, float f2, float f3, float f4, float f5, float f6) {
        this.path.curveTo(f, f2, f3, f4, f5, f6);
        this.makeRoom(6);
        this.types[this.numSeg++] = 3;
        this.values[this.numVals++] = f;
        this.values[this.numVals++] = f2;
        this.values[this.numVals++] = f3;
        this.values[this.numVals++] = f4;
        this.values[this.numVals++] = f5;
        this.values[this.numVals++] = f6;
    }

    public synchronized void closePath() {
        this.path.closePath();
        this.makeRoom(0);
        this.types[this.numSeg++] = 4;
    }

    public void append(Shape shape, boolean bl) {
        this.append(shape.getPathIterator(BaseTransform.IDENTITY_TRANSFORM), bl);
    }

    public void append(PathIterator pathIterator, boolean bl) {
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            int n = pathIterator.currentSegment(fArray);
            pathIterator.next();
            if (bl && this.numVals != 0) {
                if (n == 0) {
                    double d = fArray[0];
                    double d2 = fArray[1];
                    if (d != this.values[this.numVals - 2] || d2 != this.values[this.numVals - 1]) {
                        n = 1;
                    } else {
                        if (pathIterator.isDone()) break;
                        n = pathIterator.currentSegment(fArray);
                        pathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5]);
                }
            }
        }
    }

    public void append(ExtendedPathIterator extendedPathIterator, boolean bl) {
        while (!extendedPathIterator.isDone()) {
            double[] dArray = new double[7];
            int n = extendedPathIterator.currentSegment(dArray);
            extendedPathIterator.next();
            if (bl && this.numVals != 0) {
                if (n == 0) {
                    double d = dArray[0];
                    double d2 = dArray[1];
                    if (d != this.values[this.numVals - 2] || d2 != this.values[this.numVals - 1]) {
                        n = 1;
                    } else {
                        if (extendedPathIterator.isDone()) break;
                        n = extendedPathIterator.currentSegment(dArray);
                        extendedPathIterator.next();
                    }
                }
                bl = false;
            }
            switch (n) {
                case 4: {
                    this.closePath();
                    break;
                }
                case 0: {
                    this.moveTo((float)dArray[0], (float)dArray[1]);
                    break;
                }
                case 1: {
                    this.lineTo((float)dArray[0], (float)dArray[1]);
                    break;
                }
                case 2: {
                    this.quadTo((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3]);
                    break;
                }
                case 3: {
                    this.curveTo((float)dArray[0], (float)dArray[1], (float)dArray[2], (float)dArray[3], (float)dArray[4], (float)dArray[5]);
                    break;
                }
                case 4321: {
                    this.arcTo(dArray[0], dArray[1], dArray[2], dArray[3] != 0.0, dArray[4] != 0.0, dArray[5], dArray[6]);
                }
            }
        }
    }

    public synchronized int getWindingRule() {
        return this.path.getWindingRule();
    }

    public void setWindingRule(int n) {
        this.path.setWindingRule(n);
    }

    public synchronized Point2D getCurrentPoint() {
        return this.path.getCurrentPoint();
    }

    public synchronized void reset() {
        this.path.reset();
        this.numSeg = 0;
        this.numVals = 0;
    }

    public void transform(BaseTransform baseTransform) {
        if (!baseTransform.isIdentity()) {
            throw new IllegalArgumentException("ExtendedGeneralPaths can not be transformed");
        }
    }

    public synchronized Shape createTransformedShape(BaseTransform baseTransform) {
        return this.path.createTransformedShape(baseTransform);
    }

    @Override
    public synchronized RectBounds getBounds() {
        return this.path.getBounds();
    }

    @Override
    public boolean contains(float f, float f2) {
        return this.path.contains(f, f2);
    }

    @Override
    public boolean contains(Point2D point2D) {
        return this.path.contains(point2D);
    }

    @Override
    public boolean contains(float f, float f2, float f3, float f4) {
        return this.path.contains(f, f2, f3, f4);
    }

    @Override
    public boolean intersects(float f, float f2, float f3, float f4) {
        return this.path.intersects(f, f2, f3, f4);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform) {
        return this.path.getPathIterator(baseTransform);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform baseTransform, float f) {
        return this.path.getPathIterator(baseTransform, f);
    }

    @Override
    public ExtendedPathIterator getExtendedPathIterator() {
        return new EPI();
    }

    private void makeRoom(int n) {
        if (this.values == null) {
            this.values = new double[2 * n];
            this.types = new int[2];
            this.numVals = 0;
            this.numSeg = 0;
            return;
        }
        if (this.numVals + n > this.values.length) {
            int n2 = this.values.length * 2;
            if (n2 < this.numVals + n) {
                n2 = this.numVals + n;
            }
            double[] dArray = new double[n2];
            System.arraycopy(this.values, 0, dArray, 0, this.numVals);
            this.values = dArray;
        }
        if (this.numSeg == this.types.length) {
            int[] nArray = new int[this.types.length * 2];
            System.arraycopy(this.types, 0, nArray, 0, this.types.length);
            this.types = nArray;
        }
    }

    public Path2D getPath() {
        return this.path;
    }

    @Override
    public ExtendedGeneralPath copy() {
        return new ExtendedGeneralPath(this);
    }

    class EPI
    implements ExtendedPathIterator {
        int segNum = 0;
        int valsIdx = 0;

        @Override
        public int currentSegment(double[] dArray) {
            int n = ExtendedGeneralPath.this.types[this.segNum];
            switch (n) {
                case 0: 
                case 1: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    break;
                }
                case 2: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    break;
                }
                case 3: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    break;
                }
                case 4321: {
                    dArray[0] = ExtendedGeneralPath.this.values[this.valsIdx];
                    dArray[1] = ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    dArray[2] = ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    dArray[3] = ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    dArray[4] = ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    dArray[5] = ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    dArray[6] = ExtendedGeneralPath.this.values[this.valsIdx + 6];
                }
            }
            return n;
        }

        public int currentSegment(float[] fArray) {
            int n = ExtendedGeneralPath.this.types[this.segNum];
            switch (n) {
                case 0: 
                case 1: {
                    fArray[0] = (float)ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    break;
                }
                case 2: {
                    fArray[0] = (float)ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    fArray[2] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    fArray[3] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    break;
                }
                case 3: {
                    fArray[0] = (float)ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    fArray[2] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    fArray[3] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    fArray[4] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    fArray[5] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    break;
                }
                case 4321: {
                    fArray[0] = (float)ExtendedGeneralPath.this.values[this.valsIdx];
                    fArray[1] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 1];
                    fArray[2] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 2];
                    fArray[3] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 3];
                    fArray[4] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 4];
                    fArray[5] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 5];
                    fArray[6] = (float)ExtendedGeneralPath.this.values[this.valsIdx + 6];
                }
            }
            return n;
        }

        @Override
        public int getWindingRule() {
            return ExtendedGeneralPath.this.path.getWindingRule();
        }

        @Override
        public boolean isDone() {
            return this.segNum == ExtendedGeneralPath.this.numSeg;
        }

        @Override
        public void next() {
            int n = ExtendedGeneralPath.this.types[this.segNum++];
            switch (n) {
                case 0: 
                case 1: {
                    this.valsIdx += 2;
                    break;
                }
                case 2: {
                    this.valsIdx += 4;
                    break;
                }
                case 3: {
                    this.valsIdx += 6;
                    break;
                }
                case 4321: {
                    this.valsIdx += 7;
                }
            }
        }

        EPI() {
        }
    }
}

