/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.sg.prism;

import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Line2D;
import com.sun.javafx.geom.Path2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.RoundRectangle2D;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.TransformedShape;
import com.sun.javafx.geom.transform.Affine2D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.Translate2D;
import com.sun.javafx.sg.BaseNode;
import com.sun.javafx.sg.PGShape;
import com.sun.javafx.sg.PGText;
import com.sun.javafx.sg.prism.NGNode;
import com.sun.javafx.sg.prism.NGShape;
import com.sun.prism.Graphics;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Paint;
import com.sun.t2k.CharToGlyphMapper;
import javafx.scene.text.Font;

public class NGText
extends NGShape
implements PGText {
    private static final int ALIGN_LEFT = 0;
    private static final int ALIGN_CENTER = 1;
    private static final int ALIGN_RIGHT = 2;
    private static final int ALIGN_JUSTIFY = 3;
    private static final int TOP = 0;
    private static final int CENTER = 1;
    private static final int BASELINE = 2;
    private static final int BOTTOM = 3;
    private static final BaseTransform IDENT = BaseTransform.IDENTITY_TRANSFORM;
    public static final boolean hinting = false;
    private float x;
    private float y;
    private static final PGFont defaultFont = (PGFont)Font.getDefault().impl_getNativeFont();
    private PGFont font = defaultFont;
    private FontStrike fontStrike = null;
    private double[] strikeMat = new double[4];
    private String text = "";
    int textOrigin = 2;
    private boolean valid;
    private Selection selection;
    private TextAttributes attributes;
    private float maxLineAdvance = 0.0f;
    private boolean drawingEffect = false;
    private static final int LOGICAL_BOUNDS = 0;
    private static final int VISUAL_BOUNDS = 1;
    private static final int LOGICAL_LAYOUT_BOUNDS = 2;
    int textBoundsType = 0;
    private RectBounds visualBounds = null;
    private RectBounds logicalBounds = null;
    private float yAdjCached = 0.0f;
    private boolean yAdjValid = false;
    private static double EPSILON = 0.01;

    @Override
    public Shape getShape() {
        return this.getShape(true);
    }

    private Shape getShape(boolean bl) {
        if (this.text.isEmpty()) {
            return new Path2D();
        }
        if (!this.valid) {
            this.updateText();
        }
        if (this.attributes != null && this.attributes.cachedShape != null) {
            if (bl) {
                return this.translateShape(this.attributes.cachedShape);
            }
            return this.attributes.cachedShape;
        }
        BaseTransform baseTransform = IDENT;
        if (this.attributes == null) {
            this.attributes = new TextAttributes();
        }
        FontStrike fontStrike = this.getStrike(baseTransform);
        if (this.simpleSingleLine()) {
            Shape shape = fontStrike.getOutline(this.text, baseTransform);
            Shape shape2 = this.getDecorationShape(this.text, fontStrike, 0.0f, 0.0f, this.maxLineAdvance);
            this.attributes.cachedShape = this.union(shape, shape2);
        } else {
            float f = 0.0f;
            float f2 = 0.0f;
            if (this.attributes.textAlignment == 1) {
                f2 = 0.5f;
            } else if (this.attributes.textAlignment == 2) {
                f2 = 1.0f;
            }
            float f3 = this.getLogicalWidth();
            boolean bl2 = f3 > 0.0f;
            float f4 = 0.0f;
            Path2D path2D = null;
            double d = fontStrike.getMetrics().getLineHeight();
            int[] nArray = this.attributes.newLineIndices;
            float[] fArray = this.attributes.lineAdvances;
            if (nArray == null) {
                nArray = new int[]{this.text.length() - 1};
            }
            if (fArray == null) {
                fArray = new float[]{this.maxLineAdvance};
            }
            int n = 0;
            for (int i = 0; i < nArray.length; ++i) {
                Path2D path2D2;
                int n2 = nArray[i];
                boolean bl3 = Character.isWhitespace(this.text.charAt(n2));
                if (n >= n2 && bl3) {
                    ++n;
                    baseTransform = baseTransform.deriveWithTranslation(0.0, d);
                    continue;
                }
                int n3 = bl3 ? n2 : n2 + 1;
                String string = this.text.substring(n, n3);
                if (bl2) {
                    f4 = f3 - fArray[i];
                    f = f2 * f4;
                }
                Shape shape = null;
                if (string.indexOf(9) != -1 || this.attributes.textAlignment == 3) {
                    if (this.attributes.textAlignment != 3 || this.text.charAt(nArray[i]) == '\n' || nArray.length == i + 1) {
                        path2D2 = this.attributes.hasTabs ? NGText.getTabExpandedOutline(string, fontStrike, baseTransform.getMxt(), baseTransform.getMyt()) : (Path2D)fontStrike.getOutline(string, baseTransform);
                    } else {
                        path2D2 = new Path2D();
                        float f5 = this.getTabJustifyExpandedOutline(path2D2, string, fontStrike, baseTransform.getMxt(), baseTransform.getMyt(), f4);
                        shape = this.getDecorationShape(string, fontStrike, (float)baseTransform.getMxt() + f, (float)baseTransform.getMyt(), f5);
                    }
                } else {
                    path2D2 = (Path2D)fontStrike.getOutline(string, baseTransform);
                }
                BaseTransform baseTransform2 = BaseTransform.getTranslateInstance(f, 0.0);
                path2D2.transform(baseTransform2);
                if (path2D == null) {
                    path2D = path2D2;
                } else {
                    path2D.append(path2D2, false);
                }
                if (shape == null) {
                    shape = this.getDecorationShape(string, fontStrike, (float)baseTransform.getMxt() + f, (float)baseTransform.getMyt(), fArray[i]);
                }
                path2D = this.union(path2D, shape);
                baseTransform = baseTransform.deriveWithTranslation(0.0, d);
                n = n2 + 1;
            }
            if (path2D == null) {
                path2D = new Path2D();
            }
            this.attributes.cachedShape = path2D;
        }
        if (bl) {
            return this.translateShape(this.attributes.cachedShape);
        }
        return this.attributes.cachedShape;
    }

    private float getTabJustifyExpandedOutline(Path2D object, String string, FontStrike fontStrike, double d, double d2, float f) {
        Object object2;
        int n;
        char[] cArray = string.toCharArray();
        float f2 = 0.0f;
        float f3 = fontStrike.getCharAdvance(' ');
        float f4 = 8.0f * f3;
        float f5 = 0.0f;
        boolean bl = this.attributes.textAlignment == 3 && f > 0.0f;
        Translate2D translate2D = new Translate2D(d, d2);
        int n2 = 0;
        int n3 = 0;
        FloatList floatList = new FloatList();
        IntList intList = new IntList();
        float f6 = 0.0f;
        for (n = cArray.length - 1; n > 0 && cArray[n] == ' ' && bl; --n) {
        }
        while (n2 <= n) {
            char c = cArray[n2];
            if (c == '\t') {
                if (n2 > n3) {
                    intList.index = 0;
                    floatList.index = 0;
                    translate2D = new Translate2D(d + (double)f5, d2);
                    String string2 = new String(cArray, n3, n2 - n3);
                    object2 = (Path2D)fontStrike.getOutline(string2, translate2D);
                    if (object == null) {
                        object = object2;
                    } else {
                        ((Path2D)object).append((Shape)object2, false);
                    }
                }
                n3 = ++n2;
                float f7 = f6 + f2;
                f6 = f5 = (float)((int)(f7 / f4) + 1) * f4;
                f2 = 0.0f;
                continue;
            }
            if (bl && c == ' ') {
                intList.add(++n2);
                floatList.add(f6 + f3);
                f6 += f3 + f2;
                f2 = 0.0f;
                continue;
            }
            ++n2;
            f2 += fontStrike.getCharAdvance(c);
        }
        if (object == null) {
            object = new Path2D();
        }
        if (n2 > n3) {
            Path2D path2D;
            if (bl && intList.index > 0) {
                String string3;
                int[] nArray = intList.getData();
                object2 = floatList.getData();
                float f8 = f / (float)nArray.length;
                float f9 = 0.0f;
                int n4 = 0;
                if (n3 == 0) {
                    string3 = new String(cArray, n3, nArray[n4] - n3);
                    n3 = nArray[n4++];
                    f9 += f8;
                    translate2D = new Translate2D(d, d2);
                    Path2D path2D2 = (Path2D)fontStrike.getOutline(string3, translate2D);
                    if (path2D2 != null) {
                        ((Path2D)object).append(path2D2, false);
                    }
                }
                while (n4 < nArray.length) {
                    if (n3 < nArray[n4]) {
                        if (cArray[n3] == ' ' && nArray[n4] - n3 == 1) {
                            f9 += f8;
                        } else {
                            string3 = new String(cArray, n3, nArray[n4] - n3);
                            translate2D = new Translate2D(d + (double)object2[n4] + (double)f9, d2);
                            Path2D path2D3 = (Path2D)fontStrike.getOutline(string3, translate2D);
                            if (path2D3 != null) {
                                ((Path2D)object).append(path2D3, false);
                            }
                            f9 += f8;
                        }
                    }
                    n3 = nArray[n4];
                    ++n4;
                }
                string3 = new String(cArray, n3, n2 - n3);
                translate2D = new Translate2D(d + (double)f6 + (double)f9, d2);
                path2D = (Path2D)fontStrike.getOutline(string3, translate2D);
                f6 += f9;
            } else {
                String string4 = new String(cArray, n3, n2 - n3);
                translate2D = new Translate2D(d + (double)f6, d2);
                path2D = (Path2D)fontStrike.getOutline(string4, translate2D);
            }
            ((Path2D)object).append(path2D, false);
        }
        return f6 + f2;
    }

    private static Path2D getTabExpandedOutline(String string, FontStrike fontStrike, double d, double d2) {
        char[] cArray = string.toCharArray();
        float f = 0.0f;
        float f2 = 8.0f * fontStrike.getCharAdvance(' ');
        float f3 = 0.0f;
        Translate2D translate2D = new Translate2D(d, d2);
        Path2D path2D = null;
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            char c = cArray[n];
            if (c != '\t') {
                ++n;
                f += fontStrike.getCharAdvance(c);
                continue;
            }
            if (n > n2) {
                String string2 = new String(cArray, n2, n - n2);
                Path2D path2D2 = (Path2D)fontStrike.getOutline(string2, translate2D);
                if (path2D == null) {
                    path2D = path2D2;
                } else {
                    path2D.append(path2D2, false);
                }
            }
            n2 = ++n;
            float f4 = f3 + f;
            f3 = (float)((int)(f4 / f2) + 1) * f2;
            translate2D = new Translate2D(d + (double)f3, d2);
            f = 0.0f;
        }
        if (n > n2) {
            String string3 = new String(cArray, n2, n - n2);
            Path2D path2D3 = (Path2D)fontStrike.getOutline(string3, translate2D);
            if (path2D == null) {
                path2D = path2D3;
            } else {
                path2D.append(path2D3, false);
            }
        }
        if (path2D == null) {
            path2D = new Path2D();
        }
        return path2D;
    }

    private float getTabExpandedAdvance(String string, FontResource fontResource, CharToGlyphMapper charToGlyphMapper, float f) {
        char[] cArray = string.toCharArray();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = fontResource.getAdvance(charToGlyphMapper.charToGlyph(32), f);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == ' ') {
                f2 += f4;
                continue;
            }
            if (c == '\n') break;
            if (c != '\t') {
                f2 += fontResource.getAdvance(charToGlyphMapper.charToGlyph((int)c), f);
                continue;
            }
            if (f3 == 0.0f) {
                f3 = 8.0f * f4;
            }
            f2 = (float)((int)(f2 / f3) + 1) * f3;
        }
        if (f3 != 0.0f) {
            if (this.attributes == null) {
                this.attributes = new TextAttributes();
            }
            this.attributes.hasTabs = true;
        }
        return f2;
    }

    private static float getTabExpandedAdvance(String string, FontStrike fontStrike) {
        char c;
        if (string.isEmpty()) {
            return 0.0f;
        }
        FontResource fontResource = fontStrike.getFontResource();
        CharToGlyphMapper charToGlyphMapper = fontResource.getGlyphMapper();
        float f = fontStrike.getSize();
        char[] cArray = string.toCharArray();
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (int i = 0; i < cArray.length && (c = cArray[i]) != '\n'; ++i) {
            if (c != '\t') {
                f2 += fontResource.getAdvance(charToGlyphMapper.charToGlyph((int)c), f);
                continue;
            }
            if (f3 == 0.0f) {
                f3 = 8.0f * fontResource.getAdvance(charToGlyphMapper.charToGlyph(32), f);
            }
            f2 = (float)((int)(f2 / f3) + 1) * f3;
        }
        return f2;
    }

    private static float[] getTabJustifyExpandedAdvance(String string, FontStrike fontStrike, int n, int n2, float f) {
        int n3;
        char[] cArray = string.toCharArray();
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = fontStrike.getCharAdvance(' ');
        float f5 = 0.0f;
        float f6 = 0.0f;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n3 = cArray.length - 1; n3 > 0 && cArray[n3] == ' '; --n3) {
        }
        if (n2 > n3) {
            n2 = n3;
        }
        for (int i = 0; i <= n3; ++i) {
            char c = cArray[i];
            if (n == i) {
                f5 = f3;
                n5 = n4;
            }
            if (c == '\t') {
                if (f2 == 0.0f) {
                    f2 = 8.0f * f4;
                }
                f3 = (float)((int)(f3 / f2) + 1) * f2;
                n4 = 0;
                n5 = 0;
                n6 = 0;
            } else if (c == ' ') {
                f3 += f4;
                ++n4;
            } else {
                f3 += fontStrike.getCharAdvance(c);
            }
            if (n2 != i) continue;
            f6 = f3;
            n6 = n4;
        }
        float f7 = n4 <= 0 ? 0.0f : (f - f3) / (float)n4;
        float f8 = 0.0f;
        float f9 = 0.0f;
        f8 = f5 + f7 * (float)n5;
        f9 = f6 + f7 * (float)n6;
        float[] fArray = new float[]{f8, f9};
        return fArray;
    }

    private Path2D union(Shape shape, Shape shape2) {
        Path2D path2D = null;
        path2D = shape instanceof Path2D ? (Path2D)shape : new Path2D(shape);
        if (shape2 == null) {
            return path2D;
        }
        path2D.append(shape2.getPathIterator(IDENT), false);
        return path2D;
    }

    private Shape translateShape(Shape shape) {
        float f = this.getYAdjustment();
        return TransformedShape.translatedShape(shape, this.x, this.y + f);
    }

    private static Path2D createRectPath(float f, float f2, float f3, float f4) {
        Path2D path2D = new Path2D();
        path2D.moveTo(f, f2);
        path2D.lineTo(f + f3, f2);
        path2D.lineTo(f + f3, f2 + f4);
        path2D.lineTo(f, f2 + f4);
        path2D.lineTo(f, f2);
        path2D.closePath();
        return path2D;
    }

    private Shape getDecorationShape(String string, FontStrike fontStrike, float f, float f2, float f3) {
        if (this.attributes == null) {
            return null;
        }
        if (this.attributes.underline || this.attributes.strikethrough) {
            float f4;
            float f5;
            if (fontStrike == null) {
                fontStrike = this.getStrike();
            }
            float f6 = f3 > 0.0f ? f3 : NGText.getTabExpandedAdvance(string, fontStrike);
            Path2D path2D = null;
            Path2D path2D2 = null;
            if (this.attributes.underline) {
                f5 = fontStrike.getUnderLineOffset();
                f4 = fontStrike.getUnderLineThickness();
                path2D = NGText.createRectPath(f, f2 + f5, f6, f4);
            }
            if (this.attributes.strikethrough) {
                f5 = fontStrike.getStrikeThroughOffset();
                f4 = fontStrike.getStrikeThroughThickness();
                path2D2 = NGText.createRectPath(f, f2 + f5, f6, f4);
            }
            if (path2D == null) {
                return path2D2;
            }
            if (path2D2 == null) {
                return path2D;
            }
            Path2D path2D3 = new Path2D(path2D);
            path2D3.append(path2D2.getPathIterator(IDENT), false);
            return path2D3;
        }
        return null;
    }

    private void decorate(Graphics graphics, FontStrike fontStrike, float f, float f2, float f3) {
        if (this.attributes == null) {
            return;
        }
        if (this.attributes.underline || this.attributes.strikethrough) {
            float f4 = f3 > 0.0f ? f3 : NGText.getTabExpandedAdvance(this.text, fontStrike);
            if (this.attributes.underline) {
                this.drawUnderline(graphics, fontStrike, f, f2, f4);
            }
            if (this.attributes.strikethrough) {
                this.drawStrikeThrough(graphics, fontStrike, f, f2, f4);
            }
        }
    }

    private void drawUnderline(Graphics graphics, FontStrike fontStrike, float f, float f2, float f3) {
        if (fontStrike == null) {
            fontStrike = this.getStrike();
        }
        float f4 = fontStrike.getUnderLineOffset();
        float f5 = fontStrike.getUnderLineThickness();
        this.drawDecoration(graphics, f, f2, f3, f4, f5);
    }

    private void drawStrikeThrough(Graphics graphics, FontStrike fontStrike, float f, float f2, float f3) {
        if (fontStrike == null) {
            fontStrike = this.getStrike();
        }
        float f4 = fontStrike.getStrikeThroughOffset();
        float f5 = fontStrike.getStrikeThroughThickness();
        this.drawDecoration(graphics, f, f2, f3, f4, f5);
    }

    private void drawDecoration(Graphics graphics, float f, float f2, float f3, float f4, float f5) {
        RoundRectangle2D roundRectangle2D = new RoundRectangle2D();
        roundRectangle2D.x = f;
        roundRectangle2D.y = f2 + f4;
        roundRectangle2D.width = f3;
        roundRectangle2D.height = f5;
        Paint paint = graphics.getPaint();
        if (this.mode != PGShape.Mode.FILL) {
            graphics.setPaint(this.drawPaint);
            graphics.setStroke(this.drawStroke);
            graphics.draw(roundRectangle2D);
        }
        if (this.mode != PGShape.Mode.STROKE) {
            graphics.setPaint(this.fillPaint);
            graphics.fill(roundRectangle2D);
        }
        if (graphics.getPaint() != paint) {
            graphics.setPaint(paint);
        }
    }

    private void drawString(Graphics graphics, String string, FontStrike fontStrike, float f, float f2, int n) {
        if (this.selection != null && !this.selection.isEmpty() && this.selection.fillPaint != this.fillPaint && this.selection.fillPaint instanceof Color) {
            graphics.drawString(string, fontStrike, f, f2, (Color)this.selection.fillPaint, this.selection.start - n, this.selection.end - n);
        } else {
            graphics.drawString(string, fontStrike, f, f2);
        }
    }

    private float tabJustifyExpandedDrawstring(Graphics graphics, String string, FontStrike fontStrike, float f, float f2, float f3, int n) {
        int n2;
        char[] cArray = string.toCharArray();
        float f4 = 0.0f;
        float f5 = fontStrike.getCharAdvance(' ');
        float f6 = 8.0f * f5;
        float f7 = 0.0f;
        IntList intList = new IntList();
        FloatList floatList = new FloatList();
        boolean bl = this.attributes.textAlignment == 3 && f3 > 0.0f;
        int n3 = 0;
        int n4 = 0;
        float f8 = 0.0f;
        for (n2 = cArray.length - 1; n2 > 0 && cArray[n2] == ' ' && bl; --n2) {
        }
        while (n3 <= n2) {
            char c = cArray[n3];
            if (c == '\t') {
                if (n3 > n4) {
                    String string2 = new String(cArray, n4, n3 - n4);
                    this.drawString(graphics, string2, fontStrike, f + f7, f2, n);
                    intList.index = 0;
                    floatList.index = 0;
                }
                n4 = ++n3;
                float f9 = f4 + f8;
                f8 = f7 = (float)((int)(f9 / f6) + 1) * f6;
                f4 = 0.0f;
                continue;
            }
            if (bl && c == ' ') {
                intList.add(++n3);
                floatList.add(f8 + f5);
                f8 += f5 + f4;
                f4 = 0.0f;
                continue;
            }
            ++n3;
            f4 += fontStrike.getCharAdvance(c);
        }
        if (n3 > n4) {
            if (bl && intList.index > 0) {
                int[] nArray = intList.getData();
                float[] fArray = floatList.getData();
                float f10 = f3 / (float)nArray.length;
                float f11 = 0.0f;
                int n5 = 0;
                if (n4 == 0) {
                    String string3 = new String(cArray, n4, nArray[n5] - n4);
                    this.drawString(graphics, string3, fontStrike, f, f2, n + n4);
                    n4 = nArray[n5++];
                    f11 += f10;
                }
                while (n5 < nArray.length) {
                    if (n4 < nArray[n5]) {
                        String string4 = new String(cArray, n4, nArray[n5] - n4);
                        this.drawString(graphics, string4, fontStrike, f + fArray[n5] + f11, f2, n + n4);
                        f11 += f10;
                    }
                    n4 = nArray[n5];
                    ++n5;
                }
                f8 += f11;
            }
            String string5 = new String(cArray, n4, n3 - n4);
            this.drawString(graphics, string5, fontStrike, f + f8, f2, n + n4);
        }
        return f8 + f4;
    }

    private float tabExpandedDrawstring(Graphics graphics, String string, FontStrike fontStrike, float f, float f2, int n) {
        char[] cArray = string.toCharArray();
        float f3 = 0.0f;
        float f4 = 8.0f * fontStrike.getCharAdvance(' ');
        float f5 = 0.0f;
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            char c = cArray[n2];
            if (c != '\t') {
                ++n2;
                f3 += fontStrike.getCharAdvance(c);
                continue;
            }
            if (n2 > n3) {
                String string2 = new String(cArray, n3, n2 - n3);
                this.drawString(graphics, string2, fontStrike, f + f5, f2, n + n3);
            }
            n3 = ++n2;
            float f6 = f5 + f3;
            f5 = (float)((int)(f6 / f4) + 1) * f4;
            f3 = 0.0f;
        }
        if (n2 > n3) {
            String string3 = new String(cArray, n3, n2 - n3);
            this.drawString(graphics, string3, fontStrike, f + f5, f2, n + n3);
        }
        return f5 + f3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void renderEffect(Graphics graphics) {
        if (!graphics.getTransformNoClone().isTranslateOrIdentity()) {
            this.drawingEffect = true;
        }
        try {
            super.renderEffect(graphics);
        }
        finally {
            this.drawingEffect = false;
        }
    }

    @Override
    protected void renderContent(Graphics graphics) {
        Object object;
        if (this.mode == PGShape.Mode.EMPTY || this.text.isEmpty()) {
            return;
        }
        if (!this.valid) {
            this.updateText();
        }
        if (!graphics.getTransformNoClone().is2D()) {
            super.renderContent(graphics);
            return;
        }
        BaseBounds baseBounds = null;
        if (this.attributes != null && this.attributes.numberOfLines() > 1 && this.getClipNode() != null) {
            object = (NGNode)this.getClipNode();
            baseBounds = new RectBounds();
            baseBounds = this.getClippedBounds(baseBounds, IDENT);
        }
        object = this.getStrike(graphics.getTransformNoClone());
        if (this.mode != PGShape.Mode.STROKE && !object.drawAsShapes() && !this.drawingEffect) {
            graphics.setPaint(this.fillPaint);
            float f = this.y + this.getYAdjustment();
            if (this.simpleSingleLine()) {
                this.drawString(graphics, this.text, (FontStrike)object, this.x, f, 0);
                this.decorate(graphics, (FontStrike)object, this.x, f, this.maxLineAdvance);
            } else {
                float f2 = 0.0f;
                if (this.attributes.textAlignment == 1) {
                    f2 = 0.5f;
                } else if (this.attributes.textAlignment == 2) {
                    f2 = 1.0f;
                }
                float f3 = object.getMetrics().getLineHeight();
                int[] nArray = this.attributes.newLineIndices;
                float[] fArray = this.attributes.lineAdvances;
                if (nArray == null) {
                    nArray = new int[]{this.text.length() - 1};
                }
                if (fArray == null) {
                    fArray = new float[]{this.maxLineAdvance};
                }
                int n = 0;
                float f4 = 0.0f;
                float f5 = this.attributes.overrideWrappingWidth ? this.maxLineAdvance : this.attributes.wrappingWidth;
                boolean bl = f5 > 0.0f;
                float f6 = 0.0f;
                for (int i = 0; !(i >= nArray.length || baseBounds != null && f - f3 > baseBounds.getMaxY()); ++i) {
                    if (bl) {
                        f6 = f5 - fArray[i];
                        f4 = f2 * f6;
                    }
                    int n2 = nArray[i];
                    boolean bl2 = Character.isWhitespace(this.text.charAt(n2));
                    if (n >= n2 && bl2) {
                        ++n;
                        f += f3;
                        continue;
                    }
                    if (baseBounds != null && f + f3 < baseBounds.getMinY()) {
                        f += f3;
                        n = n2 + 1;
                        continue;
                    }
                    int n3 = bl2 ? n2 : n2 + 1;
                    String string = this.text.substring(n, n3);
                    if (this.attributes.hasTabs && string.indexOf(9) != -1 || this.attributes.textAlignment == 3) {
                        float f7;
                        boolean bl3 = false;
                        if (this.text.charAt(nArray[i]) == '\n' || i == nArray.length - 1) {
                            bl3 = true;
                        }
                        if (this.attributes.textAlignment == 3 && bl && !bl3) {
                            f7 = this.tabJustifyExpandedDrawstring(graphics, string, (FontStrike)object, this.x + f4, f, f5 - fArray[i], n);
                            this.decorate(graphics, (FontStrike)object, this.x + f4, f, f7);
                        } else {
                            f7 = this.tabExpandedDrawstring(graphics, string, (FontStrike)object, this.x + f4, f, n);
                            this.decorate(graphics, (FontStrike)object, this.x + f4, f, f7);
                        }
                    } else {
                        this.drawString(graphics, string, (FontStrike)object, this.x + f4, f, n);
                        this.decorate(graphics, (FontStrike)object, this.x + f4, f, fArray[i]);
                    }
                    f += f3;
                    n = n2 + 1;
                }
            }
        } else if (this.mode != PGShape.Mode.STROKE && (object.drawAsShapes() || this.drawingEffect)) {
            graphics.setPaint(this.fillPaint);
            graphics.fill(this.getShape(true));
        }
        if (this.mode != PGShape.Mode.FILL) {
            graphics.setPaint(this.drawPaint);
            graphics.setStroke(this.drawStroke);
            graphics.draw(this.getShape(true));
        }
    }

    @Override
    public void setTextBoundsType(int n) {
        if (this.textBoundsType == n) {
            return;
        }
        boolean bl = n == 1 || this.textBoundsType == 1;
        this.textBoundsType = n;
        if (bl) {
            this.geometryChanged();
        }
    }

    public final BaseBounds computeLayoutBounds(BaseBounds baseBounds) {
        baseBounds = this.textBoundsType == 1 ? this.computeBoundsVisual(baseBounds, IDENT) : this.computeBoundsLogical(baseBounds, IDENT, false);
        return baseBounds;
    }

    public BaseBounds computeContentBounds(BaseBounds baseBounds, BaseTransform baseTransform) {
        baseBounds = this.textBoundsType == 1 ? this.computeBoundsVisual(baseBounds, baseTransform) : this.computeBoundsLogical(baseBounds, baseTransform, true);
        return baseBounds;
    }

    private BaseBounds computeBoundsLogical(BaseBounds baseBounds, BaseTransform baseTransform, boolean bl) {
        Object object;
        if (baseBounds == null) {
            baseBounds = new RectBounds();
        }
        if (!this.valid) {
            this.updateText();
        }
        this.computeBoundsLogicalIdentity();
        float f = this.getYAdjustment() + this.y;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (bl && this.attributes != null && !this.text.isEmpty()) {
            if (this.mode == PGShape.Mode.FILL) {
                object = this.logicalHPadding();
                f2 = object[0];
                f3 = (float)object[1];
            } else {
                object = this.computeBoundsVisual(null, IDENT);
                f2 = ((BaseBounds)object).getMinX() - this.logicalBounds.getMinX() - this.x;
                f3 = ((BaseBounds)object).getMaxX() - this.logicalBounds.getMaxX() - this.x;
                if (f2 > 0.0f) {
                    f2 = 0.0f;
                }
                if (f3 < 0.0f) {
                    f3 = 0.0f;
                }
            }
        }
        object = new RectBounds(this.logicalBounds.getMinX() + this.x + f2, this.logicalBounds.getMinY() + f, this.logicalBounds.getMaxX() + this.x + f3, this.logicalBounds.getMaxY() + f);
        return NGText.getRectShapeBounds(baseBounds, baseTransform, NGText.classify(baseTransform), 0.0f, 0.0f, (RectBounds)object);
    }

    private RectBounds computeBoundsLogicalIdentity() {
        RectBounds rectBounds;
        float f;
        if (this.logicalBounds != null) {
            return this.logicalBounds;
        }
        FontStrike fontStrike = this.getStrike(IDENT);
        FontStrike.Metrics metrics = fontStrike.getMetrics();
        float f2 = f = this.attributes != null && this.attributes.wrappingWidth > 0.0f ? this.attributes.wrappingWidth : this.maxLineAdvance;
        if (this.simpleSingleLine()) {
            rectBounds = new RectBounds(0.0f, metrics.getAscent(), f, metrics.getDescent() + metrics.getLineGap());
        } else {
            float f3 = (float)this.attributes.numberOfLines() * metrics.getLineHeight();
            rectBounds = new RectBounds(0.0f, metrics.getAscent(), f, f3 + metrics.getAscent());
        }
        this.logicalBounds = rectBounds;
        return rectBounds;
    }

    private BaseBounds computeBoundsVisual(BaseBounds baseBounds, BaseTransform baseTransform) {
        Object object;
        if (baseBounds == null) {
            baseBounds = new RectBounds();
        }
        if (this.mode == PGShape.Mode.EMPTY || this.text.isEmpty()) {
            return baseBounds.makeEmpty();
        }
        if (!this.valid) {
            this.updateText();
        }
        if (this.visualBounds == null) {
            this.visualBounds = null;
            Shape shape = this.getShape(false);
            if (this.mode == PGShape.Mode.FILL || this.drawStroke.getType() == 1) {
                this.visualBounds = shape.getBounds();
            } else {
                object = new float[4];
                this.drawStroke.accumulateShapeBounds((float[])object, shape, IDENT);
                this.visualBounds = new RectBounds(object[0], object[1], object[2], object[3]);
            }
        }
        float f = this.y;
        f = this.textBoundsType == 1 ? (f += this.getYAdjustment(this.visualBounds)) : (f += this.getYAdjustment());
        object = new RectBounds(this.visualBounds.getMinX() + this.x, this.visualBounds.getMinY() + f, this.visualBounds.getMaxX() + this.x, this.visualBounds.getMaxY() + f);
        return NGText.getRectShapeBounds(baseBounds, baseTransform, NGText.classify(baseTransform), 0.0f, 0.0f, (RectBounds)object);
    }

    private float getYAdjustment(FontStrike.Metrics metrics) {
        float f = 0.0f;
        if (this.textOrigin == 2) {
            return f;
        }
        if (metrics == null) {
            metrics = this.getStrike().getMetrics();
        }
        switch (this.textOrigin) {
            case 0: {
                f = -metrics.getAscent();
                break;
            }
            case 1: {
                f = -metrics.getDescent();
                if (this.attributes != null) {
                    f -= metrics.getLineHeight() * (float)(this.attributes.numberOfLines() - 1);
                }
                f += -metrics.getAscent();
                f /= 2.0f;
                break;
            }
            case 3: {
                f = -metrics.getDescent();
                if (this.attributes == null) break;
                f -= metrics.getLineHeight() * (float)(this.attributes.numberOfLines() - 1);
                break;
            }
        }
        return f;
    }

    private float getYAdjustment(RectBounds rectBounds) {
        float f = 0.0f;
        switch (this.textOrigin) {
            case 0: {
                f = -rectBounds.getMinY();
                break;
            }
            case 1: {
                f = -((rectBounds.getMaxY() + rectBounds.getMinY()) / 2.0f);
                break;
            }
            case 3: {
                f = -rectBounds.getMaxY();
                break;
            }
        }
        this.yAdjCached = f;
        this.yAdjValid = true;
        return f;
    }

    private float getYAdjustment() {
        if (this.textOrigin == 2) {
            this.yAdjCached = 0.0f;
            this.yAdjValid = true;
            return this.yAdjCached;
        }
        if (this.yAdjValid) {
            return this.yAdjCached;
        }
        if (this.textBoundsType == 1) {
            BaseBounds baseBounds = null;
            this.computeBoundsVisual(baseBounds, BaseTransform.IDENTITY_TRANSFORM);
            this.getYAdjustment(this.visualBounds);
        } else {
            this.getYAdjustment(this.computeBoundsLogicalIdentity());
        }
        return this.yAdjCached;
    }

    public Object getCaretShape(int n, boolean bl) {
        String string;
        int n2;
        if (!this.valid) {
            this.updateText();
        }
        int n3 = 0;
        int n4 = -1;
        if (this.attributes != null && this.attributes.newLineIndices != null) {
            int[] nArray = this.attributes.newLineIndices;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                if (n > nArray[n2]) continue;
                n4 = n2;
                break;
            }
            if (n4 == -1) {
                n4 = nArray.length - 1;
            }
            if (n4 > 0) {
                n3 = nArray[n4 - 1] + 1;
            }
            n2 = nArray[n4];
            string = this.text.substring(n3, n2 + 1);
        } else {
            string = this.text;
            n4 = 0;
        }
        int n5 = Math.min(n, this.text.length());
        n2 = n5 - n3;
        FontStrike fontStrike = this.getStrike();
        float f = this.x + (n2 == 0 ? 0.0f : NGText.getTabExpandedAdvance(string.substring(0, n2), fontStrike));
        FontStrike.Metrics metrics = fontStrike.getMetrics();
        float f2 = this.y + this.getYAdjustment() + (float)n4 * metrics.getLineHeight();
        return new Line2D(f, f2 + metrics.getAscent(), f, f2 + metrics.getDescent());
    }

    public Object getHitInfo(float f, float f2) {
        int n;
        float f3;
        if (!this.valid) {
            this.updateText();
        }
        FontStrike fontStrike = this.getStrike();
        FontStrike.Metrics metrics = fontStrike.getMetrics();
        float f4 = f < this.x ? 0.0f : f - this.x;
        float f5 = (f2 < this.y ? 0.0f : f2 - this.y) - this.getYAdjustment() - metrics.getAscent();
        int n2 = 0;
        char[] cArray = null;
        String string = null;
        if (this.attributes != null && this.attributes.newLineIndices != null) {
            int[] nArray;
            f3 = metrics.getLineHeight();
            int n3 = (int)(f5 / f3);
            if (n3 > (nArray = this.attributes.newLineIndices).length - 1) {
                return new Integer(this.text.length());
            }
            if (n3 > 0) {
                n2 = nArray[n3 - 1] + 1;
            }
            n = nArray[n3] + 1;
            string = this.text.substring(n2, n);
        } else {
            string = this.text;
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        cArray = string.toCharArray();
        for (n = 0; n < cArray.length; ++n) {
            char c = cArray[n];
            if (c == '\t') {
                if (f6 == 0.0f) {
                    f6 = 8.0f * fontStrike.getCharAdvance(' ');
                }
                float f8 = (float)((int)(f7 / f6) + 1) * f6;
                f3 = f8 - f7;
            } else {
                f3 = fontStrike.getCharAdvance(cArray[n]);
            }
            if ((double)f4 < (double)f7 + (double)f3 * 0.75) {
                return n + n2;
            }
            f7 += f3;
        }
        return cArray.length + n2;
    }

    public Shape getSelectionShape() {
        if (this.selection != null) {
            if (this.selection.shape == null && this.selection.end > this.selection.start) {
                this.selection.shape = this.getRangeShapeImpl(this.selection.start, this.selection.end, false);
            }
            return this.selection.shape;
        }
        return null;
    }

    public Shape getRangeShape(int n, int n2) {
        return this.getRangeShapeImpl(n, n2, false);
    }

    public Shape getUnderlineShape(int n, int n2) {
        return this.getRangeShapeImpl(n, n2, true);
    }

    private Shape getRangeShapeImpl(int n, int n2, boolean bl) {
        String string;
        if (this.mode == PGShape.Mode.EMPTY || this.text.isEmpty()) {
            return null;
        }
        if (!this.valid) {
            this.updateText();
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        n2 = Math.min(n2, this.text.length());
        FontStrike fontStrike = this.getStrike();
        FontStrike.Metrics metrics = fontStrike.getMetrics();
        float f = metrics.getLineHeight();
        float f2 = this.y + this.getYAdjustment();
        if (this.attributes != null && this.attributes.newLineIndices != null) {
            Path2D path2D = new Path2D();
            int[] nArray = this.attributes.newLineIndices;
            int n4 = 0;
            float f3 = this.getLogicalWidth();
            boolean bl2 = f3 > 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = this.attributes.textAlignment == 3 ? 0.0f : (float)this.attributes.textAlignment;
            f6 /= 2.0f;
            int n5 = 0;
            while (n5 < nArray.length) {
                int n6 = nArray[n5];
                if (n2 < n4) break;
                if (n > n6) {
                    n4 = n6 + 1;
                } else {
                    if (bl2) {
                        f5 = f3 - this.attributes.lineAdvances[n5];
                        f4 = f6 * f5;
                    }
                    boolean bl3 = Character.isWhitespace(this.text.charAt(n6));
                    if (n4 >= n6 && bl3) {
                        ++n4;
                    } else {
                        float f7;
                        boolean bl4;
                        float f8 = 0.0f;
                        if (n > n4) {
                            String string2 = this.text.substring(n4, n);
                            f8 = this.attributes.hasTabs && string2.indexOf(9) != -1 ? NGText.getTabExpandedAdvance(string2, fontStrike) : fontStrike.getStringBounds(string2).getWidth();
                        }
                        int n7 = bl3 ? n6 : n6 + 1;
                        String string3 = this.text.substring(n4, n7 <= n2 ? n7 : n2);
                        RectBounds rectBounds = fontStrike.getStringBounds(string3);
                        float f9 = this.x + f8 + f4;
                        boolean bl5 = bl4 = this.text.charAt(nArray[n5]) == '\n' || n5 == nArray.length - 1;
                        if (bl2 && this.attributes.textAlignment == 3 && !bl4) {
                            int n8 = n <= n4 ? 0 : n - n4;
                            int n9 = n2 <= n6 ? n2 - n4 : n6 - n4;
                            string3 = this.text.substring(n4, n7);
                            float[] fArray = NGText.getTabJustifyExpandedAdvance(string3, fontStrike, n8, n9 - 1, f3);
                            f7 = 0.0f;
                            if (fArray.length == 2) {
                                f9 = fArray[0];
                                f7 = fArray[1] - f9;
                            }
                        } else {
                            f7 = (string3.indexOf(9) != -1 ? NGText.getTabExpandedAdvance(string3, fontStrike) : rectBounds.getWidth()) - f8;
                        }
                        float f10 = f;
                        if (bl) {
                            f2 += fontStrike.getUnderLineOffset() - metrics.getAscent();
                            f10 = fontStrike.getUnderLineThickness();
                        }
                        path2D.append(new RoundRectangle2D(f9 + rectBounds.getMinX(), f2 + rectBounds.getMinY(), f7, f10, 0.0f, 0.0f), false);
                        n4 = n6 + 1;
                    }
                }
                ++n5;
                f2 += f;
            }
            return path2D;
        }
        float f11 = 0.0f;
        if (n > 0) {
            string = this.text.substring(0, n);
            f11 = this.attributes != null && this.attributes.hasTabs && string.indexOf(9) != -1 ? NGText.getTabExpandedAdvance(string, fontStrike) : fontStrike.getStringBounds(string).getWidth();
        }
        string = this.text.substring(0, n2);
        RectBounds rectBounds = fontStrike.getStringBounds(string);
        float f12 = this.x + f11;
        float f13 = this.attributes != null && this.attributes.hasTabs && string.indexOf(9) != -1 ? NGText.getTabExpandedAdvance(string, fontStrike) - f11 : rectBounds.getWidth() - f11;
        float f14 = f;
        if (bl) {
            f2 += fontStrike.getUnderLineOffset() - metrics.getAscent();
            f14 = fontStrike.getUnderLineThickness();
        }
        return new RoundRectangle2D(f12 + rectBounds.getMinX(), f2 + rectBounds.getMinY(), f13, f14, 0.0f, 0.0f);
    }

    BaseTransform getCumulativeTransform() {
        BaseTransform baseTransform = new Affine2D();
        BaseNode baseNode = this;
        do {
            if (baseNode.getTransform() == null) continue;
            baseTransform = ((BaseTransform)baseTransform).deriveWithConcatenation(baseNode.getTransform());
        } while ((baseNode = baseNode.getParent()) != null);
        return baseTransform;
    }

    private FontStrike getStrike() {
        return this.getStrike(this.getCumulativeTransform());
    }

    private FontStrike getStrike(BaseTransform baseTransform) {
        if (baseTransform == null) {
            return this.getStrike();
        }
        if (this.fontStrike == null || Math.abs(this.strikeMat[0] - baseTransform.getMxx()) > EPSILON || Math.abs(this.strikeMat[1] - baseTransform.getMxy()) > EPSILON || Math.abs(this.strikeMat[2] - baseTransform.getMyx()) > EPSILON || Math.abs(this.strikeMat[3] - baseTransform.getMyy()) > EPSILON) {
            this.fontStrike = this.font.getStrike(baseTransform);
            this.strikeMat[0] = baseTransform.getMxx();
            this.strikeMat[1] = baseTransform.getMxy();
            this.strikeMat[2] = baseTransform.getMyx();
            this.strikeMat[3] = baseTransform.getMyy();
        }
        return this.fontStrike;
    }

    @Override
    public void setFont(Object object) {
        if (this.font != null && this.font.equals(object)) {
            return;
        }
        this.font = (PGFont)object;
        this.fontStrike = null;
        this.geometryChanged();
    }

    @Override
    public void setLocation(float f, float f2) {
        this.x = f;
        this.y = f2;
        this.locationChanged();
    }

    @Override
    public void setLogicalSelection(int n, int n2) {
        if (n < 0 || n2 < 0 || n2 <= n || n > this.text.length()) {
            if (this.selection != null) {
                this.selection.shape = null;
                if (this.selection.start != this.selection.end) {
                    this.selection.start = 0;
                    this.selection.end = 0;
                    this.geometryChangedTextValid();
                }
            }
            return;
        }
        if (this.selection == null || this.selection.start != n || this.selection.end != n2) {
            if (this.selection == null) {
                this.selection = new Selection();
            }
            this.selection.start = Math.max(Math.min(n, n2), 0);
            this.selection.end = Math.min(Math.max(n, n2), this.text.length());
            this.selection.shape = null;
            this.geometryChangedTextValid();
        }
    }

    @Override
    public void setSelectionPaint(Object object, Object object2) {
        if (this.selection == null) {
            this.selection = new Selection();
        }
        Paint paint = (Paint)object;
        Paint paint2 = (Paint)object2;
        boolean bl = false;
        if (this.selection.drawPaint == null || !this.selection.drawPaint.equals(paint)) {
            this.selection.drawPaint = paint;
            bl = true;
        }
        if (this.selection.fillPaint == null || !this.selection.fillPaint.equals(paint2)) {
            this.selection.fillPaint = paint2;
            bl = true;
        }
        if (bl) {
            this.geometryChangedTextValid();
        }
    }

    @Override
    public void setText(String string) {
        if (string == null) {
            string = "";
        }
        if (!this.text.equals(string)) {
            this.text = string;
            this.geometryChanged();
        }
    }

    private void updateText() {
        if (this.attributes != null) {
            this.attributes.reset();
        }
        this.maxLineAdvance = 0.0f;
        this.buildTextLines(this.text);
        this.valid = true;
    }

    private void geometryChangedTextValid() {
        boolean bl = this.valid;
        this.geometryChanged();
        this.valid = bl;
    }

    @Override
    protected void geometryChanged() {
        this.valid = false;
        if (this.attributes != null) {
            this.attributes.resetShape();
        }
        if (this.selection != null) {
            this.selection.shape = null;
        }
        this.yAdjValid = false;
        this.visualBounds = null;
        this.logicalBounds = null;
        super.geometryChanged();
    }

    private static boolean isPreferredBreakCharacter(char c) {
        if (Character.isWhitespace(c)) {
            return true;
        }
        switch (c) {
            case '.': 
            case ':': 
            case ';': {
                return true;
            }
        }
        return false;
    }

    float[] logicalHPadding() {
        if (this.attributes == null || !this.attributes.visualGreaterThanLogicalBounds()) {
            return new float[]{0.0f, 0.0f};
        }
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.attributes.simpleSingleLine()) {
            if (this.attributes.lsb != null && this.attributes.lsb[0] < 0.0f) {
                f = this.attributes.lsb[0];
            }
            if (this.attributes.rsb != null && this.attributes.rsb[0] > 0.0f) {
                f2 = this.attributes.rsb[0];
            }
        } else {
            float f3 = 0.0f;
            float f4 = 0.0f;
            switch (this.attributes.textAlignment) {
                case 1: {
                    f4 = 0.5f;
                    break;
                }
                case 2: {
                    f4 = 1.0f;
                    break;
                }
                case 3: {
                    f = FloatList.getMin(this.attributes.lsb);
                    f2 = FloatList.getMax(this.attributes.rsb);
                    return new float[]{f, f2};
                }
            }
            float[] fArray = this.attributes.lineAdvances;
            if (fArray == null) {
                fArray = new float[]{this.maxLineAdvance};
            }
            float f5 = this.attributes.wrappingWidth > 0.0f ? this.attributes.wrappingWidth : this.maxLineAdvance;
            for (int i = 0; i < fArray.length; ++i) {
                f3 = f5 - fArray[i];
                float f6 = f3 * f4;
                float f7 = this.attributes.lsb[i] + f6;
                if (f7 < f) {
                    f = f7;
                }
                if (!(f2 < (f7 = this.attributes.rsb[i] + f6 - f3))) continue;
                f2 = f7;
            }
            if (this.attributes.overrideWrappingWidth) {
                float f8 = (this.maxLineAdvance - this.attributes.wrappingWidth) * f4;
                f += f8;
                f2 += f8;
            }
        }
        return new float[]{f, f2};
    }

    float getLogicalWidth() {
        if (this.attributes != null && this.attributes.wrappingWidthSet) {
            return this.attributes.overrideWrappingWidth ? this.maxLineAdvance : this.attributes.wrappingWidth;
        }
        return this.maxLineAdvance;
    }

    boolean simpleSingleLine() {
        if (this.attributes == null) {
            return true;
        }
        return this.attributes.simpleSingleLine();
    }

    private void buildTextLines(String string) {
        if (string.isEmpty()) {
            return;
        }
        FontStrike fontStrike = this.getStrike(IDENT);
        FontResource fontResource = fontStrike.getFontResource();
        CharToGlyphMapper charToGlyphMapper = fontResource.getGlyphMapper();
        float f = fontStrike.getSize();
        if (!(string.indexOf(10) != -1 || this.attributes != null && this.attributes.wrappingWidthSet)) {
            this.maxLineAdvance = this.getTabExpandedAdvance(string, fontResource, charToGlyphMapper, f);
            float[] fArray = new float[4];
            float[] fArray2 = TextAttributes.computeSideBearings(string, fontResource, charToGlyphMapper, f, fArray);
            if (fArray2[0] < 0.0f || 0.0f < fArray2[1]) {
                if (this.attributes == null) {
                    this.attributes = new TextAttributes();
                }
                this.attributes.lsb = new float[]{fArray2[0]};
                this.attributes.rsb = new float[]{fArray2[1]};
            }
            return;
        }
        if (this.attributes == null) {
            this.attributes = new TextAttributes();
        }
        char[] cArray = string.toCharArray();
        IntList intList = new IntList();
        FloatList floatList = new FloatList();
        float f2 = 0.0f;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fontResource.getAdvance(charToGlyphMapper.charToGlyph(32), f);
        for (int i = 0; i < cArray.length; ++i) {
            float f6;
            char c = cArray[i];
            if (c == '\t') {
                this.attributes.hasTabs = true;
                if (f4 == 0.0f) {
                    f4 = 8.0f * f5;
                }
                float f7 = (float)((int)(f2 / f4) + 1) * f4;
                f6 = f7 - f2;
            } else {
                f6 = fontResource.getAdvance(charToGlyphMapper.charToGlyph((int)c), f);
            }
            if (c == '\n') {
                intList.add(i);
                floatList.add(f2);
                n2 = i + 1;
                n = 0;
                f2 = 0.0f;
                n3 = 0;
                f3 = 0.0f;
                continue;
            }
            if (this.attributes.wrappingWidthSet && f6 + f2 > this.attributes.wrappingWidth) {
                if (Character.isWhitespace(c)) {
                    intList.add(i);
                    floatList.add(f6 + f2);
                    n2 = i + 1;
                    n = 0;
                    f2 = 0.0f;
                } else if (n3 > 0) {
                    intList.add(n2 + n3);
                    floatList.add(f3);
                    f2 = f2 - f3 + f6;
                    n = i - (n2 += n3 + 1) + 1;
                    if (NGText.isPreferredBreakCharacter(c)) {
                        n3 = n;
                        f3 = f2;
                    }
                } else if (n == 0) {
                    this.attributes.overrideWrappingWidth = true;
                    intList.add(n2);
                    floatList.add(f6);
                    n2 = i + 1;
                    n = 0;
                    f2 = 0.0f;
                } else {
                    intList.add(n2 + n - 1);
                    floatList.add(f2);
                    n2 = i;
                    n = 1;
                    f2 = f6;
                }
                n3 = 0;
                f3 = 0.0f;
                continue;
            }
            f2 += f6;
            if (this.attributes.wrappingWidthSet && NGText.isPreferredBreakCharacter(c)) {
                n3 = n;
                f3 = f2;
            }
            ++n;
        }
        if (cArray.length > 0 && (n > 0 || cArray[cArray.length - 1] == '\n')) {
            intList.add(cArray.length - 1);
            floatList.add(f2);
        }
        this.attributes.lineAdvances = floatList.getData();
        this.attributes.newLineIndices = intList.getData();
        this.maxLineAdvance = this.attributes.getMaxAdvance();
        if (!this.attributes.wrappingWidthSet && this.attributes.numberOfLines() > 1) {
            this.attributes.wrappingWidth = this.maxLineAdvance;
        }
        this.attributes.computeLinePadding(this.text, fontStrike);
    }

    @Override
    public void setTextAlignment(int n) {
        if (this.attributes == null) {
            if (n == 0) {
                return;
            }
            this.attributes = new TextAttributes();
        }
        if (n != this.attributes.textAlignment) {
            this.attributes.textAlignment = n;
            this.geometryChangedTextValid();
        }
    }

    @Override
    public void setTextOrigin(int n) {
        if (n != this.textOrigin) {
            this.textOrigin = n;
            this.geometryChangedTextValid();
        }
    }

    @Override
    public void setUnderline(boolean bl) {
        if (this.attributes == null) {
            if (!bl) {
                return;
            }
            this.attributes = new TextAttributes();
        }
        if (bl != this.attributes.underline) {
            this.attributes.underline = bl;
            this.geometryChangedTextValid();
        }
    }

    @Override
    public void setStrikethrough(boolean bl) {
        if (this.attributes == null) {
            if (!bl) {
                return;
            }
            this.attributes = new TextAttributes();
        }
        if (bl != this.attributes.strikethrough) {
            this.attributes.strikethrough = bl;
            this.geometryChangedTextValid();
        }
    }

    @Override
    public void setWrappingWidth(float f) {
        if (this.attributes == null) {
            if (f <= 0.0f) {
                return;
            }
            this.attributes = new TextAttributes();
        }
        boolean bl = this.attributes.wrappingWidthSet = f > 0.0f;
        if (f != this.attributes.wrappingWidth) {
            this.attributes.wrappingWidth = f;
            this.geometryChanged();
        }
    }

    private static class Selection {
        int start = 0;
        int end = 0;
        private Paint drawPaint;
        private Paint fillPaint;
        Shape shape;

        private Selection() {
        }

        boolean isEmpty() {
            return this.start >= this.end;
        }
    }

    private static class FloatList {
        private static final int LEN = 10;
        float[] data = new float[10];
        int index = 0;
        int len = 10;

        private FloatList() {
        }

        void add(float f) {
            if (this.index == this.len) {
                float[] fArray = new float[this.len * 2];
                int n = this.len * 2;
                System.arraycopy(this.data, 0, fArray, 0, this.len);
                this.data = fArray;
                this.len = n;
            }
            this.data[this.index++] = f;
        }

        float[] getData() {
            if (this.index == 0) {
                return null;
            }
            if (this.index == 10) {
                return this.data;
            }
            float[] fArray = new float[this.index];
            System.arraycopy(this.data, 0, fArray, 0, this.index);
            return fArray;
        }

        float getMax() {
            float f = 0.0f;
            for (int i = 0; i < this.index; ++i) {
                if (!(f < this.data[i])) continue;
                f = this.data[i];
            }
            return f;
        }

        static float getMin(float[] fArray) {
            if (fArray == null) {
                return 0.0f;
            }
            float f = 0.0f;
            for (float f2 : fArray) {
                if (!(f2 < f)) continue;
                f = f2;
            }
            return f;
        }

        static float getMax(float[] fArray) {
            if (fArray == null) {
                return 0.0f;
            }
            float f = 0.0f;
            for (float f2 : fArray) {
                if (!(f2 > f)) continue;
                f = f2;
            }
            return f;
        }
    }

    private static class IntList {
        private static final int LEN = 10;
        int[] data = new int[10];
        int index = 0;
        int len = 10;

        private IntList() {
        }

        void add(int n) {
            if (this.index == this.len) {
                int[] nArray = new int[this.len * 2];
                int n2 = this.len * 2;
                System.arraycopy(this.data, 0, nArray, 0, this.len);
                this.data = nArray;
                this.len = n2;
            }
            this.data[this.index++] = n;
        }

        int getAtIndex(int n) {
            return this.data[n];
        }

        int getCurrent() {
            return this.index > 0 ? this.data[this.index - 1] : -1;
        }

        boolean removeCurrent() {
            if (this.index > 0) {
                --this.index;
                return true;
            }
            return false;
        }

        int[] getData() {
            if (this.index == 0) {
                return null;
            }
            if (this.index == 10) {
                return this.data;
            }
            int[] nArray = new int[this.index];
            System.arraycopy(this.data, 0, nArray, 0, this.index);
            return nArray;
        }
    }

    private static class TextAttributes {
        float wrappingWidth = 0.0f;
        boolean wrappingWidthSet = false;
        boolean overrideWrappingWidth = false;
        int textAlignment = 0;
        boolean underline;
        boolean strikethrough;
        static final int X_MIN_INDEX = 0;
        static final int Y_MIN_INDEX = 1;
        static final int X_MAX_INDEX = 2;
        static final int Y_MAX_INDEX = 3;
        boolean hasTabs;
        float[] lineAdvances;
        int[] newLineIndices;
        float[] lsb;
        float[] rsb;
        Shape cachedShape;

        private TextAttributes() {
        }

        int numberOfLines() {
            return this.newLineIndices == null ? 1 : this.newLineIndices.length;
        }

        boolean simpleSingleLine() {
            if (this.numberOfLines() != 1 || this.hasTabs) {
                return false;
            }
            return this.wrappingWidthSet ? this.textAlignment == 0 || this.textAlignment == 3 : true;
        }

        boolean visualGreaterThanLogicalBounds() {
            return this.lsb != null | this.rsb != null;
        }

        float getMaxAdvance() {
            float f = 0.0f;
            if (this.lineAdvances == null) {
                return 0.0f;
            }
            int n = this.lineAdvances.length;
            for (int i = 0; i < n; ++i) {
                if (!(f < this.lineAdvances[i])) continue;
                f = this.lineAdvances[i];
            }
            return f;
        }

        private boolean computeLinePadding(String string, FontStrike fontStrike) {
            int n;
            float[] fArray = new float[4];
            FontResource fontResource = fontStrike.getFontResource();
            CharToGlyphMapper charToGlyphMapper = fontResource.getGlyphMapper();
            float f = fontStrike.getSize();
            if (this.numberOfLines() == 1) {
                float[] fArray2 = TextAttributes.computeSideBearings(string, fontResource, charToGlyphMapper, f, fArray);
                return fArray2[0] < 0.0f || fArray2[1] > 0.0f;
            }
            if (this.newLineIndices == null) {
                return false;
            }
            int n2 = this.newLineIndices.length;
            float[] fArray3 = new float[n2];
            float[] fArray4 = new float[n2];
            float f2 = 0.0f;
            float f3 = 0.0f;
            int n3 = 0;
            for (int i = 0; i < n2 && n3 <= (n = this.newLineIndices[i]); ++i) {
                float[] fArray5 = TextAttributes.computeSideBearings(string.substring(n3, n + 1), fontResource, charToGlyphMapper, f, fArray);
                fArray3[i] = fArray5[0];
                fArray4[i] = fArray5[1];
                if (fArray5[0] < f2) {
                    f2 = fArray5[0];
                }
                if (fArray5[1] > f3) {
                    f3 = fArray5[0];
                }
                n3 = this.newLineIndices[i] + 1;
            }
            if (f2 < 0.0f || f3 > 0.0f) {
                this.lsb = fArray3;
                this.rsb = fArray4;
                return true;
            }
            return false;
        }

        private static float[] computeSideBearings(String string, FontResource fontResource, CharToGlyphMapper charToGlyphMapper, float f, float[] fArray) {
            int n = 0;
            float[] fArray2 = new float[]{0.0f, 0.0f};
            int n2 = string.length() - 1;
            if (n > n2) {
                return fArray2;
            }
            char c = string.charAt(n);
            int n3 = charToGlyphMapper.charToGlyph((int)c);
            float f2 = 0.0f;
            float f3 = 0.0f;
            while (Character.isWhitespace(c) && n < n2) {
                f2 += fontResource.getAdvance(n3, f);
                c = string.charAt(++n);
                n3 = charToGlyphMapper.charToGlyph((int)c);
            }
            fontResource.getGlyphBoundingBox(n3, f, fArray);
            fArray[0] = fArray[0] + f2;
            float f4 = fArray[0];
            c = string.charAt(n2);
            n3 = charToGlyphMapper.charToGlyph((int)c);
            while (Character.isWhitespace(c) && n < n2) {
                f3 += fontResource.getAdvance(n3, f);
                c = string.charAt(--n2);
                n3 = charToGlyphMapper.charToGlyph((int)c);
            }
            if (n != n2) {
                fontResource.getGlyphBoundingBox(n3, f, fArray);
            }
            fArray[2] = fArray[2] + -(f3 += fontResource.getAdvance(n3, f));
            float f5 = fArray[2];
            fArray2[0] = f4;
            fArray2[1] = f5;
            return fArray2;
        }

        void reset() {
            this.lineAdvances = null;
            this.newLineIndices = null;
            this.rsb = null;
            this.lsb = null;
            if (!this.wrappingWidthSet) {
                this.wrappingWidth = 0.0f;
            }
            this.overrideWrappingWidth = false;
            this.hasTabs = false;
            this.resetShape();
        }

        void resetShape() {
            this.cachedShape = null;
        }
    }
}

